/****************************************************************************** 
* 
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved. 
* 
* This program is free software; you can redistribute it and/or modify it 
* under the terms of version 2 of the GNU General Public License as 
* published by the Free Software Foundation. 
* 
* This program is distributed in the hope that it will be useful, but WITHOUT 
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
* more details. 
* 
* You should have received a copy of the GNU General Public License along with 
* this program; if not, write to the Free Software Foundation, Inc., 
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA 
* 
* 
******************************************************************************/

/*Image2HeaderVersion: 2.19*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8814A_SUPPORT == 1)
static BOOLEAN
CheckPositive(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2,
	IN	const u4Byte  Condition3,
	IN	const u4Byte  Condition4
)
{
	u1Byte    _BoardType = ((pDM_Odm->BoardType & BIT4) >> 4) << 0 | /* _GLNA*/
				((pDM_Odm->BoardType & BIT3) >> 3) << 1 | /* _GPA*/ 
				((pDM_Odm->BoardType & BIT7) >> 7) << 2 | /* _ALNA*/
				((pDM_Odm->BoardType & BIT6) >> 6) << 3 | /* _APA */
				((pDM_Odm->BoardType & BIT2) >> 2) << 4;  /* _BT*/  

	u4Byte	cond1   = Condition1, cond2 = Condition2, cond3 = Condition3, cond4 = Condition4;
	u4Byte    driver1 = pDM_Odm->CutVersion       << 24 | 
				(pDM_Odm->SupportInterface & 0xF0) << 16 | 
				pDM_Odm->SupportPlatform  << 16 | 
				pDM_Odm->PackageType      << 12 | 
				(pDM_Odm->SupportInterface & 0x0F) << 8  |
				_BoardType;

	u4Byte    driver2 = (pDM_Odm->TypeGLNA & 0xFF) <<  0 |  
				(pDM_Odm->TypeGPA & 0xFF)  <<  8 | 
				(pDM_Odm->TypeALNA & 0xFF) << 16 | 
				(pDM_Odm->TypeAPA & 0xFF)  << 24; 

u4Byte    driver3 = 0;

	u4Byte    driver4 = (pDM_Odm->TypeGLNA & 0xFF00) >>  8 |
				(pDM_Odm->TypeGPA & 0xFF00) |
				(pDM_Odm->TypeALNA & 0xFF00) << 8 |
				(pDM_Odm->TypeAPA & 0xFF00)  << 16;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Platform, Interface) = (0x%X, 0x%X)\n", pDM_Odm->SupportPlatform, pDM_Odm->SupportInterface));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Board, Package) = (0x%X, 0x%X)\n", pDM_Odm->BoardType, pDM_Odm->PackageType));


	/*============== Value Defined Check ===============*/
	/*QFN Type [15:12] and Cut Version [27:24] need to do value check*/
	
	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return FALSE;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return FALSE;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1   &= 0x00FF0FFF; 
	driver1 &= 0x00FF0FFF; 

	if ((cond1 & driver1) == cond1) {
		u4Byte bitMask = 0;

		if ((cond1 & 0x0F) == 0) /* BoardType is DONTCARE*/
			return TRUE;

		if ((cond1 & BIT0) != 0) /*GLNA*/
			bitMask |= 0x000000FF;
		if ((cond1 & BIT1) != 0) /*GPA*/
			bitMask |= 0x0000FF00;
		if ((cond1 & BIT2) != 0) /*ALNA*/
			bitMask |= 0x00FF0000;
		if ((cond1 & BIT3) != 0) /*APA*/
			bitMask |= 0xFF000000;

		if (((cond2 & bitMask) == (driver2 & bitMask)) && ((cond4 & bitMask) == (driver4 & bitMask)))  /* BoardType of each RF path is matched*/
			return TRUE;
		else
			return FALSE;
	} else
		return FALSE;
}
static BOOLEAN
CheckNegative(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2
)
{
	return TRUE;
}

/******************************************************************************
*                           RadioA.TXT
******************************************************************************/

u4Byte Array_MP_8814A_RadioA[] = { 
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x0B0, 0x000FFFFE,
		0x0B1, 0x0003FF48,
		0x0B2, 0x0006AA3F,
		0x0B3, 0x000FFC9A,
		0x0B4, 0x0000A78F,
		0x0B5, 0x00000A3F,
		0x0B6, 0x0000C09C,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x0B7, 0x00030008,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x0B7, 0x00030008,
	0xA0000000,	0x00000000,
		0x0B7, 0x0003000C,
	0xB0000000,	0x00000000,
		0x0B8, 0x0007400E,
		0x0B9, 0x00008250,
		0x0BA, 0x00050780,
		0x0BB, 0x00000000,
		0x0BC, 0x00040009,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0EF, 0x00020000,
		0x03E, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0xA0000000,	0x00000000,
		0x03F, 0x00030000,
	0xB0000000,	0x00000000,
		0x03E, 0x00020000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00040000,
	0xA0000000,	0x00000000,
		0x03F, 0x00040000,
	0xB0000000,	0x00000000,
		0x03E, 0x00040000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0xA0000000,	0x00000000,
		0x03F, 0x00030000,
	0xB0000000,	0x00000000,
		0x03E, 0x00060000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03F, 0x00030000,
	0xA0000000,	0x00000000,
		0x03F, 0x00030000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00010000,
		0x03E, 0x00000000,
		0x03F, 0x00006800,
		0x03E, 0x00000080,
		0x03F, 0x00006000,
		0x03E, 0x00000100,
		0x03F, 0x00004800,
		0x03E, 0x00000180,
		0x03F, 0x00004000,
		0x03E, 0x00000200,
		0x03F, 0x00004000,
		0x03E, 0x00000280,
		0x03F, 0x00002800,
		0x03E, 0x00000300,
		0x03F, 0x00002800,
		0x03E, 0x00000380,
		0x03F, 0x00002000,
		0x0EF, 0x00000000,
		0x0EF, 0x00040000,
		0x03E, 0x00000000,
		0x03F, 0x000000BC,
		0x03E, 0x00000040,
		0x03F, 0x00000053,
		0x03E, 0x00000050,
		0x03F, 0x00000050,
		0x03E, 0x00000060,
		0x03F, 0x00000050,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
		0x03E, 0x00000006,
		0x041, 0x000EE080,
		0x03E, 0x00000008,
		0x041, 0x000EE0C0,
		0x03E, 0x0000000A,
		0x041, 0x000EE100,
		0x03E, 0x0000000C,
		0x041, 0x000EE100,
		0x0EF, 0x00000000,
		0x018, 0x00000006,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
	0xB0000000,	0x00000000,
	0x80000004,	0x00550000,	0x40000000,	0x00000000,
		0x087, 0x00079F80,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x087, 0x00079F80,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x087, 0x00079F80,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x000179C3,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03C, 0x00024000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x00028000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0000078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x00078023,
		0x03C, 0x00024000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03B, 0x00078023,
		0x03C, 0x000AC000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03B, 0x00078023,
		0x03C, 0x00024000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03B, 0x00078023,
		0x03C, 0x00088000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03B, 0x00078023,
		0x03C, 0x00024000,
	0xA0000000,	0x00000000,
		0x03B, 0x00078023,
		0x03C, 0x0004C000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0004078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03B, 0x000B8023,
		0x03C, 0x00084000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03B, 0x000B8023,
		0x03C, 0x0008C000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03B, 0x000B8023,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03B, 0x000B8023,
		0x03C, 0x00084000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03B, 0x000B8023,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03B, 0x000B8023,
		0x03C, 0x00004000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0008078B,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00000801,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00001801,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000003,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00000003,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
		0x03A, 0x00001802,
		0x0EF, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000008,
		0x03C, 0x00000000,
		0x03C, 0x00000400,
		0x03C, 0x00000800,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0EF, 0x00000100,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A1AD,
		0x034, 0x000491AA,
		0x034, 0x000481A7,
		0x034, 0x000470AA,
		0x034, 0x000460A7,
		0x034, 0x00045049,
		0x034, 0x00044046,
		0x034, 0x00043026,
		0x034, 0x00042009,
		0x034, 0x00041006,
		0x034, 0x00040003,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AF,
		0x034, 0x000483AB,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004406A,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF1,
		0x034, 0x00049FEE,
		0x034, 0x00048FEB,
		0x034, 0x00047FE8,
		0x034, 0x00046DEA,
		0x034, 0x00045DE7,
		0x034, 0x00044CEA,
		0x034, 0x00043CE7,
		0x034, 0x00042C69,
		0x034, 0x00041C66,
		0x034, 0x00040C28,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A1AD,
		0x034, 0x000291AA,
		0x034, 0x000281A7,
		0x034, 0x000270AA,
		0x034, 0x000260A7,
		0x034, 0x00025049,
		0x034, 0x00024046,
		0x034, 0x00023026,
		0x034, 0x00022009,
		0x034, 0x00021006,
		0x034, 0x00020003,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF1,
		0x034, 0x00029FEE,
		0x034, 0x00028FEB,
		0x034, 0x00027FE8,
		0x034, 0x00026DEA,
		0x034, 0x00025DE7,
		0x034, 0x00024CEA,
		0x034, 0x00023CE7,
		0x034, 0x00022C69,
		0x034, 0x00021C66,
		0x034, 0x00020C28,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x0000938C,
		0x034, 0x000081AD,
		0x034, 0x000071AA,
		0x034, 0x000061A7,
		0x034, 0x000050AA,
		0x034, 0x000040A7,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x0000100C,
		0x034, 0x00000009,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF1,
		0x034, 0x00009FEE,
		0x034, 0x00008FEB,
		0x034, 0x00007FE8,
		0x034, 0x00006DEA,
		0x034, 0x00005DE7,
		0x034, 0x00004CEA,
		0x034, 0x00003CE7,
		0x034, 0x00002C69,
		0x034, 0x00001C66,
		0x034, 0x00000C28,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA1AD,
		0x034, 0x000C91AA,
		0x034, 0x000C81A7,
		0x034, 0x000C70AA,
		0x034, 0x000C60A7,
		0x034, 0x000C5049,
		0x034, 0x000C4046,
		0x034, 0x000C3026,
		0x034, 0x000C2009,
		0x034, 0x000C1006,
		0x034, 0x000C0003,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AF,
		0x034, 0x000C83AB,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C406A,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA1AD,
		0x034, 0x000A91AA,
		0x034, 0x000A81A7,
		0x034, 0x000A70AA,
		0x034, 0x000A60A7,
		0x034, 0x000A5049,
		0x034, 0x000A4046,
		0x034, 0x000A3026,
		0x034, 0x000A2009,
		0x034, 0x000A1006,
		0x034, 0x000A0003,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x0008938C,
		0x034, 0x000881AD,
		0x034, 0x000871AA,
		0x034, 0x000861A7,
		0x034, 0x000850AA,
		0x034, 0x000840A7,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x0008100C,
		0x034, 0x00080009,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0DF, 0x00000001,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000747,
		0x035, 0x00008747,
		0x035, 0x00010747,
		0x035, 0x00020747,
		0x035, 0x00028747,
		0x035, 0x00030747,
		0x035, 0x00040747,
		0x035, 0x00048747,
		0x035, 0x00050747,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0DF, 0x00000001,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x00005146,
		0x037, 0x00004000,
		0x038, 0x00005146,
		0x037, 0x00008000,
		0x038, 0x00005146,
		0x037, 0x00010000,
		0x038, 0x00005146,
		0x037, 0x00014000,
		0x038, 0x00005146,
		0x037, 0x00018000,
		0x038, 0x00004D4E,
		0x037, 0x0001C000,
		0x038, 0x00004D4E,
		0x037, 0x00020000,
		0x038, 0x00004D4E,
		0x037, 0x00024000,
		0x038, 0x000071C6,
		0x037, 0x00028000,
		0x038, 0x000071C6,
		0x037, 0x0002C000,
		0x038, 0x000071C6,
		0x037, 0x00030000,
		0x038, 0x000071CE,
		0x037, 0x00034000,
		0x038, 0x000071CE,
		0x037, 0x00038000,
		0x038, 0x00005126,
		0x037, 0x0003C000,
		0x038, 0x00005126,
		0x037, 0x00040000,
		0x038, 0x00005126,
		0x037, 0x00044000,
		0x038, 0x00005126,
		0x037, 0x00048000,
		0x038, 0x00005126,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x0000054A,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x0000154A,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x0000254A,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000933FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x055, 0x00082061,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,
		0x01C, 0x000739D2,
		0x01F, 0x0002295C,
		0x018, 0x0001B126,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0x018, 0x00013126,
		0x018, 0x00013124,

};

void
ODM_ReadAndConfig_MP_8814A_RadioA(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_RadioA)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_RadioA;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_RadioA\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioA_8814A(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_RadioA(void)
{
	   return 85;
}

/******************************************************************************
*                           RadioB.TXT
******************************************************************************/

u4Byte Array_MP_8814A_RadioB[] = { 
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x018, 0x00000006,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
	0xB0000000,	0x00000000,
	0x80000004,	0x00550000,	0x40000000,	0x00000000,
		0x087, 0x00079F80,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x087, 0x00079F80,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x087, 0x00079F80,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x03B, 0x0003F39B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017BC3,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03C, 0x00084000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x00040000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0000078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00020000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00060000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00048000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00048000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0004078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00048000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00060000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x0004C000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00044000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x0004C000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0008078B,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00001001,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00001003,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
	0x80000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x00001802,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000008,
		0x03C, 0x00000000,
		0x03C, 0x00000400,
		0x03C, 0x00000800,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0EF, 0x00000100,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x000491AD,
		0x034, 0x000481AA,
		0x034, 0x000471A7,
		0x034, 0x000460AA,
		0x034, 0x000450A7,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x0004200C,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x00049389,
		0x034, 0x0004816D,
		0x034, 0x0004716A,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38B,
		0x034, 0x00049388,
		0x034, 0x0004818B,
		0x034, 0x00047188,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF4,
		0x034, 0x00049FF1,
		0x034, 0x00048FEE,
		0x034, 0x00047FEB,
		0x034, 0x00046FE8,
		0x034, 0x00045DEA,
		0x034, 0x00044CED,
		0x034, 0x00043CEA,
		0x034, 0x00042C6C,
		0x034, 0x00041C69,
		0x034, 0x00040C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A38C,
		0x034, 0x000291AD,
		0x034, 0x000281AA,
		0x034, 0x000271A7,
		0x034, 0x000260AA,
		0x034, 0x000250A7,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x0002200C,
		0x034, 0x00021009,
		0x034, 0x00020006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293AC,
		0x034, 0x00028389,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EF,
		0x034, 0x000293AD,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF4,
		0x034, 0x00029FF1,
		0x034, 0x00028FEE,
		0x034, 0x00027FEB,
		0x034, 0x00026FE8,
		0x034, 0x00025DEA,
		0x034, 0x00024CED,
		0x034, 0x00023CEA,
		0x034, 0x00022C6C,
		0x034, 0x00021C69,
		0x034, 0x00020C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A38C,
		0x034, 0x000091AD,
		0x034, 0x000081AA,
		0x034, 0x000071A7,
		0x034, 0x000060AA,
		0x034, 0x000050A7,
		0x034, 0x0000402C,
		0x034, 0x00003029,
		0x034, 0x00002026,
		0x034, 0x00001009,
		0x034, 0x00000006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EC,
		0x034, 0x000093AC,
		0x034, 0x000081EC,
		0x034, 0x0000716D,
		0x034, 0x0000616A,
		0x034, 0x0000506D,
		0x034, 0x0000404C,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EF,
		0x034, 0x000093AD,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF4,
		0x034, 0x00009FF1,
		0x034, 0x00008FEE,
		0x034, 0x00007FEB,
		0x034, 0x00006FE8,
		0x034, 0x00005DEA,
		0x034, 0x00004CED,
		0x034, 0x00003CEA,
		0x034, 0x00002C6C,
		0x034, 0x00001C69,
		0x034, 0x00000C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C91AD,
		0x034, 0x000C81AA,
		0x034, 0x000C71A7,
		0x034, 0x000C60AA,
		0x034, 0x000C50A7,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C200C,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C9389,
		0x034, 0x000C816D,
		0x034, 0x000C716A,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38B,
		0x034, 0x000C9388,
		0x034, 0x000C818B,
		0x034, 0x000C7188,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA38C,
		0x034, 0x000A91AD,
		0x034, 0x000A81AA,
		0x034, 0x000A71A7,
		0x034, 0x000A60AA,
		0x034, 0x000A50A7,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A200C,
		0x034, 0x000A1009,
		0x034, 0x000A0006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93AC,
		0x034, 0x000A8389,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EF,
		0x034, 0x000A93AD,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A38C,
		0x034, 0x000891AD,
		0x034, 0x000881AA,
		0x034, 0x000871A7,
		0x034, 0x000860AA,
		0x034, 0x000850A7,
		0x034, 0x0008402C,
		0x034, 0x00083029,
		0x034, 0x00082026,
		0x034, 0x00081009,
		0x034, 0x00080006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EC,
		0x034, 0x000893AC,
		0x034, 0x000881EC,
		0x034, 0x0008716D,
		0x034, 0x0008616A,
		0x034, 0x0008506D,
		0x034, 0x0008404C,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EF,
		0x034, 0x000893AD,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000484,
		0x035, 0x00008484,
		0x035, 0x00010484,
		0x035, 0x00020584,
		0x035, 0x00028584,
		0x035, 0x00030584,
		0x035, 0x00040584,
		0x035, 0x00048584,
		0x035, 0x00050584,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000474,
		0x036, 0x00008474,
		0x036, 0x00010474,
		0x036, 0x00020474,
		0x036, 0x00028474,
		0x036, 0x00030474,
		0x036, 0x00040474,
		0x036, 0x00048474,
		0x036, 0x00050474,
		0x036, 0x00080474,
		0x036, 0x00088474,
		0x036, 0x00090474,
		0x036, 0x000A0474,
		0x036, 0x000A8474,
		0x036, 0x000B0474,
		0x036, 0x000C0474,
		0x036, 0x000C8474,
		0x036, 0x000D0474,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x0000514E,
		0x037, 0x00004000,
		0x038, 0x0000514E,
		0x037, 0x00008000,
		0x038, 0x0000514E,
		0x037, 0x00010000,
		0x038, 0x0000514E,
		0x037, 0x00014000,
		0x038, 0x0000514E,
		0x037, 0x00018000,
		0x038, 0x0000514E,
		0x037, 0x0001C000,
		0x038, 0x0000514E,
		0x037, 0x00020000,
		0x038, 0x0000514E,
		0x037, 0x00024000,
		0x038, 0x0000514E,
		0x037, 0x00028000,
		0x038, 0x0000514E,
		0x037, 0x0002C000,
		0x038, 0x0000714E,
		0x037, 0x00030000,
		0x038, 0x0000514E,
		0x037, 0x00034000,
		0x038, 0x0000514E,
		0x037, 0x00038000,
		0x038, 0x0000514E,
		0x037, 0x0003C000,
		0x038, 0x0000514E,
		0x037, 0x00040000,
		0x038, 0x0000514E,
		0x037, 0x00044000,
		0x038, 0x0000514E,
		0x037, 0x00048000,
		0x038, 0x0000514E,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027E,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127E,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227E,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000923FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,

};

void
ODM_ReadAndConfig_MP_8814A_RadioB(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_RadioB)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_RadioB;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_RadioB\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioB_8814A(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_RadioB(void)
{
	   return 85;
}

/******************************************************************************
*                           RadioC.TXT
******************************************************************************/

u4Byte Array_MP_8814A_RadioC[] = { 
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x018, 0x00000006,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017823,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0006C000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03C, 0x000D4000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03C, 0x00080000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00088000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x000A0000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0000078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x0004C000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00084000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00080000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00028000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0004078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00024000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00060000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00080000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00024000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0008078B,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00001803,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00001803,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00000800,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00000803,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
	0x80000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x00001802,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000008,
		0x03C, 0x00000000,
		0x03C, 0x00000400,
		0x03C, 0x00000800,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x018, 0x00013124,
	0xA0000000,	0x00000000,
		0x018, 0x00013124,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A38C,
		0x034, 0x000491AD,
		0x034, 0x000481AA,
		0x034, 0x000471A7,
		0x034, 0x000460AA,
		0x034, 0x000450A7,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x0004200C,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EF,
		0x034, 0x000493AD,
		0x034, 0x0004838A,
		0x034, 0x0004718C,
		0x034, 0x00046189,
		0x034, 0x0004506D,
		0x034, 0x0004404C,
		0x034, 0x0004302C,
		0x034, 0x00042029,
		0x034, 0x00041026,
		0x034, 0x00040023,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF4,
		0x034, 0x00049FF1,
		0x034, 0x00048FEE,
		0x034, 0x00047FEB,
		0x034, 0x00046FE8,
		0x034, 0x00045DEA,
		0x034, 0x00044CED,
		0x034, 0x00043CEA,
		0x034, 0x00042C6C,
		0x034, 0x00041C69,
		0x034, 0x00040C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002938C,
		0x034, 0x000281AD,
		0x034, 0x000271AA,
		0x034, 0x000261A7,
		0x034, 0x000250AA,
		0x034, 0x000240A7,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x0002100C,
		0x034, 0x00020009,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x0002936D,
		0x034, 0x0002836A,
		0x034, 0x0002716D,
		0x034, 0x0002616A,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EC,
		0x034, 0x000293AC,
		0x034, 0x0002838A,
		0x034, 0x0002718C,
		0x034, 0x00026189,
		0x034, 0x0002506D,
		0x034, 0x0002406A,
		0x034, 0x0002302C,
		0x034, 0x00022029,
		0x034, 0x00021026,
		0x034, 0x00020023,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF4,
		0x034, 0x00029FF1,
		0x034, 0x00028FEE,
		0x034, 0x00027FEB,
		0x034, 0x00026FE8,
		0x034, 0x00025DEA,
		0x034, 0x00024CED,
		0x034, 0x00023CEA,
		0x034, 0x00022C6C,
		0x034, 0x00021C69,
		0x034, 0x00020C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A38C,
		0x034, 0x000091AD,
		0x034, 0x000081AA,
		0x034, 0x000071A7,
		0x034, 0x000060AA,
		0x034, 0x000050A7,
		0x034, 0x0000402C,
		0x034, 0x00003029,
		0x034, 0x0000200C,
		0x034, 0x00001009,
		0x034, 0x00000006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AB,
		0x034, 0x00008389,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF4,
		0x034, 0x00009FF1,
		0x034, 0x00008FEE,
		0x034, 0x00007FEB,
		0x034, 0x00006FE8,
		0x034, 0x00005DEA,
		0x034, 0x00004CED,
		0x034, 0x00003CEA,
		0x034, 0x00002C6C,
		0x034, 0x00001C69,
		0x034, 0x00000C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA38C,
		0x034, 0x000C91AD,
		0x034, 0x000C81AA,
		0x034, 0x000C71A7,
		0x034, 0x000C60AA,
		0x034, 0x000C50A7,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C200C,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EF,
		0x034, 0x000C93AD,
		0x034, 0x000C838A,
		0x034, 0x000C718C,
		0x034, 0x000C6189,
		0x034, 0x000C506D,
		0x034, 0x000C404C,
		0x034, 0x000C302C,
		0x034, 0x000C2029,
		0x034, 0x000C1026,
		0x034, 0x000C0023,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A938C,
		0x034, 0x000A81AD,
		0x034, 0x000A71AA,
		0x034, 0x000A61A7,
		0x034, 0x000A50AA,
		0x034, 0x000A40A7,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A100C,
		0x034, 0x000A0009,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A936D,
		0x034, 0x000A836A,
		0x034, 0x000A716D,
		0x034, 0x000A616A,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EC,
		0x034, 0x000A93AC,
		0x034, 0x000A838A,
		0x034, 0x000A718C,
		0x034, 0x000A6189,
		0x034, 0x000A506D,
		0x034, 0x000A406A,
		0x034, 0x000A302C,
		0x034, 0x000A2029,
		0x034, 0x000A1026,
		0x034, 0x000A0023,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A38C,
		0x034, 0x000891AD,
		0x034, 0x000881AA,
		0x034, 0x000871A7,
		0x034, 0x000860AA,
		0x034, 0x000850A7,
		0x034, 0x0008402C,
		0x034, 0x00083029,
		0x034, 0x0008200C,
		0x034, 0x00081009,
		0x034, 0x00000006,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AB,
		0x034, 0x00088389,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000484,
		0x035, 0x00008484,
		0x035, 0x00010484,
		0x035, 0x00020584,
		0x035, 0x00028584,
		0x035, 0x00030584,
		0x035, 0x00040584,
		0x035, 0x00048584,
		0x035, 0x00050584,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000474,
		0x036, 0x00008474,
		0x036, 0x00010474,
		0x036, 0x00020474,
		0x036, 0x00028474,
		0x036, 0x00030474,
		0x036, 0x00040474,
		0x036, 0x00048474,
		0x036, 0x00050474,
		0x036, 0x00080474,
		0x036, 0x00088474,
		0x036, 0x00090474,
		0x036, 0x000A0474,
		0x036, 0x000A8474,
		0x036, 0x000B0474,
		0x036, 0x000C0474,
		0x036, 0x000C8474,
		0x036, 0x000D0474,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x0000514E,
		0x037, 0x00004000,
		0x038, 0x0000514E,
		0x037, 0x00008000,
		0x038, 0x0000514E,
		0x037, 0x00010000,
		0x038, 0x0000514E,
		0x037, 0x00014000,
		0x038, 0x0000514E,
		0x037, 0x00018000,
		0x038, 0x0000514E,
		0x037, 0x0001C000,
		0x038, 0x0000514E,
		0x037, 0x00020000,
		0x038, 0x0000514E,
		0x037, 0x00024000,
		0x038, 0x0000514E,
		0x037, 0x00028000,
		0x038, 0x0000514E,
		0x037, 0x0002C000,
		0x038, 0x0000714E,
		0x037, 0x00030000,
		0x038, 0x0000514E,
		0x037, 0x00034000,
		0x038, 0x0000514E,
		0x037, 0x00038000,
		0x038, 0x0000514E,
		0x037, 0x0003C000,
		0x038, 0x0000514E,
		0x037, 0x00040000,
		0x038, 0x0000514E,
		0x037, 0x00044000,
		0x038, 0x0000514E,
		0x037, 0x00048000,
		0x038, 0x0000514E,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000541,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001541,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002541,
		0x03C, 0x00002821,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027D,
		0x03C, 0x00000546,
		0x03C, 0x00000821,
		0x03C, 0x0000127D,
		0x03C, 0x00001546,
		0x03C, 0x00001821,
		0x03C, 0x0000227D,
		0x03C, 0x00002546,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000923FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,

};

void
ODM_ReadAndConfig_MP_8814A_RadioC(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_RadioC)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_RadioC;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_RadioC\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioC_8814A(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_RadioC(void)
{
	   return 85;
}

/******************************************************************************
*                           RadioD.TXT
******************************************************************************/

u4Byte Array_MP_8814A_RadioD[] = { 
		0x018, 0x00013124,
		0x040, 0x00000C00,
		0x058, 0x00000F98,
		0x07F, 0x00068004,
		0x018, 0x00000006,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x086, 0x000E335A,
		0x087, 0x00079F80,
	0xA0000000,	0x00000000,
		0x086, 0x000E4B58,
		0x087, 0x00049F80,
	0xB0000000,	0x00000000,
		0x0DF, 0x00000008,
		0x0EF, 0x00002000,
	0x80000001,	0x00000055,	0x40000000,	0x00000000,
		0x03B, 0x0003F19B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0x90000001,	0x000000aa,	0x40000000,	0x00000000,
		0x03B, 0x0003F09B,
		0x03B, 0x00037A5B,
		0x03B, 0x0002A433,
		0x03B, 0x00027BD3,
		0x03B, 0x0001F80B,
		0x03B, 0x00017803,
	0xA0000000,	0x00000000,
		0x03B, 0x0003F258,
		0x03B, 0x00030A58,
		0x03B, 0x0002FA58,
		0x03B, 0x00022590,
		0x03B, 0x0001FA50,
		0x03B, 0x00010248,
		0x03B, 0x00008240,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000100,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0000ADF6,
		0x034, 0x00009DF3,
		0x034, 0x00008DF0,
		0x034, 0x00007DED,
		0x034, 0x00006DEA,
		0x034, 0x00005CED,
		0x034, 0x00004CEA,
		0x034, 0x000034EA,
		0x034, 0x000024E7,
		0x034, 0x0000146A,
		0x034, 0x0000006B,
	0xB0000000,	0x00000000,
	0x80000002,	0x00005500,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0x90000002,	0x0000aa00,	0x40000000,	0x00000000,
		0x034, 0x0000A0D0,
		0x034, 0x000090CD,
		0x034, 0x000080CA,
		0x034, 0x0000704D,
		0x034, 0x0000604A,
		0x034, 0x00005047,
		0x034, 0x0000400A,
		0x034, 0x00003007,
		0x034, 0x00002004,
		0x034, 0x00001001,
		0x034, 0x00000001,
	0xA0000000,	0x00000000,
		0x034, 0x0008ADF6,
		0x034, 0x00089DF3,
		0x034, 0x00088DF0,
		0x034, 0x00087DED,
		0x034, 0x00086DEA,
		0x034, 0x00085CED,
		0x034, 0x00084CEA,
		0x034, 0x000834EA,
		0x034, 0x000824E7,
		0x034, 0x0008146A,
		0x034, 0x0008006B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x000020A2,
		0x0DF, 0x00000080,
		0x035, 0x00000192,
		0x035, 0x00008192,
		0x035, 0x00010192,
		0x036, 0x00000024,
		0x036, 0x00008024,
		0x036, 0x00010024,
		0x036, 0x00018024,
		0x0EF, 0x00000000,
		0x051, 0x00000C21,
		0x052, 0x000006D9,
		0x053, 0x000FC649,
		0x054, 0x0000017E,
		0x018, 0x0001012A,
		0x081, 0x0007FC00,
		0x089, 0x00050110,
		0x08A, 0x00043E50,
		0x08B, 0x0002E180,
		0x08C, 0x00093C3C,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x085, 0x000F8000,
	0xA0000000,	0x00000000,
		0x085, 0x000F8000,
	0xB0000000,	0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x08D, 0x000FFFF0,
	0xA0000000,	0x00000000,
		0x08D, 0x000FFFF0,
	0xB0000000,	0x00000000,
		0x0EF, 0x00001000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
		0x03C, 0x00044000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
		0x03C, 0x00048000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
		0x03C, 0x00088000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00038023,
		0x03C, 0x00048000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00030023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00028623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00021633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0001C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00010293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00009593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0000078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00020000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00020000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00044000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00078023,
		0x03C, 0x00024000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00070023,
		0x03C, 0x00048000,
		0x03A, 0x0000013C,
		0x03B, 0x00068623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00061633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0005C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00050293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00049593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0004078B,
		0x03C, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00004000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00060000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00024000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00000000,
	0xA0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B8023,
		0x03C, 0x00004000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000B0023,
	0x80000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03C, 0x00020000,
	0xA0000000,	0x00000000,
		0x03C, 0x00020000,
	0xB0000000,	0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A8623,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x000A1633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x0009C633,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00090293,
		0x03C, 0x00000000,
		0x03A, 0x0000013C,
		0x03B, 0x00089593,
		0x03C, 0x00000000,
		0x03A, 0x00000148,
		0x03B, 0x0008078B,
		0x03C, 0x00000000,
		0x0EF, 0x00000000,
		0x0EF, 0x00000800,
		0x03B, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x00000803,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00000803,
	0xA0000000,	0x00000000,
		0x03A, 0x00000803,
	0xB0000000,	0x00000000,
		0x03B, 0x00040000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
		0x03A, 0x00001002,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
		0x03A, 0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
		0x03A, 0x00001000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
		0x03A, 0x00000001,
	0xA0000000,	0x00000000,
		0x03A, 0x00001000,
	0xB0000000,	0x00000000,
		0x03B, 0x00080000,
		0x03A, 0x00001802,
		0x0EF, 0x00000000,
	0x80000004,	0x00000000,	0x40000000,	0x00000000,
	0x90000004,	0x00550000,	0x40000000,	0x00000000,
	0x90000004,	0x00aa0000,	0x40000000,	0x00000000,
	0x90000004,	0x00ff0000,	0x40000000,	0x00000000,
	0x90000004,	0x00000000,	0x40000000,	0x00550000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000008,
		0x03C, 0x00000000,
		0x03C, 0x00000400,
		0x03C, 0x00000800,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x00013124,
		0x0EF, 0x00000100,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3EB,
		0x034, 0x0004938B,
		0x034, 0x000481AC,
		0x034, 0x000471A9,
		0x034, 0x000460AC,
		0x034, 0x000450A9,
		0x034, 0x0004402E,
		0x034, 0x0004302B,
		0x034, 0x00042028,
		0x034, 0x0004100B,
		0x034, 0x00040008,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0004A3AD,
		0x034, 0x0004938A,
		0x034, 0x0004818C,
		0x034, 0x00047189,
		0x034, 0x0004606D,
		0x034, 0x0004506A,
		0x034, 0x0004402C,
		0x034, 0x00043029,
		0x034, 0x00042026,
		0x034, 0x00041009,
		0x034, 0x00040006,
	0xA0000000,	0x00000000,
		0x034, 0x0004AFF4,
		0x034, 0x00049FF1,
		0x034, 0x00048FEE,
		0x034, 0x00047FEB,
		0x034, 0x00046FE8,
		0x034, 0x00045DEA,
		0x034, 0x00044CED,
		0x034, 0x00043CEA,
		0x034, 0x00042C6C,
		0x034, 0x00041C69,
		0x034, 0x00040C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3EE,
		0x034, 0x000293EB,
		0x034, 0x0002838B,
		0x034, 0x000271AC,
		0x034, 0x000261A9,
		0x034, 0x000250AC,
		0x034, 0x000240A9,
		0x034, 0x000230A6,
		0x034, 0x0002202C,
		0x034, 0x00021029,
		0x034, 0x00020026,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0002A3AD,
		0x034, 0x0002938A,
		0x034, 0x0002818C,
		0x034, 0x00027189,
		0x034, 0x0002606D,
		0x034, 0x0002504C,
		0x034, 0x0002402C,
		0x034, 0x00023029,
		0x034, 0x00022026,
		0x034, 0x00021023,
		0x034, 0x00020006,
	0xA0000000,	0x00000000,
		0x034, 0x0002AFF4,
		0x034, 0x00029FF1,
		0x034, 0x00028FEE,
		0x034, 0x00027FEB,
		0x034, 0x00026FE8,
		0x034, 0x00025DEA,
		0x034, 0x00024CED,
		0x034, 0x00023CEA,
		0x034, 0x00022C6C,
		0x034, 0x00021C69,
		0x034, 0x00020C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EF,
		0x034, 0x000093EC,
		0x034, 0x0000838C,
		0x034, 0x000071AD,
		0x034, 0x000061AA,
		0x034, 0x000050AD,
		0x034, 0x000040AA,
		0x034, 0x0000306A,
		0x034, 0x0000202D,
		0x034, 0x0000102A,
		0x034, 0x00000027,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0000A3EE,
		0x034, 0x000093AC,
		0x034, 0x0000838A,
		0x034, 0x0000718C,
		0x034, 0x00006189,
		0x034, 0x0000506D,
		0x034, 0x0000406A,
		0x034, 0x0000302C,
		0x034, 0x00002029,
		0x034, 0x00001026,
		0x034, 0x00000023,
	0xA0000000,	0x00000000,
		0x034, 0x0000AFF4,
		0x034, 0x00009FF1,
		0x034, 0x00008FEE,
		0x034, 0x00007FEB,
		0x034, 0x00006FE8,
		0x034, 0x00005DEA,
		0x034, 0x00004CED,
		0x034, 0x00003CEA,
		0x034, 0x00002C6C,
		0x034, 0x00001C69,
		0x034, 0x00000C2B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3EB,
		0x034, 0x000C938B,
		0x034, 0x000C81AC,
		0x034, 0x000C71A9,
		0x034, 0x000C60AC,
		0x034, 0x000C50A9,
		0x034, 0x000C402E,
		0x034, 0x000C302B,
		0x034, 0x000C2028,
		0x034, 0x000C100B,
		0x034, 0x000C0008,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000CA3AD,
		0x034, 0x000C938A,
		0x034, 0x000C818C,
		0x034, 0x000C7189,
		0x034, 0x000C606D,
		0x034, 0x000C506A,
		0x034, 0x000C402C,
		0x034, 0x000C3029,
		0x034, 0x000C2026,
		0x034, 0x000C1009,
		0x034, 0x000C0006,
	0xA0000000,	0x00000000,
		0x034, 0x000CA794,
		0x034, 0x000C9791,
		0x034, 0x000C878E,
		0x034, 0x000C778B,
		0x034, 0x000C658D,
		0x034, 0x000C558A,
		0x034, 0x000C448D,
		0x034, 0x000C348A,
		0x034, 0x000C244C,
		0x034, 0x000C1449,
		0x034, 0x000C042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3EE,
		0x034, 0x000A93EB,
		0x034, 0x000A838B,
		0x034, 0x000A71AC,
		0x034, 0x000A61A9,
		0x034, 0x000A50AC,
		0x034, 0x000A40A9,
		0x034, 0x000A30A6,
		0x034, 0x000A202C,
		0x034, 0x000A1029,
		0x034, 0x000A0026,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x000AA3AD,
		0x034, 0x000A938A,
		0x034, 0x000A818C,
		0x034, 0x000A7189,
		0x034, 0x000A606D,
		0x034, 0x000A504C,
		0x034, 0x000A402C,
		0x034, 0x000A3029,
		0x034, 0x000A2026,
		0x034, 0x000A1023,
		0x034, 0x000A0006,
	0xA0000000,	0x00000000,
		0x034, 0x000AA794,
		0x034, 0x000A9791,
		0x034, 0x000A878E,
		0x034, 0x000A778B,
		0x034, 0x000A658D,
		0x034, 0x000A558A,
		0x034, 0x000A448D,
		0x034, 0x000A348A,
		0x034, 0x000A244C,
		0x034, 0x000A1449,
		0x034, 0x000A042B,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EF,
		0x034, 0x000893EC,
		0x034, 0x0008838C,
		0x034, 0x000871AD,
		0x034, 0x000861AA,
		0x034, 0x000850AD,
		0x034, 0x000840AA,
		0x034, 0x0008306A,
		0x034, 0x0008202D,
		0x034, 0x0008102A,
		0x034, 0x00080027,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x034, 0x0008A3EE,
		0x034, 0x000893AC,
		0x034, 0x0008838A,
		0x034, 0x0008718C,
		0x034, 0x00086189,
		0x034, 0x0008506D,
		0x034, 0x0008406A,
		0x034, 0x0008302C,
		0x034, 0x00082029,
		0x034, 0x00081026,
		0x034, 0x00080023,
	0xA0000000,	0x00000000,
		0x034, 0x0008A794,
		0x034, 0x00089791,
		0x034, 0x0008878E,
		0x034, 0x0008778B,
		0x034, 0x0008658D,
		0x034, 0x0008558A,
		0x034, 0x0008448D,
		0x034, 0x0008348A,
		0x034, 0x0008244C,
		0x034, 0x00081449,
		0x034, 0x0008042B,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000040,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x035, 0x000006CC,
		0x035, 0x000086CC,
		0x035, 0x000106CC,
		0x035, 0x000206CC,
		0x035, 0x000286CC,
		0x035, 0x000306CC,
		0x035, 0x000406CC,
		0x035, 0x000486CC,
		0x035, 0x000506CC,
		0x035, 0x000806CC,
		0x035, 0x000886CC,
		0x035, 0x000906CC,
		0x035, 0x000A06CC,
		0x035, 0x000A86CC,
		0x035, 0x000B06CC,
		0x035, 0x000C06CC,
		0x035, 0x000C86CC,
		0x035, 0x000D06CC,
	0xA0000000,	0x00000000,
		0x035, 0x00000484,
		0x035, 0x00008484,
		0x035, 0x00010484,
		0x035, 0x00020584,
		0x035, 0x00028584,
		0x035, 0x00030584,
		0x035, 0x00040584,
		0x035, 0x00048584,
		0x035, 0x00050584,
		0x035, 0x000805FB,
		0x035, 0x000885FB,
		0x035, 0x000905FB,
		0x035, 0x000A05FB,
		0x035, 0x000A85FB,
		0x035, 0x000B05FB,
		0x035, 0x000C05FB,
		0x035, 0x000C85FB,
		0x035, 0x000D05FB,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x0DF, 0x00000001,
	0xA0000000,	0x00000000,
		0x0DF, 0x00000000,
	0xB0000000,	0x00000000,
		0x018, 0x0001712A,
		0x0EF, 0x00000010,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x036, 0x00000473,
		0x036, 0x00008473,
		0x036, 0x00010473,
		0x036, 0x00020473,
		0x036, 0x00028473,
		0x036, 0x00030473,
		0x036, 0x00040473,
		0x036, 0x00048473,
		0x036, 0x00050473,
		0x036, 0x00080473,
		0x036, 0x00088473,
		0x036, 0x00090473,
		0x036, 0x000A0473,
		0x036, 0x000A8473,
		0x036, 0x000B0473,
		0x036, 0x000C0473,
		0x036, 0x000C8473,
		0x036, 0x000D0473,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x036, 0x00000475,
		0x036, 0x00008475,
		0x036, 0x00010475,
		0x036, 0x00020475,
		0x036, 0x00028475,
		0x036, 0x00030475,
		0x036, 0x00040475,
		0x036, 0x00048475,
		0x036, 0x00050475,
		0x036, 0x00080475,
		0x036, 0x00088475,
		0x036, 0x00090475,
		0x036, 0x000A0475,
		0x036, 0x000A8475,
		0x036, 0x000B0475,
		0x036, 0x000C0475,
		0x036, 0x000C8475,
		0x036, 0x000D0475,
	0xA0000000,	0x00000000,
		0x036, 0x00000474,
		0x036, 0x00008474,
		0x036, 0x00010474,
		0x036, 0x00020474,
		0x036, 0x00028474,
		0x036, 0x00030474,
		0x036, 0x00040474,
		0x036, 0x00048474,
		0x036, 0x00050474,
		0x036, 0x00080474,
		0x036, 0x00088474,
		0x036, 0x00090474,
		0x036, 0x000A0474,
		0x036, 0x000A8474,
		0x036, 0x000B0474,
		0x036, 0x000C0474,
		0x036, 0x000C8474,
		0x036, 0x000D0474,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000004,
		0x037, 0x00000000,
		0x038, 0x0000514E,
		0x037, 0x00004000,
		0x038, 0x0000514E,
		0x037, 0x00008000,
		0x038, 0x0000514E,
		0x037, 0x00010000,
		0x038, 0x0000514E,
		0x037, 0x00014000,
		0x038, 0x0000514E,
		0x037, 0x00018000,
		0x038, 0x0000514E,
		0x037, 0x0001C000,
		0x038, 0x0000514E,
		0x037, 0x00020000,
		0x038, 0x0000514E,
		0x037, 0x00024000,
		0x038, 0x0000514E,
		0x037, 0x00028000,
		0x038, 0x0000514E,
		0x037, 0x0002C000,
		0x038, 0x0000714E,
		0x037, 0x00030000,
		0x038, 0x0000514E,
		0x037, 0x00034000,
		0x038, 0x0000514E,
		0x037, 0x00038000,
		0x038, 0x0000514E,
		0x037, 0x0003C000,
		0x038, 0x0000514E,
		0x037, 0x00040000,
		0x038, 0x0000514E,
		0x037, 0x00044000,
		0x038, 0x0000514E,
		0x037, 0x00048000,
		0x038, 0x0000514E,
		0x037, 0x00080000,
		0x038, 0x00005ECE,
		0x037, 0x00084000,
		0x038, 0x00005ECE,
		0x037, 0x00088000,
		0x038, 0x00005ECE,
		0x037, 0x00090000,
		0x038, 0x00005ECE,
		0x037, 0x00094000,
		0x038, 0x00005ECE,
		0x037, 0x00098000,
		0x038, 0x00005ECE,
		0x037, 0x0009C000,
		0x038, 0x00005ECE,
		0x037, 0x000A0000,
		0x038, 0x00005ECE,
		0x037, 0x000A4000,
		0x038, 0x00005ECE,
		0x037, 0x000A8000,
		0x038, 0x00005ECE,
		0x037, 0x000AC000,
		0x038, 0x00005ECE,
		0x037, 0x000B0000,
		0x038, 0x00005ECE,
		0x037, 0x000B4000,
		0x038, 0x00005ECE,
		0x037, 0x000B8000,
		0x038, 0x00005ECE,
		0x037, 0x000BC000,
		0x038, 0x00005ECE,
		0x037, 0x000C0000,
		0x038, 0x00005ECE,
		0x037, 0x000C4000,
		0x038, 0x00005ECE,
		0x037, 0x000C8000,
		0x038, 0x00005ECE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000008,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x03C, 0x0000007D,
		0x03C, 0x0000047D,
		0x03C, 0x0000087D,
		0x03C, 0x0000107D,
		0x03C, 0x0000147D,
		0x03C, 0x0000187D,
	0xB0000000,	0x00000000,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x03C, 0x00000275,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x00001275,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x00002275,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x03C, 0x0000027F,
		0x03C, 0x00000542,
		0x03C, 0x00000821,
		0x03C, 0x0000127F,
		0x03C, 0x00001542,
		0x03C, 0x00001821,
		0x03C, 0x0000227F,
		0x03C, 0x00002542,
		0x03C, 0x00002821,
	0xA0000000,	0x00000000,
		0x03C, 0x0000037E,
		0x03C, 0x00000575,
		0x03C, 0x00000971,
		0x03C, 0x0000127E,
		0x03C, 0x00001575,
		0x03C, 0x00001871,
		0x03C, 0x0000217E,
		0x03C, 0x00002575,
		0x03C, 0x00002871,
	0xB0000000,	0x00000000,
		0x0EF, 0x00000000,
		0x061, 0x000C0D47,
		0x062, 0x0000133C,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x063, 0x000750E7,
	0xA0000000,	0x00000000,
		0x063, 0x0007D0E7,
	0xB0000000,	0x00000000,
		0x064, 0x00014FEC,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
		0x065, 0x000920D0,
	0xA0000000,	0x00000000,
		0x065, 0x000923FF,
	0xB0000000,	0x00000000,
		0x066, 0x00000040,
		0x057, 0x00050000,
		0x056, 0x00051DF0,
	0x80000008,	0x00000000,	0x40000000,	0x00000000,
	0x90000008,	0x55000000,	0x40000000,	0x00000000,
	0x90000008,	0xaa000000,	0x40000000,	0x00000000,
	0xA0000000,	0x00000000,
		0x055, 0x00082060,
	0xB0000000,	0x00000000,

};

void
ODM_ReadAndConfig_MP_8814A_RadioD(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_RadioD)/sizeof(u4Byte);
	pu4Byte    Array       = Array_MP_8814A_RadioD;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_RadioD\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioD_8814A(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_MP_8814A_RadioD(void)
{
	   return 85;
}

/******************************************************************************
*                           TxPowerTrack.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 11, 11, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19},
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 15, 15, 16, 17, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};
u1Byte gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 15, 15, 16, 16, 17, 18},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 24, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 16, 17, 17},
	{0, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 15, 15, 16, 17, 17, 18, 19, 19, 20},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 11, 12, 13, 13, 14, 14, 15, 16, 17, 18, 18, 19, 20, 20},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 20, 21, 22, 23, 24, 25, 25},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 16, 17, 18, 19, 19, 20, 21},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};
u1Byte gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14};

void
ODM_ReadAndConfig_MP_8814A_TxPowerTrack(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8814A\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_P, gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_N, gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_P, gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_N, gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_P, gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_N, gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_P, gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_N, gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_P, gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_N, gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_P, gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_N, gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_8814A, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_Type0.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};
u1Byte gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
	{0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type0_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
};
u1Byte gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type0_8814A[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 5, 6, 7, 7, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type0_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};

void
ODM_ReadAndConfig_MP_8814A_TxPowerTrack_Type0(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8814A\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_P, gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_N, gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_P, gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_N, gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_P, gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_N, gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_P, gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_N, gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_P, gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_N, gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_P, gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_N, gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_Type0_8814A, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_Type2.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 10, 11, 11, 12, 12, 12, 13, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 5, 5, 6, 6, 7, 8, 9, 9, 10, 10, 10, 10, 11, 11, 12, 12, 13, 14, 15, 16, 16, 16, 16, 16, 16},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
};
u1Byte gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 22, 22, 22, 22, 22},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 22, 22, 22, 22, 22},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 23, 23, 23, 23, 23, 23},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 9, 10, 10, 11, 11, 12, 12, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 20, 20, 21, 21, 21, 21, 21},
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 11, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 11, 11, 12, 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21, 21},
	{0, 0, 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 20, 20, 20, 20, 20, 20},
	{0, 1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 10, 10, 11, 11, 11, 12, 13, 13, 13, 13, 14, 15, 15, 15, 15, 15, 15, 15},
	{0, 1, 2, 3, 3, 4, 5, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 12, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 7, 8, 9, 10, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type2_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15, 15, 16, 17, 18, 18, 19, 19, 20, 20, 20, 20, 20},
	{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 11, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 20, 20, 20, 20, 20, 20},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15, 15, 16, 17, 18, 19, 19, 20, 20, 20, 20, 20, 20, 20},
};
u1Byte gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_Type2_8814A[]    = {0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 8, 9, 10, 11, 11, 11, 11, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_Type2_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_Type2_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_Type2_8814A[]    = {0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 5, 6, 7, 8, 8, 9, 10, 10, 11, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type2_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type2_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type2_8814A[]    = {0, 0, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 9, 9, 9, 10, 11, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type2_8814A[]    = {0, 1, 1, 2, 3, 3, 4, 4, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_Type2_8814A[] = {0, 1, 1, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 8, 9, 9, 9, 9, 9, 9, 10, 10, 11, 11, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_Type2_8814A[] = {0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 10, 11, 12, 12, 13, 14, 14, 14, 14, 14, 14, 14};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_Type2_8814A[] = {0, 0, 1, 2, 2, 3, 4, 5, 5, 6, 6, 6, 6, 7, 8, 9, 9, 10, 10, 11, 11, 11, 12, 13, 13, 13, 13, 13, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_Type2_8814A[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type2_8814A[] = {0, 1, 1, 2, 2, 2, 3, 3, 4, 5, 6, 6, 7, 7, 8, 8, 9, 10, 10, 10, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type2_8814A[] = {0, 1, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type2_8814A[] = {0, 1, 2, 2, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 9, 9, 9, 9, 10, 10, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type2_8814A[] = {0, 0, 1, 2, 2, 3, 3, 4, 5, 5, 6, 7, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13};

void
ODM_ReadAndConfig_MP_8814A_TxPowerTrack_Type2(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8814A\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_P, gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_N, gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_P, gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_N, gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_P, gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_N, gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_P, gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_N, gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_P, gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_N, gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_P, gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_N, gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_Type2_8814A, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TxPowerTrack_Type5.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 3, 3, 3, 4, 6, 6, 7, 7, 8, 9, 10, 11, 12, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 4, 5, 6, 7, 7, 8, 7, 8, 10, 11, 12, 12, 13, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 5, 5, 6, 7, 8, 9, 9, 10, 11, 12, 13, 13, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16},
};
u1Byte gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 9, 10, 10, 11, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13},
	{0, 0, 0, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 8, 9, 11, 12, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 0, 1, 1, 2, 2, 3, 5, 7, 8, 9, 10, 11, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 3, 3, 4, 6, 7, 7, 8, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 3, 7, 7, 8, 8, 9, 11, 12, 12, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 2, 3, 4, 5, 7, 8, 8, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 0, 1, 1, 2, 2, 3, 4, 5, 6, 6, 7, 8, 9, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13},
	{0, 0, 1, 2, 3, 3, 5, 5, 6, 8, 8, 9, 10, 11, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 1, 2, 3, 4, 4, 5, 7, 8, 9, 9, 10, 11, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 2, 2, 2, 3, 4, 5, 6, 7, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 3, 7, 7, 8, 8, 9, 11, 12, 12, 13, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 2, 3, 4, 5, 7, 8, 8, 10, 11, 12, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 1, 2, 2, 4, 5, 6, 6, 7, 8, 9, 10, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 0, 0, 2, 3, 4, 5, 6, 8, 8, 9, 9, 11, 12, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14},
	{0, 0, 0, 1, 2, 3, 3, 4, 6, 7, 8, 9, 10, 11, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 0, 1, 2, 3, 3, 3, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12},
	{0, 2, 3, 4, 5, 7, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18},
	{0, 1, 2, 3, 3, 4, 6, 7, 8, 8, 10, 11, 11, 12, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14},
};
u1Byte gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type5_8814A[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 1, 3, 3, 3, 5, 5, 6, 6, 8, 8, 9, 10, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12},
	{0, 1, 2, 3, 4, 4, 5, 6, 7, 8, 8, 9, 11, 12, 13, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15},
	{0, 0, 1, 3, 3, 4, 5, 5, 6, 7, 7, 8, 10, 10, 11, 11, 11, 11, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13},
};
u1Byte gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_Type5_8814A[]    = {0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 7, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_Type5_8814A[]    = {0, 1, 1, 2, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10};
u1Byte gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_Type5_8814A[]    = {0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 9, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_Type5_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type5_8814A[]    = {0, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 7, 8, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type5_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type5_8814A[]    = {0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 10, 10, 11, 11, 11, 11, 111, 12, 12, 12, 12, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type5_8814A[]    = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 6, 7, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_Type5_8814A[] = {0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 11, 11, 10, 11, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_Type5_8814A[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_Type5_8814A[] = {0, 2, 3, 4, 4, 5, 6, 6, 7, 8, 8, 8, 8, 9, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12};
u1Byte gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_Type5_8814A[] = {0, 0, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type5_8814A[] = {0, 2, 3, 4, 4, 5, 6, 6, 6, 7, 7, 8, 8, 9, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
u1Byte gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type5_8814A[] = {0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type5_8814A[] = {0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10};
u1Byte gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type5_8814A[] = {0, 1, 1, 2, 2, 2, 3, 4, 4, 5, 6, 7, 8, 8, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10};

void
ODM_ReadAndConfig_MP_8814A_TxPowerTrack_Type5(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_MP_8814A\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_MP_2GA_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_MP_2GA_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_P, gDeltaSwingTableIdx_MP_2GB_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GB_N, gDeltaSwingTableIdx_MP_2GB_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_P, gDeltaSwingTableIdx_MP_2GC_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GC_N, gDeltaSwingTableIdx_MP_2GC_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_P, gDeltaSwingTableIdx_MP_2GD_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GD_N, gDeltaSwingTableIdx_MP_2GD_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_MP_2GCCKA_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_MP_2GCCKA_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_P, gDeltaSwingTableIdx_MP_2GCCKB_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKB_N, gDeltaSwingTableIdx_MP_2GCCKB_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_P, gDeltaSwingTableIdx_MP_2GCCKC_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKC_N, gDeltaSwingTableIdx_MP_2GCCKC_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_P, gDeltaSwingTableIdx_MP_2GCCKD_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKD_N, gDeltaSwingTableIdx_MP_2GCCKD_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_MP_5GA_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_MP_5GA_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_P, gDeltaSwingTableIdx_MP_5GB_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GB_N, gDeltaSwingTableIdx_MP_5GB_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_P, gDeltaSwingTableIdx_MP_5GC_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GC_N, gDeltaSwingTableIdx_MP_5GC_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_P, gDeltaSwingTableIdx_MP_5GD_P_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GD_N, gDeltaSwingTableIdx_MP_5GD_N_TxPowerTrack_Type5_8814A, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TXPWR_LMT.TXT
******************************************************************************/

const char *Array_MP_8814A_TXPWR_LMT[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "32", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "32", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "30", 
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "01", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "02", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "03", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "04", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "05", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "06", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "07", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "08", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "09", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "10", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "28", 
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "11", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "12", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "13", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "28", 
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "01", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "02", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "03", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "04", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "05", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "06", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "07", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "08", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "09", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "10", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "26", 
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "11", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "12", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "13", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "4T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "32", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "32", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "30", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "30", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "28", 
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "03", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "04", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "05", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "06", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "07", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "08", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "09", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "10", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "28", 
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "11", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "12", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "13", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "26", 
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "03", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "04", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "05", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "06", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "07", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "08", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "09", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "10", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "26", 
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "11", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "12", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "13", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "32", 
	"MKK", "5G", "20M", "HT", "1T", "36", "32",
	"FCC", "5G", "20M", "HT", "1T", "40", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "32", 
	"MKK", "5G", "20M", "HT", "1T", "40", "32",
	"FCC", "5G", "20M", "HT", "1T", "44", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "32", 
	"MKK", "5G", "20M", "HT", "1T", "44", "32",
	"FCC", "5G", "20M", "HT", "1T", "48", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "32", 
	"MKK", "5G", "20M", "HT", "1T", "48", "32",
	"FCC", "5G", "20M", "HT", "1T", "52", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "32", 
	"MKK", "5G", "20M", "HT", "1T", "52", "32",
	"FCC", "5G", "20M", "HT", "1T", "56", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "32", 
	"MKK", "5G", "20M", "HT", "1T", "56", "32",
	"FCC", "5G", "20M", "HT", "1T", "60", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "32", 
	"MKK", "5G", "20M", "HT", "1T", "60", "32",
	"FCC", "5G", "20M", "HT", "1T", "64", "28", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "32", 
	"MKK", "5G", "20M", "HT", "1T", "64", "32",
	"FCC", "5G", "20M", "HT", "1T", "100", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "32", 
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "32", 
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "32", 
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "32", 
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "32", 
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "32", 
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "32", 
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "32", 
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "32", 
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "32", 
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "28", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "32", 
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "149", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "32", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "32", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "32", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "32", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "32", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "30", 
	"MKK", "5G", "20M", "HT", "2T", "36", "30",
	"FCC", "5G", "20M", "HT", "2T", "40", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "30", 
	"MKK", "5G", "20M", "HT", "2T", "40", "30",
	"FCC", "5G", "20M", "HT", "2T", "44", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "30", 
	"MKK", "5G", "20M", "HT", "2T", "44", "30",
	"FCC", "5G", "20M", "HT", "2T", "48", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "30", 
	"MKK", "5G", "20M", "HT", "2T", "48", "30",
	"FCC", "5G", "20M", "HT", "2T", "52", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "30", 
	"MKK", "5G", "20M", "HT", "2T", "52", "30",
	"FCC", "5G", "20M", "HT", "2T", "56", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "30", 
	"MKK", "5G", "20M", "HT", "2T", "56", "30",
	"FCC", "5G", "20M", "HT", "2T", "60", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "30", 
	"MKK", "5G", "20M", "HT", "2T", "60", "30",
	"FCC", "5G", "20M", "HT", "2T", "64", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "30", 
	"MKK", "5G", "20M", "HT", "2T", "64", "30",
	"FCC", "5G", "20M", "HT", "2T", "100", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "30", 
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "30", 
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "30", 
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "30", 
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "30", 
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "30", 
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "30", 
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "30", 
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "30", 
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "30", 
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "30", 
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "149", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "30", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "30", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "30", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "30", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "30", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "20M", "HT", "3T", "36", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "36", "28", 
	"MKK", "5G", "20M", "HT", "3T", "36", "28",
	"FCC", "5G", "20M", "HT", "3T", "40", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "40", "28", 
	"MKK", "5G", "20M", "HT", "3T", "40", "28",
	"FCC", "5G", "20M", "HT", "3T", "44", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "44", "28", 
	"MKK", "5G", "20M", "HT", "3T", "44", "28",
	"FCC", "5G", "20M", "HT", "3T", "48", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "48", "28", 
	"MKK", "5G", "20M", "HT", "3T", "48", "28",
	"FCC", "5G", "20M", "HT", "3T", "52", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "52", "28", 
	"MKK", "5G", "20M", "HT", "3T", "52", "28",
	"FCC", "5G", "20M", "HT", "3T", "56", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "56", "28", 
	"MKK", "5G", "20M", "HT", "3T", "56", "28",
	"FCC", "5G", "20M", "HT", "3T", "60", "28", 
	"ETSI", "5G", "20M", "HT", "3T", "60", "28", 
	"MKK", "5G", "20M", "HT", "3T", "60", "28",
	"FCC", "5G", "20M", "HT", "3T", "64", "24", 
	"ETSI", "5G", "20M", "HT", "3T", "64", "28", 
	"MKK", "5G", "20M", "HT", "3T", "64", "28",
	"FCC", "5G", "20M", "HT", "3T", "100", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "100", "28", 
	"MKK", "5G", "20M", "HT", "3T", "100", "28",
	"FCC", "5G", "20M", "HT", "3T", "104", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "104", "28", 
	"MKK", "5G", "20M", "HT", "3T", "104", "28",
	"FCC", "5G", "20M", "HT", "3T", "108", "28", 
	"ETSI", "5G", "20M", "HT", "3T", "108", "28", 
	"MKK", "5G", "20M", "HT", "3T", "108", "28",
	"FCC", "5G", "20M", "HT", "3T", "112", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "112", "28", 
	"MKK", "5G", "20M", "HT", "3T", "112", "28",
	"FCC", "5G", "20M", "HT", "3T", "116", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "116", "28", 
	"MKK", "5G", "20M", "HT", "3T", "116", "28",
	"FCC", "5G", "20M", "HT", "3T", "120", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "120", "28", 
	"MKK", "5G", "20M", "HT", "3T", "120", "28",
	"FCC", "5G", "20M", "HT", "3T", "124", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "124", "28", 
	"MKK", "5G", "20M", "HT", "3T", "124", "28",
	"FCC", "5G", "20M", "HT", "3T", "128", "28", 
	"ETSI", "5G", "20M", "HT", "3T", "128", "28", 
	"MKK", "5G", "20M", "HT", "3T", "128", "28",
	"FCC", "5G", "20M", "HT", "3T", "132", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "132", "28", 
	"MKK", "5G", "20M", "HT", "3T", "132", "28",
	"FCC", "5G", "20M", "HT", "3T", "136", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "136", "28", 
	"MKK", "5G", "20M", "HT", "3T", "136", "28",
	"FCC", "5G", "20M", "HT", "3T", "140", "24", 
	"ETSI", "5G", "20M", "HT", "3T", "140", "28", 
	"MKK", "5G", "20M", "HT", "3T", "140", "28",
	"FCC", "5G", "20M", "HT", "3T", "149", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "149", "28", 
	"MKK", "5G", "20M", "HT", "3T", "149", "63",
	"FCC", "5G", "20M", "HT", "3T", "153", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "153", "28", 
	"MKK", "5G", "20M", "HT", "3T", "153", "63",
	"FCC", "5G", "20M", "HT", "3T", "157", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "157", "28", 
	"MKK", "5G", "20M", "HT", "3T", "157", "63",
	"FCC", "5G", "20M", "HT", "3T", "161", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "161", "28", 
	"MKK", "5G", "20M", "HT", "3T", "161", "63",
	"FCC", "5G", "20M", "HT", "3T", "165", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "165", "28", 
	"MKK", "5G", "20M", "HT", "3T", "165", "63",
	"FCC", "5G", "20M", "HT", "4T", "36", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "36", "26", 
	"MKK", "5G", "20M", "HT", "4T", "36", "26",
	"FCC", "5G", "20M", "HT", "4T", "40", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "40", "26", 
	"MKK", "5G", "20M", "HT", "4T", "40", "26",
	"FCC", "5G", "20M", "HT", "4T", "44", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "44", "26", 
	"MKK", "5G", "20M", "HT", "4T", "44", "26",
	"FCC", "5G", "20M", "HT", "4T", "48", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "48", "26", 
	"MKK", "5G", "20M", "HT", "4T", "48", "26",
	"FCC", "5G", "20M", "HT", "4T", "52", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "52", "26", 
	"MKK", "5G", "20M", "HT", "4T", "52", "26",
	"FCC", "5G", "20M", "HT", "4T", "56", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "56", "26", 
	"MKK", "5G", "20M", "HT", "4T", "56", "26",
	"FCC", "5G", "20M", "HT", "4T", "60", "26", 
	"ETSI", "5G", "20M", "HT", "4T", "60", "26", 
	"MKK", "5G", "20M", "HT", "4T", "60", "26",
	"FCC", "5G", "20M", "HT", "4T", "64", "22", 
	"ETSI", "5G", "20M", "HT", "4T", "64", "26", 
	"MKK", "5G", "20M", "HT", "4T", "64", "26",
	"FCC", "5G", "20M", "HT", "4T", "100", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "100", "26", 
	"MKK", "5G", "20M", "HT", "4T", "100", "26",
	"FCC", "5G", "20M", "HT", "4T", "104", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "104", "26", 
	"MKK", "5G", "20M", "HT", "4T", "104", "26",
	"FCC", "5G", "20M", "HT", "4T", "108", "26", 
	"ETSI", "5G", "20M", "HT", "4T", "108", "26", 
	"MKK", "5G", "20M", "HT", "4T", "108", "26",
	"FCC", "5G", "20M", "HT", "4T", "112", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "112", "26", 
	"MKK", "5G", "20M", "HT", "4T", "112", "26",
	"FCC", "5G", "20M", "HT", "4T", "116", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "116", "26", 
	"MKK", "5G", "20M", "HT", "4T", "116", "26",
	"FCC", "5G", "20M", "HT", "4T", "120", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "120", "26", 
	"MKK", "5G", "20M", "HT", "4T", "120", "26",
	"FCC", "5G", "20M", "HT", "4T", "124", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "124", "26", 
	"MKK", "5G", "20M", "HT", "4T", "124", "26",
	"FCC", "5G", "20M", "HT", "4T", "128", "26", 
	"ETSI", "5G", "20M", "HT", "4T", "128", "26", 
	"MKK", "5G", "20M", "HT", "4T", "128", "26",
	"FCC", "5G", "20M", "HT", "4T", "132", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "132", "26", 
	"MKK", "5G", "20M", "HT", "4T", "132", "26",
	"FCC", "5G", "20M", "HT", "4T", "136", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "136", "26", 
	"MKK", "5G", "20M", "HT", "4T", "136", "26",
	"FCC", "5G", "20M", "HT", "4T", "140", "22", 
	"ETSI", "5G", "20M", "HT", "4T", "140", "26", 
	"MKK", "5G", "20M", "HT", "4T", "140", "26",
	"FCC", "5G", "20M", "HT", "4T", "149", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "149", "26", 
	"MKK", "5G", "20M", "HT", "4T", "149", "63",
	"FCC", "5G", "20M", "HT", "4T", "153", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "153", "26", 
	"MKK", "5G", "20M", "HT", "4T", "153", "63",
	"FCC", "5G", "20M", "HT", "4T", "157", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "157", "26", 
	"MKK", "5G", "20M", "HT", "4T", "157", "63",
	"FCC", "5G", "20M", "HT", "4T", "161", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "161", "26", 
	"MKK", "5G", "20M", "HT", "4T", "161", "63",
	"FCC", "5G", "20M", "HT", "4T", "165", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "165", "26", 
	"MKK", "5G", "20M", "HT", "4T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "32", 
	"MKK", "5G", "40M", "HT", "1T", "38", "32",
	"FCC", "5G", "40M", "HT", "1T", "46", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "32", 
	"MKK", "5G", "40M", "HT", "1T", "46", "32",
	"FCC", "5G", "40M", "HT", "1T", "54", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "32", 
	"MKK", "5G", "40M", "HT", "1T", "54", "32",
	"FCC", "5G", "40M", "HT", "1T", "62", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "32", 
	"MKK", "5G", "40M", "HT", "1T", "62", "32",
	"FCC", "5G", "40M", "HT", "1T", "102", "28", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "32", 
	"MKK", "5G", "40M", "HT", "1T", "102", "32",
	"FCC", "5G", "40M", "HT", "1T", "110", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "32", 
	"MKK", "5G", "40M", "HT", "1T", "110", "32",
	"FCC", "5G", "40M", "HT", "1T", "118", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "32", 
	"MKK", "5G", "40M", "HT", "1T", "118", "32",
	"FCC", "5G", "40M", "HT", "1T", "126", "34", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "32", 
	"MKK", "5G", "40M", "HT", "1T", "126", "32",
	"FCC", "5G", "40M", "HT", "1T", "134", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "32", 
	"MKK", "5G", "40M", "HT", "1T", "134", "32",
	"FCC", "5G", "40M", "HT", "1T", "151", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "32", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "32", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "28", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "30", 
	"MKK", "5G", "40M", "HT", "2T", "38", "30",
	"FCC", "5G", "40M", "HT", "2T", "46", "28", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "30", 
	"MKK", "5G", "40M", "HT", "2T", "46", "30",
	"FCC", "5G", "40M", "HT", "2T", "54", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "30", 
	"MKK", "5G", "40M", "HT", "2T", "54", "30",
	"FCC", "5G", "40M", "HT", "2T", "62", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "30", 
	"MKK", "5G", "40M", "HT", "2T", "62", "30",
	"FCC", "5G", "40M", "HT", "2T", "102", "26", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "30", 
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "30", 
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "34", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "30", 
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "32", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "30", 
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "30", 
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "151", "34", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "30", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "34", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "30", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "40M", "HT", "3T", "38", "26", 
	"ETSI", "5G", "40M", "HT", "3T", "38", "28", 
	"MKK", "5G", "40M", "HT", "3T", "38", "28",
	"FCC", "5G", "40M", "HT", "3T", "46", "26", 
	"ETSI", "5G", "40M", "HT", "3T", "46", "28", 
	"MKK", "5G", "40M", "HT", "3T", "46", "28",
	"FCC", "5G", "40M", "HT", "3T", "54", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "54", "28", 
	"MKK", "5G", "40M", "HT", "3T", "54", "28",
	"FCC", "5G", "40M", "HT", "3T", "62", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "62", "28", 
	"MKK", "5G", "40M", "HT", "3T", "62", "28",
	"FCC", "5G", "40M", "HT", "3T", "102", "24", 
	"ETSI", "5G", "40M", "HT", "3T", "102", "28", 
	"MKK", "5G", "40M", "HT", "3T", "102", "28",
	"FCC", "5G", "40M", "HT", "3T", "110", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "110", "28", 
	"MKK", "5G", "40M", "HT", "3T", "110", "28",
	"FCC", "5G", "40M", "HT", "3T", "118", "32", 
	"ETSI", "5G", "40M", "HT", "3T", "118", "28", 
	"MKK", "5G", "40M", "HT", "3T", "118", "28",
	"FCC", "5G", "40M", "HT", "3T", "126", "30", 
	"ETSI", "5G", "40M", "HT", "3T", "126", "28", 
	"MKK", "5G", "40M", "HT", "3T", "126", "28",
	"FCC", "5G", "40M", "HT", "3T", "134", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "134", "28", 
	"MKK", "5G", "40M", "HT", "3T", "134", "28",
	"FCC", "5G", "40M", "HT", "3T", "151", "32", 
	"ETSI", "5G", "40M", "HT", "3T", "151", "28", 
	"MKK", "5G", "40M", "HT", "3T", "151", "63",
	"FCC", "5G", "40M", "HT", "3T", "159", "32", 
	"ETSI", "5G", "40M", "HT", "3T", "159", "28", 
	"MKK", "5G", "40M", "HT", "3T", "159", "63",
	"FCC", "5G", "40M", "HT", "4T", "38", "24", 
	"ETSI", "5G", "40M", "HT", "4T", "38", "26", 
	"MKK", "5G", "40M", "HT", "4T", "38", "26",
	"FCC", "5G", "40M", "HT", "4T", "46", "24", 
	"ETSI", "5G", "40M", "HT", "4T", "46", "26", 
	"MKK", "5G", "40M", "HT", "4T", "46", "26",
	"FCC", "5G", "40M", "HT", "4T", "54", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "54", "26", 
	"MKK", "5G", "40M", "HT", "4T", "54", "26",
	"FCC", "5G", "40M", "HT", "4T", "62", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "62", "26", 
	"MKK", "5G", "40M", "HT", "4T", "62", "26",
	"FCC", "5G", "40M", "HT", "4T", "102", "22", 
	"ETSI", "5G", "40M", "HT", "4T", "102", "26", 
	"MKK", "5G", "40M", "HT", "4T", "102", "26",
	"FCC", "5G", "40M", "HT", "4T", "110", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "110", "26", 
	"MKK", "5G", "40M", "HT", "4T", "110", "26",
	"FCC", "5G", "40M", "HT", "4T", "118", "30", 
	"ETSI", "5G", "40M", "HT", "4T", "118", "26", 
	"MKK", "5G", "40M", "HT", "4T", "118", "26",
	"FCC", "5G", "40M", "HT", "4T", "126", "28", 
	"ETSI", "5G", "40M", "HT", "4T", "126", "26", 
	"MKK", "5G", "40M", "HT", "4T", "126", "26",
	"FCC", "5G", "40M", "HT", "4T", "134", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "134", "26", 
	"MKK", "5G", "40M", "HT", "4T", "134", "26",
	"FCC", "5G", "40M", "HT", "4T", "151", "30", 
	"ETSI", "5G", "40M", "HT", "4T", "151", "26", 
	"MKK", "5G", "40M", "HT", "4T", "151", "63",
	"FCC", "5G", "40M", "HT", "4T", "159", "30", 
	"ETSI", "5G", "40M", "HT", "4T", "159", "26", 
	"MKK", "5G", "40M", "HT", "4T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "32",
	"FCC", "5G", "80M", "VHT", "1T", "58", "28", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "32",
	"FCC", "5G", "80M", "VHT", "1T", "106", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "32",
	"FCC", "5G", "80M", "VHT", "1T", "122", "34", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "32",
	"FCC", "5G", "80M", "VHT", "1T", "155", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "28", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "30",
	"FCC", "5G", "80M", "VHT", "2T", "58", "26", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "30",
	"FCC", "5G", "80M", "VHT", "2T", "106", "28", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "32", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "155", "34", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"FCC", "5G", "80M", "VHT", "3T", "42", "26", 
	"ETSI", "5G", "80M", "VHT", "3T", "42", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "42", "28",
	"FCC", "5G", "80M", "VHT", "3T", "58", "24", 
	"ETSI", "5G", "80M", "VHT", "3T", "58", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "58", "28",
	"FCC", "5G", "80M", "VHT", "3T", "106", "26", 
	"ETSI", "5G", "80M", "VHT", "3T", "106", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "106", "28",
	"FCC", "5G", "80M", "VHT", "3T", "122", "30", 
	"ETSI", "5G", "80M", "VHT", "3T", "122", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "122", "28",
	"FCC", "5G", "80M", "VHT", "3T", "155", "32", 
	"ETSI", "5G", "80M", "VHT", "3T", "155", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "155", "63",
	"FCC", "5G", "80M", "VHT", "4T", "42", "24", 
	"ETSI", "5G", "80M", "VHT", "4T", "42", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "42", "26",
	"FCC", "5G", "80M", "VHT", "4T", "58", "22", 
	"ETSI", "5G", "80M", "VHT", "4T", "58", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "58", "26",
	"FCC", "5G", "80M", "VHT", "4T", "106", "24", 
	"ETSI", "5G", "80M", "VHT", "4T", "106", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "106", "26",
	"FCC", "5G", "80M", "VHT", "4T", "122", "28", 
	"ETSI", "5G", "80M", "VHT", "4T", "122", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "122", "26",
	"FCC", "5G", "80M", "VHT", "4T", "155", "30", 
	"ETSI", "5G", "80M", "VHT", "4T", "155", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "155", "63"
};

void
ODM_ReadAndConfig_MP_8814A_TXPWR_LMT(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_TXPWR_LMT)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_MP_8814A_TXPWR_LMT;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_TXPWR_LMT\n"));

	for (i = 0; i < ArrayLen; i += 7) {
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
	
		odm_ConfigBB_TXPWR_LMT_8814A(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

/******************************************************************************
*                           TXPWR_LMT_type2.TXT
******************************************************************************/

const char *Array_MP_8814A_TXPWR_LMT_type2[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "36", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "36",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "36", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "36",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "36", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "36", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "36", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "36", 
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "36", 
	"MKK", "2.4G", "20M", "HT", "3T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "01", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "02", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "03", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "04", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "05", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "06", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "07", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "08", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "09", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "10", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "36", 
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "11", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "12", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "36", 
	"MKK", "2.4G", "20M", "HT", "4T", "13", "36",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "4T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "36", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "36",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "36", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "36", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "36",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "36", 
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "12", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "36", 
	"MKK", "2.4G", "40M", "HT", "3T", "13", "36",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "03", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "04", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "05", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "06", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "07", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "08", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "09", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "10", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "36", 
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "11", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "12", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "36", 
	"MKK", "2.4G", "40M", "HT", "4T", "13", "36",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "36",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "36", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "36", 
	"MKK", "5G", "20M", "HT", "1T", "36", "36",
	"FCC", "5G", "20M", "HT", "1T", "40", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "36", 
	"MKK", "5G", "20M", "HT", "1T", "40", "36",
	"FCC", "5G", "20M", "HT", "1T", "44", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "36", 
	"MKK", "5G", "20M", "HT", "1T", "44", "36",
	"FCC", "5G", "20M", "HT", "1T", "48", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "36", 
	"MKK", "5G", "20M", "HT", "1T", "48", "36",
	"FCC", "5G", "20M", "HT", "1T", "52", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "36", 
	"MKK", "5G", "20M", "HT", "1T", "52", "36",
	"FCC", "5G", "20M", "HT", "1T", "56", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "36", 
	"MKK", "5G", "20M", "HT", "1T", "56", "36",
	"FCC", "5G", "20M", "HT", "1T", "60", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "36", 
	"MKK", "5G", "20M", "HT", "1T", "60", "36",
	"FCC", "5G", "20M", "HT", "1T", "64", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "36", 
	"MKK", "5G", "20M", "HT", "1T", "64", "36",
	"FCC", "5G", "20M", "HT", "1T", "100", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "36", 
	"MKK", "5G", "20M", "HT", "1T", "100", "36",
	"FCC", "5G", "20M", "HT", "1T", "104", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "36", 
	"MKK", "5G", "20M", "HT", "1T", "104", "36",
	"FCC", "5G", "20M", "HT", "1T", "108", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "36", 
	"MKK", "5G", "20M", "HT", "1T", "108", "36",
	"FCC", "5G", "20M", "HT", "1T", "112", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "36", 
	"MKK", "5G", "20M", "HT", "1T", "112", "36",
	"FCC", "5G", "20M", "HT", "1T", "116", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "36", 
	"MKK", "5G", "20M", "HT", "1T", "116", "36",
	"FCC", "5G", "20M", "HT", "1T", "120", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "36", 
	"MKK", "5G", "20M", "HT", "1T", "120", "36",
	"FCC", "5G", "20M", "HT", "1T", "124", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "36", 
	"MKK", "5G", "20M", "HT", "1T", "124", "36",
	"FCC", "5G", "20M", "HT", "1T", "128", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "36", 
	"MKK", "5G", "20M", "HT", "1T", "128", "36",
	"FCC", "5G", "20M", "HT", "1T", "132", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "36", 
	"MKK", "5G", "20M", "HT", "1T", "132", "36",
	"FCC", "5G", "20M", "HT", "1T", "136", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "36", 
	"MKK", "5G", "20M", "HT", "1T", "136", "36",
	"FCC", "5G", "20M", "HT", "1T", "140", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "36", 
	"MKK", "5G", "20M", "HT", "1T", "140", "36",
	"FCC", "5G", "20M", "HT", "1T", "149", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "36", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "36", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "36", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "36", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "36", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "36", 
	"MKK", "5G", "20M", "HT", "2T", "36", "36",
	"FCC", "5G", "20M", "HT", "2T", "40", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "36", 
	"MKK", "5G", "20M", "HT", "2T", "40", "36",
	"FCC", "5G", "20M", "HT", "2T", "44", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "36", 
	"MKK", "5G", "20M", "HT", "2T", "44", "36",
	"FCC", "5G", "20M", "HT", "2T", "48", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "36", 
	"MKK", "5G", "20M", "HT", "2T", "48", "36",
	"FCC", "5G", "20M", "HT", "2T", "52", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "36", 
	"MKK", "5G", "20M", "HT", "2T", "52", "36",
	"FCC", "5G", "20M", "HT", "2T", "56", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "36", 
	"MKK", "5G", "20M", "HT", "2T", "56", "36",
	"FCC", "5G", "20M", "HT", "2T", "60", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "36", 
	"MKK", "5G", "20M", "HT", "2T", "60", "36",
	"FCC", "5G", "20M", "HT", "2T", "64", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "36", 
	"MKK", "5G", "20M", "HT", "2T", "64", "36",
	"FCC", "5G", "20M", "HT", "2T", "100", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "36", 
	"MKK", "5G", "20M", "HT", "2T", "100", "36",
	"FCC", "5G", "20M", "HT", "2T", "104", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "36", 
	"MKK", "5G", "20M", "HT", "2T", "104", "36",
	"FCC", "5G", "20M", "HT", "2T", "108", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "36", 
	"MKK", "5G", "20M", "HT", "2T", "108", "36",
	"FCC", "5G", "20M", "HT", "2T", "112", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "36", 
	"MKK", "5G", "20M", "HT", "2T", "112", "36",
	"FCC", "5G", "20M", "HT", "2T", "116", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "36", 
	"MKK", "5G", "20M", "HT", "2T", "116", "36",
	"FCC", "5G", "20M", "HT", "2T", "120", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "36", 
	"MKK", "5G", "20M", "HT", "2T", "120", "36",
	"FCC", "5G", "20M", "HT", "2T", "124", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "36", 
	"MKK", "5G", "20M", "HT", "2T", "124", "36",
	"FCC", "5G", "20M", "HT", "2T", "128", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "36", 
	"MKK", "5G", "20M", "HT", "2T", "128", "36",
	"FCC", "5G", "20M", "HT", "2T", "132", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "36", 
	"MKK", "5G", "20M", "HT", "2T", "132", "36",
	"FCC", "5G", "20M", "HT", "2T", "136", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "36", 
	"MKK", "5G", "20M", "HT", "2T", "136", "36",
	"FCC", "5G", "20M", "HT", "2T", "140", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "36", 
	"MKK", "5G", "20M", "HT", "2T", "140", "36",
	"FCC", "5G", "20M", "HT", "2T", "149", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "36", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "36", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "36", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "36", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "36", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "36", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "20M", "HT", "3T", "36", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "36", "36", 
	"MKK", "5G", "20M", "HT", "3T", "36", "36",
	"FCC", "5G", "20M", "HT", "3T", "40", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "40", "36", 
	"MKK", "5G", "20M", "HT", "3T", "40", "36",
	"FCC", "5G", "20M", "HT", "3T", "44", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "44", "36", 
	"MKK", "5G", "20M", "HT", "3T", "44", "36",
	"FCC", "5G", "20M", "HT", "3T", "48", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "48", "36", 
	"MKK", "5G", "20M", "HT", "3T", "48", "36",
	"FCC", "5G", "20M", "HT", "3T", "52", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "52", "36", 
	"MKK", "5G", "20M", "HT", "3T", "52", "36",
	"FCC", "5G", "20M", "HT", "3T", "56", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "56", "36", 
	"MKK", "5G", "20M", "HT", "3T", "56", "36",
	"FCC", "5G", "20M", "HT", "3T", "60", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "60", "36", 
	"MKK", "5G", "20M", "HT", "3T", "60", "36",
	"FCC", "5G", "20M", "HT", "3T", "64", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "64", "36", 
	"MKK", "5G", "20M", "HT", "3T", "64", "36",
	"FCC", "5G", "20M", "HT", "3T", "100", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "100", "36", 
	"MKK", "5G", "20M", "HT", "3T", "100", "36",
	"FCC", "5G", "20M", "HT", "3T", "104", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "104", "36", 
	"MKK", "5G", "20M", "HT", "3T", "104", "36",
	"FCC", "5G", "20M", "HT", "3T", "108", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "108", "36", 
	"MKK", "5G", "20M", "HT", "3T", "108", "36",
	"FCC", "5G", "20M", "HT", "3T", "112", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "112", "36", 
	"MKK", "5G", "20M", "HT", "3T", "112", "36",
	"FCC", "5G", "20M", "HT", "3T", "116", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "116", "36", 
	"MKK", "5G", "20M", "HT", "3T", "116", "36",
	"FCC", "5G", "20M", "HT", "3T", "120", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "120", "36", 
	"MKK", "5G", "20M", "HT", "3T", "120", "36",
	"FCC", "5G", "20M", "HT", "3T", "124", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "124", "36", 
	"MKK", "5G", "20M", "HT", "3T", "124", "36",
	"FCC", "5G", "20M", "HT", "3T", "128", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "128", "36", 
	"MKK", "5G", "20M", "HT", "3T", "128", "36",
	"FCC", "5G", "20M", "HT", "3T", "132", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "132", "36", 
	"MKK", "5G", "20M", "HT", "3T", "132", "36",
	"FCC", "5G", "20M", "HT", "3T", "136", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "136", "36", 
	"MKK", "5G", "20M", "HT", "3T", "136", "36",
	"FCC", "5G", "20M", "HT", "3T", "140", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "140", "36", 
	"MKK", "5G", "20M", "HT", "3T", "140", "36",
	"FCC", "5G", "20M", "HT", "3T", "149", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "149", "36", 
	"MKK", "5G", "20M", "HT", "3T", "149", "63",
	"FCC", "5G", "20M", "HT", "3T", "153", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "153", "36", 
	"MKK", "5G", "20M", "HT", "3T", "153", "63",
	"FCC", "5G", "20M", "HT", "3T", "157", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "157", "36", 
	"MKK", "5G", "20M", "HT", "3T", "157", "63",
	"FCC", "5G", "20M", "HT", "3T", "161", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "161", "36", 
	"MKK", "5G", "20M", "HT", "3T", "161", "63",
	"FCC", "5G", "20M", "HT", "3T", "165", "36", 
	"ETSI", "5G", "20M", "HT", "3T", "165", "36", 
	"MKK", "5G", "20M", "HT", "3T", "165", "63",
	"FCC", "5G", "20M", "HT", "4T", "36", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "36", "36", 
	"MKK", "5G", "20M", "HT", "4T", "36", "36",
	"FCC", "5G", "20M", "HT", "4T", "40", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "40", "36", 
	"MKK", "5G", "20M", "HT", "4T", "40", "36",
	"FCC", "5G", "20M", "HT", "4T", "44", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "44", "36", 
	"MKK", "5G", "20M", "HT", "4T", "44", "36",
	"FCC", "5G", "20M", "HT", "4T", "48", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "48", "36", 
	"MKK", "5G", "20M", "HT", "4T", "48", "36",
	"FCC", "5G", "20M", "HT", "4T", "52", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "52", "36", 
	"MKK", "5G", "20M", "HT", "4T", "52", "36",
	"FCC", "5G", "20M", "HT", "4T", "56", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "56", "36", 
	"MKK", "5G", "20M", "HT", "4T", "56", "36",
	"FCC", "5G", "20M", "HT", "4T", "60", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "60", "36", 
	"MKK", "5G", "20M", "HT", "4T", "60", "36",
	"FCC", "5G", "20M", "HT", "4T", "64", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "64", "36", 
	"MKK", "5G", "20M", "HT", "4T", "64", "36",
	"FCC", "5G", "20M", "HT", "4T", "100", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "100", "36", 
	"MKK", "5G", "20M", "HT", "4T", "100", "36",
	"FCC", "5G", "20M", "HT", "4T", "104", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "104", "36", 
	"MKK", "5G", "20M", "HT", "4T", "104", "36",
	"FCC", "5G", "20M", "HT", "4T", "108", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "108", "36", 
	"MKK", "5G", "20M", "HT", "4T", "108", "36",
	"FCC", "5G", "20M", "HT", "4T", "112", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "112", "36", 
	"MKK", "5G", "20M", "HT", "4T", "112", "36",
	"FCC", "5G", "20M", "HT", "4T", "116", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "116", "36", 
	"MKK", "5G", "20M", "HT", "4T", "116", "36",
	"FCC", "5G", "20M", "HT", "4T", "120", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "120", "36", 
	"MKK", "5G", "20M", "HT", "4T", "120", "36",
	"FCC", "5G", "20M", "HT", "4T", "124", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "124", "36", 
	"MKK", "5G", "20M", "HT", "4T", "124", "36",
	"FCC", "5G", "20M", "HT", "4T", "128", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "128", "36", 
	"MKK", "5G", "20M", "HT", "4T", "128", "36",
	"FCC", "5G", "20M", "HT", "4T", "132", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "132", "36", 
	"MKK", "5G", "20M", "HT", "4T", "132", "36",
	"FCC", "5G", "20M", "HT", "4T", "136", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "136", "36", 
	"MKK", "5G", "20M", "HT", "4T", "136", "36",
	"FCC", "5G", "20M", "HT", "4T", "140", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "140", "36", 
	"MKK", "5G", "20M", "HT", "4T", "140", "36",
	"FCC", "5G", "20M", "HT", "4T", "149", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "149", "36", 
	"MKK", "5G", "20M", "HT", "4T", "149", "63",
	"FCC", "5G", "20M", "HT", "4T", "153", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "153", "36", 
	"MKK", "5G", "20M", "HT", "4T", "153", "63",
	"FCC", "5G", "20M", "HT", "4T", "157", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "157", "36", 
	"MKK", "5G", "20M", "HT", "4T", "157", "63",
	"FCC", "5G", "20M", "HT", "4T", "161", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "161", "36", 
	"MKK", "5G", "20M", "HT", "4T", "161", "63",
	"FCC", "5G", "20M", "HT", "4T", "165", "36", 
	"ETSI", "5G", "20M", "HT", "4T", "165", "36", 
	"MKK", "5G", "20M", "HT", "4T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "36", 
	"MKK", "5G", "40M", "HT", "1T", "38", "36",
	"FCC", "5G", "40M", "HT", "1T", "46", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "36", 
	"MKK", "5G", "40M", "HT", "1T", "46", "36",
	"FCC", "5G", "40M", "HT", "1T", "54", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "36", 
	"MKK", "5G", "40M", "HT", "1T", "54", "36",
	"FCC", "5G", "40M", "HT", "1T", "62", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "36", 
	"MKK", "5G", "40M", "HT", "1T", "62", "36",
	"FCC", "5G", "40M", "HT", "1T", "102", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "36", 
	"MKK", "5G", "40M", "HT", "1T", "102", "36",
	"FCC", "5G", "40M", "HT", "1T", "110", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "36", 
	"MKK", "5G", "40M", "HT", "1T", "110", "36",
	"FCC", "5G", "40M", "HT", "1T", "118", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "36", 
	"MKK", "5G", "40M", "HT", "1T", "118", "36",
	"FCC", "5G", "40M", "HT", "1T", "126", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "36", 
	"MKK", "5G", "40M", "HT", "1T", "126", "36",
	"FCC", "5G", "40M", "HT", "1T", "134", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "36", 
	"MKK", "5G", "40M", "HT", "1T", "134", "36",
	"FCC", "5G", "40M", "HT", "1T", "151", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "36", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "36", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "36", 
	"MKK", "5G", "40M", "HT", "2T", "38", "36",
	"FCC", "5G", "40M", "HT", "2T", "46", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "36", 
	"MKK", "5G", "40M", "HT", "2T", "46", "36",
	"FCC", "5G", "40M", "HT", "2T", "54", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "36", 
	"MKK", "5G", "40M", "HT", "2T", "54", "36",
	"FCC", "5G", "40M", "HT", "2T", "62", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "36", 
	"MKK", "5G", "40M", "HT", "2T", "62", "36",
	"FCC", "5G", "40M", "HT", "2T", "102", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "36", 
	"MKK", "5G", "40M", "HT", "2T", "102", "36",
	"FCC", "5G", "40M", "HT", "2T", "110", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "36", 
	"MKK", "5G", "40M", "HT", "2T", "110", "36",
	"FCC", "5G", "40M", "HT", "2T", "118", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "36", 
	"MKK", "5G", "40M", "HT", "2T", "118", "36",
	"FCC", "5G", "40M", "HT", "2T", "126", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "36", 
	"MKK", "5G", "40M", "HT", "2T", "126", "36",
	"FCC", "5G", "40M", "HT", "2T", "134", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "36", 
	"MKK", "5G", "40M", "HT", "2T", "134", "36",
	"FCC", "5G", "40M", "HT", "2T", "151", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "36", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "36", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "36", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "40M", "HT", "3T", "38", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "38", "36", 
	"MKK", "5G", "40M", "HT", "3T", "38", "36",
	"FCC", "5G", "40M", "HT", "3T", "46", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "46", "36", 
	"MKK", "5G", "40M", "HT", "3T", "46", "36",
	"FCC", "5G", "40M", "HT", "3T", "54", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "54", "36", 
	"MKK", "5G", "40M", "HT", "3T", "54", "36",
	"FCC", "5G", "40M", "HT", "3T", "62", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "62", "36", 
	"MKK", "5G", "40M", "HT", "3T", "62", "36",
	"FCC", "5G", "40M", "HT", "3T", "102", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "102", "36", 
	"MKK", "5G", "40M", "HT", "3T", "102", "36",
	"FCC", "5G", "40M", "HT", "3T", "110", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "110", "36", 
	"MKK", "5G", "40M", "HT", "3T", "110", "36",
	"FCC", "5G", "40M", "HT", "3T", "118", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "118", "36", 
	"MKK", "5G", "40M", "HT", "3T", "118", "36",
	"FCC", "5G", "40M", "HT", "3T", "126", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "126", "36", 
	"MKK", "5G", "40M", "HT", "3T", "126", "36",
	"FCC", "5G", "40M", "HT", "3T", "134", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "134", "36", 
	"MKK", "5G", "40M", "HT", "3T", "134", "36",
	"FCC", "5G", "40M", "HT", "3T", "151", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "151", "36", 
	"MKK", "5G", "40M", "HT", "3T", "151", "63",
	"FCC", "5G", "40M", "HT", "3T", "159", "36", 
	"ETSI", "5G", "40M", "HT", "3T", "159", "36", 
	"MKK", "5G", "40M", "HT", "3T", "159", "63",
	"FCC", "5G", "40M", "HT", "4T", "38", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "38", "36", 
	"MKK", "5G", "40M", "HT", "4T", "38", "36",
	"FCC", "5G", "40M", "HT", "4T", "46", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "46", "36", 
	"MKK", "5G", "40M", "HT", "4T", "46", "36",
	"FCC", "5G", "40M", "HT", "4T", "54", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "54", "36", 
	"MKK", "5G", "40M", "HT", "4T", "54", "36",
	"FCC", "5G", "40M", "HT", "4T", "62", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "62", "36", 
	"MKK", "5G", "40M", "HT", "4T", "62", "36",
	"FCC", "5G", "40M", "HT", "4T", "102", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "102", "36", 
	"MKK", "5G", "40M", "HT", "4T", "102", "36",
	"FCC", "5G", "40M", "HT", "4T", "110", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "110", "36", 
	"MKK", "5G", "40M", "HT", "4T", "110", "36",
	"FCC", "5G", "40M", "HT", "4T", "118", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "118", "36", 
	"MKK", "5G", "40M", "HT", "4T", "118", "36",
	"FCC", "5G", "40M", "HT", "4T", "126", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "126", "36", 
	"MKK", "5G", "40M", "HT", "4T", "126", "36",
	"FCC", "5G", "40M", "HT", "4T", "134", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "134", "36", 
	"MKK", "5G", "40M", "HT", "4T", "134", "36",
	"FCC", "5G", "40M", "HT", "4T", "151", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "151", "36", 
	"MKK", "5G", "40M", "HT", "4T", "151", "63",
	"FCC", "5G", "40M", "HT", "4T", "159", "36", 
	"ETSI", "5G", "40M", "HT", "4T", "159", "36", 
	"MKK", "5G", "40M", "HT", "4T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "36", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "36",
	"FCC", "5G", "80M", "VHT", "1T", "58", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "36", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "36",
	"FCC", "5G", "80M", "VHT", "1T", "106", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "36", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "36",
	"FCC", "5G", "80M", "VHT", "1T", "122", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "36", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "36",
	"FCC", "5G", "80M", "VHT", "1T", "155", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "36", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "36", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "36", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "36",
	"FCC", "5G", "80M", "VHT", "2T", "58", "36", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "36", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "36",
	"FCC", "5G", "80M", "VHT", "2T", "106", "36", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "36", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "36",
	"FCC", "5G", "80M", "VHT", "2T", "122", "36", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "36", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "36",
	"FCC", "5G", "80M", "VHT", "2T", "155", "36", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "36", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"FCC", "5G", "80M", "VHT", "3T", "42", "36", 
	"ETSI", "5G", "80M", "VHT", "3T", "42", "36", 
	"MKK", "5G", "80M", "VHT", "3T", "42", "36",
	"FCC", "5G", "80M", "VHT", "3T", "58", "36", 
	"ETSI", "5G", "80M", "VHT", "3T", "58", "36", 
	"MKK", "5G", "80M", "VHT", "3T", "58", "36",
	"FCC", "5G", "80M", "VHT", "3T", "106", "36", 
	"ETSI", "5G", "80M", "VHT", "3T", "106", "36", 
	"MKK", "5G", "80M", "VHT", "3T", "106", "36",
	"FCC", "5G", "80M", "VHT", "3T", "122", "36", 
	"ETSI", "5G", "80M", "VHT", "3T", "122", "36", 
	"MKK", "5G", "80M", "VHT", "3T", "122", "36",
	"FCC", "5G", "80M", "VHT", "3T", "155", "36", 
	"ETSI", "5G", "80M", "VHT", "3T", "155", "36", 
	"MKK", "5G", "80M", "VHT", "3T", "155", "63",
	"FCC", "5G", "80M", "VHT", "4T", "42", "36", 
	"ETSI", "5G", "80M", "VHT", "4T", "42", "36", 
	"MKK", "5G", "80M", "VHT", "4T", "42", "36",
	"FCC", "5G", "80M", "VHT", "4T", "58", "36", 
	"ETSI", "5G", "80M", "VHT", "4T", "58", "36", 
	"MKK", "5G", "80M", "VHT", "4T", "58", "36",
	"FCC", "5G", "80M", "VHT", "4T", "106", "36", 
	"ETSI", "5G", "80M", "VHT", "4T", "106", "36", 
	"MKK", "5G", "80M", "VHT", "4T", "106", "36",
	"FCC", "5G", "80M", "VHT", "4T", "122", "36", 
	"ETSI", "5G", "80M", "VHT", "4T", "122", "36", 
	"MKK", "5G", "80M", "VHT", "4T", "122", "36",
	"FCC", "5G", "80M", "VHT", "4T", "155", "36", 
	"ETSI", "5G", "80M", "VHT", "4T", "155", "36", 
	"MKK", "5G", "80M", "VHT", "4T", "155", "63"
};

void
ODM_ReadAndConfig_MP_8814A_TXPWR_LMT_type2(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_TXPWR_LMT_type2)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_MP_8814A_TXPWR_LMT_type2;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_TXPWR_LMT_type2\n"));

	for (i = 0; i < ArrayLen; i += 7) {
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
	
		odm_ConfigBB_TXPWR_LMT_8814A(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

/******************************************************************************
*                           TXPWR_LMT_Type3.TXT
******************************************************************************/

const char *Array_MP_8814A_TXPWR_LMT_Type3[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "4T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "40", 
	"MKK", "5G", "20M", "HT", "1T", "36", "40",
	"FCC", "5G", "20M", "HT", "1T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "40", 
	"MKK", "5G", "20M", "HT", "1T", "40", "40",
	"FCC", "5G", "20M", "HT", "1T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "40", 
	"MKK", "5G", "20M", "HT", "1T", "44", "40",
	"FCC", "5G", "20M", "HT", "1T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "40", 
	"MKK", "5G", "20M", "HT", "1T", "48", "40",
	"FCC", "5G", "20M", "HT", "1T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "40", 
	"MKK", "5G", "20M", "HT", "1T", "52", "40",
	"FCC", "5G", "20M", "HT", "1T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "40", 
	"MKK", "5G", "20M", "HT", "1T", "56", "40",
	"FCC", "5G", "20M", "HT", "1T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "40", 
	"MKK", "5G", "20M", "HT", "1T", "60", "40",
	"FCC", "5G", "20M", "HT", "1T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "40", 
	"MKK", "5G", "20M", "HT", "1T", "64", "40",
	"FCC", "5G", "20M", "HT", "1T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "40", 
	"MKK", "5G", "20M", "HT", "1T", "100", "40",
	"FCC", "5G", "20M", "HT", "1T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "40", 
	"MKK", "5G", "20M", "HT", "1T", "104", "40",
	"FCC", "5G", "20M", "HT", "1T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "40", 
	"MKK", "5G", "20M", "HT", "1T", "108", "40",
	"FCC", "5G", "20M", "HT", "1T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "40", 
	"MKK", "5G", "20M", "HT", "1T", "112", "40",
	"FCC", "5G", "20M", "HT", "1T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "40", 
	"MKK", "5G", "20M", "HT", "1T", "116", "40",
	"FCC", "5G", "20M", "HT", "1T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "40", 
	"MKK", "5G", "20M", "HT", "1T", "120", "40",
	"FCC", "5G", "20M", "HT", "1T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "40", 
	"MKK", "5G", "20M", "HT", "1T", "124", "40",
	"FCC", "5G", "20M", "HT", "1T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "40", 
	"MKK", "5G", "20M", "HT", "1T", "128", "40",
	"FCC", "5G", "20M", "HT", "1T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "40", 
	"MKK", "5G", "20M", "HT", "1T", "132", "40",
	"FCC", "5G", "20M", "HT", "1T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "40", 
	"MKK", "5G", "20M", "HT", "1T", "136", "40",
	"FCC", "5G", "20M", "HT", "1T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "40", 
	"MKK", "5G", "20M", "HT", "1T", "140", "40",
	"FCC", "5G", "20M", "HT", "1T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "40", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "40", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "40", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "40", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "40", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "40", 
	"MKK", "5G", "20M", "HT", "2T", "36", "40",
	"FCC", "5G", "20M", "HT", "2T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "40", 
	"MKK", "5G", "20M", "HT", "2T", "40", "40",
	"FCC", "5G", "20M", "HT", "2T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "40", 
	"MKK", "5G", "20M", "HT", "2T", "44", "40",
	"FCC", "5G", "20M", "HT", "2T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "40", 
	"MKK", "5G", "20M", "HT", "2T", "48", "40",
	"FCC", "5G", "20M", "HT", "2T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "40", 
	"MKK", "5G", "20M", "HT", "2T", "52", "40",
	"FCC", "5G", "20M", "HT", "2T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "40", 
	"MKK", "5G", "20M", "HT", "2T", "56", "40",
	"FCC", "5G", "20M", "HT", "2T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "40", 
	"MKK", "5G", "20M", "HT", "2T", "60", "40",
	"FCC", "5G", "20M", "HT", "2T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "40", 
	"MKK", "5G", "20M", "HT", "2T", "64", "40",
	"FCC", "5G", "20M", "HT", "2T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "40", 
	"MKK", "5G", "20M", "HT", "2T", "100", "40",
	"FCC", "5G", "20M", "HT", "2T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "40", 
	"MKK", "5G", "20M", "HT", "2T", "104", "40",
	"FCC", "5G", "20M", "HT", "2T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "40", 
	"MKK", "5G", "20M", "HT", "2T", "108", "40",
	"FCC", "5G", "20M", "HT", "2T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "40", 
	"MKK", "5G", "20M", "HT", "2T", "112", "40",
	"FCC", "5G", "20M", "HT", "2T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "40", 
	"MKK", "5G", "20M", "HT", "2T", "116", "40",
	"FCC", "5G", "20M", "HT", "2T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "40", 
	"MKK", "5G", "20M", "HT", "2T", "120", "40",
	"FCC", "5G", "20M", "HT", "2T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "40", 
	"MKK", "5G", "20M", "HT", "2T", "124", "40",
	"FCC", "5G", "20M", "HT", "2T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "40", 
	"MKK", "5G", "20M", "HT", "2T", "128", "40",
	"FCC", "5G", "20M", "HT", "2T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "40", 
	"MKK", "5G", "20M", "HT", "2T", "132", "40",
	"FCC", "5G", "20M", "HT", "2T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "40", 
	"MKK", "5G", "20M", "HT", "2T", "136", "40",
	"FCC", "5G", "20M", "HT", "2T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "40", 
	"MKK", "5G", "20M", "HT", "2T", "140", "40",
	"FCC", "5G", "20M", "HT", "2T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "40", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "40", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "40", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "40", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "40", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "20M", "HT", "3T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "36", "40", 
	"MKK", "5G", "20M", "HT", "3T", "36", "40",
	"FCC", "5G", "20M", "HT", "3T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "40", "40", 
	"MKK", "5G", "20M", "HT", "3T", "40", "40",
	"FCC", "5G", "20M", "HT", "3T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "44", "40", 
	"MKK", "5G", "20M", "HT", "3T", "44", "40",
	"FCC", "5G", "20M", "HT", "3T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "48", "40", 
	"MKK", "5G", "20M", "HT", "3T", "48", "40",
	"FCC", "5G", "20M", "HT", "3T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "52", "40", 
	"MKK", "5G", "20M", "HT", "3T", "52", "40",
	"FCC", "5G", "20M", "HT", "3T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "56", "40", 
	"MKK", "5G", "20M", "HT", "3T", "56", "40",
	"FCC", "5G", "20M", "HT", "3T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "60", "40", 
	"MKK", "5G", "20M", "HT", "3T", "60", "40",
	"FCC", "5G", "20M", "HT", "3T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "64", "40", 
	"MKK", "5G", "20M", "HT", "3T", "64", "40",
	"FCC", "5G", "20M", "HT", "3T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "100", "40", 
	"MKK", "5G", "20M", "HT", "3T", "100", "40",
	"FCC", "5G", "20M", "HT", "3T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "104", "40", 
	"MKK", "5G", "20M", "HT", "3T", "104", "40",
	"FCC", "5G", "20M", "HT", "3T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "108", "40", 
	"MKK", "5G", "20M", "HT", "3T", "108", "40",
	"FCC", "5G", "20M", "HT", "3T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "112", "40", 
	"MKK", "5G", "20M", "HT", "3T", "112", "40",
	"FCC", "5G", "20M", "HT", "3T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "116", "40", 
	"MKK", "5G", "20M", "HT", "3T", "116", "40",
	"FCC", "5G", "20M", "HT", "3T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "120", "40", 
	"MKK", "5G", "20M", "HT", "3T", "120", "40",
	"FCC", "5G", "20M", "HT", "3T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "124", "40", 
	"MKK", "5G", "20M", "HT", "3T", "124", "40",
	"FCC", "5G", "20M", "HT", "3T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "128", "40", 
	"MKK", "5G", "20M", "HT", "3T", "128", "40",
	"FCC", "5G", "20M", "HT", "3T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "132", "40", 
	"MKK", "5G", "20M", "HT", "3T", "132", "40",
	"FCC", "5G", "20M", "HT", "3T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "136", "40", 
	"MKK", "5G", "20M", "HT", "3T", "136", "40",
	"FCC", "5G", "20M", "HT", "3T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "140", "40", 
	"MKK", "5G", "20M", "HT", "3T", "140", "40",
	"FCC", "5G", "20M", "HT", "3T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "149", "40", 
	"MKK", "5G", "20M", "HT", "3T", "149", "63",
	"FCC", "5G", "20M", "HT", "3T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "153", "40", 
	"MKK", "5G", "20M", "HT", "3T", "153", "63",
	"FCC", "5G", "20M", "HT", "3T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "157", "40", 
	"MKK", "5G", "20M", "HT", "3T", "157", "63",
	"FCC", "5G", "20M", "HT", "3T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "161", "40", 
	"MKK", "5G", "20M", "HT", "3T", "161", "63",
	"FCC", "5G", "20M", "HT", "3T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "165", "40", 
	"MKK", "5G", "20M", "HT", "3T", "165", "63",
	"FCC", "5G", "20M", "HT", "4T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "36", "40", 
	"MKK", "5G", "20M", "HT", "4T", "36", "40",
	"FCC", "5G", "20M", "HT", "4T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "40", "40", 
	"MKK", "5G", "20M", "HT", "4T", "40", "40",
	"FCC", "5G", "20M", "HT", "4T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "44", "40", 
	"MKK", "5G", "20M", "HT", "4T", "44", "40",
	"FCC", "5G", "20M", "HT", "4T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "48", "40", 
	"MKK", "5G", "20M", "HT", "4T", "48", "40",
	"FCC", "5G", "20M", "HT", "4T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "52", "40", 
	"MKK", "5G", "20M", "HT", "4T", "52", "40",
	"FCC", "5G", "20M", "HT", "4T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "56", "40", 
	"MKK", "5G", "20M", "HT", "4T", "56", "40",
	"FCC", "5G", "20M", "HT", "4T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "60", "40", 
	"MKK", "5G", "20M", "HT", "4T", "60", "40",
	"FCC", "5G", "20M", "HT", "4T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "64", "40", 
	"MKK", "5G", "20M", "HT", "4T", "64", "40",
	"FCC", "5G", "20M", "HT", "4T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "100", "40", 
	"MKK", "5G", "20M", "HT", "4T", "100", "40",
	"FCC", "5G", "20M", "HT", "4T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "104", "40", 
	"MKK", "5G", "20M", "HT", "4T", "104", "40",
	"FCC", "5G", "20M", "HT", "4T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "108", "40", 
	"MKK", "5G", "20M", "HT", "4T", "108", "40",
	"FCC", "5G", "20M", "HT", "4T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "112", "40", 
	"MKK", "5G", "20M", "HT", "4T", "112", "40",
	"FCC", "5G", "20M", "HT", "4T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "116", "40", 
	"MKK", "5G", "20M", "HT", "4T", "116", "40",
	"FCC", "5G", "20M", "HT", "4T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "120", "40", 
	"MKK", "5G", "20M", "HT", "4T", "120", "40",
	"FCC", "5G", "20M", "HT", "4T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "124", "40", 
	"MKK", "5G", "20M", "HT", "4T", "124", "40",
	"FCC", "5G", "20M", "HT", "4T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "128", "40", 
	"MKK", "5G", "20M", "HT", "4T", "128", "40",
	"FCC", "5G", "20M", "HT", "4T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "132", "40", 
	"MKK", "5G", "20M", "HT", "4T", "132", "40",
	"FCC", "5G", "20M", "HT", "4T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "136", "40", 
	"MKK", "5G", "20M", "HT", "4T", "136", "40",
	"FCC", "5G", "20M", "HT", "4T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "140", "40", 
	"MKK", "5G", "20M", "HT", "4T", "140", "40",
	"FCC", "5G", "20M", "HT", "4T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "149", "40", 
	"MKK", "5G", "20M", "HT", "4T", "149", "63",
	"FCC", "5G", "20M", "HT", "4T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "153", "40", 
	"MKK", "5G", "20M", "HT", "4T", "153", "63",
	"FCC", "5G", "20M", "HT", "4T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "157", "40", 
	"MKK", "5G", "20M", "HT", "4T", "157", "63",
	"FCC", "5G", "20M", "HT", "4T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "161", "40", 
	"MKK", "5G", "20M", "HT", "4T", "161", "63",
	"FCC", "5G", "20M", "HT", "4T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "165", "40", 
	"MKK", "5G", "20M", "HT", "4T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "40", 
	"MKK", "5G", "40M", "HT", "1T", "38", "40",
	"FCC", "5G", "40M", "HT", "1T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "40", 
	"MKK", "5G", "40M", "HT", "1T", "46", "40",
	"FCC", "5G", "40M", "HT", "1T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "40", 
	"MKK", "5G", "40M", "HT", "1T", "54", "40",
	"FCC", "5G", "40M", "HT", "1T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "40", 
	"MKK", "5G", "40M", "HT", "1T", "62", "40",
	"FCC", "5G", "40M", "HT", "1T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "40", 
	"MKK", "5G", "40M", "HT", "1T", "102", "40",
	"FCC", "5G", "40M", "HT", "1T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "40", 
	"MKK", "5G", "40M", "HT", "1T", "110", "40",
	"FCC", "5G", "40M", "HT", "1T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "40", 
	"MKK", "5G", "40M", "HT", "1T", "118", "40",
	"FCC", "5G", "40M", "HT", "1T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "40", 
	"MKK", "5G", "40M", "HT", "1T", "126", "40",
	"FCC", "5G", "40M", "HT", "1T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "40", 
	"MKK", "5G", "40M", "HT", "1T", "134", "40",
	"FCC", "5G", "40M", "HT", "1T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "40", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "40", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "40", 
	"MKK", "5G", "40M", "HT", "2T", "38", "40",
	"FCC", "5G", "40M", "HT", "2T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "40", 
	"MKK", "5G", "40M", "HT", "2T", "46", "40",
	"FCC", "5G", "40M", "HT", "2T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "40", 
	"MKK", "5G", "40M", "HT", "2T", "54", "40",
	"FCC", "5G", "40M", "HT", "2T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "40", 
	"MKK", "5G", "40M", "HT", "2T", "62", "40",
	"FCC", "5G", "40M", "HT", "2T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "40", 
	"MKK", "5G", "40M", "HT", "2T", "102", "40",
	"FCC", "5G", "40M", "HT", "2T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "40", 
	"MKK", "5G", "40M", "HT", "2T", "110", "40",
	"FCC", "5G", "40M", "HT", "2T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "40", 
	"MKK", "5G", "40M", "HT", "2T", "118", "40",
	"FCC", "5G", "40M", "HT", "2T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "40", 
	"MKK", "5G", "40M", "HT", "2T", "126", "40",
	"FCC", "5G", "40M", "HT", "2T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "40", 
	"MKK", "5G", "40M", "HT", "2T", "134", "40",
	"FCC", "5G", "40M", "HT", "2T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "40", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "40", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "40M", "HT", "3T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "38", "40", 
	"MKK", "5G", "40M", "HT", "3T", "38", "40",
	"FCC", "5G", "40M", "HT", "3T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "46", "40", 
	"MKK", "5G", "40M", "HT", "3T", "46", "40",
	"FCC", "5G", "40M", "HT", "3T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "54", "40", 
	"MKK", "5G", "40M", "HT", "3T", "54", "40",
	"FCC", "5G", "40M", "HT", "3T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "62", "40", 
	"MKK", "5G", "40M", "HT", "3T", "62", "40",
	"FCC", "5G", "40M", "HT", "3T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "102", "40", 
	"MKK", "5G", "40M", "HT", "3T", "102", "40",
	"FCC", "5G", "40M", "HT", "3T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "110", "40", 
	"MKK", "5G", "40M", "HT", "3T", "110", "40",
	"FCC", "5G", "40M", "HT", "3T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "118", "40", 
	"MKK", "5G", "40M", "HT", "3T", "118", "40",
	"FCC", "5G", "40M", "HT", "3T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "126", "40", 
	"MKK", "5G", "40M", "HT", "3T", "126", "40",
	"FCC", "5G", "40M", "HT", "3T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "134", "40", 
	"MKK", "5G", "40M", "HT", "3T", "134", "40",
	"FCC", "5G", "40M", "HT", "3T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "151", "40", 
	"MKK", "5G", "40M", "HT", "3T", "151", "63",
	"FCC", "5G", "40M", "HT", "3T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "159", "40", 
	"MKK", "5G", "40M", "HT", "3T", "159", "63",
	"FCC", "5G", "40M", "HT", "4T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "38", "40", 
	"MKK", "5G", "40M", "HT", "4T", "38", "40",
	"FCC", "5G", "40M", "HT", "4T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "46", "40", 
	"MKK", "5G", "40M", "HT", "4T", "46", "40",
	"FCC", "5G", "40M", "HT", "4T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "54", "40", 
	"MKK", "5G", "40M", "HT", "4T", "54", "40",
	"FCC", "5G", "40M", "HT", "4T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "62", "40", 
	"MKK", "5G", "40M", "HT", "4T", "62", "40",
	"FCC", "5G", "40M", "HT", "4T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "102", "40", 
	"MKK", "5G", "40M", "HT", "4T", "102", "40",
	"FCC", "5G", "40M", "HT", "4T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "110", "40", 
	"MKK", "5G", "40M", "HT", "4T", "110", "40",
	"FCC", "5G", "40M", "HT", "4T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "118", "40", 
	"MKK", "5G", "40M", "HT", "4T", "118", "40",
	"FCC", "5G", "40M", "HT", "4T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "126", "40", 
	"MKK", "5G", "40M", "HT", "4T", "126", "40",
	"FCC", "5G", "40M", "HT", "4T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "134", "40", 
	"MKK", "5G", "40M", "HT", "4T", "134", "40",
	"FCC", "5G", "40M", "HT", "4T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "151", "40", 
	"MKK", "5G", "40M", "HT", "4T", "151", "63",
	"FCC", "5G", "40M", "HT", "4T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "159", "40", 
	"MKK", "5G", "40M", "HT", "4T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "40",
	"FCC", "5G", "80M", "VHT", "1T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "40",
	"FCC", "5G", "80M", "VHT", "1T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "40",
	"FCC", "5G", "80M", "VHT", "1T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "40",
	"FCC", "5G", "80M", "VHT", "1T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "40",
	"FCC", "5G", "80M", "VHT", "2T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "40",
	"FCC", "5G", "80M", "VHT", "2T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "40",
	"FCC", "5G", "80M", "VHT", "2T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "40",
	"FCC", "5G", "80M", "VHT", "2T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"FCC", "5G", "80M", "VHT", "3T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "42", "40",
	"FCC", "5G", "80M", "VHT", "3T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "58", "40",
	"FCC", "5G", "80M", "VHT", "3T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "106", "40",
	"FCC", "5G", "80M", "VHT", "3T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "122", "40",
	"FCC", "5G", "80M", "VHT", "3T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "155", "63",
	"FCC", "5G", "80M", "VHT", "4T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "42", "40",
	"FCC", "5G", "80M", "VHT", "4T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "58", "40",
	"FCC", "5G", "80M", "VHT", "4T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "106", "40",
	"FCC", "5G", "80M", "VHT", "4T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "122", "40",
	"FCC", "5G", "80M", "VHT", "4T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "155", "63"
};

void
ODM_ReadAndConfig_MP_8814A_TXPWR_LMT_Type3(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_TXPWR_LMT_Type3)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_MP_8814A_TXPWR_LMT_Type3;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_TXPWR_LMT_Type3\n"));

	for (i = 0; i < ArrayLen; i += 7) {
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
	
		odm_ConfigBB_TXPWR_LMT_8814A(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

/******************************************************************************
*                           TXPWR_LMT_Type5.TXT
******************************************************************************/

const char *Array_MP_8814A_TXPWR_LMT_Type5[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "46", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "40", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "40",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "46", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "40", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "40",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "3T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "01", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "02", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "03", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "04", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "05", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "06", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "07", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "08", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "09", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "10", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "46", 
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "11", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "12", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "40", 
	"MKK", "2.4G", "20M", "HT", "4T", "13", "40",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "4T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "3T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "03", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "04", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "05", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "06", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "07", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "08", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "09", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "10", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "46", 
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "11", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "12", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "40", 
	"MKK", "2.4G", "40M", "HT", "4T", "13", "40",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "40",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "46", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "40", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "40", 
	"MKK", "5G", "20M", "HT", "1T", "36", "40",
	"FCC", "5G", "20M", "HT", "1T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "40", 
	"MKK", "5G", "20M", "HT", "1T", "40", "40",
	"FCC", "5G", "20M", "HT", "1T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "40", 
	"MKK", "5G", "20M", "HT", "1T", "44", "40",
	"FCC", "5G", "20M", "HT", "1T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "40", 
	"MKK", "5G", "20M", "HT", "1T", "48", "40",
	"FCC", "5G", "20M", "HT", "1T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "40", 
	"MKK", "5G", "20M", "HT", "1T", "52", "40",
	"FCC", "5G", "20M", "HT", "1T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "40", 
	"MKK", "5G", "20M", "HT", "1T", "56", "40",
	"FCC", "5G", "20M", "HT", "1T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "40", 
	"MKK", "5G", "20M", "HT", "1T", "60", "40",
	"FCC", "5G", "20M", "HT", "1T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "40", 
	"MKK", "5G", "20M", "HT", "1T", "64", "40",
	"FCC", "5G", "20M", "HT", "1T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "40", 
	"MKK", "5G", "20M", "HT", "1T", "100", "40",
	"FCC", "5G", "20M", "HT", "1T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "40", 
	"MKK", "5G", "20M", "HT", "1T", "104", "40",
	"FCC", "5G", "20M", "HT", "1T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "40", 
	"MKK", "5G", "20M", "HT", "1T", "108", "40",
	"FCC", "5G", "20M", "HT", "1T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "40", 
	"MKK", "5G", "20M", "HT", "1T", "112", "40",
	"FCC", "5G", "20M", "HT", "1T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "40", 
	"MKK", "5G", "20M", "HT", "1T", "116", "40",
	"FCC", "5G", "20M", "HT", "1T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "40", 
	"MKK", "5G", "20M", "HT", "1T", "120", "40",
	"FCC", "5G", "20M", "HT", "1T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "40", 
	"MKK", "5G", "20M", "HT", "1T", "124", "40",
	"FCC", "5G", "20M", "HT", "1T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "40", 
	"MKK", "5G", "20M", "HT", "1T", "128", "40",
	"FCC", "5G", "20M", "HT", "1T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "40", 
	"MKK", "5G", "20M", "HT", "1T", "132", "40",
	"FCC", "5G", "20M", "HT", "1T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "40", 
	"MKK", "5G", "20M", "HT", "1T", "136", "40",
	"FCC", "5G", "20M", "HT", "1T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "40", 
	"MKK", "5G", "20M", "HT", "1T", "140", "40",
	"FCC", "5G", "20M", "HT", "1T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "40", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "40", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "40", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "40", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "40", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "40", 
	"MKK", "5G", "20M", "HT", "2T", "36", "40",
	"FCC", "5G", "20M", "HT", "2T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "40", 
	"MKK", "5G", "20M", "HT", "2T", "40", "40",
	"FCC", "5G", "20M", "HT", "2T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "40", 
	"MKK", "5G", "20M", "HT", "2T", "44", "40",
	"FCC", "5G", "20M", "HT", "2T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "40", 
	"MKK", "5G", "20M", "HT", "2T", "48", "40",
	"FCC", "5G", "20M", "HT", "2T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "40", 
	"MKK", "5G", "20M", "HT", "2T", "52", "40",
	"FCC", "5G", "20M", "HT", "2T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "40", 
	"MKK", "5G", "20M", "HT", "2T", "56", "40",
	"FCC", "5G", "20M", "HT", "2T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "40", 
	"MKK", "5G", "20M", "HT", "2T", "60", "40",
	"FCC", "5G", "20M", "HT", "2T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "40", 
	"MKK", "5G", "20M", "HT", "2T", "64", "40",
	"FCC", "5G", "20M", "HT", "2T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "40", 
	"MKK", "5G", "20M", "HT", "2T", "100", "40",
	"FCC", "5G", "20M", "HT", "2T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "40", 
	"MKK", "5G", "20M", "HT", "2T", "104", "40",
	"FCC", "5G", "20M", "HT", "2T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "40", 
	"MKK", "5G", "20M", "HT", "2T", "108", "40",
	"FCC", "5G", "20M", "HT", "2T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "40", 
	"MKK", "5G", "20M", "HT", "2T", "112", "40",
	"FCC", "5G", "20M", "HT", "2T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "40", 
	"MKK", "5G", "20M", "HT", "2T", "116", "40",
	"FCC", "5G", "20M", "HT", "2T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "40", 
	"MKK", "5G", "20M", "HT", "2T", "120", "40",
	"FCC", "5G", "20M", "HT", "2T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "40", 
	"MKK", "5G", "20M", "HT", "2T", "124", "40",
	"FCC", "5G", "20M", "HT", "2T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "40", 
	"MKK", "5G", "20M", "HT", "2T", "128", "40",
	"FCC", "5G", "20M", "HT", "2T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "40", 
	"MKK", "5G", "20M", "HT", "2T", "132", "40",
	"FCC", "5G", "20M", "HT", "2T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "40", 
	"MKK", "5G", "20M", "HT", "2T", "136", "40",
	"FCC", "5G", "20M", "HT", "2T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "40", 
	"MKK", "5G", "20M", "HT", "2T", "140", "40",
	"FCC", "5G", "20M", "HT", "2T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "40", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "40", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "40", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "40", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "40", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "20M", "HT", "3T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "36", "40", 
	"MKK", "5G", "20M", "HT", "3T", "36", "40",
	"FCC", "5G", "20M", "HT", "3T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "40", "40", 
	"MKK", "5G", "20M", "HT", "3T", "40", "40",
	"FCC", "5G", "20M", "HT", "3T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "44", "40", 
	"MKK", "5G", "20M", "HT", "3T", "44", "40",
	"FCC", "5G", "20M", "HT", "3T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "48", "40", 
	"MKK", "5G", "20M", "HT", "3T", "48", "40",
	"FCC", "5G", "20M", "HT", "3T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "52", "40", 
	"MKK", "5G", "20M", "HT", "3T", "52", "40",
	"FCC", "5G", "20M", "HT", "3T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "56", "40", 
	"MKK", "5G", "20M", "HT", "3T", "56", "40",
	"FCC", "5G", "20M", "HT", "3T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "60", "40", 
	"MKK", "5G", "20M", "HT", "3T", "60", "40",
	"FCC", "5G", "20M", "HT", "3T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "64", "40", 
	"MKK", "5G", "20M", "HT", "3T", "64", "40",
	"FCC", "5G", "20M", "HT", "3T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "100", "40", 
	"MKK", "5G", "20M", "HT", "3T", "100", "40",
	"FCC", "5G", "20M", "HT", "3T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "104", "40", 
	"MKK", "5G", "20M", "HT", "3T", "104", "40",
	"FCC", "5G", "20M", "HT", "3T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "108", "40", 
	"MKK", "5G", "20M", "HT", "3T", "108", "40",
	"FCC", "5G", "20M", "HT", "3T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "112", "40", 
	"MKK", "5G", "20M", "HT", "3T", "112", "40",
	"FCC", "5G", "20M", "HT", "3T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "116", "40", 
	"MKK", "5G", "20M", "HT", "3T", "116", "40",
	"FCC", "5G", "20M", "HT", "3T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "120", "40", 
	"MKK", "5G", "20M", "HT", "3T", "120", "40",
	"FCC", "5G", "20M", "HT", "3T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "124", "40", 
	"MKK", "5G", "20M", "HT", "3T", "124", "40",
	"FCC", "5G", "20M", "HT", "3T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "128", "40", 
	"MKK", "5G", "20M", "HT", "3T", "128", "40",
	"FCC", "5G", "20M", "HT", "3T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "132", "40", 
	"MKK", "5G", "20M", "HT", "3T", "132", "40",
	"FCC", "5G", "20M", "HT", "3T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "136", "40", 
	"MKK", "5G", "20M", "HT", "3T", "136", "40",
	"FCC", "5G", "20M", "HT", "3T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "140", "40", 
	"MKK", "5G", "20M", "HT", "3T", "140", "40",
	"FCC", "5G", "20M", "HT", "3T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "149", "40", 
	"MKK", "5G", "20M", "HT", "3T", "149", "63",
	"FCC", "5G", "20M", "HT", "3T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "153", "40", 
	"MKK", "5G", "20M", "HT", "3T", "153", "63",
	"FCC", "5G", "20M", "HT", "3T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "157", "40", 
	"MKK", "5G", "20M", "HT", "3T", "157", "63",
	"FCC", "5G", "20M", "HT", "3T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "161", "40", 
	"MKK", "5G", "20M", "HT", "3T", "161", "63",
	"FCC", "5G", "20M", "HT", "3T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "3T", "165", "40", 
	"MKK", "5G", "20M", "HT", "3T", "165", "63",
	"FCC", "5G", "20M", "HT", "4T", "36", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "36", "40", 
	"MKK", "5G", "20M", "HT", "4T", "36", "40",
	"FCC", "5G", "20M", "HT", "4T", "40", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "40", "40", 
	"MKK", "5G", "20M", "HT", "4T", "40", "40",
	"FCC", "5G", "20M", "HT", "4T", "44", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "44", "40", 
	"MKK", "5G", "20M", "HT", "4T", "44", "40",
	"FCC", "5G", "20M", "HT", "4T", "48", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "48", "40", 
	"MKK", "5G", "20M", "HT", "4T", "48", "40",
	"FCC", "5G", "20M", "HT", "4T", "52", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "52", "40", 
	"MKK", "5G", "20M", "HT", "4T", "52", "40",
	"FCC", "5G", "20M", "HT", "4T", "56", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "56", "40", 
	"MKK", "5G", "20M", "HT", "4T", "56", "40",
	"FCC", "5G", "20M", "HT", "4T", "60", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "60", "40", 
	"MKK", "5G", "20M", "HT", "4T", "60", "40",
	"FCC", "5G", "20M", "HT", "4T", "64", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "64", "40", 
	"MKK", "5G", "20M", "HT", "4T", "64", "40",
	"FCC", "5G", "20M", "HT", "4T", "100", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "100", "40", 
	"MKK", "5G", "20M", "HT", "4T", "100", "40",
	"FCC", "5G", "20M", "HT", "4T", "104", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "104", "40", 
	"MKK", "5G", "20M", "HT", "4T", "104", "40",
	"FCC", "5G", "20M", "HT", "4T", "108", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "108", "40", 
	"MKK", "5G", "20M", "HT", "4T", "108", "40",
	"FCC", "5G", "20M", "HT", "4T", "112", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "112", "40", 
	"MKK", "5G", "20M", "HT", "4T", "112", "40",
	"FCC", "5G", "20M", "HT", "4T", "116", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "116", "40", 
	"MKK", "5G", "20M", "HT", "4T", "116", "40",
	"FCC", "5G", "20M", "HT", "4T", "120", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "120", "40", 
	"MKK", "5G", "20M", "HT", "4T", "120", "40",
	"FCC", "5G", "20M", "HT", "4T", "124", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "124", "40", 
	"MKK", "5G", "20M", "HT", "4T", "124", "40",
	"FCC", "5G", "20M", "HT", "4T", "128", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "128", "40", 
	"MKK", "5G", "20M", "HT", "4T", "128", "40",
	"FCC", "5G", "20M", "HT", "4T", "132", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "132", "40", 
	"MKK", "5G", "20M", "HT", "4T", "132", "40",
	"FCC", "5G", "20M", "HT", "4T", "136", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "136", "40", 
	"MKK", "5G", "20M", "HT", "4T", "136", "40",
	"FCC", "5G", "20M", "HT", "4T", "140", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "140", "40", 
	"MKK", "5G", "20M", "HT", "4T", "140", "40",
	"FCC", "5G", "20M", "HT", "4T", "149", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "149", "40", 
	"MKK", "5G", "20M", "HT", "4T", "149", "63",
	"FCC", "5G", "20M", "HT", "4T", "153", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "153", "40", 
	"MKK", "5G", "20M", "HT", "4T", "153", "63",
	"FCC", "5G", "20M", "HT", "4T", "157", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "157", "40", 
	"MKK", "5G", "20M", "HT", "4T", "157", "63",
	"FCC", "5G", "20M", "HT", "4T", "161", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "161", "40", 
	"MKK", "5G", "20M", "HT", "4T", "161", "63",
	"FCC", "5G", "20M", "HT", "4T", "165", "46", 
	"ETSI", "5G", "20M", "HT", "4T", "165", "40", 
	"MKK", "5G", "20M", "HT", "4T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "40", 
	"MKK", "5G", "40M", "HT", "1T", "38", "40",
	"FCC", "5G", "40M", "HT", "1T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "40", 
	"MKK", "5G", "40M", "HT", "1T", "46", "40",
	"FCC", "5G", "40M", "HT", "1T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "40", 
	"MKK", "5G", "40M", "HT", "1T", "54", "40",
	"FCC", "5G", "40M", "HT", "1T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "40", 
	"MKK", "5G", "40M", "HT", "1T", "62", "40",
	"FCC", "5G", "40M", "HT", "1T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "40", 
	"MKK", "5G", "40M", "HT", "1T", "102", "40",
	"FCC", "5G", "40M", "HT", "1T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "40", 
	"MKK", "5G", "40M", "HT", "1T", "110", "40",
	"FCC", "5G", "40M", "HT", "1T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "40", 
	"MKK", "5G", "40M", "HT", "1T", "118", "40",
	"FCC", "5G", "40M", "HT", "1T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "40", 
	"MKK", "5G", "40M", "HT", "1T", "126", "40",
	"FCC", "5G", "40M", "HT", "1T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "40", 
	"MKK", "5G", "40M", "HT", "1T", "134", "40",
	"FCC", "5G", "40M", "HT", "1T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "40", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "40", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "40", 
	"MKK", "5G", "40M", "HT", "2T", "38", "40",
	"FCC", "5G", "40M", "HT", "2T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "40", 
	"MKK", "5G", "40M", "HT", "2T", "46", "40",
	"FCC", "5G", "40M", "HT", "2T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "40", 
	"MKK", "5G", "40M", "HT", "2T", "54", "40",
	"FCC", "5G", "40M", "HT", "2T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "40", 
	"MKK", "5G", "40M", "HT", "2T", "62", "40",
	"FCC", "5G", "40M", "HT", "2T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "40", 
	"MKK", "5G", "40M", "HT", "2T", "102", "40",
	"FCC", "5G", "40M", "HT", "2T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "40", 
	"MKK", "5G", "40M", "HT", "2T", "110", "40",
	"FCC", "5G", "40M", "HT", "2T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "40", 
	"MKK", "5G", "40M", "HT", "2T", "118", "40",
	"FCC", "5G", "40M", "HT", "2T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "40", 
	"MKK", "5G", "40M", "HT", "2T", "126", "40",
	"FCC", "5G", "40M", "HT", "2T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "40", 
	"MKK", "5G", "40M", "HT", "2T", "134", "40",
	"FCC", "5G", "40M", "HT", "2T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "40", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "40", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "40M", "HT", "3T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "38", "40", 
	"MKK", "5G", "40M", "HT", "3T", "38", "40",
	"FCC", "5G", "40M", "HT", "3T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "46", "40", 
	"MKK", "5G", "40M", "HT", "3T", "46", "40",
	"FCC", "5G", "40M", "HT", "3T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "54", "40", 
	"MKK", "5G", "40M", "HT", "3T", "54", "40",
	"FCC", "5G", "40M", "HT", "3T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "62", "40", 
	"MKK", "5G", "40M", "HT", "3T", "62", "40",
	"FCC", "5G", "40M", "HT", "3T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "102", "40", 
	"MKK", "5G", "40M", "HT", "3T", "102", "40",
	"FCC", "5G", "40M", "HT", "3T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "110", "40", 
	"MKK", "5G", "40M", "HT", "3T", "110", "40",
	"FCC", "5G", "40M", "HT", "3T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "118", "40", 
	"MKK", "5G", "40M", "HT", "3T", "118", "40",
	"FCC", "5G", "40M", "HT", "3T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "126", "40", 
	"MKK", "5G", "40M", "HT", "3T", "126", "40",
	"FCC", "5G", "40M", "HT", "3T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "134", "40", 
	"MKK", "5G", "40M", "HT", "3T", "134", "40",
	"FCC", "5G", "40M", "HT", "3T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "151", "40", 
	"MKK", "5G", "40M", "HT", "3T", "151", "63",
	"FCC", "5G", "40M", "HT", "3T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "3T", "159", "40", 
	"MKK", "5G", "40M", "HT", "3T", "159", "63",
	"FCC", "5G", "40M", "HT", "4T", "38", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "38", "40", 
	"MKK", "5G", "40M", "HT", "4T", "38", "40",
	"FCC", "5G", "40M", "HT", "4T", "46", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "46", "40", 
	"MKK", "5G", "40M", "HT", "4T", "46", "40",
	"FCC", "5G", "40M", "HT", "4T", "54", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "54", "40", 
	"MKK", "5G", "40M", "HT", "4T", "54", "40",
	"FCC", "5G", "40M", "HT", "4T", "62", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "62", "40", 
	"MKK", "5G", "40M", "HT", "4T", "62", "40",
	"FCC", "5G", "40M", "HT", "4T", "102", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "102", "40", 
	"MKK", "5G", "40M", "HT", "4T", "102", "40",
	"FCC", "5G", "40M", "HT", "4T", "110", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "110", "40", 
	"MKK", "5G", "40M", "HT", "4T", "110", "40",
	"FCC", "5G", "40M", "HT", "4T", "118", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "118", "40", 
	"MKK", "5G", "40M", "HT", "4T", "118", "40",
	"FCC", "5G", "40M", "HT", "4T", "126", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "126", "40", 
	"MKK", "5G", "40M", "HT", "4T", "126", "40",
	"FCC", "5G", "40M", "HT", "4T", "134", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "134", "40", 
	"MKK", "5G", "40M", "HT", "4T", "134", "40",
	"FCC", "5G", "40M", "HT", "4T", "151", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "151", "40", 
	"MKK", "5G", "40M", "HT", "4T", "151", "63",
	"FCC", "5G", "40M", "HT", "4T", "159", "46", 
	"ETSI", "5G", "40M", "HT", "4T", "159", "40", 
	"MKK", "5G", "40M", "HT", "4T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "40",
	"FCC", "5G", "80M", "VHT", "1T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "40",
	"FCC", "5G", "80M", "VHT", "1T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "40",
	"FCC", "5G", "80M", "VHT", "1T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "40",
	"FCC", "5G", "80M", "VHT", "1T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "40",
	"FCC", "5G", "80M", "VHT", "2T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "40",
	"FCC", "5G", "80M", "VHT", "2T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "40",
	"FCC", "5G", "80M", "VHT", "2T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "40",
	"FCC", "5G", "80M", "VHT", "2T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"FCC", "5G", "80M", "VHT", "3T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "42", "40",
	"FCC", "5G", "80M", "VHT", "3T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "58", "40",
	"FCC", "5G", "80M", "VHT", "3T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "106", "40",
	"FCC", "5G", "80M", "VHT", "3T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "122", "40",
	"FCC", "5G", "80M", "VHT", "3T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "3T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "3T", "155", "63",
	"FCC", "5G", "80M", "VHT", "4T", "42", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "42", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "42", "40",
	"FCC", "5G", "80M", "VHT", "4T", "58", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "58", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "58", "40",
	"FCC", "5G", "80M", "VHT", "4T", "106", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "106", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "106", "40",
	"FCC", "5G", "80M", "VHT", "4T", "122", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "122", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "122", "40",
	"FCC", "5G", "80M", "VHT", "4T", "155", "46", 
	"ETSI", "5G", "80M", "VHT", "4T", "155", "40", 
	"MKK", "5G", "80M", "VHT", "4T", "155", "63"
};

void
ODM_ReadAndConfig_MP_8814A_TXPWR_LMT_Type5(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
	u4Byte     ArrayLen    = sizeof(Array_MP_8814A_TXPWR_LMT_Type5)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_MP_8814A_TXPWR_LMT_Type5;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_8814A_TXPWR_LMT_Type5\n"));

	for (i = 0; i < ArrayLen; i += 7) {
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
	
		odm_ConfigBB_TXPWR_LMT_8814A(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

#endif /* end of HWIMG_SUPPORT*/

