/******************************************************************************
 *
 * Copyright(c) 2007 - 2020  Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 2.0.1.10*/
#ifndef _HALRF_HWIMG_RAW_DATA_8851B_H
#define _HALRF_HWIMG_RAW_DATA_8851B_H

#define D_S_SIZE DELTA_SWINGIDX_SIZE
#define D_ST_SIZE DELTA_SWINTSSI_SIZE


#if 0
/* Please put following enum definitions in appropriate header file. */
enum odm_pw_byrate_para_type {
	PW_BYRATE_PARA_NSS1,
	PW_BYRATE_PARA_NSS2,
	PW_BYRATE_PARA_OFFS = 0xF
};

enum odm_pw_byrate_rate_type {
	PW_BYRATE_RATE_11M_1M,
	PW_BYRATE_RATE_18M_6M,
	PW_BYRATE_RATE_54M_24M,
	PW_BYRATE_RATE_MCS3_0,
	PW_BYRATE_RATE_MCS7_4,
	PW_BYRATE_RATE_MCS11_8,
	PW_BYRATE_RATE_DCM4_0,
	PW_BYRATE_RATE_AllRate2_1,  /* CCK, OFDM, HT, VHT */
	PW_BYRATE_RATE_AllRate2_2,  /* HE_HEDCM */
	PW_BYRATE_RATE_AllRate5_1,  /* OFDM, HT, VHT, HE_HEDCM */
	PW_BYRATE_RATE_AllRate6_1,  /* OFDM, HT, VHT, HE_HEDCM (6G) */
	PW_BYRATE_RATE_NULL = 0xF
};

enum odm_pw_lmt_regulation_type {
	PW_LMT_REGU_FCC,
	PW_LMT_REGU_ETSI,
	PW_LMT_REGU_MKK,
	PW_LMT_REGU_IC,
	PW_LMT_REGU_KCC,
	PW_LMT_REGU_ACMA,
	PW_LMT_REGU_CHILE,
	PW_LMT_REGU_UKRAINE,
	PW_LMT_REGU_MEXICO,
	PW_LMT_REGU_CN,
	PW_LMT_REGU_WW13,
	PW_LMT_REGU_NULL
};

enum odm_pw_lmt_band_type {
	PW_LMT_BAND_2_4G,
	PW_LMT_BAND_5G,
	PW_LMT_BAND_6G,
	PW_LMT_BAND_NULL
};

enum odm_pw_lmt_bandwidth_type {
	PW_LMT_BW_20M,
	PW_LMT_BW_40M,
	PW_LMT_BW_80M,
	PW_LMT_BW_160M,
	PW_LMT_BW_NULL
};

enum odm_pw_lmt_ru_bandwidth_type {
	PW_LMT_RU_BW_RU26,
	PW_LMT_RU_BW_RU52,
	PW_LMT_RU_BW_RU106,
	PW_LMT_RU_BW_NULL
};

enum odm_pw_lmt_ratesection_type {
	PW_LMT_RS_CCK,
	PW_LMT_RS_OFDM,
	PW_LMT_RS_HT,
	PW_LMT_RS_VHT,
	PW_LMT_RS_HE,
	PW_LMT_RS_NULL
};

enum odm_pw_lmt_beamform_type {
	PW_LMT_BF,
	PW_LMT_NONBF,
	PW_LMT_NULL
};

enum odm_pw_lmt_rfpath_type {
	PW_LMT_PH_1T,
	PW_LMT_PH_2T,
	PW_LMT_PH_3T,
	PW_LMT_PH_4T,
	PW_LMT_PH_NULL
};

struct halrf_tx_pw_lmt {
	u8			band:1;
	u8			bw:3;
	u8			rs:2;
	u8			ntx:2;
	u8			bf:3;
	u8			reg:5;
	u8			ch;
	s8			val;
};

struct halrf_tx_pw_lmt_ru {
	u8			band:1;
	u8			bw:2;
	u8			ntx:2;
	u8			rs:3;
	u8			reg;
	u8			ch;
	s8			val;
};
#endif


/******************************************************************************
 *                           radioa.TXT
 ******************************************************************************/

const u32 array_mp_8851b_radioa[] = {
		0xF0010000, 0x00000000,
		0xF0020000, 0x00000001,
		0xF0030000, 0x00000002,
		0xF0010001, 0x00000003,
		0xF0020001, 0x00000004,
		0xF0030001, 0x00000005,
		0xF0040001, 0x00000006,
		0xF0050001, 0x00000007,
		0xF0060001, 0x00000008,
		0x000, 0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000003,
		0x03E, 0x00000150,
		0x03F, 0x0000D79C,
		0x0EF, 0x00000000,
		0x052, 0x000C3338,
		0x053, 0x000608AF,
		0x054, 0x00006C04,
		0x063, 0x000FC082,
		0x065, 0x00018122,
		0x000, 0x00010000,
		0x0FE, 0x0000005A,
		0x000, 0x00030000,
		0x018, 0x00013124,
		0x0EF, 0x00080000,
		0x033, 0x00000008,
		0x03E, 0x00000110,
		0x03F, 0x0000D39C,
		0x033, 0x0000000C,
		0x03E, 0x00000110,
		0x03F, 0x0000F79E,
		0x0EF, 0x00000000,
		0x01B, 0x00003A40,
		0x08F, 0x000C170E,
		0x08E, 0x00005160,
		0x002, 0x00000600,
		0x0EE, 0x00000002,
		0x033, 0x00000002,
		0x03F, 0x0000003F,
		0x033, 0x00000003,
		0x03F, 0x0000003F,
		0x033, 0x00000004,
		0x03F, 0x0000003F,
		0x033, 0x00000005,
		0x03F, 0x0000003F,
		0x033, 0x00000006,
		0x03F, 0x0000003F,
		0x033, 0x00000007,
		0x03F, 0x0000003F,
		0x033, 0x00000008,
		0x03F, 0x0000003F,
		0x033, 0x0000000C,
		0x03F, 0x0000003F,
		0x033, 0x0000000D,
		0x03F, 0x0000003F,
		0x033, 0x0000000E,
		0x03F, 0x0000003F,
		0x0EE, 0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000007,
		0x03E, 0x00000000,
		0x03F, 0x00000707,
		0x033, 0x00000006,
		0x03E, 0x00000000,
		0x03F, 0x00000704,
		0x033, 0x00000005,
		0x03E, 0x00000000,
		0x03F, 0x00020500,
		0x033, 0x00000004,
		0x03E, 0x00000000,
		0x03F, 0x00010404,
		0x033, 0x00000003,
		0x03E, 0x00000000,
		0x03F, 0x00099B04,
		0x033, 0x00000002,
		0x03E, 0x00000000,
		0x03F, 0x00092B04,
		0x033, 0x00000001,
		0x03E, 0x00000000,
		0x03F, 0x000B3204,
		0x033, 0x00000000,
		0x03E, 0x00000000,
		0x03F, 0x00003000,
		0x033, 0x00000017,
		0x03E, 0x00000000,
		0x03F, 0x00000787,
		0x033, 0x00000016,
		0x03E, 0x00000000,
		0x03F, 0x00000784,
		0x033, 0x00000015,
		0x03E, 0x00000000,
		0x03F, 0x00020580,
		0x033, 0x00000014,
		0x03E, 0x00000000,
		0x03F, 0x00010484,
		0x033, 0x00000013,
		0x03E, 0x00000000,
		0x03F, 0x00099B84,
		0x033, 0x00000012,
		0x03E, 0x00000000,
		0x03F, 0x00092B84,
		0x033, 0x00000011,
		0x03E, 0x00000000,
		0x03F, 0x000B3284,
		0x033, 0x00000010,
		0x03E, 0x00000000,
		0x03F, 0x00003080,
		0x0EF, 0x00000000,
		0x0EE, 0x00000010,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x0EE, 0x00000000,
		0x0EF, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00000034,
		0x033, 0x00000001,
		0x03F, 0x00000037,
		0x033, 0x00000002,
		0x03F, 0x00000034,
		0x033, 0x00000003,
		0x03F, 0x00000024,
		0x033, 0x00000004,
		0x03F, 0x00000037,
		0x033, 0x00000005,
		0x03F, 0x00000027,
		0x0EF, 0x00000000,
		0x0EC, 0x00000400,
		0x033, 0x00000001,
		0x03F, 0x00000022,
		0x033, 0x00000003,
		0x03F, 0x00000022,
		0x033, 0x00000009,
		0x03F, 0x00000022,
		0x0EC, 0x00000000,
		0x0EC, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x000000AE,
		0x033, 0x00000001,
		0x03F, 0x0000008C,
		0x033, 0x00000002,
		0x03F, 0x0000006A,
		0x033, 0x00000003,
		0x03F, 0x00000048,
		0x033, 0x00000004,
		0x03F, 0x00000026,
		0x033, 0x00000005,
		0x03F, 0x00000004,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000000,
		0x0EC, 0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x00000007,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x00000006,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x00000005,
		0x03E, 0x00000003,
		0x03F, 0x00001DB0,
		0x033, 0x00000004,
		0x03E, 0x00000003,
		0x03F, 0x00001CB0,
		0x033, 0x00000003,
		0x03E, 0x00000003,
		0x03F, 0x00001BB0,
		0x033, 0x00000002,
		0x03E, 0x00000003,
		0x03F, 0x00001AB0,
		0x033, 0x00000001,
		0x03E, 0x00000003,
		0x03F, 0x0000D9BC,
		0x033, 0x00000000,
		0x03E, 0x00000003,
		0x03F, 0x0000D4BC,
		0x033, 0x00000017,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x00000016,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x00000015,
		0x03E, 0x00000003,
		0x03F, 0x00001DB0,
		0x033, 0x00000014,
		0x03E, 0x00000003,
		0x03F, 0x00001CB0,
		0x033, 0x00000013,
		0x03E, 0x00000003,
		0x03F, 0x00001BB0,
		0x033, 0x00000012,
		0x03E, 0x00000003,
		0x03F, 0x00001AB0,
		0x033, 0x00000011,
		0x03E, 0x00000003,
		0x03F, 0x0000D9BC,
		0x033, 0x00000010,
		0x03E, 0x00000003,
		0x03F, 0x0000D4BC,
		0x033, 0x00000027,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x00000026,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x00000025,
		0x03E, 0x00000003,
		0x03F, 0x00001DB0,
		0x033, 0x00000024,
		0x03E, 0x00000003,
		0x03F, 0x00001CB0,
		0x033, 0x00000023,
		0x03E, 0x00000003,
		0x03F, 0x00001BB0,
		0x033, 0x00000022,
		0x03E, 0x00000003,
		0x03F, 0x00001AB0,
		0x033, 0x00000021,
		0x03E, 0x00000003,
		0x03F, 0x0000D9BC,
		0x033, 0x00000020,
		0x03E, 0x00000003,
		0x03F, 0x0000D4BC,
		0x033, 0x0000000E,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x0000000D,
		0x03E, 0x00000003,
		0x03F, 0x00001DB0,
		0x033, 0x0000000C,
		0x03E, 0x00000003,
		0x03F, 0x00001CB0,
		0x033, 0x0000000B,
		0x03E, 0x00000003,
		0x03F, 0x00091BB0,
		0x033, 0x0000000A,
		0x03E, 0x00000003,
		0x03F, 0x000A9AB0,
		0x033, 0x00000009,
		0x03E, 0x00000003,
		0x03F, 0x000BD9BC,
		0x033, 0x00000008,
		0x03E, 0x00000003,
		0x03F, 0x0009D4BC,
		0x033, 0x0000001E,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x0000001D,
		0x03E, 0x00000003,
		0x03F, 0x00001DB0,
		0x033, 0x0000001C,
		0x03E, 0x00000003,
		0x03F, 0x00001CB0,
		0x033, 0x0000001B,
		0x03E, 0x00000003,
		0x03F, 0x00091BB0,
		0x033, 0x0000001A,
		0x03E, 0x00000003,
		0x03F, 0x00099AB0,
		0x033, 0x00000019,
		0x03E, 0x00000003,
		0x03F, 0x000AD9BC,
		0x033, 0x00000018,
		0x03E, 0x00000003,
		0x03F, 0x0009D4BC,
		0x033, 0x0000002E,
		0x03E, 0x00000003,
		0x03F, 0x00001FB0,
		0x033, 0x0000002D,
		0x03E, 0x00000003,
		0x03F, 0x00001DB0,
		0x033, 0x0000002C,
		0x03E, 0x00000003,
		0x03F, 0x00001CB0,
		0x033, 0x0000002B,
		0x03E, 0x00000003,
		0x03F, 0x00001BB0,
		0x033, 0x0000002A,
		0x03E, 0x00000003,
		0x03F, 0x00009AB0,
		0x033, 0x00000029,
		0x03E, 0x00000003,
		0x03F, 0x0009D9BC,
		0x033, 0x00000028,
		0x03E, 0x00000003,
		0x03F, 0x0000D4BC,
		0x0EF, 0x00000000,
		0x0EF, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000005,
		0x033, 0x00000001,
		0x03F, 0x00000004,
		0x033, 0x00000002,
		0x03F, 0x00000004,
		0x033, 0x00000004,
		0x03F, 0x0000000C,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000003,
		0x0EF, 0x00000000,
		0x06C, 0x00038085,
		0x06D, 0x00000D6B,
		0x06E, 0x0001FB89,
		0x06F, 0x00097B99,
		0x069, 0x00008040,
		0x0EF, 0x00000200,
		0x033, 0x00000004,
		0x03F, 0x000008FF,
		0x033, 0x00000005,
		0x03F, 0x000004F2,
		0x033, 0x00000006,
		0x03F, 0x00000217,
		0x033, 0x00000007,
		0x03F, 0x00000131,
		0x0EF, 0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000004,
		0x03F, 0x000004F7,
		0x033, 0x00000005,
		0x03F, 0x000004F7,
		0x033, 0x00000006,
		0x03F, 0x000004F2,
		0x033, 0x00000007,
		0x03F, 0x00000117,
		0x0EF, 0x00000000,
		0x043, 0x00005000,
		0x036, 0x000147D0,
		0x0B0, 0x0008677C,
		0x0B1, 0x00012920,
		0x0BB, 0x000EF000,
		0x0CB, 0x000A9594,
		0x0CC, 0x000C36D2,
		0x0CD, 0x00024923,
		0x0CE, 0x00020180,
		0x0CF, 0x00000000,
		0x0D5, 0x0006E27A,
		0x0D8, 0x00000044,
		0x0D9, 0x00000007,
		0x0DD, 0x00000020,
		0x0E3, 0x0000002C,
		0x0B7, 0x0000000C,
		0x0E1, 0x000080C0,
		0x0E4, 0x00000380,
		0x0ED, 0x00002000,
		0x033, 0x00000001,
		0x03D, 0x000A6094,
		0x03E, 0x00003449,
		0x03F, 0x00000001,
		0x033, 0x00000003,
		0x03D, 0x000AA094,
		0x03E, 0x00003449,
		0x03F, 0x00000001,
		0x0ED, 0x00000000,
		0x0ED, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x0000007F,
		0x033, 0x00000001,
		0x03F, 0x0000007F,
		0x033, 0x00000002,
		0x03F, 0x0000007F,
		0x033, 0x00000003,
		0x03F, 0x0000007F,
		0x033, 0x00000004,
		0x03F, 0x0000007F,
		0x033, 0x00000005,
		0x03F, 0x0000007F,
		0x033, 0x00000007,
		0x03F, 0x0000007F,
		0x033, 0x00000008,
		0x03F, 0x0000007F,
		0x033, 0x00000009,
		0x03F, 0x0000007F,
		0x0ED, 0x00000000,
		0x0ED, 0x00000080,
		0x033, 0x00000000,
		0x03E, 0x000007E1,
		0x03F, 0x0001F87F,
		0x033, 0x00000010,
		0x03E, 0x000007E1,
		0x03F, 0x0001F87F,
		0x033, 0x00000030,
		0x03E, 0x000007E1,
		0x03F, 0x0001F87F,
		0x033, 0x00000040,
		0x03E, 0x000007E1,
		0x03F, 0x0001F87F,
		0x033, 0x00000050,
		0x03E, 0x000007E1,
		0x03F, 0x0001F87F,
		0x033, 0x00000070,
		0x03E, 0x000007E1,
		0x03F, 0x0001F87F,
		0x0ED, 0x00000000,
		0x0ED, 0x00000004,
		0x033, 0x00000000,
		0x03F, 0x00008420,
		0x0ED, 0x00000000,
		0x018, 0x00011108,
		0x0B9, 0x00000000,
		0x0B9, 0x00000000,
		0x0B9, 0x00000200,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0FF, 0x00000000,
		0x0B9, 0x00000000,
		0x018, 0x00013124,
		0x05A, 0x0006808F,
		0x0ED, 0x00000008,
		0x033, 0x00000001,
		0x03F, 0x0000000F,
		0x0ED, 0x00000000,
		0x000, 0x00020000,
		0x018, 0x00010124,
		0x0EE, 0x00000800,
		0x033, 0x00000004,
		0x03F, 0x00000002,
		0x033, 0x00000005,
		0x03F, 0x00000003,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000008,
		0x03F, 0x00000000,
		0x033, 0x00000009,
		0x03F, 0x00000001,
		0x033, 0x0000000A,
		0x03F, 0x00000003,
		0x033, 0x0000000B,
		0x03F, 0x00000103,
		0x033, 0x0000000C,
		0x03F, 0x00000107,
		0x033, 0x0000000D,
		0x03F, 0x00000207,
		0x033, 0x0000000E,
		0x03F, 0x00000307,
		0x033, 0x0000000F,
		0x03F, 0x00000307,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x00000004,
		0x03F, 0x00000000,
		0x033, 0x00000005,
		0x03F, 0x00000001,
		0x033, 0x00000006,
		0x03F, 0x00000002,
		0x033, 0x00000007,
		0x03F, 0x00000003,
		0x0EE, 0x00000000,
		0x011, 0x00014062,
		0x0EF, 0x00000010,
		0x033, 0x00000001,
		0x03F, 0x00000DF3,
		0x033, 0x00000002,
		0x03F, 0x00000DF3,
		0x033, 0x00000003,
		0x03F, 0x00000A83,
		0x033, 0x00000004,
		0x03F, 0x00000A83,
		0x033, 0x00000005,
		0x03F, 0x00000643,
		0x033, 0x00000006,
		0x03F, 0x00000643,
		0x0EF, 0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000001,
		0x03F, 0x0001B5A8,
		0x033, 0x00000002,
		0x03F, 0x0001B5A8,
		0x033, 0x00000003,
		0x03F, 0x0001B5A9,
		0x033, 0x00000004,
		0x03F, 0x0001B5A8,
		0x033, 0x00000005,
		0x03F, 0x0001B5A8,
		0x033, 0x00000006,
		0x03F, 0x0001B589,
		0x033, 0x00000007,
		0x03F, 0x0001B5A8,
		0x033, 0x00000008,
		0x03F, 0x0001B5A8,
		0x033, 0x00000009,
		0x03F, 0x0001B5A8,
		0x033, 0x0000000A,
		0x03F, 0x0001B5A8,
		0x033, 0x0000000B,
		0x03F, 0x0001B5A9,
		0x033, 0x0000000C,
		0x03F, 0x0001B5A8,
		0x033, 0x0000000D,
		0x03F, 0x0001B5A9,
		0x033, 0x0000000E,
		0x03F, 0x0001B5A8,
		0x033, 0x0000000F,
		0x03F, 0x0001B5A8,
		0x033, 0x00000010,
		0x03F, 0x0001B5A8,
		0x033, 0x00000011,
		0x03F, 0x0001B5A8,
		0x033, 0x00000012,
		0x03F, 0x0001B5A8,
		0x033, 0x00000013,
		0x03F, 0x0001B5A8,
		0x033, 0x00000014,
		0x03F, 0x0001B5A8,
		0x033, 0x00000015,
		0x03F, 0x0001B589,
		0x033, 0x00000016,
		0x03F, 0x0001B5A8,
		0x033, 0x00000017,
		0x03F, 0x0001B5A9,
		0x033, 0x00000018,
		0x03F, 0x0001B5A8,
		0x033, 0x00000019,
		0x03F, 0x0001B5A8,
		0x033, 0x0000001A,
		0x03F, 0x0001B5A8,
		0x033, 0x0000001B,
		0x03F, 0x0001B5A8,
		0x033, 0x0000001C,
		0x03F, 0x0001B5A8,
		0x033, 0x0000001D,
		0x03F, 0x0001B5A8,
		0x033, 0x0000001E,
		0x03F, 0x0001B5A8,
		0x033, 0x0000001F,
		0x03F, 0x0001B5A8,
		0x033, 0x00000020,
		0x03F, 0x0001B5A8,
		0x033, 0x00000021,
		0x03F, 0x0001B5A8,
		0x033, 0x00000022,
		0x03F, 0x0001B5A8,
		0x033, 0x00000023,
		0x03F, 0x0001B5A8,
		0x033, 0x00000024,
		0x03F, 0x0001B5A8,
		0x033, 0x00000025,
		0x03F, 0x0001B5A8,
		0x033, 0x00000022,
		0x03F, 0x0001B5A8,
		0x0EF, 0x00000000,
		0x0EF, 0x00000040,
		0x033, 0x00000001,
		0x03F, 0x000002C5,
		0x033, 0x00000002,
		0x03F, 0x000002C5,
		0x033, 0x00000003,
		0x03F, 0x000002C5,
		0x033, 0x00000004,
		0x03F, 0x000002C5,
		0x033, 0x00000005,
		0x03F, 0x000002C5,
		0x033, 0x00000006,
		0x03F, 0x000002C5,
		0x033, 0x00000007,
		0x03F, 0x000002C5,
		0x033, 0x00000008,
		0x03F, 0x000002C5,
		0x033, 0x00000009,
		0x03F, 0x000002C5,
		0x033, 0x0000000A,
		0x03F, 0x000002C5,
		0x033, 0x0000000B,
		0x03F, 0x000002C5,
		0x0EF, 0x00000000,
		0x059, 0x00050033,
		0x061, 0x0005F48A,
		0x062, 0x00077435,
		0x067, 0x00008060,
		0x07E, 0x0009780B,
		0x0EE, 0x00000004,
		0x033, 0x0000000B,
		0x03F, 0x0000000B,
		0x033, 0x0000000C,
		0x03F, 0x00000012,
		0x033, 0x0000000D,
		0x03F, 0x00000019,
		0x033, 0x0000000F,
		0x03F, 0x0000000B,
		0x033, 0x00000010,
		0x03F, 0x00000012,
		0x033, 0x00000011,
		0x03F, 0x00000019,
		0x03F, 0x00000000,
		0x0EE, 0x00000000,
		0x0EE, 0x00000800,
		0x033, 0x00000000,
		0x03F, 0x00000001,
		0x033, 0x00000001,
		0x03F, 0x00000002,
		0x033, 0x00000002,
		0x03F, 0x00000003,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EE, 0x00001000,
		0x033, 0x00000000,
		0x03F, 0x00003000,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000001,
		0x033, 0x00000003,
		0x03F, 0x00000003,
		0x033, 0x00000004,
		0x03F, 0x00000007,
		0x033, 0x00000005,
		0x03F, 0x0000000F,
		0x033, 0x00000006,
		0x03F, 0x0000010F,
		0x033, 0x00000007,
		0x03F, 0x0000030F,
		0x0EE, 0x00000000,
		0x0EE, 0x00000200,
		0x033, 0x00000000,
		0x03F, 0x00000004,
		0x033, 0x00000001,
		0x03F, 0x00000005,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000003,
		0x03F, 0x00000007,
		0x0EE, 0x00000000,
		0x0EF, 0x00000080,
		0x033, 0x00000004,
		0x03E, 0x0000001D,
		0x03F, 0x0001A241,
		0x033, 0x00000005,
		0x03E, 0x0000001D,
		0x03F, 0x0001A241,
		0x033, 0x00000006,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000007,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000008,
		0x03E, 0x0000001D,
		0x03F, 0x0001A241,
		0x033, 0x00000009,
		0x03E, 0x0001A241,
		0x03F, 0x0001C3C1,
		0x033, 0x0000000A,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000000B,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000000C,
		0x03E, 0x0000001D,
		0x03F, 0x0001A241,
		0x033, 0x0000000D,
		0x03E, 0x0000001D,
		0x03F, 0x0001A241,
		0x033, 0x0000000E,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000000F,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000010,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000011,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000012,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000013,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000014,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000015,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000016,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000017,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000018,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000019,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x0000001A,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000001B,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000001C,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x0000001D,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x0000001E,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000001F,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000020,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000021,
		0x03E, 0x0000001C,
		0x03F, 0x000199C1,
		0x033, 0x00000022,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000023,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000024,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000025,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000026,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000027,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000028,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000029,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x0000002A,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000002B,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000002C,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x0000002D,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x0000002E,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000002F,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000030,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000031,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000032,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000033,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000034,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000035,
		0x03E, 0x0000001C,
		0x03F, 0x0001E141,
		0x033, 0x00000036,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000037,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000038,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x00000039,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C1,
		0x033, 0x0000003A,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C3,
		0x033, 0x0000003B,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C3,
		0x033, 0x0000003C,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C3,
		0x033, 0x0000003D,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C3,
		0x033, 0x0000003E,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C3,
		0x033, 0x0000003F,
		0x03E, 0x0000001B,
		0x03F, 0x0001C3C3,
		0x0EF, 0x00000000,
		0x051, 0x0003D368,
		0x058, 0x00084221,
		0x05B, 0x000EB000,
		0x100EE, 0x00002000,
		0x10030, 0x000000F9,
		0x10030, 0x000004F6,
		0x10030, 0x000008F3,
		0x10030, 0x00000CF0,
		0x10030, 0x000010ED,
		0x10030, 0x000014EA,
		0x10030, 0x000018E7,
		0x10030, 0x00001CE4,
		0x10030, 0x000020E1,
		0x10030, 0x000024A4,
		0x10030, 0x000028A1,
		0x10030, 0x00002C9E,
		0x10030, 0x0000309B,
		0x10030, 0x0000341E,
		0x10030, 0x0000381B,
		0x10030, 0x00003C18,
		0x10030, 0x00004015,
		0x10030, 0x000200BC,
		0x10030, 0x000204B9,
		0x10030, 0x000208B6,
		0x10030, 0x00020CB3,
		0x10030, 0x000210B0,
		0x10030, 0x000214AD,
		0x10030, 0x0002186C,
		0x10030, 0x00021C69,
		0x10030, 0x00022066,
		0x10030, 0x00022426,
		0x10030, 0x00022823,
		0x10030, 0x00022C20,
		0x10030, 0x0002301D,
		0x10030, 0x0002341A,
		0x10030, 0x00023817,
		0x10030, 0x00023C14,
		0x10030, 0x00024011,
		0x10030, 0x000280BC,
		0x10030, 0x000284B9,
		0x10030, 0x000288B6,
		0x10030, 0x00028CB3,
		0x10030, 0x000290B0,
		0x10030, 0x000294AD,
		0x10030, 0x0002986C,
		0x10030, 0x00029C69,
		0x10030, 0x0002A066,
		0x10030, 0x0002A426,
		0x10030, 0x0002A823,
		0x10030, 0x0002AC20,
		0x10030, 0x0002B01D,
		0x10030, 0x0002B41A,
		0x10030, 0x0002B817,
		0x10030, 0x0002BC14,
		0x10030, 0x0002C011,
		0x10030, 0x000300BC,
		0x10030, 0x000304B9,
		0x10030, 0x000308B6,
		0x10030, 0x00030CB3,
		0x10030, 0x000310B0,
		0x10030, 0x000314AD,
		0x10030, 0x0003186C,
		0x10030, 0x00031C69,
		0x10030, 0x00032066,
		0x10030, 0x00032426,
		0x10030, 0x00032823,
		0x10030, 0x00032C20,
		0x10030, 0x0003301D,
		0x10030, 0x0003341A,
		0x10030, 0x00033817,
		0x10030, 0x00033C14,
		0x10030, 0x00034011,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10030, 0x000201EF,
		0x10030, 0x000205E9,
		0x10030, 0x000209E3,
		0x10030, 0x00020DDD,
		0x10030, 0x000211D7,
		0x10030, 0x000215D1,
		0x10030, 0x00021919,
		0x10030, 0x00021D13,
		0x10030, 0x000220D9,
		0x10030, 0x000224D3,
		0x10030, 0x00022899,
		0x10030, 0x00022C93,
		0x10030, 0x00023059,
		0x10030, 0x00023453,
		0x10030, 0x00023819,
		0x10030, 0x00023C13,
		0x10030, 0x0002400D,
		0x10030, 0x00024407,
		0x10030, 0x000281EF,
		0x10030, 0x000285E9,
		0x10030, 0x000289E3,
		0x10030, 0x00028DDD,
		0x10030, 0x000291D7,
		0x10030, 0x000295D1,
		0x10030, 0x00029919,
		0x10030, 0x00029D13,
		0x10030, 0x0002A0D9,
		0x10030, 0x0002A4D3,
		0x10030, 0x0002A899,
		0x10030, 0x0002AC93,
		0x10030, 0x0002B059,
		0x10030, 0x0002B453,
		0x10030, 0x0002B819,
		0x10030, 0x0002BC13,
		0x10030, 0x0002C00D,
		0x10030, 0x0002C407,
		0x10030, 0x000301EF,
		0x10030, 0x000305E9,
		0x10030, 0x000309E3,
		0x10030, 0x00030DDD,
		0x10030, 0x000311D7,
		0x10030, 0x000315D1,
		0x10030, 0x00031919,
		0x10030, 0x00031D13,
		0x10030, 0x000320D9,
		0x10030, 0x000324D3,
		0x10030, 0x00032899,
		0x10030, 0x00032C93,
		0x10030, 0x00033059,
		0x10030, 0x00033453,
		0x10030, 0x00033819,
		0x10030, 0x00033C13,
		0x10030, 0x0003400D,
		0x10030, 0x00034407,
		0x100EE, 0x00000000,
		0x100EE, 0x00004000,
		0x10030, 0x000001EF,
		0x10030, 0x000005E9,
		0x10030, 0x000009E3,
		0x10030, 0x00000DDD,
		0x10030, 0x000011A5,
		0x10030, 0x0000159F,
		0x10030, 0x00001965,
		0x10030, 0x00001D5F,
		0x10030, 0x00002125,
		0x10030, 0x0000251F,
		0x10030, 0x000028E5,
		0x10030, 0x00002CDF,
		0x10030, 0x000030A5,
		0x10030, 0x0000349F,
		0x10030, 0x00003865,
		0x10030, 0x00003C5F,
		0x10030, 0x00004025,
		0x10030, 0x0000441F,
		0x100EE, 0x00000000,
		0x0EF, 0x00000008,
		0x033, 0x00000000,
		0x03F, 0x00000004,
		0x0EF, 0x00000000,
		0x000, 0x00010000,
		0x0FE, 0x0000005A,
		0x005, 0x00000001,
		0x10005, 0x00000001,
		0x0FE, 0x00000031,

};


/******************************************************************************
 *                           txpwr_lmt.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt array_mp_8851b_txpwr_lmt[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 84, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 82, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 82, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 62, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 52, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 66, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 50, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 1},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_CCK, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 76, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 74, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 72, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 70, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 38, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 60, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 80, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 78, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_OFDM, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_20M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 76, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 78, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 80, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 38, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 38, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 46, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 46, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 54, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 54, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 62, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 62, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 102, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 102, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 110, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 110, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 134, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 134, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 142, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 142, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 151, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 151, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 159, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 159, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 38, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 38, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 38, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 46, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 46, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 46, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 54, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 54, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 54, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 62, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 62, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 62, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 102, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 102, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 102, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 110, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 110, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 110, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 118, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 118, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 126, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 126, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 134, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 134, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 134, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 142, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 142, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 142, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 151, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 151, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 151, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 159, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 159, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 159, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 167, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 167, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 175, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_40M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 175, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 60, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 30, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 72, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 42, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 42, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 58, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 58, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 106, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 106, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 138, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 138, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 155, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 155, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 42, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 42, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 42, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 58, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 58, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 58, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 106, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 106, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 106, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 122, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 122, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 138, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 138, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 138, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 155, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 155, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 155, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 171, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_80M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 171, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_FCC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_NONBF, PW_LMT_REGU_UK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 50, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 50, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 114, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 114, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_FCC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ETSI, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_MKK, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_IC, 163, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_KCC, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_ACMA, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_CN, 163, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_BW_160M, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_BF, PW_LMT_REGU_UK, 163, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8851b_txpwr_lmt_ru[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 86, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 86, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru_type2.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8851b_txpwr_lmt_ru_type2[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 60, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 56, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 68, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 80, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 54, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 28, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 56, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 40, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 42, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 66, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 38, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 82, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 52, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 76, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 50, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 48, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 74, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 64, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 72, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 68, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 70, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 78, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 80, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 62, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 60, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 3},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru_type3.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8851b_txpwr_lmt_ru_type3[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 86, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 86, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 68, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 68, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 68, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 68, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 42, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 42, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 40, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 4, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 38, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 66, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 38, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 38, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 36, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 38, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 32, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 52, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 38, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 62, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 58, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 78, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 78, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 62, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 78, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 78, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 34, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 14, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 54, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 78, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 50, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 74, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 48, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 74, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 48, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 74, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 48, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 74, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 74, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 74, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 80, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 48, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 40, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 72, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 72, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 72, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 72, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 70, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 70, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 84, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 84, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 74, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 84, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 84, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 84, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 84, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 64, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 80, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 80, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 82, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 66, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 84, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 68, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 64, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 60, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 28, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 120, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 124, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 124, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 128, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 128, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 132, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 132, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 132, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 136, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 136, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 136, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 140, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 140, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 140, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 144, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 144, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 144, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 149, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 149, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 149, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 149, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 153, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 153, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 153, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 153, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 157, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 157, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 157, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 157, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 161, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 161, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 161, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 161, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 165, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 165, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 165, 56, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 165, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 169, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 169, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 173, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 173, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 177, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 177, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 177, 127, 0}
};


/******************************************************************************
 *                           txpwr_lmt_ru_type4.TXT
 ******************************************************************************/

const struct halrf_tx_pw_lmt_ru array_mp_8851b_txpwr_lmt_ru_type4[] = {
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 46, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 84, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 62, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 48, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 58, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 54, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 40, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 36, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 30, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 22, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 20, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU26, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 70, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 66, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 52, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 58, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 32, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU52, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 76, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 78, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 82, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 74, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 72, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 64, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 64, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 34, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 68, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 56, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 54, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 1, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 1, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 1, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 2, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 2, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 2, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 3, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 3, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 3, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 4, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 4, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 4, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 5, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 5, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 5, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 6, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 6, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 6, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 7, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 7, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 7, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 8, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 8, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 8, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 9, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 9, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 9, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 10, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 10, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 10, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 11, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 11, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 11, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 12, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 12, 44, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 12, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 13, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 13, 42, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 13, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 14, 127, 3},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 14, 127, 0},
	{PW_LMT_BAND_2_4G, PW_LMT_RU_BW_RU106, PW_LMT_PH_2T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 14, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 36, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 36, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 36, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 36, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 36, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 36, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 40, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 40, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 40, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 40, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 40, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 40, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 44, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 44, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 44, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 44, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 44, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 44, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 48, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 48, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 48, 28, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 48, 18, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 48, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 48, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 52, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 52, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 52, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 52, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 52, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 52, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 56, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 56, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 56, 52, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 56, 42, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 56, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 56, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 60, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 60, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 60, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 60, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 60, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 60, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 64, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 64, 26, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 64, 56, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 64, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 64, 16, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 64, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 100, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 100, 46, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 100, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 100, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 100, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 100, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 104, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 104, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 104, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 104, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 104, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 104, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 108, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 108, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 108, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 108, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 108, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 108, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 112, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 112, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 112, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 112, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 112, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 112, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 116, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 116, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 116, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 116, 44, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ACMA, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_CN, 116, 127, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_UK, 116, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_FCC, 120, 54, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_ETSI, 120, 24, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_MKK, 120, 50, 0},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_IC, 120, 127, 1},
	{PW_LMT_BAND_5G, PW_LMT_RU_BW_RU26, PW_LMT_PH_1T, PW_LMT_RS_HE, PW_LMT_REGU_KCC, 120, 44