/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#ifndef _HAL_BTC_H_
#define _HAL_BTC_H_

#include "halbtc_fw.h"
#include "halbtc_dbg_cmd.h"

#ifdef CONFIG_RTL8852A
#define BTC_8852A_SUPPORT
#endif

#ifdef CONFIG_RTL8852B
#define BTC_8852B_SUPPORT
#endif

#ifdef CONFIG_RTL8852BP
#define BTC_8852B_SUPPORT
#define BTC_8852BP_SUPPORT
#endif

#ifdef CONFIG_RTL8852BT
#define BTC_8852B_SUPPORT
#define BTC_8852BT_SUPPORT
#endif


#ifdef CONFIG_RTL8851B
#define BTC_8852B_SUPPORT
#define BTC_8851B_SUPPORT
#endif

#ifdef CONFIG_RTL8852C
#define BTC_8852C_SUPPORT
#endif

#ifdef CONFIG_RTL8852D
#define BTC_8852D_SUPPORT
#endif

#ifdef CONFIG_PHL_IO_OFLD
#define BTC_CONFIG_FW_IO_OFLD_SUPPORT
#endif

#if PLATFOM_IS_LITTLE_ENDIAN
#define BTC_PLATFORM_BIG_ENDIAN 0
#else
#define BTC_PLATFORM_BIG_ENDIAN 1
#endif

#define BTC_GPIO_DBG_EN 1
#define BTC_PHY_MAX 2
#define BTC_WL_TX_PWR_CTRL_OFLD
#define BTC_WL_MAX_ROLE_NUMBER 6  /* Must = MAX_WIFI_ROLE_NUMBER */

#define BTC_FDDT_INFO_MAP_DEF 0x1f

#define BTC_WL_RX_TP_LOW_THRES 10
#define BTC_WL_TX_TP_LOW_THRES 1

#define BTC_SCBD_REWRITE_DELAY 1000
#define BTC_MSG_MAXLEN 200
#define BTC_H2C_MAXLEN 2020 /* limitby H2C hdr-type-20 0:36 ; 1:228 ; 2:2020 */
#define BTC_H2C_MAXLEN1 228
#define BTC_POLICY_MAXLEN 512
#define BTC_HUBMSG_MAXLEN 512
#define BTC_RPT_PERIOD 2000
#define BTC_RSN_MAXLEN 32
#define BTC_ACT_MAXLEN 32
#define BTC_DELAYED_PERIODIC_TIME 2000 /* ms, delayed to start periodic timer */
#define BTC_PERIODIC_TIME 100 /* 100ms, must be non zero and < 2000 */
#define BTC_WRFK_MAXT 300 /* WL RFK 300ms */
#define BTC_BRFK_MAXT 800 /* BT RFK 800ms */
#define BTC_SPKT_MAXT 4000 /* special pkt unit: 4000ms */
#define BTC_REA2DP_MAXT 16000 /* for A2DP resume, 16sec = 16000ms */
#define BTC_WLPS_MAXT 6000
#define BTC_RPT_HDR_SIZE 3
#define BTC_BUSY2IDLE_THRES 10000 /* wait time for WL busy-to-idle, ms */
#define BTC_WL_DEF_TX_PWR 15

#define BTC_DM_MAXSTEP 30

#define BTC_LEAK_AP_TH 10
#define BTC_CYSTA_CHK_PERIOD 50
#define BTC_SLOT_REQ_TH 2

#define BTC_NULLTX_FAIL_TH 8
#define BTC_NULLTX_CHK_PERIOD 100

#define BTC_P2P_CYCLE 100
#define BTC_NULL1_EBT_EARLY_T 10
#define BTC_E2G_OFFSET 10;
#define BTC_E2G_LIMIT_DEF 80
#define BTC_E2G_LIMIT_MIN 40
#define BTC_E2G_LIMIT_MAX 100

#define B_BTC_DIS_BTC_CLK_G BIT(2)
#define B_BTC_WL_SRC BIT(0)

#define BTC_WL_LINK_SCAN 0x3e

#define BTC_BB_GNT_FWCTRL 2
#define BTC_BB_GNT_NOTFOUND 3
#define BTC_BB_PRE_AGC_FWCTRL 2
#define BTC_BB_PRE_AGC_NOTFOUND 3

#define BTC_BB_TX_1SS_LIMIT 0 /* if halbb support rtw_hal_btc_cfg_tx_1ss */

#define BTC_AP_BLIST 0 /* Sporton AP issue*/

#define R_BTC_ZB_COEX_TBL_0 0xDA28
#define R_BTC_ZB_COEX_TBL_1 0xDA2C
#define R_BTC_ZB_BREAK_TBL  0xDA50

struct btc_t;

#define NM_EXEC false
#define FC_EXEC true

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(x) (sizeof(x) / sizeof((x)[0]))
#endif

#ifndef BIT
#define BIT(x) (1 << (x))
#endif

#define bMASKDW 0xffffffff
#define bMASKHW 0xffff0000
#define bMASKLW 0x0000ffff
#define bMASKB0 0x000000ff
#define bMASKB1 0x0000ff00
#define bMASKB2 0x00ff0000
#define bMASKB3 0xff000000
#define bMASKRF 0x000fffff

#define BTC_WL_RSSI_THMAX 4
#define BTC_BT_RSSI_THMAX 4

#define BTC_WL_RSSI_MAX_BTG 70 /* for BTG co-rx Hi-RSSI thres */

#define BTC_TDMA_WLROLE_MAX 3
#define BTC_FREERUN_ANTISO_MIN 30
#define BTC_FDDTRAIN_ANTISO_MIN 10
#define BTC_FDDTRAIN_ANTISO_MAX 40
#define BTC_BT_RX_NORMAL_LVL 7

#define BTC_BTINFO_LEN 6
#define BTC_B1_MAX 250  /* unit:ms, used for Max A2DP retry adjust */

#define BTC_COEX_RTK_MODE 0
#define BTC_COEX_CSR_MODE 1

#define BTC_CHK_ERR_TH 3
#define BTC_CHK_WLSLOT_DRIFT_MAX 15
#define BTC_CHK_BTSLOT_DRIFT_MAX 15

#define BTC_RFK_PATH_MAP 0xf
#define BTC_RFK_PHY_MAP 0x30
#define BTC_RFK_BAND_MAP 0xc0

#define BTC_GNT_SET_SKIP 0xff

#define BTC_CLIENT_PS_MAX 32 /* client TDMA-on if >= (unit: BTC_PERIODIC_TIME)*/

/* mailbox 0x45 BT device info related */
#define BTC_DEV_LINK_MAX 4

#define _write_cx_reg(btc, offset, val) \
	rtw_hal_mac_coex_reg_write(btc->hal, offset, val)

#define _read_cx_reg(btc, offset, val) \
	rtw_hal_mac_coex_reg_read(btc->hal, offset, val)

#define _read_cx_ctrl(btc, val) \
	rtw_hal_mac_get_coex_ctrl(btc->hal, val)

#define _write_wl_rf_reg(btc, path, addr, mask, data) \
	rtw_hal_write_rf_reg(btc->hal, path, addr, mask, data)

#define _send_phl_evnt(btc, buf, len, vid) \
	hal_btc_send_event(btc, btc->cx.wl.pta_req_mac, buf, len, vid)

#define _update_poicy hal_btc_fw_set_policy
#define _set_fw_rpt hal_btc_fw_set_rpt

#define run_rsn(r) \
	(hal_mem_cmp(btc->hal, btc->dm.run_reason, r, _os_strlen((u8*)r))? 0:1)

#define _rsn_cpy(dst, src, len) \
	do { \
		len = (len < BTC_RSN_MAXLEN) ? len : BTC_RSN_MAXLEN-1; \
		hal_mem_set(btc->hal, dst, 0, BTC_RSN_MAXLEN); \
		hal_mem_cpy(btc->hal, dst, src, len); \
	} while (0)

#define _act_cpy(dst, src, len) \
	do { \
		len = (len < BTC_ACT_MAXLEN) ? len : BTC_ACT_MAXLEN-1; \
		hal_mem_set(btc->hal, dst, 0, BTC_ACT_MAXLEN); \
		hal_mem_cpy(btc->hal, dst, src, len); \
	} while (0)

#define _tdma_cmp(dst, src) \
	hal_mem_cmp(btc->hal, dst, src, sizeof(struct fbtc_tdma))
#define _tdma_cpy(dst, src) \
	hal_mem_cpy(btc->hal, dst, src, sizeof(struct fbtc_tdma))
#define _tdma_set(tp,rxflc,txflc,wtg,lek,ext,flc_role) \
	do { \
		btc->dm.tdma.type = tp;\
		btc->dm.tdma.rxflctrl = rxflc; \
		btc->dm.tdma.txflctrl = txflc; \
		btc->dm.tdma.rsvd = wtg; \
		btc->dm.tdma.leak_n = lek; \
		btc->dm.tdma.ext_ctrl = ext; \
		btc->dm.tdma.rxflctrl_role = flc_role; \
	} while (0)
#define _tdma_set_rxflctrl(rxflc) btc->dm.tdma.rxflctrl = rxflc
#define _tdma_set_txflctrl(txflc) btc->dm.tdma.txflctrl = txflc
#define _tdma_set_flctrl_role(role) btc->dm.tdma.rxflctrl_role = role
#define _tdma_set_lek(lek) btc->dm.tdma.leak_n = lek

#define _tdma_set_instant() btc->dm.tdma.option_ctrl |= CXOPCTL_INST_EXEC
#define _tdma_set_fddt_en() btc->dm.tdma.option_ctrl |= CXOPCTL_FDDT_ENABLE
#define _tdma_set_fddt_renew() btc->dm.tdma.option_ctrl |= CXOPCTL_FDDT_RENEW
#define _tdma_set_fddt_dbg() btc->dm.tdma.option_ctrl |= CXOPCTL_FDDT_DEBUG

#define _slot_cmp(dst, src) \
	hal_mem_cmp(btc->hal, dst, src, sizeof(struct fbtc_slot))
#define _slot_cpy(dst, src) \
	hal_mem_cpy(btc->hal, dst, src, sizeof(struct fbtc_slot))
#define _slots_cpy(dst, src) \
	hal_mem_cpy(btc->hal, dst, src, CXST_MAX*sizeof(struct fbtc_slot))
#define _slot_set(sid,dura,tbl,type) \
	do { \
		btc->dm.slot[sid].dur = dura;\
		btc->dm.slot[sid].cxtbl = tbl; \
		btc->dm.slot[sid].cxtype = type; \
	} while (0)
#define _slot_set_dur(sid,dura) btc->dm.slot[sid].dur = dura
#define _slot_set_tbl(sid,tbl) btc->dm.slot[sid].cxtbl = tbl
#define _slot_set_type(sid,type) btc->dm.slot[sid].cxtype = type

#define _fddt_cmp(dst, src) \
	hal_mem_cmp(btc->hal, dst, src, sizeof(struct btc_fddt_train_info))
#define _fddt_cpy(dst, src) \
	hal_mem_cpy(btc->hal, dst, src, sizeof(struct btc_fddt_train_info))

#define btc_swap2(a, b) \
		do { u8 __tmp = (a); (a) = (b); (b) = __tmp; } while (0)
#define btc_swap4(a, b, c, d) \
		do { btc_swap2(a, d); btc_swap2(b, c); } while (0)

#ifdef BTC_AISO_SUPPORT
#define BT_PSD_RPT_TYPE_QUERY	0x0 /* report when WLAN query */
#define BT_PSD_RPT_TYPE_CAL	0x1 /* when PSD scan idx~idx+4, idx+5~idx+9 */
#define BT_PSD_RPT_TYPE_NOISE	0x2 /* report all channel */

#define BT_PSD_SRC_RAW		0x0
#define BT_PSD_SRC_POST_BB	0x1
#define BT_PSD_SRC_POST_BB_FW	0x2

#define BT_PSD_WAIT_CNT		200

#define BT_PSD_TX_BUSY_CNT_MIN	3    /* data num per frequency point*/
#define BT_PSD_VALID_CH_MIN	4    /* 1~5, 3/4 is more suitbale */
#define BT_PSD_PRINT_PERIOD	10
#endif

enum btc_wl_gpio_debug {
	BTC_DBG_GNT_BT = 0,
	BTC_DBG_GNT_WL = 1,
	/* The following signals should 0-1 tiggle by each function-call */
	BTC_DBG_BCN_EARLY = 2,
	BTC_DBG_WL_NULL0 = 3,
	BTC_DBG_WL_NULL1 = 4,
	BTC_DBG_WL_RXISR = 5,
	BTC_DBG_TDMA_ENTRY = 6,
	BTC_DBG_A2DP_EMPTY = 7,
	BTC_DBG_BT_RETRY = 8,
	/* The following signals should 0-1 tiggle by state L/H */
	BTC_DBG_BT_RELINK = 9,
	BTC_DBG_SLOT_WL = 10,
	BTC_DBG_SLOT_BT = 11,
	/* The following signals should 0-1 tiggle by external*/
	BTC_DBG_WL_ERR = 12,
	BTC_DBG_WL_OK = 13,
	/* The following signals appear only 1-active at same time*/
	BTC_DBG_SLOT_B2W = 14,
	BTC_DBG_SLOT_W1 = 15,
	BTC_DBG_SLOT_W2 = 16,
	BTC_DBG_SLOT_W2B = 17,
	BTC_DBG_SLOT_B1 = 18,
	BTC_DBG_SLOT_B2 = 19,
	BTC_DBG_SLOT_B3 = 20,
	BTC_DBG_SLOT_B4 = 21,
	BTC_DBG_SLOT_LK = 22,
	BTC_DBG_SLOT_E2G = 23,
	BTC_DBG_SLOT_E5G = 24,
	BTC_DBG_SLOT_EBT = 25,
	BTC_DBG_SLOT_WLK = 26,
	BTC_DBG_SLOT_B1FDD = 27,
	BTC_DBG_BT_CHANGE = 28,
	/* The following signals should 0-1 tiggle by external*/
	BTC_DBG_WL_CCA = 29,
	BTC_DBG_BT_LEAUDIO = 30,
	BTC_DBG_USER_DEF = 31 /* limit by BTC_DBG_MAX1-1  */
};

enum btc_bt_dev_info {
	BTC_DEV_HID_LIST = 0x0,
	BTC_DEV_HID_VINFO = 0x1,
	BTC_DEV_HID_DNAME =  0x2,
	BTC_DEV_HID_BINFO = 0x3,

	BTC_DEV_A2DP_LIST = 0x10,
	BTC_DEV_A2DP_BINFO = 0x11,

	BTC_DEV_PAN_LIST = 0x20,
	BTC_DEV_PAN_BINFO = 0x21
};

enum btc_coex_dir {
	BTC_COEX_INNER = 0,
	BTC_COEX_OUTPUT = 1,
	BTC_COEX_INPUT = 2
};

enum btc_cx_run_info {
	BTC_CXR_WSCBD = 0,
	BTC_CXR_RESULT,
	BTC_CXR_MAX
};

enum btc_bt_rfk_state {
	BTC_BRFK_STOP = 0,
	BTC_BRFK_START = 1
};

enum btc_wl_rfk_state {
	BTC_WRFK_STOP = 0,
	BTC_WRFK_START = 1,
	BTC_WRFK_ONESHOT_START = 2,
	BTC_WRFK_ONESHOT_STOP = 3
};

enum btc_wl_rfk_result {
	BTC_WRFK_REJECT = 0,
	BTC_WRFK_ALLOW = 1
};

enum btc_lps_state {
	BTC_LPS_OFF = 0,
	BTC_LPS_RF_OFF = 1,
	BTC_LPS_RF_ON = 2
};

enum btc_gnt_ctrl_type {
	BTC_CTRL_BY_BT = 0,
	BTC_CTRL_BY_WL
};

enum btc_3cx_type {
	BTC_3CX_NONE = 0,
	BTC_3CX_LTE = 1,
	BTC_3CX_ZB = 2,
	BTC_3CX_MAX
};

enum btc_wl_pri_mask_type {
	BTC_PRI_MASK_RX_RESP = 0,
	BTC_PRI_MASK_TX_RESP,
	BTC_PRI_MASK_BEACON,
	BTC_PRI_MASK_RX_CCK,
	BTC_PRI_MASK_TX_CCK,
	BTC_PRI_MASK_TX_TRIG,
	BTC_PRI_MASK_MAX
};

enum btc_init_type {
	BTC_INIT_NORMAL,
	BTC_INIT_WLONLY,
	BTC_INIT_WLOFF
};

enum btc_branch_type {
	BTC_BRANCH_FORMAL = 0,
	BTC_BRANCH_UPSTREAM,
	BTC_BRANCH_HP,
	BTC_BRANCH_LENOVO,
	BTC_BRANCH_XBOX,
	BTC_BRANCH_HW,
	BTC_BRANCH_ROKU,
	BTC_BRANCH_LG,
	BTC_BRANCH_SAMSUNG,
	BTC_BRANCH_AMAZON,
	BTC_BRANCH_MAX
};

enum btc_dbg_str_type {
	BTC_STR_ROLE = 0,
	BTC_STR_MROLE,
	BTC_STR_REG,
	BTC_STR_SLOT,
	BTC_STR_TDMA,
	BTC_STR_TRACE,
	BTC_STR_BRANCH,
	BTC_STR_RXFLCTRL,
	BTC_STR_WLLINK,
	BTC_STR_ANTPATH,
	BTC_STR_GDBG,
	BTC_STR_CHIPID,
	BTC_STR_EVENT,
	BTC_STR_WLMODE,
	BTC_STR_WLBW,
	BTC_STR_RFTYPE,
	BTC_STR_POLICY,
	BTC_STR_MSTATE,
	BTC_STR_RATE,
	BTC_STR_POLUT,
	BTC_STR_BAND,
	BTC_STR_CXSTATE,
	BTC_STR_FDDT_TYPE,
	BTC_STR_FDDT_STATE,
	BTC_STR_FDDT_NORUN,
	BTC_STR_DMERROR,
	BTC_STR_FWERROR,
	BTC_STR_RPTMATCH,
	BTC_STR_H2CERROR,
	BTC_STR_MAX
};

enum btc_bt_rf_group {
	BTC_BT_SS_GROUP = 0x0,
	BTC_BT_TX_GROUP = 0x2,
	BTC_BT_RX_GROUP = 0x3,
	BTC_BT_MAX_GROUP,
};

enum btc_rssi_st {
	BTC_RSSI_ST_LOW = 0x0,
	BTC_RSSI_ST_HIGH,
	BTC_RSSI_ST_STAY_LOW,
	BTC_RSSI_ST_STAY_HIGH,
	BTC_RSSI_ST_MAX
};

enum btc_fddt_en {
	BTC_FDDT_DISABLE,
	BTC_FDDT_ENABLE,
};

enum btc_fddt_type {
	BTC_FDDT_TYPE_STOP,
	BTC_FDDT_TYPE_AUTO,
	BTC_FDDT_TYPE_FIX_TDD,
	BTC_FDDT_TYPE_FIX_FULL_FDD,
	BTC_FDDT_MAX
};

enum btc_chip_feature {
	BTC_FEAT_PTA_ONOFF_CTRL  = BIT(0), /* on/off ctrl by HW (not 0x73[2]) */
	BTC_FEAT_NONBTG_GWL_THRU = BIT(1),  /* non-BTG GNT_WL!=0 if GNT_BT = 1*/
	BTC_FEAT_WLAN_ACT_MUX = BIT(2)
};

#define	BTC_RSSI_HIGH(_rssi_) \
	((_rssi_ == BTC_RSSI_ST_HIGH || _rssi_ == BTC_RSSI_ST_STAY_HIGH)? 1:0)
#define	BTC_RSSI_LOW(_rssi_) \
	((_rssi_ == BTC_RSSI_ST_LOW || _rssi_ == BTC_RSSI_ST_STAY_LOW)? 1:0)
#define	BTC_RSSI_CHANGE(_rssi_) \
	((_rssi_ == BTC_RSSI_ST_LOW || _rssi_ == BTC_RSSI_ST_HIGH)? 1:0)

enum btc_coex_info_map_en {
	BTC_COEX_INFO_CX = BIT(0),
	BTC_COEX_INFO_WL = BIT(1),
	BTC_COEX_INFO_BT = BIT(2),
	BTC_COEX_INFO_DM = BIT(3),
	BTC_COEX_INFO_MREG = BIT(4),
	BTC_COEX_INFO_SUMMARY = BIT(5),
	BTC_COEX_INFO_ALL = 0xff
};

/* list all-chip scoreboard definition, remap at chip file */
enum btc_w2b_scoreboard {
	BTC_WSCB_ACTIVE	= BIT(0),
	BTC_WSCB_ON = BIT(1),
	BTC_WSCB_SCAN = BIT(2),
	BTC_WSCB_UNDERTEST = BIT(3),
	BTC_WSCB_RXGAIN = BIT(4), /* set BT LNA constrain for free-run */
	BTC_WSCB_5GHICH = BIT(6),
	BTC_WSCB_WLBUSY = BIT(7),
	BTC_WSCB_EXTFEM = BIT(8),
	BTC_WSCB_TDMA = BIT(9),
	BTC_WSCB_FIX2M = BIT(10),
	BTC_WSCB_WLRFK = BIT(11),
	BTC_WSCB_RXSCAN_PRI = BIT(12), /* set BT Rx-Scan PTA pri */
	BTC_WSCB_BT_HILNA = BIT(13), /* request BT use Hi-LNA table for BTG */
	BTC_WSCB_BTLOG = BIT(14),  /* open BT log */
	BTC_WSCB_ALL = 0xffffff /* driver only use bit0~23 */
};

enum btc_b2w_scoreboard {
	BTC_BSCB_ACT = BIT(0),
	BTC_BSCB_ON = BIT(1),
	BTC_BSCB_WHQL = BIT(2),
	BTC_BSCB_BT_S1 = BIT(3),  /* 1-> BT at S1, 0-> BT at S0 */
	BTC_BSCB_A2DP_ACT = BIT(4),
	BTC_BSCB_RFK_RUN = BIT(5),
	BTC_BSCB_RFK_REQ = BIT(6),
	BTC_BSCB_LPS = BIT(7),
	BTC_BSCB_BT_LNAB0 = BIT(8),
	BTC_BSCB_BT_LNAB1 = BIT(10),
	BTC_BSCB_WLRFK = BIT(11),
	BTC_BSCB_BT_HILNA = BIT(13), /* reply if BT use Hi-LNA table for BTG */
	BTC_BSCB_BT_CONNECT = BIT(16), /* If any BT connected */
	BTC_BSCB_PATCH_CODE = BIT(30),  /* BT use 1: patch code 2:ROM code */
	BTC_BSCB_ALL = 0x7fffffff
};

enum btc_bt_link_status {
	BTC_BLINK_CONNECT = BIT(0),
	BTC_BLINK_BLE_CONNECT = BIT(1),
	BTC_BLINK_ACL_BUSY = BIT(2),
	BTC_BLINK_SCO_BUSY = BIT(3),
	BTC_BLINK_MESH_BUSY = BIT(4),
	BTC_BLINK_INQ_PAGE = BIT(5)
};

enum btc_dcnt_type {
	BTC_DCNT_RUN = 0x0,
	BTC_DCNT_CX_RUNINFO,
	BTC_DCNT_RPT,
	BTC_DCNT_RPT_HANG,
	BTC_DCNT_CYCLE,
	BTC_DCNT_CYCLE_HANG,
	BTC_DCNT_W1,
	BTC_DCNT_W1_HANG,
	BTC_DCNT_B1,
	BTC_DCNT_B1_HANG,
	BTC_DCNT_TDMA_NONSYNC,
	BTC_DCNT_SLOT_NONSYNC,
	BTC_DCNT_BTCNT_HANG,
	BTC_DCNT_BTTX_HANG,
	BTC_DCNT_WL_SLOT_DRIFT,
	BTC_DCNT_WL_STA_LAST,
	BTC_DCNT_BT_SLOT_DRIFT,
	BTC_DCNT_BT_SLOT_FLOOD,
	BTC_DCNT_FDDT_TRIG,
	BTC_DCNT_E2G,
	BTC_DCNT_E2G_HANG,
	BTC_DCNT_WL_FW_VER_MATCH,
	BTC_DCNT_NULL_TX_FAIL,
	BTC_DCNT_WL_STA_NTFY,
	BTC_DCNT_MAX
};

enum btc_ncnt_type {
	BTC_NCNT_POWER_ON = 0x0,
	BTC_NCNT_POWER_OFF,
	BTC_NCNT_INIT_COEX,
	BTC_NCNT_SCAN_START,
	BTC_NCNT_SCAN_FINISH,
	BTC_NCNT_SPECIAL_PACKET,
	BTC_NCNT_SWITCH_BAND,
	BTC_NCNT_RFK_TIMEOUT,
	BTC_NCNT_SHOW_COEX_INFO,
	BTC_NCNT_ROLE_INFO,
	BTC_NCNT_RADIO_STATE,
	BTC_NCNT_CUSTOMERIZE,
	BTC_NCNT_WL_RFK,
	BTC_NCNT_WL_STA,
	BTC_NCNT_WL_STA_LAST,
	BTC_NCNT_FWINFO,
	BTC_NCNT_TIMER,
	BTC_NCNT_MAX
};

enum btc_wl_state_cnt {
	BTC_WCNT_SCANAP = 0x0,
	BTC_WCNT_DHCP,
	BTC_WCNT_EAPOL,
	BTC_WCNT_ARP,
	BTC_WCNT_SCBDUPDATE,
	BTC_WCNT_RFK_REQ,
	BTC_WCNT_RFK_GO,
	BTC_WCNT_RFK_REJECT,
	BTC_WCNT_RFK_TIMEOUT,
	BTC_WCNT_CH_UPDATE,
	BTC_WCNT_DBCC_ALL_2G,
	BTC_WCNT_DBCC_CHG,
	BTC_WCNT_RX_OK_LAST,
	BTC_WCNT_RX_OK_LAST2S,
	BTC_WCNT_RX_ERR_LAST,
	BTC_WCNT_RX_ERR_LAST2S,
	BTC_WCNT_RX_LAST,
	BTC_WCNT_MAX
};

enum btc_bt_state_cnt {
	BTC_BCNT_RETRY = 0x0,
	BTC_BCNT_REINIT,
	BTC_BCNT_REENABLE,
	BTC_BCNT_SCBDREAD,
	BTC_BCNT_RELINK,
	BTC_BCNT_IGNOWL,
	BTC_BCNT_INQPAG,
	BTC_BCNT_INQ,
	BTC_BCNT_PAGE,
	BTC_BCNT_ROLESW,
	BTC_BCNT_AFH,
	BTC_BCNT_INFOUPDATE,
	BTC_BCNT_INFOSAME,
	BTC_BCNT_SCBDUPDATE,
	BTC_BCNT_HIPRI_TX,
	BTC_BCNT_HIPRI_RX,
	BTC_BCNT_LOPRI_TX,
	BTC_BCNT_LOPRI_RX,
	BTC_BCNT_POLUT,
	BTC_BCNT_RATECHG,
	BTC_BCNT_AFH_CONFLICT,
	BTC_BCNT_AFH_LE_CONFLICT,
	BTC_BCNT_AFH_UPDATE,
	BTC_BCNT_AFH_LE_UPDATE,
	BTC_BCNT_MAX
};

enum btc_wl_link_mode {
	BTC_WLINK_NOLINK = 0x0,
	BTC_WLINK_2G_STA,
	BTC_WLINK_2G_AP,
	BTC_WLINK_2G_GO,
	BTC_WLINK_2G_GC,
	BTC_WLINK_2G_SCC,
	BTC_WLINK_2G_MCC,
	BTC_WLINK_25G_MCC,
	BTC_WLINK_25G_DBCC,
	BTC_WLINK_5G,
	BTC_WLINK_2G_NAN,
	BTC_WLINK_OTHER,
	BTC_WLINK_MAX
};

enum btc_wl_mrole_type {
	BTC_WLMROLE_NONE = 0x0,
	BTC_WLMROLE_STA_GC,
	BTC_WLMROLE_STA_GC_NOA,
	BTC_WLMROLE_STA_GO,
	BTC_WLMROLE_STA_GO_NOA,
	BTC_WLMROLE_STA_STA,
	BTC_WLMROLE_MAX
};

enum btc_btinfo_byte {
	BTC_BTINFO_L0 = 0,
	BTC_BTINFO_L1,
	BTC_BTINFO_L2,
	BTC_BTINFO_L3,
	BTC_BTINFO_H0,
	BTC_BTINFO_H1,
	BTC_BTINFO_H2,
	BTC_BTINFO_H3,
	BTC_BTINFO_MAX
};

enum btc_dm_error {
	BTC_DMERR_INIT = BIT(0),
	BTC_DMERR_PTA_OWNER = BIT(1),
	BTC_DMERR_WL_RFK_TIMEOUT = BIT(2),
	BTC_DMERR_BT_RFK_TIMEOUT = BIT(3),

	BTC_DMERR_WL_FW_HANG = BIT(4),
	BTC_DMERR_CYCLE_HANG = BIT(5),
	BTC_DMERR_W1_HANG = BIT(6),
	BTC_DMERR_B1_HANG = BIT(7),

	BTC_DMERR_TDMA_NO_SYNC = BIT(8),
	BTC_DMERR_SLOT_NO_SYNC = BIT(9),
	BTC_DMERR_WL_SLOT_DRIFT = BIT(10),
	BTC_DMERR_BT_SLOT_DRIFT = BIT(11), /* for external slot control */

	BTC_DMERR_ROLE_NUM_MISMATCH = BIT(12),
	BTC_DMERR_NULL1_TX_LATE = BIT(13),
	BTC_DMERR_AFH_CONFLICT = BIT(14),
	BTC_DMERR_AFH_LE_CONFLICT = BIT(15),

	BTC_DMERR_BT_SLOT_FLOOD = BIT(16),
	BTC_DMERR_E2G_HANG = BIT(17),
	BTC_DMERR_WL_VER_MISMATCH = BIT(18),
	BTC_DMERR_BT_VER_MISMATCH = BIT(19),

	BTC_DMERR_RFE_TYPE0 = BIT(20),
	BTC_DMERR_H2C_BUF_OVER = BIT(21),
	BTC_DMERR_BTTX_HANG = BIT(22), /* for SNR too low bug, BT has no Tx req*/
	BTC_DMERR_WL_NO_STA_NTFY = BIT(23), /*  */
	BTC_DMERR_H2C_BMAP_MISMATCH = BIT(24),
	BTC_DMERR_C2H_BMAP_MISMATCH = BIT(25),
	BTC_DMERR_H2C_STRUCT_INVALID = BIT(26),
	BTC_DMERR_C2H_STRUCT_INVALID = BIT(27),
	BTC_DMERR_MAX = 28
};

enum btc_fw_btc_error {
	BTC_FWERR_NULL_RESULT = BIT(0),
	BTC_FWERR_NULL_EXCEPTION = BIT(1),
	BTC_FWERR_B1_EXCEPTION = BIT(2),
	BTC_FWERR_W1_EXCEPTION = BIT(3),

	BTC_FWERR_B2_EXCEPTION = BIT(4),
	BTC_FWERR_B3_EXCEPTION = BIT(5),
	BTC_FWERR_B4_EXCEPTION = BIT(6),
	BTC_FWERR_LPS_TIMER_START = BIT(7),

	BTC_FWERR_EXAUTO_EXCEPTION = BIT(8),
	BTC_FWERR_BUF_OVERFLOW = BIT(9),
	BTC_FWERR_BRLY_EXCEPTION = BIT(10),
	BTC_FWERR_SM = BIT(11),  /* un-known-event */

	BTC_FWERR_B2_AFTER = BIT(12),
	BTC_FWERR_LK_END = BIT(13),
	BTC_FWERR_TMR_FAIL = BIT(14),
	BTC_FWERR_H2C_SET_EXCEPTION = BIT(15),
	BTC_FWERR_MAX = 16
};

enum btc_get_reg_status {
	BTC_CSTATUS_TXDIV_POS = 0,
	BTC_CSTATUS_RXDIV_POS = 1,
	BTC_CSTATUS_BB_GNT_MUX = 2,
	BTC_CSTATUS_BB_GNT_MUX_MON = 3,
	BTC_CSTATUS_BB_PRE_AGC = 4,
	BTC_CSTATUS_BB_PRE_AGC_MON = 5
};

enum halrf_rfk_type {
	BTC_RF_IQK	= 0,
	BTC_RF_LCK	= 1,
	BTC_RF_DPK	= 2,
	BTC_RF_TXGAPK	= 3,
	BTC_RF_DACK	= 4,
	BTC_RF_RXDCK	= 5,
	BTC_RF_TSSI	= 6,
	BTC_RF_CHLK	= 7
};

enum btc_ant_div_pos {
	BTC_ANT_DIV_MAIN = 0,
	BTC_ANT_DIV_AUX = 1
};

enum btc_fw_data_dir {
	BTC_FW_H2C = 0,
	BTC_FW_C2H = 1
};

struct btc_byte_map_desc {
	u16 map_u8;
	u16 map_u16;
	u16 map_u32;
};

struct btc_btinfo_lb2 {
	u8 connect: 1;
	u8 sco_busy: 1;
	u8 inq_pag: 1;
	u8 acl_busy: 1;
	u8 hfp: 1;
	u8 hid: 1;
	u8 a2dp: 1;
	u8 pan: 1;
};

struct btc_btinfo_lb3 {
	u8 retry: 4;
	u8 cqddr: 1;
	u8 inq: 1;
	u8 mesh_busy: 1;
	u8 pag: 1;
};

struct btc_btinfo_hb0 {
	u8 rssi;
};

struct btc_btinfo_hb1 {
	u8 ble_connect: 1;
	u8 reinit: 1;
	u8 relink: 1;
	u8 igno_wl: 1;
	u8 voice: 1;
	u8 ble_scan: 1;
	u8 role_sw: 1;
	u8 multi_link: 1;
};

struct btc_btinfo_hb2 {
	u8 pan_active: 1;
	u8 afh_update: 1;
	u8 a2dp_active: 1;
	u8 slave: 1;
	u8 hid_slot: 2;
	u8 hid_cnt: 2;
};

struct btc_btinfo_hb3 {
	u8 a2dp_bitpool: 6;
	u8 tx_3M: 1;
	u8 a2dp_sink: 1;
};

union btc_btinfo {
	u8 val;
	struct btc_btinfo_lb2 lb2;
	struct btc_btinfo_lb3 lb3;
	struct btc_btinfo_hb0 hb0;
	struct btc_btinfo_hb1 hb1;
	struct btc_btinfo_hb2 hb2;
	struct btc_btinfo_hb3 hb3;
};

enum btc_rinfo_lo_b2 {
	BTC_RINFO_INQPAG = BIT(2),
};

enum btc_bt_hfp_type {
	BTC_HFP_SCO = 0,
	BTC_HFP_ESCO = 1,
	BTC_HFP_ESCO_2SLOT = 2,
};

enum btc_bt_hid_type {
	BTC_HID_218 = BIT(0),
	BTC_HID_418 = BIT(1),
	BTC_HID_BLE = BIT(2),
	BTC_HID_RCU = BIT(3),
	BTC_HID_RCU_VOICE = BIT(4),
	BTC_HID_OTHER_LEGACY = BIT(5)
};

enum btc_bt_a2dp_type {
	BTC_A2DP_LEGACY = 0,
	BTC_A2DP_TWS_SNIFF = 1, /* Airpod */
	BTC_A2DP_TWS_RELAY = 2, /* RTL8763B */
};

enum btc_bt_PAN_type {
	BTC_BT_PAN_ONLY = 0,
	BTC_BT_OPP_ONLY = 1
};

enum btc_bt_mailbox_id {
	BTC_BTINFO_REPLY = 0x23,
	BTC_BTINFO_AUTO = 0x27
};

enum btc_bt_profile_map {
	BTC_BT_HFP = BIT(0),
	BTC_BT_HID = BIT(1),
	BTC_BT_A2DP = BIT(2),
	BTC_BT_PAN = BIT(3),
	BTC_PROFILE_MAX = 4,
	BTC_BT_ALL = 0xf
};

enum btc_iqk_state {
	BTC_BT_IQK_OK = 0,
	BTC_BT_IQK_START = 1,
	BTC_BT_IQK_STOP = 2,
	BTC_BT_IQK_MAX
};

enum btc_ant_share_type {
	BTC_ANT_SHARED = 0,
	BTC_ANT_DEDICATED,
	BTC_ANTTYPE_MAX
};

enum btc_bt_combo_type {
	BTC_BT_ALONE = 0,
	BTC_BT_BTG
};

enum btc_ant_switch_type {
	BTC_SWITCH_INTERNAL = 0,  /* internal or none */
	BTC_SWITCH_EXTERNAL
};

enum btc_reset_var_map {
	BTC_RESET_CX = BIT(0),
	BTC_RESET_DM = BIT(1),
	BTC_RESET_CTRL = BIT(2),
	BTC_RESET_CXDM = BIT(0) | BIT(1),
	BTC_RESET_BTINFO = BIT(3),
	BTC_RESET_MDINFO = BIT(4),
	BTC_RESET_BT_PSD_DM = BIT(5),
	BTC_RESET_ALL = 0xff
};

enum btc_gnt_state {
	BTC_GNT_HW	= 0,
	BTC_GNT_SW_LO,
	BTC_GNT_SW_HI,
	BTC_GNT_MAX
};

enum btc_wlact_state {
	BTC_WLACT_HW	= 0,
	BTC_WLACT_SW_LO,
	BTC_WLACT_SW_HI,
	BTC_WLACT_MAX
};

enum btc_wl_max_tx_time {
	BTC_MAX_TX_TIME_L1 = 500,
	BTC_MAX_TX_TIME_L2 = 1000,
	BTC_MAX_TX_TIME_L3 = 2000,
	BTC_MAX_TX_TIME_DEF = 5280
};

enum btc_wl_max_tx_retry {
	BTC_MAX_TX_RETRY_L1 = 7,
	BTC_MAX_TX_RETRY_L2 = 15,
	BTC_MAX_TX_RETRY_DEF = 31
};

enum btc_nofddt_rsn {
	BTC_NFRSN_SUPPORT = 0,
	BTC_NFRSN_FORCE_STOP,
	BTC_NFRSN_DEDICATED_ANT,
	BTC_NFRSN_ANT_ISO_LOW,
	BTC_NFRSN_ANT_ISO_HI,
	BTC_NFRSN_WL_2GSTA,     /* if 2G STA only */
	BTC_NFRSN_WL_BUSY,      /* if idle/LPS */
	BTC_NFRSN_WL_NOSCAN,
	BTC_NFRSN_WL_NORFK,
	BTC_NFRSN_WB_RSSI,      /* if WL & BT RSSI to low */
	BTC_NFRSN_BT_PROFILE,   /* if NOT A2DP or A2DP + HID/HFP */
	BTC_NFRSN_BT_A2DP_BUSY, /* if A2DP idle */
	BTC_NFRSN_BT_NOINQ,
	BTC_NFRSN_COND_NUM,
	BTC_NFRSN_NHM,
	BTC_NFRSN_RETRY_PERIOD,/* if bt retry-period not reach */
	BTC_NFRSN_MAX
};

enum btc_fddt_state {
	BTC_FDDT_STATE_STOP,
	BTC_FDDT_STATE_RUN,
	BTC_FDDT_STATE_PENDING,
	BTC_FDDT_STATE_DEBUG,
	BTC_FDDT_STATE_MAX
};

enum btc_fddt_result {
	BTC_FDDT_RESULT_UNFINISH,
	BTC_FDDT_RESULT_OK,
	BTC_FDDT_RESULT_FAIL,
	BTC_FDDT_RESULT_MAX
};

enum btc_wa_type {
	BTC_WA_5G_HI_CH_RX = BIT(0),
	BTC_WA_NULL_AP = BIT(1),
	BTC_WA_HFP_ZB = BIT(2)  /* HFP PTA req bit4 define issue */
};

struct btc_wl_tx_limit_para {
	u8 en;
	u8 tx_1ss;
	u32 tx_time;	/* unit: us */
	u16 tx_retry;
};

struct btc_rf_trx_para {
	u32 wl_tx_power; /* absolute Tx power (dBm), 1's complement -5->0x85 */
	u32 wl_rx_gain;  /* rx gain table index (TBD.) */
	u32 bt_tx_power; /* decrease Tx power (dB) */
	u32 bt_rx_gain;  /* LNA constrain level */
};

struct btc_gnt_ctrl {
	u8 gnt_bt_sw_en;
	u8 gnt_bt;
	u8 gnt_wl_sw_en;
	u8 gnt_wl;
};

struct btc_wlact_ctrl {
	u8 sw_en;
	u8 sw_val;
};

struct btc_fw_dm {
	u32 freerun: 1;
	u32 wl_ps_ctrl: 2; /* 0: off, 1: force on, 2:forec off */
	u32 wl_mimo_ps: 1;
	u32 leak_ap: 1;
	u32 igno_bt: 1;
	u32 noisy_level: 3;
	u32 set_ant_path: 16;
	u32 rsvd: 7;
};

struct btc_cxr_result {
	struct btc_fw_dm dm;
	struct btc_rf_trx_para rf_trx_para;
	u32 cx_state_map;
	u32 policy_type;
	u32 run_cnt;

	char run_reason[BTC_RSN_MAXLEN];
	char run_action[BTC_ACT_MAXLEN];
};

struct btc_bt_link_hid {
	u8 h;  /* handle_id */
	u8 vendor_id;
	u8 update;
	u8 interval;
	u8 window;
	bool type;
	bool role;
	bool sniff;
};

struct btc_bt_link_a2dp {
	u8 h;  /* handle_id */
	u8 vendor_id;
	u8 update;
	bool type;
	bool role;
	bool sniff;
};

struct btc_bt_link_pan {
	u8 h;  /* handle_id */
	u8 vendor_id;
	u8 update;
	bool type;
	bool role;
	bool sniff;
	bool direct; /* 0:Rx, 1:Tx */
};

struct btc_bt_link_hfp {
	u8 h;  /* handle_id */
	u8 vendor_id;
	u8 update;
	bool type;
	bool role;
	bool sniff;
};

struct btc_bt_link_noprofile {
	u8 h;  /* handle_id */
	u8 vendor_id;
	u8 update;
	bool type;
	bool role;
	bool sniff;
};

struct btc_bt_hfp_desc {
	u32 exist: 1;
	u32 exist_last: 1;
	u32 type: 2; /* refer to btc_bt_hfp_type */
	u32 handle_update: 1;
	u32 devinfo_query: 1;
	u32 rsvd: 26;

	u8 cnt;
	u8 lists[BTC_DEV_LINK_MAX];
	struct btc_bt_link_hfp links[BTC_DEV_LINK_MAX];
};

struct btc_bt_hid_desc {
	u32 exist: 1;
	u32 exist_last: 1;
	u32 slot_info: 2;
	u32 pair_cnt: 2;
	u32 pair_cnt_last: 2;
	u32 type: 8; /* refer to btc_bt_hid_type */
	u32 handle_update: 1;
	u32 devinfo_query: 1;
	u32 query_timer: 4;
	u32 rsvd: 10;

	u8 cnt;
	u8 lists[BTC_DEV_LINK_MAX];
	struct btc_bt_link_hid links[BTC_DEV_LINK_MAX];
};

struct btc_bt_a2dp_desc {
	u32 exist: 1;
	u32 exist_last: 1;
	u32 play_latency: 1;
	u32 type: 3; /* refer to btc_bt_a2dp_type */
	u32 active: 1;
	u32 sink: 1;
	u32 handle_update: 1;
	u32 devinfo_query: 1;
	u32 no_empty_streak_2s: 8;
	u32 no_empty_streak_max: 8;
	u32 rsvd: 6;

	u8 bitpool;
	u16 vendor_id;
	u32 device_name;
	u32 flush_time;

	u8 cnt;
	u8 lists[BTC_DEV_LINK_MAX];
	struct btc_bt_link_a2dp links[BTC_DEV_LINK_MAX];
};

struct btc_bt_pan_desc {
	u32 exist: 1;
	u32 exist_last: 1;
	u32 type: 1; /* refer to btc_bt_pan_type */
	u32 active: 1;
	u32 handle_update: 1;
	u32 devinfo_query: 1;
	u32 rsvd: 26;

	u8 cnt;
	u8 lists[BTC_DEV_LINK_MAX];
	struct btc_bt_link_pan links[BTC_DEV_LINK_MAX];
};

struct btc_bt_noprofile_desc {
	u8 no_profile_cnt;
	u8 no_profile[BTC_DEV_LINK_MAX];
	struct btc_bt_link_noprofile noprofiles[BTC_DEV_LINK_MAX];
};

struct btc_wl_nhm {
	s8 instant_wl_nhm_dbm;
	s8 instant_wl_nhm_per_mhz;
	u16 valid_record_times;
	s8 record_pwr[16];
	u8 record_ratio[16];
	s8 pwr; /* dbm_per_MHz  */
	u8 ratio;
	u8 current_status;
	u8 refresh;
	bool start_flag;
	u8 last_ccx_rpt_stamp;
	s8 pwr_max;
	s8 pwr_min;
};

struct btc_chip_ops {
	void (*set_rfe)(struct btc_t *btc);
	void (*init_cfg)(struct btc_t *btc);
	void (*wl_tx_power)(struct btc_t *btc, u32 level);
	void (*wl_rx_gain)(struct btc_t *btc, u32 level);
	void (*wl_btg_standby)(struct btc_t *btc, u32 state);
	void (*wl_req_mac)(struct btc_t *btc, u8 mac_id);
	void (*get_reg_status)(struct btc_t *btc, u8 type, void *status);
	u8 (*bt_rssi)(struct btc_t *btc, u8 val);
};

struct btc_chip {
	u32 chip_id;
	u32 hw;  /* chip HW feature/parameter */
	u8 btcx_desired; /* bt fw desired coex version */
	u32 wlcx_desired; /* wl fw desired coex version */
	u8 scbd; /* scoreboard version, 0: not support*/
	u8 mailbox; /* mailbox version, 0: not support */
	u8 pta_mode;
	u8 pta_direction;
	u8 afh_guard_ch;
	const u8 *wl_rssi_thres; /* wl rssi thre level */
	const u8 *bt_rssi_thres; /* bt rssi thre level */
	u8 rssi_tol; /* rssi tolerance */
	struct btc_chip_ops *ops;
	u8 mon_reg_num;
	struct fbtc_mreg *mon_reg;
	u8 rf_para_ulink_num;
	struct btc_rf_trx_para *rf_para_ulink;
	u8 rf_para_dlink_num;
	struct btc_rf_trx_para *rf_para_dlink;

};

struct btc_bt_rfk_info {
	u32 run: 1;
	u32 req: 1;
	u32 timeout: 1;
	u32 rsvd: 29;
};

union btc_bt_rfk_info_map {
	u32 val;
	struct btc_bt_rfk_info map;
};

struct btc_bt_ver_info {
	u32 fw_coex; /* match with which coex_ver */
	u32 fw;
};
struct btc_bool_sta_chg { /* status change varible */
	u32 now: 1;
	u32 last: 1;
	u32 remain: 1;
	u32 srvd: 29;
};

struct btc_u8_sta_chg { /* status change varible */
	u8 now;
	u8 last;
	u8 remain;
	u8 rsvd;
};

struct btc_bit_remap {
	u32 index;
	u32 bpos;
};

struct btc_traffic {
	enum rtw_tfc_lvl tx_lvl;
	enum rtw_tfc_sts tx_sts;
	enum rtw_tfc_lvl rx_lvl;
	enum rtw_tfc_sts rx_sts;

	u64 tx_byte;
	u64 rx_byte;
	u32 tx_time;
	u32 rx_time;

	u32 tx_tp;
	u32 rx_tp;
};

struct btc_wl_scan_info {
	u8 band[HW_PHY_MAX];
	u8 phy_map;
	u8 rsvd;
};

struct btc_wl_dbcc_info {
	u8 op_band[HW_PHY_MAX]; /* op band in each phy */
	u8 scan_band[HW_PHY_MAX]; /* scan band in  each phy */
	u8 real_band[HW_PHY_MAX];
	u16 role[HW_PHY_MAX]; /* role in each phy */
};

struct btc_wl_active_role { /* struct size must be n*4 bytes */
	u8 connected;
	u8 pid;
	u8 phy;
	u8 noa;

	u8 band; /* enum band_type RF band: 2.4G/5G/6G */
	u8 client_ps;
	u8 bw; /* enum channel_width */
	u8 role; /*enum role_type */

	u8 ch;
	u8 noa_dur; /* ms */
	u8 rsvd1;
	u8 rsvd2;
};

struct btc_wl_scc_ctrl {
	u8 null_role1;
	u8 null_role2;
	u8 e2g_null; /* if tx null at E2G-slot before entering EBT-slot */
	u8 rsvd;
};

#define FCX_VER_ROLE 7
struct btc_wl_role_info { /* struct size must be n*4 bytes */
	u8 connect_cnt;
	u8 link_mode;
	u8 link_mode_chg;
	u8 p2p_2g;

	struct btc_wl_active_role active_role[BTC_WL_MAX_ROLE_NUMBER];

	u32 role_map;
	u32 mrole_type; /* btc_wl_mrole_type */
	u32 mrole_noa_duration; /* ms */
	u32 dbcc_en;
	u32 dbcc_chg;
	u32 dbcc_2g_phy; /* which phy operate in 2G, HW_PHY_0 or HW_PHY_1 */
};

struct btc_wl_link_info {
	struct rtw_chan_def chdef;

	u8 mode; /* wl mode: 11b, 11g, 11n... */
	u8 ch;
	u8 bw;
	u8 band; /* enum  RF band: 2.4G/5G/6G */
	u8 role; /*enum role_type */
	u8 pid; /* MAC HW Port id: 0~4 */
	u8 phy; /* PHY-0 or PHY-1*/
	u8 dtim_period;
	u8 rssi; /* 0%~110% (dBm = rssi -110) */
	u8 tx_1ss_limit;

	u8 busy;
	u8 rssi_state[BTC_WL_RSSI_THMAX];
	u8 mac_addr[6];
	u8 tx_retry;

	u16 mac_id; /* 0~63 */
	u16 tx_rate;
	u16 rx_rate;

	u32 bcn_period;
	u32 noa_duration; /* us */
	u32 tx_time; /* the original max_tx_time */
	u32 client_cnt; /* connected-client cnt for p2p-GO/soft-AP mode */
	u32 rx_rate_drop_cnt;

	u32 active: 1;
	u32 noa: 1; /* for P2P */
	u32 client_ps: 1; /* For AP mode, if client enter LPS */
	u32 connected: 2;
};

struct btc_wl_rfk_info {
	u32 state: 2;
	u32 path_map: 4;
	u32 phy_map: 2;
	u32 band: 2; /*0:2g, 1:5g, 2:6g  */
	u32 type: 8;
	u32 rsvd: 14;

	u32 start_time;
	u32 proc_time;
};

struct btc_wl_ver_info {
	u32 fw_coex; /* match with which coex_ver */
	u32 fw;
	u32 mac;
	u32 bb;
	u32 rf;
};

struct btc_wl_afh_info {
	u8 en;
	u8 ch;
	u8 bw;
	u8 rsvd;
};

struct btc_rf_cfg {
	u32 addr;
	u32 val;
};

struct btc_ops {
	void (*ntfy_power_on)(struct btc_t *btc);
	void (*ntfy_power_off)(struct btc_t *btc);
	void (*ntfy_init_coex)(struct btc_t *btc, u8 mode);
	void (*ntfy_scan_start)(struct btc_t *btc, u8 band_idx, u8 band);
	void (*ntfy_scan_finish)(struct btc_t *btc, u8 band_idx);
	void (*ntfy_switch_band)(struct btc_t *btc, u8 band_idx, u8 band);
	void (*ntfy_specific_packet)(struct btc_t *btc, u8 pkt_type);
	void (*ntfy_role_info)(struct btc_t *btc, u8 rid,
			      struct btc_wl_link_info *info,
			      enum link_state reason);
	void (*ntfy_radio_state)(struct btc_t *btc, u8 rf_state);
	void (*ntfy_customerize)(struct btc_t *btc, u8 type, u16 len, u8 *buf);
	u8  (*ntfy_wl_rfk)(struct btc_t *btc, u8 phy, u8 type, u8 state);
	void (*ntfy_wl_sta)(struct btc_t *btc, struct rtw_stats *phl_stats,
			   u8 ntfy_num, struct rtw_phl_stainfo_t *sta[],
			   u8 reason);
	void (*ntfy_fwinfo)(struct btc_t *btc, u8 *buf, u32 len, u8 cls,
			   u8 func);
	void (*ntfy_timer)(struct btc_t *btc, u16 tmr_id);
};

struct btc_bt_smap {
	u32 connect: 1;
	u32 ble_connect: 1;
	u32 acl_busy: 1;
	u32 sco_busy: 1;
	u32 mesh_busy: 1;
	u32 inq_pag: 1;
};

union btc_bt_state_map {
	u32 val;
	struct btc_bt_smap map;
};

struct btc_bt_link_info {
	struct btc_u8_sta_chg profile_cnt;
	struct btc_bool_sta_chg multi_link;
	struct btc_bool_sta_chg relink;
	struct btc_bt_hfp_desc hfp_desc;
	struct btc_bt_hid_desc hid_desc;
	struct btc_bt_a2dp_desc a2dp_desc;
	struct btc_bt_pan_desc pan_desc;
	struct btc_bt_noprofile_desc noprofile_desc;
	union btc_bt_state_map status;

	u8 sut_pwr_level[BTC_PROFILE_MAX];
	u8 golden_rx_shift[BTC_PROFILE_MAX];
	u8 rssi_state[BTC_BT_RSSI_THMAX];
	u8 afh_map[12];
	u8 afh_map_le[5];

	u32 role_sw: 1;
	u32 slave_role: 1;
	u32 afh_update: 1;
	u32 cqddr: 1;
	u32 rssi: 8;
	u32 tx_3M: 1;
	u32 rsvd: 19;
};

struct btc_3rdcx_info {
	u8 type;   /* 0: none, 1:zigbee, 2:LTE  */
	u8 hw_coex;
	u16 rsvd;
};

struct btc_rf_para {
	u32 tx_pwr_freerun;
	u32 rx_gain_freerun;
	u32 tx_pwr_perpkt;
	u32 rx_gain_perpkt;
};

struct btc_bt_info {
	struct btc_bt_link_info link_info;
	struct btc_bt_scan_info scan_info[CXSCAN_MAX1];
	struct btc_bt_ver_info ver_info;
	struct btc_bool_sta_chg enable;
	struct btc_bool_sta_chg inq_pag;
	struct btc_rf_para rf_para; /* for record */
	union btc_bt_rfk_info_map rfk_info;

	u8 raw_info[BTC_BTINFO_MAX]; /* raw bt info from mailbox */
	u8 rssi_level;

	u32 scbd; /* scoreboard value */
	u32 feature;

	u32 mbx_avl: 1; /* mailbox available */
	u32 whql_test: 1;
	u32 igno_wl: 1;
	u32 reinit: 1;
	u32 ble_scan_en: 1;
	u32 btg_type: 1; /* BT located at BT only or BTG */
	u32 inq: 1;
	u32 pag: 1;

	u32 run_patch_code: 1;
	u32 hi_lna_rx: 1;
	u32 scan_rx_low_pri: 1;
	u32 lna_constrain: 3;
	u32 scan_info_update: 1;
	u32 fw_ver_mismatch: 1;

	u32 rsvd: 16;
};

struct btc_bt_mb_devinfo {
	u8 cmd;
	u8 len;
	u8 sub_id;
	u8 data[5];
};

struct btc_wl_smap {
	u32 busy: 1;
	u32 scan: 1;
	u32 connecting: 1;
	u32 roaming: 1;
	u32 dbccing: 1;
	u32 _4way: 1;
	u32 rf_off: 1;
	u32 lps: 2;  /* 1: refer to enum btc_lps_state  */
	u32 ips: 1;
	u32 init_ok: 1;
	u32 traffic_dir : 2;
	u32 rf_off_pre: 1;
	u32 lps_pre: 2;
	u32 lps_exiting: 1; /* Exit-LPS to rf_state = BTC_RFCTRL_WL_ON in 6s */
};

union btc_wl_state_map {
	u32 val;
	struct btc_wl_smap map;
};

struct btc_wl_info {
	struct btc_wl_link_info link_info[BTC_WL_MAX_ROLE_NUMBER];
	struct btc_wl_rfk_info  rfk_info;
	struct btc_wl_ver_info  ver_info;
	struct btc_wl_afh_info afh_info;
	struct btc_wl_role_info role_info;
	struct btc_wl_scan_info scan_info;
	struct btc_wl_dbcc_info dbcc_info;
	struct btc_bool_sta_chg cck_lock;
	struct btc_rf_para rf_para; /* for record */
	union btc_wl_state_map status;
	struct btc_wl_nhm nhm;
	struct btc_traffic traffic;

	u8 iot_peer;
	u8 rssi_level;/* the overall-role rssi-level 0~4, "low_rssi->lo_level"*/
	u8 bssid[6];
	u8 pta_req_mac;
	u8 bt_polut_type[2]; /* BT polluted WL-Tx type for phy0/1  */
	u8 cn_report;

	u8 evm_1ss_rpt;
	u8 evm_2ss_max_rpt;
	u8 evm_2ss_min_rpt;

	u8 ch_map[12];
	u8 ch_map_le[5];

	u8 scbd_change: 1;
	u8 pta_reg_mac_chg: 1;
	u8 fw_ver_mismatch: 1;
	u8 is_5g_hi_channel: 1;
	u8 busy_to_idle: 1;
	u8 legacy_mode: 1;
	u8 rsvd: 2;

	u8 coex_mode;

	u32 scbd;
	u32 rx_err_ratio_2s;
	u32 busy_t; /* busy start time */
};

struct btc_ant_info {
	u8 type;  /* shared, dedicated(non-shared) */
	u8 num;   /* antenna count  */
	u8 isolation;
	u8 single_pos;/* wifi 1ss-1ant at 0:S0 or 1:S1 */

	u8 diversity; /* only for wifi use 1-antenna */
	u8 btg_pos; /* btg-circuit at 0:S0/1:S1/others:all */
	u8 stream_cnt;  /* spatial_stream count */
	u8 rsvd;
};

struct btc_module {
	u8 rfe_type;
	u8 kt_ver;
	u8 bt_solo;
	u8 bt_pos; /* wl-end view: get from efuse, must compare bt.btg_type*/

	u8 switch_type; /* WL/BT switch type: 0: internal, 1: external */
	u8 wa_type; /* WA type: 0:none, 1: 51B 5G_Hi-Ch_Rx */
	u8 kt_ver_adie;
	u8 rsvd;

	struct btc_ant_info ant;
};

#define FCX_VER_INIT 7
struct btc_init_info {
	u8 wl_guard_ch;
	u8 wl_only;
	u8 wl_init_ok;
	u8 dbcc_en;

	u8 cx_other;
	u8 bt_only;
	u8 rsvd1;
	u8 rsvd2;

	struct btc_module module;
};

/* record the last 20 reason/action */
struct btc_dm_step {
	char step[BTC_DM_MAXSTEP][BTC_RSN_MAXLEN];
	u32 cnt;
};

struct btc_fddt_bt_stat {
	struct btc_rpt_ctrl_a2dp_empty a2dp_last;
	u32 retry_last;
};

struct btc_fddt_cell {
	s8 wl_pwr_min;
	s8 wl_pwr_max;
	s8 bt_pwr_dec_max;
	s8 bt_rx_gain;
};

struct btc_fddt_fail_check { /* for cell stay in training */
	u8 check_map;         /* check pass condition if bit-map = 1 */
	u8 bt_no_empty_cnt;   /* 0-fail if no bt-empty >= th in train_cycle */
	u8 wl_tp_ratio;       /* 1-fail if wl tp rise ratio < th */
	u8 wl_kpibtr_ratio;   /* 2-fail if phase_now_tp < phase_last_tp * kpibtr_ratio*/
};

struct btc_fddt_break_check { /* for cell stay in training or train-ok */
	u8 check_map;            /* check break condition if bit-map = 1 */
	u8 bt_no_empty_cnt;  /* 0-break if no empty count >= th  */
	u8 wl_tp_ratio;      /* 1-break if wl tp ratio < th (%)*/
	u8 wl_tp_low_bound;  /* 2-break if wl tp (in Mbps) < th */

	u8 cn;               /* 3-break if (cn >= cn_limit) >= th cycle */
	u8 cell_chg;         /* 4-break if non-matched-RSSI >= th cycle */
	s8 nhm_limit;        /* 5-break if nhm >= th --> ill-condition*/
	u8 cn_limit;         /* if condition number >= th --> ill-condition  */
};

struct btc_fddt_time_ctrl {
	/* 1 TDD cycle = w1 + b1, FDD 1cycle = w1fdd-slot + b1fdd-slot */
	u8 m_cycle; /* KPI Moving-Average-Cycle: 1~32 cycles */
	u8 w_cycle; /* Start to calcul WKPI after this if train-phase change */
	u8 k_cycle; /* Total kpi-estimate cycles for each training-step */
	u8 rsvd;
};

#define FCX_VER_FDDT 7
struct btc_fddt_train_info {
	struct btc_fddt_time_ctrl t_ctrl;
	struct btc_fddt_break_check b_chk;
	struct btc_fddt_fail_check f_chk;
	struct btc_fddt_cell cell_ul[5][5];
	struct btc_fddt_cell cell_dl[5][5];
};

struct btc_fddt_info {
	u8 type;         /* refer to enum btc_fddt_type */
	u8 result;       /* fw send fdd-training status by c2h  */
	u8 state;        /* refer to enum btc_fddt_state */

	u8 wl_iot[6];    /* wl bssid  */
	u16 bt_iot;      /* bt vendor-id */

	u32 nrsn_map;    /* the reason map for no-run fdd-traing */
	struct btc_fddt_bt_stat bt_stat;  /* bt statistics */
	struct btc_fddt_train_info train;
	struct btc_fddt_train_info train_now;
};

#define FCX_VER_TRX 7
struct btc_trx_info {
	u8 tx_lvl;
	u8 rx_lvl;
	u8 wl_rssi;
	u8 bt_rssi;

	s8 tx_power; /* absolute Tx power (dBm), 0xff-> no BTC control */
	s8 rx_gain;  /* rx gain table index (TBD.) */
	s8 bt_tx_power; /* decrease Tx power (dB) */
	s8 bt_rx_gain;  /* LNA constrain level */

	u8 cn; /* condition_num */
	s8 nhm;
	u8 bt_profile;
	u8 rsvd2;

	u16 tx_rate;
	u16 rx_rate;

	u32 tx_tp;
	u32 rx_tp;
	u32 rx_err_ratio;
};

/* dynamic coex mechanism  */
struct btc_dm {
	struct fbtc_slot slot[CXST_MAX];
	struct fbtc_slot slot_now[CXST_MAX];
	struct fbtc_tdma tdma;
	struct fbtc_tdma tdma_now;
	struct btc_gnt_ctrl gnt_set[HW_PHY_MAX];
	struct btc_gnt_ctrl gnt_val[HW_PHY_MAX];
	struct btc_wlact_ctrl wlact_set[2]; /* BT 0/1 wlan_act setup */
	struct btc_init_info init_info; /* pass to wl_fw if offload */
	struct btc_rf_trx_para rf_trx_para;
	struct btc_wl_tx_limit_para wl_tx_limit;
	struct btc_wl_scc_ctrl wl_scc;
	struct btc_dm_step dm_step;

	struct btc_fddt_info fddt_info;
	struct btc_trx_info trx_info;

	u32 error; /* halbtc dm error map, refer to "enum btc_dm_error" */

	char run_reason[BTC_RSN_MAXLEN];
	char run_action[BTC_ACT_MAXLEN];

	u16 slot_dur[CXST_MAX]; /* for user-define slot duration */
	u16 bt_slot_flood; /* time threshold for BTC_DCNT_BT_SLOT_FLOOD check */

	u32 set_ant_path;
	u32 cnt_dm[BTC_DCNT_MAX];
	u32 cnt_notify[BTC_NCNT_MAX];

	u32 wl_only: 1; /* drv->Fw if offload  */
	u32 wl_fw_cx_offload: 1; /* BTC_CX_FW_OFFLOAD from FW code  */
	u32 freerun: 1;
	u32 fddt_train: 1;
	u32 wl_ps_ctrl: 2; /* 0: off, 1: force on, 2:forec off */
	u32 leak_ap: 1;
	u32 noisy_level: 3;
	u32 coex_info_map: 8;
	u32 bt_only: 1; /* drv->Fw if offload  */
	u32 wl_btg_rx: 2;  /* if wl rx shared with bt */
	u32 trx_para_level: 8;
	u32 wl_stb_chg: 1; /* if change s1 WL standby mode table = Rx  */
	u32 pta_owner: 1; /* 0x73[2] BTC_CTRL_BY_WL, BTC_CTRL_BT*/
	u32 tdma_instant_excute: 1;

	u32 client_ps_tog1: 8; /* client active/LPS toggle-cnt in ntfy_role */
	u32 client_ps_tog1_last: 8; /* last client_ps_tog1 in ntfy_role */
	u32 client_ps_cnt: 8; /* client active/LPS accumulate-cnt in ntfy_sta*/
	u32 client_ps_tdma_on: 1;
	u32 rx_err_rpt_en: 1;
	u32 wl_btg_rx_rb: 2;  /* 0x10980 reg state from reg-moniter read-back */
	u32 rsvd2: 4;

	u8 wl_pre_agc: 2;
	u8 wl_lna2: 1;
	u8 freerun_chk: 1;
	u8 fddt_train_chk: 1;
	u8 slot_req_more: 1;
	u8 wl_pre_agc_rb: 2;

	u8 bt_select: 2; /* 0:s0, 1:s1, 2:s0 & s1, refer to enum btc_bt_index */
	u8 btc_initing: 1;
	u8 rsvd3: 5;

	u32 e2g_slot_limit;
	u32 e2g_slot_nulltx_time;
};

/* the wl/bt/zb cx instance */
struct btc_cx {
	struct btc_wl_info wl;
	struct btc_bt_info bt;
	struct btc_3rdcx_info other;
	struct btc_rf_trx_para rf_para;
	u32 state_map; /* wl/bt combined state map  */
	u32 cnt_bt[BTC_BCNT_MAX];
	u32 cnt_wl[BTC_WCNT_MAX];
};


#define FCX_VER_CTRL 7
struct btc_ctrl {
	u8 manual;
	u8 igno_bt;
	u8 always_freerun;
	u8 rsvd;
};

struct btc_dbg {
	/* cmd "rb" */
	bool rb_done;
	u32 rb_val;
	u8 lb_val[8];  /* for H2C-C2H/mailbox-loopback test*/
};

struct btc_tmr {
	void *btc;
	u16 id;
	_os_timer tmr;
};

struct btc_t {
	struct rtw_phl_com_t *phl;
	struct rtw_hal_com_t *hal;

	struct btc_ops *ops;
	const struct btc_chip *chip;

	struct btc_cx cx;
	struct btc_dm dm;
	struct btc_ctrl ctrl;
	struct btc_module mdinfo;
	struct btf_fwinfo fwinfo;
	struct btc_dbg dbg;
	struct btc_bt_psd_dm bt_psd_dm;

	/* btc timers */
	bool tmr_init;
	bool tmr_stop;
	struct btc_tmr timer[BTC_TIMER_MAX];
	/* a delayed timer to start periodic timer (wait phl started) */
	_os_timer delay_tmr;

	char mbuf[BTC_MSG_MAXLEN]; /* msg buffer */
	size_t mlen; /* max msg len */

	u8 policy[BTC_POLICY_MAXLEN]; /* coex policy buffer */
	u16 policy_len;
	u16 policy_type;

	u8 hubmsg[BTC_HUBMSG_MAXLEN]; /* phl hub msg */
	u16 hubmsg_len;
	u32 hubmsg_cnt;
	u32 bt_req_len[HW_PHY_MAX]; /* request bt-slot in WL SCC/MCC +BT coex */
	u8 bt_req_stbc; /*STBC flag*/
	bool bt_req_en;
};

static void _ntfy_power_on(struct btc_t *btc);
static void _ntfy_power_off(struct btc_t *btc);
static void _ntfy_init_coex(struct btc_t *btc, u8 mode);
static void _ntfy_scan_start(struct btc_t *btc, u8 phy_idx, u8 band);
static void _ntfy_scan_finish(struct btc_t *btc, u8 pyh_idx);
static void _ntfy_switch_band(struct btc_t *btc, u8 phy_idx, u8 band);
static void _ntfy_specific_packet(struct btc_t *btc, u8 pkt_type);
static void _ntfy_role_info(struct btc_t *btc, u8 rid,
			    struct btc_wl_link_info *info,
			    enum link_state reason);
static void _ntfy_radio_state(struct btc_t *btc, u8 rf_state);
static void _ntfy_customerize(struct btc_t *btc, u8 type, u16 len, u8 *buf);
static u8 _ntfy_wl_rfk(struct btc_t *btc, u8 phy_path, u8 type, u8 state);
static void _ntfy_wl_sta(struct btc_t *btc, struct rtw_stats *phl_stats,
			u8 ntfy_num, struct rtw_phl_stainfo_t *sta[],
			u8 reason);
static void _ntfy_fwinfo(struct btc_t *btc, u8 *buf, u32 len, u8 cls, u8 func);
static void _ntfy_timer(struct btc_t *btc, u16 tmr_id);

#ifdef BTC_8852A_SUPPORT
extern const struct btc_chip chip_8852a;
#endif
#ifdef BTC_8852B_SUPPORT
extern const struct btc_chip chip_8852b;
extern const struct btc_chip chip_8852bp;
extern const struct btc_chip chip_8851b;
extern const struct btc_chip chip_8852bt;
#endif
#ifdef BTC_8852C_SUPPORT
extern const struct btc_chip chip_8852c;
#endif
#ifdef BTC_8852D_SUPPORT
extern const struct btc_chip chip_8852d;
#endif
extern const u32 coex_ver;

u8 _send_fw_cmd(struct btc_t *btc, u8 h2c_func, u8 *param, u16 len);
void _update_bt_scbd(struct btc_t *btc, bool only_update);
bool hal_btc_init(struct btc_t *btc);
void hal_btc_deinit(struct btc_t *btc);
void _write_bt_reg(struct btc_t *btc, u8 reg_type, u16 addr, u32 val);
void _read_bt_reg(struct btc_t *btc, u8 reg_type, u16 addr);
u32 _read_scbd(struct btc_t *btc);
void _write_scbd(struct btc_t *btc, u32 val, bool state);
void _run_coex(struct btc_t *btc, const char *reason);
void _set_init_info(struct btc_t *btc);
void _update_dm_step(struct btc_t *btc, const char *strin);
void hal_btc_send_event(struct btc_t *btc, enum phl_band_idx hw_band, u8 *buf,
			u32 len, u16 ev_id);
u8 _get_wl_role_idx(struct btc_t *btc, u8 role);
void _update_btc_state_map(struct btc_t *btc);
void _set_fddt_cell_by_antiso(struct btc_t *btc);

bool hal_btc_check_io_ofld(struct btc_t *btc);
void _btc_io_w (struct btc_t *btc, u32 type, u32 addr, u32 mask,
		u32 value, bool trigger);

#endif /*_HAL_BTC_H_*/
