#ifndef __PLAT_REG_AX_H__
#define __PLAT_REG_AX_H__

//
// WL_AX_Reg_AXIDMA.xls
//

//
// AXIDMA_Reg_Spec
//

#define R_PL_AXIDMA_INIT_CFG1 0x0000
#define B_PL_AXIDMA_MASTER_STOP BIT(20)
#define B_PL_AXIDMA_RESET_KEEP_REG BIT(19)
#define B_PL_AXIDMA_RX_EN BIT(13)
#define B_PL_AXIDMA_TX_EN BIT(11)

#define R_PL_AXIDMA_DMA_STOP 0x0004
#define B_PL_AXIDMA_WPDMA_STOP BIT(12)
#define B_PL_AXIDMA_CH3_TX_STOP BIT(11)
#define B_PL_AXIDMA_CH2_TX_STOP BIT(10)
#define B_PL_AXIDMA_CH1_TX_STOP BIT(9)
#define B_PL_AXIDMA_CH0_TX_STOP BIT(8)

#define R_PL_AXIDMA_INIT_CFG2 0x0008
#define B_PL_AXIDMA_WD_ITVL_ACT_SH 24
#define B_PL_AXIDMA_WD_ITVL_ACT_MSK 0x7
#define B_PL_AXIDMA_WD_ITVL_IDLE_SH 16
#define B_PL_AXIDMA_WD_ITVL_IDLE_MSK 0x7

#define R_PL_AXIDMA_INFO 0x0100
#define B_PL_AXIDMA_MASTER_IDLE BIT(16)
#define B_PL_AXIDMA_RX_IDLE BIT(1)
#define B_PL_AXIDMA_TX_IDLE BIT(0)

#define R_PL_AXIDMA_BUSY 0x0104
#define B_PL_AXIDMA_WPDMA_BUSY BIT(12)
#define B_PL_AXIDMA_CH3_TX_BUSY BIT(11)
#define B_PL_AXIDMA_CH2_TX_BUSY BIT(10)
#define B_PL_AXIDMA_CH1_TX_BUSY BIT(9)
#define B_PL_AXIDMA_CH0_TX_BUSY BIT(8)
#define B_PL_AXIDMA_CH5_RX_BUSY BIT(5)
#define B_PL_AXIDMA_CH4_RX_BUSY BIT(4)
#define B_PL_AXIDMA_CH3_RX_BUSY BIT(3)
#define B_PL_AXIDMA_CH2_RX_BUSY BIT(2)
#define B_PL_AXIDMA_CH1_RX_BUSY BIT(1)
#define B_PL_AXIDMA_CH0_RX_BUSY BIT(0)

#define R_PL_AXIDMA_INT_MIT_TX 0x0200
#define B_PL_AXIDMA_TXMIT_CH3_SEL BIT(22)
#define B_PL_AXIDMA_TXMIT_CH2_SEL BIT(21)
#define B_PL_AXIDMA_TXMIT_CH1_SEL BIT(20)
#define B_PL_AXIDMA_TXMIT_CH0_SEL BIT(19)
#define B_PL_AXIDMA_TXTIMER_UNIT_SH 16
#define B_PL_AXIDMA_TXTIMER_UNIT_MSK 0x3
#define B_PL_AXIDMA_TXCOUNTER_MATCH_SH 8
#define B_PL_AXIDMA_TXCOUNTER_MATCH_MSK 0xff
#define B_PL_AXIDMA_TXTIMER_MATCH_SH 0
#define B_PL_AXIDMA_TXTIMER_MATCH_MSK 0xff

#define R_PL_AXIDMA_INT_MIT_RX 0x0204
#define B_PL_AXIDMA_RXMIT_CH5_SEL BIT(24)
#define B_PL_AXIDMA_RXMIT_CH4_SEL BIT(23)
#define B_PL_AXIDMA_RXMIT_CH3_SEL BIT(22)
#define B_PL_AXIDMA_RXMIT_CH2_SEL BIT(21)
#define B_PL_AXIDMA_RXMIT_CH1_SEL BIT(20)
#define B_PL_AXIDMA_RXMIT_CH0_SEL BIT(19)
#define B_PL_AXIDMA_RXTIMER_UNIT_SH 16
#define B_PL_AXIDMA_RXTIMER_UNIT_MSK 0x3
#define B_PL_AXIDMA_RXCOUNTER_MATCH_SH 8
#define B_PL_AXIDMA_RXCOUNTER_MATCH_MSK 0xff
#define B_PL_AXIDMA_RXTIMER_MATCH_SH 0
#define B_PL_AXIDMA_RXTIMER_MATCH_MSK 0xff

#define R_PL_AXIDMA_CH0_RXBD_NUM 0x0300
#define B_PL_AXIDMA_CH0_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH0_RXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH1_RXBD_NUM 0x0302
#define B_PL_AXIDMA_CH1_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH1_RXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH2_RXBD_NUM 0x0304
#define B_PL_AXIDMA_CH2_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH2_RXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH3_RXBD_NUM 0x0306
#define B_PL_AXIDMA_CH3_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH3_RXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH4_RXBD_NUM 0x0308
#define B_PL_AXIDMA_CH4_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH4_RXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH5_RXBD_NUM 0x030A
#define B_PL_AXIDMA_CH5_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH5_RXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH0_TXBD_NUM 0x0320
#define B_PL_AXIDMA_CH0_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH0_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH0_TXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH1_TXBD_NUM 0x0322
#define B_PL_AXIDMA_CH1_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH1_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH1_TXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH2_TXBD_NUM 0x0324
#define B_PL_AXIDMA_CH2_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH2_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH2_TXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH3_TXBD_NUM 0x0326
#define B_PL_AXIDMA_CH3_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH3_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH3_TXBD_NUM_MSK 0x3ff

#define R_PL_AXIDMA_CH0_RXBD_IDX 0x0400
#define B_PL_AXIDMA_CH0_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH0_RX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH0_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH0_RX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH1_RXBD_IDX 0x0404
#define B_PL_AXIDMA_CH1_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH1_RX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH1_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH1_RX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH2_RXBD_IDX 0x0408
#define B_PL_AXIDMA_CH2_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH2_RX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH2_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH2_RX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH3_RXBD_IDX 0x040C
#define B_PL_AXIDMA_CH3_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH3_RX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH3_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH3_RX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH4_RXBD_IDX 0x0410
#define B_PL_AXIDMA_CH4_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH4_RX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH4_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH4_RX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH5_RXBD_IDX 0x0414
#define B_PL_AXIDMA_CH5_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH5_RX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH5_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH5_RX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH0_TXBD_IDX 0x0420
#define B_PL_AXIDMA_CH0_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH0_TX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH0_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH0_TX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH1_TXBD_IDX 0x0424
#define B_PL_AXIDMA_CH1_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH1_TX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH1_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH1_TX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH2_TXBD_IDX 0x0428
#define B_PL_AXIDMA_CH2_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH2_TX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH2_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH2_TX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_CH3_TXBD_IDX 0x042C
#define B_PL_AXIDMA_CH3_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH3_TX_HW_IDX_MSK 0x3ff
#define B_PL_AXIDMA_CH3_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH3_TX_HOST_IDX_MSK 0x3ff

#define R_PL_AXIDMA_TXBD_RWPTR_CLR 0x0430
#define B_PL_AXIDMA_CLR_CH3_TX_IDX BIT(3)
#define B_PL_AXIDMA_CLR_CH2_TX_IDX BIT(2)
#define B_PL_AXIDMA_CLR_CH1_TX_IDX BIT(1)
#define B_PL_AXIDMA_CLR_CH0_TX_IDX BIT(0)

#define R_PL_AXIDMA_RXBD_RWPTR_CLR 0x0434
#define B_PL_AXIDMA_CLR_CH5_RX_IDX BIT(5)
#define B_PL_AXIDMA_CLR_CH4_RX_IDX BIT(4)
#define B_PL_AXIDMA_CLR_CH3_RX_IDX BIT(3)
#define B_PL_AXIDMA_CLR_CH2_RX_IDX BIT(2)
#define B_PL_AXIDMA_CLR_CH1_RX_IDX BIT(1)
#define B_PL_AXIDMA_CLR_CH0_RX_IDX BIT(0)

#define R_PL_AXIDMA_DBG_CTRL 0x0500
#define B_PL_AXIDMA_DBG_SEL_SH 16
#define B_PL_AXIDMA_DBG_SEL_MSK 0x1ff
#define B_PL_AXIDMA_SEC_ACCESS BIT(2)
#define B_PL_AXIDMA_EN_STUCK_DBG BIT(0)

#define R_PL_AXIDMA_DBG_ERR_FLAG 0x0504
#define B_PL_AXIDMA_CH1_RX_FULL BIT(29)
#define B_PL_AXIDMA_CH0_RX_FULL BIT(28)
#define B_PL_AXIDMA_RX_STUCK BIT(22)
#define B_PL_AXIDMA_TX_STUCK BIT(21)
#define B_PL_AXIDMA_DBG_TXERR BIT(16)
#define B_PL_AXIDMA_CH5_RX_FULL BIT(5)
#define B_PL_AXIDMA_CH4_RX_FULL BIT(4)
#define B_PL_AXIDMA_CH3_RX_FULL BIT(3)
#define B_PL_AXIDMA_CH2_RX_FULL BIT(2)
#define B_PL_AXIDMA_TXBD_LEN0 BIT(1)
#define B_PL_AXIDMA_TXBD_4KBOUD_LENERR BIT(0)

#define R_PL_AXIDMA_CH0_RXBD_DESA_L 0x0600
#define B_PL_AXIDMA_CH0_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH0_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH1_RXBD_DESA_L 0x0608
#define B_PL_AXIDMA_CH1_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH1_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH2_RXBD_DESA_L 0x0610
#define B_PL_AXIDMA_CH2_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH2_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH3_RXBD_DESA_L 0x0618
#define B_PL_AXIDMA_CH3_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH3_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH4_RXBD_DESA_L 0x0620
#define B_PL_AXIDMA_CH4_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH4_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH5_RXBD_DESA_L 0x0628
#define B_PL_AXIDMA_CH5_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH5_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH0_TXBD_DESA_L 0x0640
#define B_PL_AXIDMA_CH0_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH0_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH1_TXBD_DESA_L 0x0648
#define B_PL_AXIDMA_CH1_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH1_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH2_TXBD_DESA_L 0x0650
#define B_PL_AXIDMA_CH2_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH2_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH3_TXBD_DESA_L 0x0658
#define B_PL_AXIDMA_CH3_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH3_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_FC_CTRL1 0x0700
#define B_PL_AXIDMA_FC_MODE BIT(2)
#define B_PL_AXIDMA_SET1_FC_EN BIT(1)
#define B_PL_AXIDMA_SET0_FC_EN BIT(0)

#define R_PL_AXIDMA_FC_CTRL2 0x0704
#define B_PL_AXIDMA_SET1_PREC_PAGE_SH 16
#define B_PL_AXIDMA_SET1_PREC_PAGE_MSK 0x1ff
#define B_PL_AXIDMA_SET0_PREC_PAGE_SH 0
#define B_PL_AXIDMA_SET0_PREC_PAGE_MSK 0x1ff

#define R_PL_AXIDMA_CH1_PAGE_CTRL 0x0710
#define B_PL_AXIDMA_CH1_GRP BIT(31)
#define B_PL_AXIDMA_CH1_MAX_PG_SH 16
#define B_PL_AXIDMA_CH1_MAX_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH1_MIN_PG_SH 0
#define B_PL_AXIDMA_CH1_MIN_PG_MSK 0x1fff

#define R_PL_AXIDMA_CH3_PAGE_CTRL 0x0714
#define B_PL_AXIDMA_CH3_GRP BIT(31)
#define B_PL_AXIDMA_CH3_MAX_PG_SH 16
#define B_PL_AXIDMA_CH3_MAX_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH3_MIN_PG_SH 0
#define B_PL_AXIDMA_CH3_MIN_PG_MSK 0x1fff

#define R_PL_AXIDMA_CH1_PAGE_INFO 0x0720
#define B_PL_AXIDMA_CH1_AVAIL_PG_SH 16
#define B_PL_AXIDMA_CH1_AVAIL_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH1_USE_PG_SH 0
#define B_PL_AXIDMA_CH1_USE_PG_MSK 0x1fff

#define R_PL_AXIDMA_CH3_PAGE_INFO 0x0724
#define B_PL_AXIDMA_CH3_AVAIL_PG_SH 16
#define B_PL_AXIDMA_CH3_AVAIL_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH3_USE_PG_SH 0
#define B_PL_AXIDMA_CH3_USE_PG_MSK 0x1fff

#define R_PL_AXIDMA_SET0_PUB_PAGE_INFO 0x0730
#define B_PL_AXIDMA_SET0_AVAL_PUBPG_SH 0
#define B_PL_AXIDMA_SET0_AVAL_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_CTRL1 0x0740
#define B_PL_AXIDMA_SET1_G1_MAX_PUBPG_SH 16
#define B_PL_AXIDMA_SET1_G1_MAX_PUBPG_MSK 0x1fff
#define B_PL_AXIDMA_SET1_G0_MAX_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_G0_MAX_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_CTRL2 0x0744
#define B_PL_AXIDMA_SET1_ALL_MAX_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_ALL_MAX_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_INFO1 0x0748
#define B_PL_AXIDMA_SET1_G1_USE_PUBPG_SH 16
#define B_PL_AXIDMA_SET1_G1_USE_PUBPG_MSK 0x1fff
#define B_PL_AXIDMA_SET1_G0_USE_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_G0_USE_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_INFO2 0x074C
#define B_PL_AXIDMA_SET1_AVAL_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_AVAL_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_INFO3 0x0750
#define B_PL_AXIDMA_SET1_G1_AVAL_PUBPG_SH 16
#define B_PL_AXIDMA_SET1_G1_AVAL_PUBPG_MSK 0x1fff
#define B_PL_AXIDMA_SET1_G0_AVAL_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_G0_AVAL_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_WP_PAGE_CTRL1 0x0760
#define B_PL_AXIDMA_PREC_PAGE_WP_SH 16
#define B_PL_AXIDMA_PREC_PAGE_WP_MSK 0x1ff

#define R_PL_AXIDMA_WP_PAGE_CTRL2 0x0764
#define B_PL_AXIDMA_WP_THRD_SH 0
#define B_PL_AXIDMA_WP_THRD_MSK 0x1fff

#define R_PL_AXIDMA_WP_PAGE_INFO 0x0768
#define B_PL_AXIDMA_WP_AVAL_PG_SH 16
#define B_PL_AXIDMA_WP_AVAL_PG_MSK 0x1fff

#define R_PL_AXIDMA_FC_ERR_FLAG 0x0770
#define B_PL_AXIDMA_SET1_PUB_USE_PG_OFW BIT(24)
#define B_PL_AXIDMA_SET1_PUB_USE_PG_UFW BIT(23)
#define B_PL_AXIDMA_SET1_USE_PG_OFW BIT(22)
#define B_PL_AXIDMA_SET1_USE_PG_UFW BIT(21)
#define B_PL_AXIDMA_SET1_AVAL_PG_OFW BIT(20)
#define B_PL_AXIDMA_SET1_AVAL_PG_UFW BIT(19)
#define B_PL_AXIDMA_SET1_WP_REQ_PG_ERR BIT(18)

#define R_PL_AXIDMA_FWIMR0 0x0900
#define B_PL_AXIDMA_CH5_RX_RDU_MSK BIT(21)
#define B_PL_AXIDMA_CH4_RX_RDU_MSK BIT(20)
#define B_PL_AXIDMA_CH3_RX_RDU_MSK BIT(19)
#define B_PL_AXIDMA_CH2_RX_RDU_MSK BIT(18)
#define B_PL_AXIDMA_CH1_RX_RDU_MSK BIT(17)
#define B_PL_AXIDMA_CH0_RX_RDU_MSK BIT(16)
#define B_PL_AXIDMA_CH5_RX_DERR_MSK BIT(13)
#define B_PL_AXIDMA_CH4_RX_DERR_MSK BIT(12)
#define B_PL_AXIDMA_CH3_RX_DERR_MSK BIT(11)
#define B_PL_AXIDMA_CH2_RX_DERR_MSK BIT(10)
#define B_PL_AXIDMA_CH1_RX_DERR_MSK BIT(9)
#define B_PL_AXIDMA_CH0_RX_DERR_MSK BIT(8)
#define B_PL_AXIDMA_CH5_RX_DOK_MSK BIT(5)
#define B_PL_AXIDMA_CH4_RX_DOK_MSK BIT(4)
#define B_PL_AXIDMA_CH3_RX_DOK_MSK BIT(3)
#define B_PL_AXIDMA_CH2_RX_DOK_MSK BIT(2)
#define B_PL_AXIDMA_CH1_RX_DOK_MSK BIT(1)
#define B_PL_AXIDMA_CH0_RX_DOK_MSK BIT(0)

#define R_PL_AXIDMA_FWIMR1 0x0904
#define B_PL_AXIDMA_CH3_TX_DOK_MSK BIT(3)
#define B_PL_AXIDMA_CH2_TX_DOK_MSK BIT(2)
#define B_PL_AXIDMA_CH1_TX_DOK_MSK BIT(1)
#define B_PL_AXIDMA_CH0_TX_DOK_MSK BIT(0)

#define R_PL_AXIDMA_FWISR0 0x0908
#define B_PL_AXIDMA_CH5_RX_RDU BIT(21)
#define B_PL_AXIDMA_CH4_RX_RDU BIT(20)
#define B_PL_AXIDMA_CH3_RX_RDU BIT(19)
#define B_PL_AXIDMA_CH2_RX_RDU BIT(18)
#define B_PL_AXIDMA_CH1_RX_RDU BIT(17)
#define B_PL_AXIDMA_CH0_RX_RDU BIT(16)
#define B_PL_AXIDMA_CH5_RX_DERR BIT(13)
#define B_PL_AXIDMA_CH4_RX_DERR BIT(12)
#define B_PL_AXIDMA_CH3_RX_DERR BIT(11)
#define B_PL_AXIDMA_CH2_RX_DERR BIT(10)
#define B_PL_AXIDMA_CH1_RX_DERR BIT(9)
#define B_PL_AXIDMA_CH0_RX_DERR BIT(8)
#define B_PL_AXIDMA_CH5_RX_DOK BIT(5)
#define B_PL_AXIDMA_CH4_RX_DOK BIT(4)
#define B_PL_AXIDMA_CH3_RX_DOK BIT(3)
#define B_PL_AXIDMA_CH2_RX_DOK BIT(2)
#define B_PL_AXIDMA_CH1_RX_DOK BIT(1)
#define B_PL_AXIDMA_CH0_RX_DOK BIT(0)

#define R_PL_AXIDMA_FWISR1 0x090C
#define B_PL_AXIDMA_CH3_TX_DOK BIT(3)
#define B_PL_AXIDMA_CH2_TX_DOK BIT(2)
#define B_PL_AXIDMA_CH1_TX_DOK BIT(1)
#define B_PL_AXIDMA_CH0_TX_DOK BIT(0)

#define R_PL_AXIDMA_BURST_CFG 0x0A00
#define B_PL_AXIDMA_RX_BURST_LEN_SH 16
#define B_PL_AXIDMA_RX_BURST_LEN_MSK 0x3
#define B_PL_AXIDMA_MAX_TX_BURST_SH 0
#define B_PL_AXIDMA_MAX_TX_BURST_MSK 0x3

//
// WL_AX_Reg_AXIDMA.xls
//

//
// AXIDMA_Reg_Spec
//

//
// WL_AX_Reg_AXIDMA.xls
//

//
// AXIDMA_Reg_Spec
//
#define B_AX_EN_HW_IDX_UPD BIT(5)
#define B_AX_FLUSH_AXI_MST BIT(4)
#define B_PL_AXIDMA_MASTER_BUSY BIT(16)
#define B_PL_AXIDMA_DBG_CH2_RX_FULL BIT(6)
#define B_PL_AXIDMA_DBG_CH1_RX_FULL BIT(5)
#define B_PL_AXIDMA_DBG_CH0_RX_FULL BIT(4)
#define B_PL_AXIDMA_DBG_TXBD_ZERO_LENGTH BIT(3)
#define B_PL_AXIDMA_DBG_TXBD_CROSS_BOUNDARY BIT(2)
#define B_PL_AXIDMA_DBG_RX_STUCK BIT(1)
#define B_PL_AXIDMA_DBG_TX_STUCK BIT(0)
#define B_PL_AXIDMA_SET1_PUB_USE_PG_OVFUDF BIT(3)
#define B_PL_AXIDMA_SET1_USE_PG_OVFUDF BIT(2)
#define B_PL_AXIDMA_SET1_AVAL_PG_OVFUDF BIT(1)
#define B_PL_AXIDMA_SET1_WP_REQ_PG_ERR_V1 BIT(0)
#define B_PL_AXIDMA_CH2_RX_RDU_MSK_V1 BIT(5)
#define B_PL_AXIDMA_CH1_RX_RDU_MSK_V1 BIT(4)
#define B_PL_AXIDMA_CH0_RX_RDU_MSK_V1 BIT(3)
#define B_PL_AXIDMA_CH2_RX_DOK_MSK_V1 BIT(2)
#define B_PL_AXIDMA_CH1_RX_DOK_MSK_V1 BIT(1)
#define B_PL_AXIDMA_CH0_RX_DOK_MSK_V1 BIT(0)
#define B_PL_AXIDMA_CH2_RX_RDU_V1 BIT(5)
#define B_PL_AXIDMA_CH1_RX_RDU_V1 BIT(4)
#define B_PL_AXIDMA_CH0_RX_RDU_V1 BIT(3)

#define R_PL_AXIDMA_IDCT_MSK 0x0910
#define B_PL_AXIDMA_RRESP_ERR_MSK BIT(6)
#define B_PL_AXIDMA_BRESP_ERR_MSK BIT(5)
#define B_PL_AXIDMA_FCS_ERR_MSK BIT(4)
#define B_PL_AXIDMA_TXBD_ZERO_LENGTH_MSK BIT(3)
#define B_PL_AXIDMA_TXBD_CROSS_BOUNDARY_MSK BIT(2)
#define B_PL_AXIDMA_RX_STUCK_MSK BIT(1)
#define B_PL_AXIDMA_TX_STUCK_MSK BIT(0)

#define R_PL_AXIDMA_IDCT 0x0914
#define B_PL_AXIDMA_IDCT_AXI_RRESP_ERR BIT(6)
#define B_PL_AXIDMA_IDCT_AXI_BRESP_ERR BIT(5)
#define B_PL_AXIDMA_IDCT_FC_ERR BIT(4)
#define B_PL_AXIDMA_IDCT_TXBD_ZERO_LENGTH_ BIT(3)
#define B_PL_AXIDMA_IDCT_TXBD_CROSS_BOUNDARY_MSK BIT(2)
#define B_PL_AXIDMA_IDCT_RX_STUCK_MSK BIT(1)
#define B_PL_AXIDMA_IDCT_TX_STUCK_MSK BIT(0)

//
// WL_AX_Reg_AXIDMA.xls
//

//
// AXIDMA_Reg_Spec
//

//
// WL_AX_Reg_HIOE.xls
//

//
// HIOE_Reg_Spec
//

#define R_PL_HIOE_CTRL 0x0000
#define B_PL_HIOE_RESTORE_REQ BIT(31)
#define B_PL_HIOE_RETAIN_REQ BIT(30)
#define B_PL_HIOE_DDMA_CH1_REQ BIT(29)
#define B_PL_HIOE_DDMA_CH2_REQ BIT(28)
#define B_PL_HIOE_DDMA_CH1_CHKSUM_STATUS BIT(27)
#define B_PL_HIOE_DDMA_CH2_CHKSUM_STATUS BIT(26)
#define B_PL_HIOE_INST_FORMAT_ERR BIT(25)
#define B_PL_HIOE_OP_TIMEOUT_ERR BIT(24)
#define B_PL_HIOE_OP_TIMEOUT_SH 16
#define B_PL_HIOE_OP_TIMEOUT_MSK 0xff
#define B_PL_HIOE_ADDR_CHECKSUM_SH 0
#define B_PL_HIOE_ADDR_CHECKSUM_MSK 0xffff

#define R_PL_HIOE_CFG_FILE_START 0x0004
#define B_PL_HIOE_CFG_FILE_START_SH 0
#define B_PL_HIOE_CFG_FILE_START_MSK 0xffffffffL

#define R_PL_HIOE_CFG_FILE_END 0x0008
#define B_PL_HIOE_CFG_FILE_END_SH 0
#define B_PL_HIOE_CFG_FILE_END_MSK 0xffffffffL

#define R_PL_HIOE_CUR_INST_ADDR 0x000C
#define B_PL_HIOE_CUR_INST_ADDR_SH 0
#define B_PL_HIOE_CUR_INST_ADDR_MSK 0xffffffffL

//
// WL_AX_Reg_HIOE.xls
//

//
// HIOE_Reg_Spec
//

//
// WL_AX_Reg_HIOE.xls
//

//
// HIOE_Reg_Spec
//

//
// WL_AX_Reg_HIOE.xls
//

//
// HIOE_Reg_Spec
//

//
// WL_AX_Reg_IDDMA.xls
//

//
// IDDMA_Reg_Spec
//

#define R_PL_IDDMA_CH0_SA 0x0000
#define B_PL_IDDMA_CH0_SA_SH 0
#define B_PL_IDDMA_CH0_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH0_DA 0x0004
#define B_PL_IDDMA_CH0_DA_SH 0
#define B_PL_IDDMA_CH0_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH0_CTRL 0x0008
#define B_PL_IDDMA_CH0_OWN BIT(31)
#define B_PL_IDDMA_CH0_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH0_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH0_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH0_CHKSUM_CONT BIT(24)
#define B_PL_IDDMA_CH0_DLEN_SH 0
#define B_PL_IDDMA_CH0_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH1_SA 0x0010
#define B_PL_IDDMA_CH1_SA_SH 0
#define B_PL_IDDMA_CH1_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH1_DA 0x0014
#define B_PL_IDDMA_CH1_DA_SH 0
#define B_PL_IDDMA_CH1_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH1_CTRL 0x0018
#define B_PL_IDDMA_CH1_OWN BIT(31)
#define B_PL_IDDMA_CH1_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH1_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH1_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH1_DLEN_SH 0
#define B_PL_IDDMA_CH1_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH2_SA 0x0020
#define B_PL_IDDMA_CH2_SA_SH 0
#define B_PL_IDDMA_CH2_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH2_DA 0x0024
#define B_PL_IDDMA_CH2_DA_SH 0
#define B_PL_IDDMA_CH2_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH2_CTRL 0x0028
#define B_PL_IDDMA_CH2_OWN BIT(31)
#define B_PL_IDDMA_CH2_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH2_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH2_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH2_DLEN_SH 0
#define B_PL_IDDMA_CH2_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH3_SA 0x0030
#define B_PL_IDDMA_CH3_SA_SH 0
#define B_PL_IDDMA_CH3_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH3_DA 0x0034
#define B_PL_IDDMA_CH3_DA_SH 0
#define B_PL_IDDMA_CH3_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH3_CTRL 0x0038
#define B_PL_IDDMA_CH3_OWN BIT(31)
#define B_PL_IDDMA_CH3_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH3_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH3_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH3_DLEN_SH 0
#define B_PL_IDDMA_CH3_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH4_SA 0x0040
#define B_PL_IDDMA_CH4_SA_SH 0
#define B_PL_IDDMA_CH4_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH4_DA 0x0044
#define B_PL_IDDMA_CH4_DA_SH 0
#define B_PL_IDDMA_CH4_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH4_CTRL 0x0048
#define B_PL_IDDMA_CH4_OWN BIT(31)
#define B_PL_IDDMA_CH4_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH4_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH4_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH4_DLEN_SH 0
#define B_PL_IDDMA_CH4_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH5_SA 0x0050
#define B_PL_IDDMA_CH5_SA_SH 0
#define B_PL_IDDMA_CH5_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH5_DA 0x0054
#define B_PL_IDDMA_CH5_DA_SH 0
#define B_PL_IDDMA_CH5_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH5_CTRL 0x0058
#define B_PL_IDDMA_CH5_OWN BIT(31)
#define B_PL_IDDMA_CH5_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH5_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH5_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH5_DLEN_SH 0
#define B_PL_IDDMA_CH5_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_FWIMR 0x00E0
#define B_PL_IDDMA_CH5_INT_MSK BIT(5)
#define B_PL_IDDMA_CH4_INT_MSK BIT(4)
#define B_PL_IDDMA_CH3_INT_MSK BIT(3)
#define B_PL_IDDMA_CH2_INT_MSK BIT(2)
#define B_PL_IDDMA_CH1_INT_MSK BIT(1)
#define B_PL_IDDMA_CH0_INT_MSK BIT(0)

#define R_PL_IDDMA_FWISR 0x00E4
#define B_PL_IDDMA_CH5_INT BIT(5)
#define B_PL_IDDMA_CH4_INT BIT(4)
#define B_PL_IDDMA_CH3_INT BIT(3)
#define B_PL_IDDMA_CH2_INT BIT(2)
#define B_PL_IDDMA_CH1_INT BIT(1)
#define B_PL_IDDMA_CH0_INT BIT(0)

#define R_PL_IDDMA_CH_STATUS 0x00E8
#define B_PL_IDDMA_CH5_BUSY BIT(5)
#define B_PL_IDDMA_CH4_BUSY BIT(4)
#define B_PL_IDDMA_CH3_BUSY BIT(3)
#define B_PL_IDDMA_CH2_BUSY BIT(2)
#define B_PL_IDDMA_CH1_BUSY BIT(1)
#define B_PL_IDDMA_CH0_BUSY BIT(0)

#define R_PL_IDDMA_CHKSUM_CONTROL 0x00EC
#define B_PL_IDDMA_CHKSUM_RESET BIT(0)

#define R_PL_IDDMA_CHKSUM 0x00F0
#define B_PL_IDDMA_CHKSUM_RESULT_SH 0
#define B_PL_IDDMA_CHKSUM_RESULT_MSK 0xffff

#define R_PL_IDDMA_MONITOR 0x00FC
#define B_PL_IDDMA_CH5_DOK BIT(21)
#define B_PL_IDDMA_CH4_DOK BIT(20)
#define B_PL_IDDMA_CH3_DOK BIT(19)
#define B_PL_IDDMA_CH2_DOK BIT(18)
#define B_PL_IDDMA_CH1_DOK BIT(17)
#define B_PL_IDDMA_CH0_DOK BIT(16)
#define B_PL_IDDMA_DATA_UNDERFLOW BIT(14)
#define B_PL_IDDMA_FIFO_UNDERFLOW BIT(13)
#define B_PL_IDDMA_FIFO_OVERFLOW BIT(12)
#define B_PL_IDDMA_CH5_ERROR BIT(5)
#define B_PL_IDDMA_CH4_ERROR BIT(4)
#define B_PL_IDDMA_CH3_ERROR BIT(3)
#define B_PL_IDDMA_CH2_ERROR BIT(2)
#define B_PL_IDDMA_CH1_ERROR BIT(1)
#define B_PL_IDDMA_CH0_ERROR BIT(0)

//
// WL_AX_Reg_IDDMA.xls
//

//
// IDDMA_Reg_Spec
//

//
// WL_AX_Reg_IDDMA.xls
//

//
// IDDMA_Reg_Spec
//

//
// WL_AX_Reg_IDDMA.xls
//

//
// IDDMA_Reg_Spec
//

//
// WL_AX_Reg_IPSec.xls
//

//
// IPSec_Reg
//

#define R_PL_REG_SDSR 0x0000
#define B_PL_SRC_RST BIT(31)
#define B_PL_PK_UP BIT(30)
#define B_PL_SRC_FAIL_STATUS_SH 25
#define B_PL_SRC_FAIL_STATUS_MSK 0x3
#define B_PL_SRC_FAIL BIT(24)
#define B_PL_SRPTR_SH 16
#define B_PL_SRPTR_MSK 0xff
#define B_PL_SWPTR_SH 8
#define B_PL_SWPTR_MSK 0xff
#define B_PL_FIFO_EMPTY_CNT_SH 0
#define B_PL_FIFO_EMPTY_CNT_MSK 0xff

#define R_PL_REG_SDFWR 0x0004
#define B_PL_SDFW_SH 0
#define B_PL_SDFW_MSK 0xffffffffL

#define R_PL_REG_SDSWR 0x0008
#define B_PL_SDSW_SH 0
#define B_PL_SDSW_MSK 0xffffffffL

#define R_PL_REG_IPSCSR_RSTEACONFISR 0x0010
#define B_PL_IPSEC_RST BIT(31)
#define B_PL_CLEAR_OK_INT_NUM_SH 16
#define B_PL_CLEAR_OK_INT_NUM_MSK 0xff
#define B_PL_OK_INTR_CNT_SH 8
#define B_PL_OK_INTR_CNT_MSK 0xff
#define B_PL_INTR_MODE BIT(7)
#define B_PL_CMD_OK BIT(4)
#define B_PL_DMA_BUSY BIT(3)
#define B_PL_SOFT_RST BIT(0)

#define R_PL_REG_IPSCSR_INTM 0x0014
#define B_PL_DES_ERR5_M BIT(18)
#define B_PL_DES_ERR4_M BIT(17)
#define B_PL_DES_ERR3_M BIT(16)
#define B_PL_DES_ERR2_M BIT(15)
#define B_PL_DES_ERR1_M BIT(14)
#define B_PL_DES_ERR0_M BIT(13)
#define B_PL_SRC_ERR9_M BIT(12)
#define B_PL_SRC_ERR8_M BIT(11)
#define B_PL_SRC_ERR7_M BIT(10)
#define B_PL_SRC_ERR6_M BIT(9)
#define B_PL_SRC_ERR5_M BIT(8)
#define B_PL_SRC_ERR4_M BIT(7)
#define B_PL_SRC_ERR3_M BIT(6)
#define B_PL_SRC_ERR2_M BIT(5)
#define B_PL_SRC_ERR1_M BIT(4)
#define B_PL_SRC_ERR0_M BIT(3)
#define B_PL_DES_FAIL_M BIT(2)
#define B_PL_SRC_FAIL_M BIT(1)
#define B_PL_CMD_OK_M BIT(0)

#define R_PL_REG_IPSCSR_DBG 0x0018
#define B_PL_DEBUG_WB BIT(31)
#define B_PL_MST_BAD_SEL_SH 28
#define B_PL_MST_BAD_SEL_MSK 0x3
#define B_PL_ENGINE_CLK_EN BIT(24)
#define B_PL_DEBUG_PORT_SEL_SH 20
#define B_PL_DEBUG_PORT_SEL_MSK 0xf
#define B_PL_ARBITER_MODE BIT(16)
#define B_PL_DMA_WAIT_CYCLE_SH 0
#define B_PL_DMA_WAIT_CYCLE_MSK 0xffff

#define R_PL_REG_IPSCSR_ERR_INT 0x001C
#define B_PL_DES_ERR5 BIT(15)
#define B_PL_DES_ERR4 BIT(14)
#define B_PL_DES_ERR3 BIT(13)
#define B_PL_DES_ERR2 BIT(12)
#define B_PL_DES_ERR1 BIT(11)
#define B_PL_DES_ERR0 BIT(10)
#define B_PL_SRC_ERR9 BIT(9)
#define B_PL_SRC_ERR8 BIT(8)
#define B_PL_SRC_ERR7 BIT(7)
#define B_PL_SRC_ERR6 BIT(6)
#define B_PL_SRC_ERR5 BIT(5)
#define B_PL_SRC_ERR4 BIT(4)
#define B_PL_SRC_ERR3 BIT(3)
#define B_PL_SRC_ERR2 BIT(2)
#define B_PL_SRC_ERR1 BIT(1)
#define B_PL_SRC_ERR0 BIT(0)

#define R_PL_REG_IPSCSR_SAADLR 0x0020
#define B_PL_A2EO_SUM_SH 0
#define B_PL_A2EO_SUM_MSK 0x7ff

#define R_PL_REG_IPSCSR_SENLR 0x0024
#define B_PL_ENL_SUM_SH 0
#define B_PL_ENL_SUM_MSK 0xffffff

#define R_PL_REG_IPSCSR_SAPLR 0x0028
#define B_PL_APL_SUM_SH 0
#define B_PL_APL_SUM_MSK 0xfff

#define R_PL_REG_IPSCSR_SEPLR 0x002C
#define B_PL_EPL_SUM_SH 0
#define B_PL_EPL_SUM_MSK 0x3f

#define R_PL_REG_IPSCSR_SWAPABURSTR 0x0030
#define B_PL_MD5_INPUT_DATA_BYTE_SWAP BIT(25)
#define B_PL_MD5_OUTPUT_DATA_BYTE_SWAP BIT(24)
#define B_PL_DMA_BURST_LENGTH_SH 16
#define B_PL_DMA_BURST_LENGTH_MSK 0x3f
#define B_PL_AUTO_PADDING_SWAP BIT(13)
#define B_PL_TX_WD_SWAP BIT(12)
#define B_PL_RX_WD_SWAP BIT(11)
#define B_PL_MAC_OUT_LITTLE_ENDIAN BIT(10)
#define B_PL_DATA_OUT_LITTLE_ENDIAN BIT(9)
#define B_PL_TX_BYTE_SWAP BIT(8)
#define B_PL_DATA_IN_LITTLE_ENDIAN BIT(4)
#define B_PL_HASH_INITIAL_VALUE_SWAP BIT(3)
#define B_PL_KEY_PAD_SWAP BIT(2)
#define B_PL_KEY_IV_SWAP BIT(1)
#define B_PL_SET_SWAP BIT(0)

#define R_PL_REG_DDSR 0x1000
#define B_PL_DES_RST BIT(31)
#define B_PL_DES_FAIL_STATUS_SH 25
#define B_PL_DES_FAIL_STATUS_MSK 0x3
#define B_PL_DES_FAIL BIT(24)
#define B_PL_DRPTR_SH 16
#define B_PL_DRPTR_MSK 0xff
#define B_PL_DWPTR_SH 8
#define B_PL_DWPTR_MSK 0xff

#define R_PL_REG_DDFWR 0x1004
#define B_PL_DDFW_SH 0
#define B_PL_DDFW_MSK 0xffffffffL

#define R_PL_REG_DDSWR 0x1008
#define B_PL_DDSW_SH 0
#define B_PL_DDSW_MSK 0xffffffffL

#define R_PL_REG_DES_PKTCONF 0x100C
#define B_PL_DBG_DPTR_SH 8
#define B_PL_DBG_DPTR_MSK 0xff
#define B_PL_DBG_SPTR_SH 0
#define B_PL_DBG_SPTR_MSK 0xff

#define R_PL_REG_DBGSDR 0x1010
#define B_PL_DBG_SD_SH 0
#define B_PL_DBG_SD_MSK 0xffffffffL

#define R_PL_REG_DBGDDR 0x1014
#define B_PL_DBG_DD_SH 0
#define B_PL_DBG_DD_MSK 0xffffffffL

//
// WL_AX_Reg_IPSec.xls
//

//
// IPSec_Reg
//

//
// WL_AX_Reg_IPSec.xls
//

//
// IPSec_Reg
//

//
// WL_AX_Reg_IPSec.xls
//

//
// IPSec_Reg
//

//
// WL_AX_Reg_RXI300.xls
//

//
// RXI300
//

#define R_AX_RXI300_NAME 0x0000
#define B_AX_RXI300_NAME_SH 0
#define B_AX_RXI300_NAME_MSK 0xffffffffL

#define R_AX_RXI300_VER 0x0004
#define B_AX_RXI300_VER_SH 0
#define B_AX_RXI300_VER_MSK 0xffffffffL

#define R_AX_RXI300_REV 0x0008
#define B_AX_RXI300_REV_SH 0
#define B_AX_RXI300_REV_MSK 0xffffffffL

#define R_AX_RXI300_INST 0x000C
#define B_AX_RXI300_INST_SH 0
#define B_AX_RXI300_INST_MSK 0xffffffffL

#define R_AX_RXI300_IMPL_Y 0x0010
#define B_AX_RXI300_IMPL_Y_SH 0
#define B_AX_RXI300_IMPL_Y_MSK 0xffffffffL

#define R_AX_RXI300_IMPL_D 0x0014
#define B_AX_RXI300_IMPL_D_SH 0
#define B_AX_RXI300_IMPL_D_MSK 0xffffffffL

#define R_AX_RXI300_DEV 0x0018
#define B_AX_RXI300_DEV_SH 0
#define B_AX_RXI300_DEV_MSK 0xffffffffL

#define R_AX_RXI300_PRO_NUM 0x001C
#define B_AX_RXI300_PRO_NUM_SH 0
#define B_AX_RXI300_PRO_NUM_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_PLD0 0x0200
#define B_AX_ERR_BSTINDEX_SH 24
#define B_AX_ERR_BSTINDEX_MSK 0xff
#define B_AX_ERR_BSTLEN_SH 16
#define B_AX_ERR_BSTLEN_MSK 0xff
#define B_AX_ERR_BSTTYPE_SH 11
#define B_AX_ERR_BSTTYPE_MSK 0x7
#define B_AX_ERR_CMD_SH 8
#define B_AX_ERR_CMD_MSK 0x7
#define B_AX_ERR_SRC_SH 0
#define B_AX_ERR_SRC_MSK 0xff

#define R_AX_RXI300_ELR_0_PLD1 0x0204
#define B_AX_ERR_MREQINFO_SH 23
#define B_AX_ERR_MREQINFO_MSK 0x1ff
#define B_AX_ERR_SIZE_SH 16
#define B_AX_ERR_SIZE_MSK 0x7
#define B_AX_ERR_BYTEEN_SH 0
#define B_AX_ERR_BYTEEN_MSK 0xffff

#define R_AX_RXI300_ELR_0_ID 0x0208
#define B_AX_ERR_ID_SH 0
#define B_AX_ERR_ID_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_ADR0 0x020C
#define B_AX_ERR_ADR0_SH 0
#define B_AX_ERR_ADR0_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_ADR1 0x0210
#define B_AX_ERR_ADR1_SH 0
#define B_AX_ERR_ADR1_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_CODE 0x0230
#define B_AX_ELR_CODE_SH 0
#define B_AX_ELR_CODE_MSK 0xff

#define R_AX_RXI300_ELR_0_INTR_CLR 0x023C
#define B_AX_ELR_INTR_CLR BIT(0)

#define R_AX_RXI300_ICG_CTRL0 0x0300
#define B_AX_RXI300_ICG_CTRL0_SH 0
#define B_AX_RXI300_ICG_CTRL0_MSK 0xffffffffL

#define R_AX_RXI300_ICG_CTRL1 0x0304
#define B_AX_RXI300_ICG_CTRL1_SH 0
#define B_AX_RXI300_ICG_CTRL1_MSK 0xffffffffL

#define R_AX_RXI300_TIME_MON 0x0308
#define B_AX_RXI300_TM_AXI_APB_BBRF_RST BIT(26)
#define B_AX_RXI300_TM_AXI_APB_SA_RST BIT(25)
#define B_AX_RXI300_TM_AXI2AHB_RST BIT(24)
#define B_AX_RXI300_TM_AXI_APB_BBRF_EN BIT(18)
#define B_AX_RXI300_TM_AXI_APB_SA_EN BIT(17)
#define B_AX_RXI300_TM_AXI2AHB_EN BIT(16)
#define B_AX_RXI300_TM_GRADE_SH 8
#define B_AX_RXI300_TM_GRADE_MSK 0xf
#define B_AX_RXI300_TM_TRSH_SH 0
#define B_AX_RXI300_TM_TRSH_MSK 0xff

#define R_AX_RXI300_ICG_STAT0 0x0320
#define B_AX_RXI300_ICG_STAT0_SH 0
#define B_AX_RXI300_ICG_STAT0_MSK 0xffffffffL

#define R_AX_RXI300_ICG_STAT1 0x0324
#define B_AX_RXI300_ICG_STAT1_SH 0
#define B_AX_RXI300_ICG_STAT1_MSK 0xffffffffL

//
// WL_AX_Reg_RXI300.xls
//

//
// RXI300
//

//
// WL_AX_Reg_RXI300.xls
//

//
// RXI300
//

#define R_AX_RXI300_TIME_MON_V1 0x0408
#define B_AX_RXI300_TM_BBRF_RST BIT(26)
#define B_AX_RXI300_TM_APB_RST BIT(25)
#define B_AX_RXI300_TM_WPA_RST BIT(24)
#define B_AX_RXI300_TM_AXI_BBRF_EN BIT(18)
#define B_AX_RXI300_TM_AXI_APB_EN BIT(17)
#define B_AX_RXI300_TM_WPA_EN BIT(16)

//
// WL_AX_Reg_RXI300.xls
//

//
// RXI300
//

//
// WL_AX_Reg_SPIC.xls
//

//
// SPIC
//

#define R_AX_SPIC_CTRLR0 0x0000
#define B_AX_PRM_2ND_PHASE BIT(31)
#define B_AX_DDR_EN_SH 28
#define B_AX_DDR_EN_MSK 0x7
#define B_AX_CK_MTIMES_SH 23
#define B_AX_CK_MTIMES_MSK 0x1f
#define B_AX_FAST_RD BIT(22)
#define B_AX_CMD_CH_SH 20
#define B_AX_CMD_CH_MSK 0x3
#define B_AX_DATA_CH_SH 18
#define B_AX_DATA_CH_MSK 0x3
#define B_AX_ADDR_CH_SH 16
#define B_AX_ADDR_CH_MSK 0x3
#define B_AX_TMOD_SH 8
#define B_AX_TMOD_MSK 0x3
#define B_AX_SCPOL BIT(7)
#define B_AX_SCPH BIT(6)

#define R_AX_SPIC_CTRLR1 0x0004
#define B_AX_NDF_SH 0
#define B_AX_NDF_MSK 0xffff

#define R_AX_SPIC_SSIENR 0x0008
#define B_AX_PGM_RST_TEST_EN BIT(4)
#define B_AX_ATCK_CMD BIT(1)
#define B_AX_FUNC_EN BIT(0)

#define R_AX_SPIC_SER 0x0010
#define B_AX_SER BIT(0)

#define R_AX_SPIC_BAUDR 0x0014
#define B_AX_SCKDV_SH 0
#define B_AX_SCKDV_MSK 0xfff

#define R_AX_SPIC_TXFTLR 0x0018
#define B_AX_TFT_SH 0
#define B_AX_TFT_MSK 0x7f

#define R_AX_SPIC_RXFTLR 0x001C
#define B_AX_RFT_SH 0
#define B_AX_RFT_MSK 0x7f

#define R_AX_SPIC_TXFLR 0x0020
#define B_AX_TXFLR_SH 0
#define B_AX_TXFLR_MSK 0xff

#define R_AX_SPIC_RXFLR 0x0024
#define B_AX_RXFLR_SH 0
#define B_AX_RXFLR_MSK 0xff

#define R_AX_SPIC_SR 0x0028
#define B_AX_BOOT_FIN BIT(7)
#define B_AX_DCOL BIT(6)
#define B_AX_TXE BIT(5)
#define B_AX_RFF BIT(4)
#define B_AX_RFNE BIT(3)
#define B_AX_TFE BIT(2)
#define B_AX_TFNF BIT(1)
#define B_AX_BUSY BIT(0)

#define R_AX_SPIC_IMR 0x002C
#define B_AX_ACSIM BIT(11)
#define B_AX_RXSIM BIT(10)
#define B_AX_TXSIM BIT(9)
#define B_AX_ACEIM BIT(8)
#define B_AX_BYEIM BIT(7)
#define B_AX_WBEIM BIT(6)
#define B_AX_FSEIM BIT(5)
#define B_AX_RXFIM BIT(4)
#define B_AX_RXOIM BIT(3)
#define B_AX_RXUIM BIT(2)
#define B_AX_TXOIM BIT(1)
#define B_AX_TXEIM BIT(0)

#define R_AX_SPIC_ISR 0x0030
#define B_AX_ACSIS BIT(11)
#define B_AX_RXSIS BIT(10)
#define B_AX_TXSIS BIT(9)
#define B_AX_ACEIS BIT(8)
#define B_AX_BYEIS BIT(7)
#define B_AX_WBEIS BIT(6)
#define B_AX_FSEIS BIT(5)
#define B_AX_RXFIS BIT(4)
#define B_AX_RXOIS BIT(3)
#define B_AX_RXUIS BIT(2)
#define B_AX_TXOIS BIT(1)
#define B_AX_TXEIS BIT(0)

#define R_AX_SPIC_RISR 0x0034
#define B_AX_ACSIR BIT(11)
#define B_AX_RXSIR BIT(10)
#define B_AX_TXSIR BIT(9)
#define B_AX_ACEIR BIT(8)
#define B_AX_BYEIR BIT(7)
#define B_AX_WBEIR BIT(6)
#define B_AX_FSEIR BIT(5)
#define B_AX_RXFIR BIT(4)
#define B_AX_RXOIR BIT(3)
#define B_AX_RXUIR BIT(2)
#define B_AX_TXOIR BIT(1)
#define B_AX_TXEIR BIT(0)

#define R_AX_SPIC_TXOICR 0x0038
#define B_AX_TXOICR BIT(0)

#define R_AX_SPIC_RXOICR 0x003C
#define B_AX_RXOICR BIT(0)

#define R_AX_SPIC_RXUICR 0x0040
#define B_AX_RXUICR BIT(0)

#define R_AX_SPIC_MSTICR 0x0044
#define B_AX_MSTICR BIT(0)

#define R_AX_SPIC_ICR 0x0048
#define B_AX_ICR BIT(0)

#define R_AX_SPIC_DMACR 0x004C
#define B_AX_TX_DMAC_EN BIT(1)
#define B_AX_RX_DMAC_EN BIT(0)

#define R_AX_SPIC_DMATDLR 0x0050
#define B_AX_DMATDL_SH 0
#define B_AX_DMATDL_MSK 0x7f

#define R_AX_SPIC_DMARDLR 0x0054
#define B_AX_DMARDL_SH 0
#define B_AX_DMARDL_MSK 0x7f

#define R_AX_SPIC_IDR 0x0058
#define B_AX_IDCODE_SH 0
#define B_AX_IDCODE_MSK 0xffffffffL

#define R_AX_SPIC_VERSION 0x005C
#define B_AX_VERSION_SH 0
#define B_AX_VERSION_MSK 0xffffffffL

#define R_AX_SPIC_DR_WORD 0x0060
#define B_AX_DR_WORD_SH 0
#define B_AX_DR_WORD_MSK 0xffffffffL

#define R_AX_SPIC_DR_HALF_WORD 0x0060
#define B_AX_DR_HALF_WORD_SH 0
#define B_AX_DR_HALF_WORD_MSK 0xffff

#define R_AX_SPIC_DR_BYTE 0x0060
#define B_AX_DR_BYTE_SH 0
#define B_AX_DR_BYTE_MSK 0xff

#define R_AX_SPIC_READ_FAST_SINGLE 0x00E0
#define B_AX_FRD_CMD_SH 0
#define B_AX_FRD_CMD_MSK 0xffff

#define R_AX_SPIC_READ_DUAL_DATA 0x00E4
#define B_AX_RD_DUAL_O_CMD_SH 0
#define B_AX_RD_DUAL_O_CMD_MSK 0xff

#define R_AX_SPIC_READ_DUAL_ADDR_DATA 0x00E8
#define B_AX_RD_DUAL_IO_CMD_SH 0
#define B_AX_RD_DUAL_IO_CMD_MSK 0xff

#define R_AX_SPIC_READ_QUAD_DATA 0x00EC
#define B_AX_RD_QUAD_O_CMD_SH 0
#define B_AX_RD_QUAD_O_CMD_MSK 0xff

#define R_AX_SPIC_READ_QUAD_ADDR_DATA 0x00F0
#define B_AX_PRM_VALUE_SH 16
#define B_AX_PRM_VALUE_MSK 0xff
#define B_AX_RD_QUAD_IO_CMD_SH 0
#define B_AX_RD_QUAD_IO_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_SINGLE 0x00F4
#define B_AX_WR_CMD_SH 0
#define B_AX_WR_CMD_MSK 0xffff

#define R_AX_SPIC_WRITE_DUAL_DATA 0x00F8
#define B_AX_WR_DUAL_I_CMD_SH 0
#define B_AX_WR_DUAL_I_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_DUAL_ADDR_DATA 0x00FC
#define B_AX_WR_DUAL_II_CMD_SH 0
#define B_AX_WR_DUAL_II_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_QUAD_DATA 0x0100
#define B_AX_WR_QUAD_I_CMD_SH 0
#define B_AX_WR_QUAD_I_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_QUAD_ADDR_DATA 0x0104
#define B_AX_WR_QUAD_II_CMD_SH 0
#define B_AX_WR_QUAD_II_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_ENABLE 0x0108
#define B_AX_WR_EN_CMD_SH 0
#define B_AX_WR_EN_CMD_MSK 0xffff

#define R_AX_SPIC_READ_STATUS 0x010C
#define B_AX_ADDR_EN BIT(31)
#define B_AX_ADDR_LEN_SH 29
#define B_AX_ADDR_LEN_MSK 0x3
#define B_AX_ADDR_SEL BIT(28)
#define B_AX_INTERVAL_EN BIT(27)
#define B_AX_RD_ST_CMD_SH 0
#define B_AX_RD_ST_CMD_MSK 0xffff

#define R_AX_SPIC_CTRLR2 0x0110
#define B_AX_CS_ACTIVE_HOLD_SH 12
#define B_AX_CS_ACTIVE_HOLD_MSK 0x3
#define B_AX_RX_FIFO_ENTRY_SH 8
#define B_AX_RX_FIFO_ENTRY_MSK 0xf
#define B_AX_FIFO_ENTRY_SH 4
#define B_AX_FIFO_ENTRY_MSK 0xf
#define B_AX_SEQ_EN BIT(3)
#define B_AX_WPN_DNUM BIT(2)
#define B_AX_WPN_SET BIT(1)
#define B_AX_SO_DNUM BIT(0)

#define R_AX_SPIC_FBAUDR 0x0114
#define B_AX_FSCKDV_SH 0
#define B_AX_FSCKDV_MSK 0xfff

#define R_AX_SPIC_ADDR_LENGTH 0x0118
#define B_AX_ADDR_PHASE_LENGTH_SH 0
#define B_AX_ADDR_PHASE_LENGTH_MSK 0x7

#define R_AX_SPIC_AUTO_LENGTH 0x011C
#define B_AX_ADDR_CS_H_WR_DUM_LEN_SH 28
#define B_AX_ADDR_CS_H_WR_DUM_LEN_MSK 0xf
#define B_AX_ADDR_CS_H_RD_DUM_LEN_SH 26
#define B_AX_ADDR_CS_H_RD_DUM_LEN_MSK 0x3
#define B_AX_ADDR_AUTO_DUM_LEN_SH 18
#define B_AX_ADDR_AUTO_DUM_LEN_MSK 0xff
#define B_AX_ADDR_AUTO_ADDR_LENGTH_SH 16
#define B_AX_ADDR_AUTO_ADDR_LENGTH_MSK 0x3
#define B_AX_ADDR_IN_PHYSICAL_CYC_SH 12
#define B_AX_ADDR_IN_PHYSICAL_CYC_MSK 0xf

#define R_AX_SPIC_VALID_CMD 0x0120
#define B_AX_ADDR_SEQ_TRANS_EN BIT(14)
#define B_AX_ADDR_CTRLR0_CH BIT(12)
#define B_AX_ADDR_PRM_EN BIT(11)
#define B_AX_ADDR_WR_BLOCKING BIT(9)
#define B_AX_ADDR_WR_QUAD_II BIT(8)
#define B_AX_ADDR_WR_QUAD_I BIT(7)
#define B_AX_ADDR_WR_DUAL_II BIT(6)
#define B_AX_ADDR_WR_DUAL_I BIT(5)
#define B_AX_ADDR_RD_QUAD_IO BIT(4)
#define B_AX_ADDR_RD_QUAD_O BIT(3)
#define B_AX_ADDR_RD_DUAL_IO BIT(2)
#define B_AX_ADDR_RD_DUAL_I BIT(1)
#define B_AX_ADDR_FRD_SINGEL BIT(0)

#define R_AX_SPIC_FLASH_SIZE 0x0124
#define B_AX_FLASH_SIZE_SH 0
#define B_AX_FLASH_SIZE_MSK 0xfff

#define R_AX_SPIC_FLUSH_FIFO 0x0128
#define B_AX_FLUSH_PGM_RST_FIFO BIT(1)
#define B_AX_FLUSH_FIFO BIT(0)

#define R_AX_SPIC_PGM_RST_FIFO 0x0140
#define B_AX_PGM_RST_FIFO_SH 0
#define B_AX_PGM_RST_FIFO_MSK 0xffff

//
// WL_AX_Reg_SPIC.xls
//

//
// SPIC
//

//
// WL_AX_Reg_SPIC.xls
//

//
// SPIC
//
#define B_AX_SPIC_USER_MODE BIT(31)
#define B_AX_SPIC_UAR BIT(30)
#define B_AX_SPIC_CK_MTIMES_SH 23
#define B_AX_SPIC_CK_MTIMES_MSK 0x1f
#define B_AX_SPIC_FAST_RD BIT(22)
#define B_AX_SPIC_CMD_CH_SH 20
#define B_AX_SPIC_CMD_CH_MSK 0x3
#define B_AX_SPIC_DATA_CH_SH 18
#define B_AX_SPIC_DATA_CH_MSK 0x3
#define B_AX_SPIC_ADDR_CH_SH 16
#define B_AX_SPIC_ADDR_CH_MSK 0x3
#define B_AX_SPIC_DDR_EN_V1_SH 13
#define B_AX_SPIC_DDR_EN_V1_MSK 0x7
#define B_AX_SPIC_GCLK_DIS BIT(10)
#define B_AX_SPIC_TMOD_SH 8
#define B_AX_SPIC_TMOD_MSK 0x3
#define B_AX_SPIC_SCPOL BIT(7)
#define B_AX_SPIC_SCPH BIT(6)
#define B_AX_SPIC_SIPOL_EN BIT(5)
#define B_AX_SPIC_SIPOL_SH 0
#define B_AX_SPIC_SIPOL_MSK 0x1f

#define R_AX_SPIC_RX_NDF 0x0004
#define B_AX_SPIC_RX_NDF_SH 0
#define B_AX_SPIC_RX_NDF_MSK 0xffff
#define B_AX_SPIC_PGM_RST_TEST_EN BIT(4)
#define B_AX_SPIC_ATCK_CMD BIT(1)
#define B_AX_SPIC_SPIC_FUNC_EN BIT(0)
#define B_AX_SPIC_SER BIT(0)
#define B_AX_SPIC_SCKDV_SH 0
#define B_AX_SPIC_SCKDV_MSK 0xfff
#define B_AX_SPIC_TFT_SH 0
#define B_AX_SPIC_TFT_MSK 0x7f
#define B_AX_SPIC_RFT_SH 0
#define B_AX_SPIC_RFT_MSK 0x7f
#define B_AX_SPIC_TXFLR_SH 0
#define B_AX_SPIC_TXFLR_MSK 0xff
#define B_AX_SPIC_RXFLR_SH 0
#define B_AX_SPIC_RXFLR_MSK 0xff
#define B_AX_SPIC_ATWR_RDSR_N BIT(8)
#define B_AX_SPIC_BOOT_FIN BIT(7)
#define B_AX_SPIC_DCOL BIT(6)
#define B_AX_SPIC_TXE BIT(5)
#define B_AX_SPIC_RFF BIT(4)
#define B_AX_SPIC_RFNE BIT(3)
#define B_AX_SPIC_TFE BIT(2)
#define B_AX_SPIC_TFNF BIT(1)
#define B_AX_SPIC_BUSY BIT(0)
#define B_AX_SPIC_NWEIM BIT(16)
#define B_AX_SPIC_STFIM BIT(15)
#define B_AX_SPIC_STOIM BIT(14)
#define B_AX_SPIC_STUIM BIT(13)
#define B_AX_SPIC_DREIM BIT(12)
#define B_AX_SPIC_ACSIM BIT(11)
#define B_AX_SPIC_TFSIM BIT(10)
#define B_AX_SPIC_USEIM BIT(9)
#define B_AX_SPIC_ACEIM BIT(8)
#define B_AX_SPIC_BYEIM BIT(7)
#define B_AX_SPIC_WBEIM BIT(6)
#define B_AX_SPIC_FSEIM BIT(5)
#define B_AX_SPIC_RXFIM BIT(4)
#define B_AX_SPIC_RXOIM BIT(3)
#define B_AX_SPIC_RXUIM BIT(2)
#define B_AX_SPIC_TXOIM BIT(1)
#define B_AX_SPIC_TXEIM BIT(0)
#define B_AX_SPIC_NWEIS BIT(16)
#define B_AX_SPIC_STFIS BIT(15)
#define B_AX_SPIC_STOIS BIT(14)
#define B_AX_SPIC_STUIS BIT(13)
#define B_AX_SPIC_DREIS BIT(12)
#define B_AX_SPIC_ACSIS BIT(11)
#define B_AX_SPIC_TFSIS BIT(10)
#define B_AX_SPIC_USEIS BIT(9)
#define B_AX_SPIC_ACEIS BIT(8)
#define B_AX_SPIC_BYEIS BIT(7)
#define B_AX_SPIC_WBEIS BIT(6)
#define B_AX_SPIC_FSEIS BIT(5)
#define B_AX_SPIC_RXFIS BIT(4)
#define B_AX_SPIC_RXOIS BIT(3)
#define B_AX_SPIC_RXUIS BIT(2)
#define B_AX_SPIC_TXOIS BIT(1)
#define B_AX_SPIC_TXEIS BIT(0)
#define B_AX_SPIC_NWEIR BIT(16)
#define B_AX_SPIC_STFIR BIT(15)
#define B_AX_SPIC_STOIR BIT(14)
#define B_AX_SPIC_STUIR BIT(13)
#define B_AX_SPIC_DREIR BIT(12)
#define B_AX_SPIC_ACSIR BIT(11)
#define B_AX_SPIC_TFSIR BIT(10)
#define B_AX_SPIC_USEIR BIT(9)
#define B_AX_SPIC_ACEIR BIT(8)
#define B_AX_SPIC_BYEIR BIT(7)
#define B_AX_SPIC_WBEIR BIT(6)
#define B_AX_SPIC_FSEIR BIT(5)
#define B_AX_SPIC_RXFIR BIT(4)
#define B_AX_SPIC_RXOIR BIT(3)
#define B_AX_SPIC_RXUIR BIT(2)
#define B_AX_SPIC_TXOIR BIT(1)
#define B_AX_SPIC_TXEIR BIT(0)
#define B_AX_SPIC_TXOICR BIT(0)
#define B_AX_SPIC_RXOICR BIT(0)
#define B_AX_SPIC_RXUICR BIT(0)
#define B_AX_SPIC_MSTICR BIT(0)
#define B_AX_SPIC_ICR BIT(0)
#define B_AX_SPIC_TX_DMAC_EN BIT(1)
#define B_AX_SPIC_RX_DMAC_EN BIT(0)
#define B_AX_SPIC_DMATDL_SH 0
#define B_AX_SPIC_DMATDL_MSK 0x7f
#define B_AX_SPIC_DMARDL_SH 0
#define B_AX_SPIC_DMARDL_MSK 0x7f
#define B_AX_SPIC_IDCODE_SH 0
#define B_AX_SPIC_IDCODE_MSK 0xffffffffL
#define B_AX_SPIC_SPIC_VERSION_SH 0
#define B_AX_SPIC_SPIC_VERSION_MSK 0xffffffffL

#define R_AX_SPIC_DR 0x0060
#define B_AX_SPIC_DR_SH 0
#define B_AX_SPIC_DR_MSK 0xffffffffL

#define R_AX_SPIC_DM_DR 0x00A0
#define B_AX_SPIC_DATA_EN_DR BIT(1)
#define B_AX_SPIC_DATA_MASK_DR BIT(0)
#define B_AX_SPIC_FRD_CMD_SH 0
#define B_AX_SPIC_FRD_CMD_MSK 0xffff
#define B_AX_SPIC_RD_DUAL_O_CMD_SH 0
#define B_AX_SPIC_RD_DUAL_O_CMD_MSK 0xff
#define B_AX_SPIC_RD_DUAL_IO_CMD_SH 0
#define B_AX_SPIC_RD_DUAL_IO_CMD_MSK 0xff
#define B_AX_SPIC_RD_QUAD_O_CMD_SH 0
#define B_AX_SPIC_RD_QUAD_O_CMD_MSK 0xff
#define B_AX_SPIC_EXIT_PRM_CMD_SH 24
#define B_AX_SPIC_EXIT_PRM_CMD_MSK 0xff
#define B_AX_SPIC_PRM_VALUE_SH 16
#define B_AX_SPIC_PRM_VALUE_MSK 0xff
#define B_AX_SPIC_EXIT_PRM_DUM_LEN_SH 8
#define B_AX_SPIC_EXIT_PRM_DUM_LEN_MSK 0xff
#define B_AX_SPIC_RD_QUAD_IO_CMD_SH 0
#define B_AX_SPIC_RD_QUAD_IO_CMD_MSK 0xff
#define B_AX_SPIC_WR_CMD_SH 0
#define B_AX_SPIC_WR_CMD_MSK 0xffff
#define B_AX_SPIC_WR_DUAL_I_CMD_SH 0
#define B_AX_SPIC_WR_DUAL_I_CMD_MSK 0xff
#define B_AX_SPIC_WR_DUAL_II_CMD_SH 0
#define B_AX_SPIC_WR_DUAL_II_CMD_MSK 0xff
#define B_AX_SPIC_WR_QUAD_I_CMD_SH 0
#define B_AX_SPIC_WR_QUAD_I_CMD_MSK 0xff
#define B_AX_SPIC_WR_QUAD_II_CMD_SH 0
#define B_AX_SPIC_WR_QUAD_II_CMD_MSK 0xff
#define B_AX_SPIC_WR_EN_CMD_2ND_BYTE_SH 8
#define B_AX_SPIC_WR_EN_CMD_2ND_BYTE_MSK 0xff
#define B_AX_SPIC_WR_EN_CMD_1ST_BYTE_SH 0
#define B_AX_SPIC_WR_EN_CMD_1ST_BYTE_MSK 0xff
#define B_AX_SPIC_INTERVAL_EN_V1 BIT(31)
#define B_AX_SPIC_INTERVAL_ODD BIT(30)
#define B_AX_SPIC_ST_CMD_LEN_SH 28
#define B_AX_SPIC_ST_CMD_LEN_MSK 0x3
#define B_AX_SPIC_ST_CMD_CH_SH 26
#define B_AX_SPIC_ST_CMD_CH_MSK 0x3
#define B_AX_SPIC_ST_CMD_DDR_EN BIT(25)
#define B_AX_SPIC_RD_ST_CMD_3RD_BYTE_SH 16
#define B_AX_SPIC_RD_ST_CMD_3RD_BYTE_MSK 0xff
#define B_AX_SPIC_RD_ST_CMD_2ND_BYTE_SH 8
#define B_AX_SPIC_RD_ST_CMD_2ND_BYTE_MSK 0xff
#define B_AX_SPIC_RD_ST_CMD_1ST_BYTE_SH 0
#define B_AX_SPIC_RD_ST_CMD_1ST_BYTE_MSK 0xff
#define B_AX_SPIC_DIS_DM_CA BIT(14)
#define B_AX_SPIC_FULL_WR BIT(13)
#define B_AX_SPIC_DM_ACT BIT(12)
#define B_AX_SPIC_RX_FIFO_ENTRY_SH 8
#define B_AX_SPIC_RX_FIFO_ENTRY_MSK 0xf
#define B_AX_SPIC_TX_FIFO_ENTRY_SH 4
#define B_AX_SPIC_TX_FIFO_ENTRY_MSK 0xf
#define B_AX_SPIC_WPN_DNUM BIT(2)
#define B_AX_SPIC_WPN_SET BIT(1)
#define B_AX_SPIC_SO_DNUM BIT(0)
#define B_AX_SPIC_FSCKDV_SH 0
#define B_AX_SPIC_FSCKDV_MSK 0xfff

#define R_AX_SPIC_USER_LENGTH 0x0118
#define B_AX_SPIC_USER_ADDR_LENGTH_SH 16
#define B_AX_SPIC_USER_ADDR_LENGTH_MSK 0xf
#define B_AX_SPIC_USER_CMD_LENGHT_SH 12
#define B_AX_SPIC_USER_CMD_LENGHT_MSK 0x3
#define B_AX_SPIC_AUTO_ADDR_LENGTH_SH 16
#define B_AX_SPIC_AUTO_ADDR_LENGTH_MSK 0xf
#define B_AX_SPIC_IN_PHYSICAL_CYC_SH 12
#define B_AX_SPIC_IN_PHYSICAL_CYC_MSK 0xf
#define B_AX_SPIC_SEQ_WR_EN BIT(15)
#define B_AX_SPIC_SEQ_RD_EN BIT(14)
#define B_AX_SPIC_DUM_EN BIT(13)
#define B_AX_SPIC_CTRLR0_CH BIT(12)
#define B_AX_SPIC_PRM_EN BIT(11)
#define B_AX_SPIC_RM_WEN BIT(10)
#define B_AX_SPIC_RM_RDSR BIT(9)
#define B_AX_SPIC_WR_QUAD_II BIT(8)
#define B_AX_SPIC_WR_QUAD_I BIT(7)
#define B_AX_SPIC_WR_DUAL_II BIT(6)
#define B_AX_SPIC_WR_DUAL_I BIT(5)
#define B_AX_SPIC_RD_QUAD_IO BIT(4)
#define B_AX_SPIC_RD_QUAD_O BIT(3)
#define B_AX_SPIC_RD_DUAL_IO BIT(2)
#define B_AX_SPIC_RD_DUAL_I BIT(1)
#define B_AX_SPIC_FRD_SINGLE BIT(0)
#define B_AX_SPIC_FLASH_SIZE_V1_SH 0
#define B_AX_SPIC_FLASH_SIZE_V1_MSK 0xf
#define B_AX_SPIC_FLUSH_ST_FIFO BIT(2)
#define B_AX_SPIC_FLUSH_DR_FIFO BIT(1)
#define B_AX_SPIC_FLUSH_ALL BIT(0)

#define R_AX_SPIC_DUM_BYTE 0x012C
#define B_AX_SPIC_DUM_BYTE_VAL_SH 0
#define B_AX_SPIC_DUM_BYTE_VAL_MSK 0xff

#define R_AX_SPIC_TX_NDF 0x0130
#define B_AX_SPIC_TX_NDF_SH 0
#define B_AX_SPIC_TX_NDF_MSK 0xffffff

#define R_AX_SPIC_DEVICE_INFO 0x0134
#define B_AX_SPIC_DATA_UNIT_2B BIT(12)
#define B_AX_SPIC_JEDEC_P2CMF BIT(11)
#define B_AX_SPIC_PSRAM BIT(10)
#define B_AX_SPIC_NAND_FLASH BIT(9)
#define B_AX_SPIC_NOR_FLASH BIT(8)
#define B_AX_SPIC_RD_PAGE_EN BIT(5)
#define B_AX_SPIC_WR_PAGE_EN BIT(4)
#define B_AX_SPIC_PAGE_SIZE_SH 0
#define B_AX_SPIC_PAGE_SIZE_MSK 0xf

#define R_AX_SPIC_TPR0 0x0138
#define B_AX_SPIC_CS_TCEM_SH 24
#define B_AX_SPIC_CS_TCEM_MSK 0xff
#define B_AX_SPIC_CS_SEQ_TIMEOUT_SH 16
#define B_AX_SPIC_CS_SEQ_TIMEOUT_MSK 0xff
#define B_AX_SPIC_CS_ACTIVE_HOLD_V1_SH 12
#define B_AX_SPIC_CS_ACTIVE_HOLD_V1_MSK 0xf
#define B_AX_SPIC_CS_H_WR_DUM_LEN_SH 6
#define B_AX_SPIC_CS_H_WR_DUM_LEN_MSK 0x3f
#define B_AX_SPIC_CS_H_RD_DUM_LEN_SH 0
#define B_AX_SPIC_CS_H_RD_DUM_LEN_MSK 0x3f

#define R_AX_SPIC_AUTO_LENGTH2 0x013C

#define R_AX_SPIC_ST_DR 0x0180
#define B_AX_SPIC_ST_DR_SH 0
#define B_AX_SPIC_ST_DR_MSK 0xff

#define R_AX_SPIC_STFLR 0x01C0
#define B_AX_SPIC_STFLR_SH 0
#define B_AX_SPIC_STFLR_MSK 0xff

#define R_AX_SPIC_PAGE_READ 0x01D0
#define B_AX_SPIC_PAGE_RD_ADDR_LEN_SH 18
#define B_AX_SPIC_PAGE_RD_ADDR_LEN_MSK 0x3
#define B_AX_SPIC_PAGE_RD_CH_SH 16
#define B_AX_SPIC_PAGE_RD_CH_MSK 0x3
#define B_AX_SPIC_PAGE_RD_CMD_SH 0
#define B_AX_SPIC_PAGE_RD_CMD_MSK 0xff

//
// WL_AX_Reg_SPIC.xls
//

//
// SPIC
//

//
// WL_AX_Reg_UART.xls
//

//
// UART
//

#define R_AX_UART_RBR 0x0000
#define B_AX_RBR_SH 0
#define B_AX_RBR_MSK 0xff

#define R_AX_UART_THR 0x0000
#define B_AX_THR_SH 0
#define B_AX_THR_MSK 0xff

#define R_AX_UART_DLH 0x0004
#define B_AX_DLH_SH 0
#define B_AX_DLH_MSK 0xff

#define R_AX_UART_DLL 0x0000
#define B_AX_DLL_SH 0
#define B_AX_DLL_MSK 0xff

#define R_AX_UART_IER 0x0004
#define B_AX_IER_PTIME BIT(7)
#define B_AX_IER_EDSSI BIT(3)
#define B_AX_IER_ELSI BIT(2)
#define B_AX_IER_ETBEI BIT(1)
#define B_AX_IER_ERBFI BIT(0)

#define R_AX_UART_IIR 0x0008
#define B_AX_FIFOSE_SH 6
#define B_AX_FIFOSE_MSK 0x3
#define B_AX_IID_SH 0
#define B_AX_IID_MSK 0xf

#define R_AX_UART_FCR 0x0008
#define B_AX_RT_SH 6
#define B_AX_RT_MSK 0x3
#define B_AX_TET_SH 4
#define B_AX_TET_MSK 0x3
#define B_AX_DMAM BIT(3)
#define B_AX_XFIFOR BIT(2)
#define B_AX_RFIFOR BIT(1)
#define B_AX_FIFOE BIT(0)

#define R_AX_UART_LCR 0x000C
#define B_AX_DLAB BIT(7)
#define B_AX_BC BIT(6)
#define B_AX_EPS BIT(4)
#define B_AX_PEN BIT(3)
#define B_AX_STOP BIT(2)
#define B_AX_DLS_SH 0
#define B_AX_DLS_MSK 0x3

#define R_AX_UART_MCR 0x0010
#define B_AX_SIRE BIT(6)
#define B_AX_AFCE BIT(5)
#define B_AX_LB BIT(4)
#define B_AX_OUT2 BIT(3)
#define B_AX_OUT1 BIT(2)
#define B_AX_RTS BIT(1)
#define B_AX_DTR BIT(0)

#define R_AX_UART_LSR 0x0014
#define B_AX_RFE BIT(7)
#define B_AX_TEMT BIT(6)
#define B_AX_THRE BIT(5)
#define B_AX_BI BIT(4)
#define B_AX_FE BIT(3)
#define B_AX_PE BIT(2)
#define B_AX_OE BIT(1)
#define B_AX_DR BIT(0)

#define R_AX_UART_MSR 0x0018
#define B_AX_DCD BIT(7)
#define B_AX_RI BIT(6)
#define B_AX_DSR BIT(5)
#define B_AX_CTS BIT(4)
#define B_AX_DDCD BIT(3)
#define B_AX_TERI BIT(2)
#define B_AX_DDSR BIT(1)
#define B_AX_DCTS BIT(0)

#define R_AX_UART_SCR 0x001C
#define B_AX_SCR_SH 0
#define B_AX_SCR_MSK 0xff

#define R_AX_UART_LPDLL 0x001C
#define B_AX_LPDLL_SH 0
#define B_AX_LPDLL_MSK 0xff

#define R_AX_UART_LPDLH 0x001C
#define B_AX_LPDLH_SH 0
#define B_AX_LPDLH_MSK 0xff

#define R_AX_UART_FAR 0x0070
#define B_AX_FAR BIT(0)

#define R_AX_UART_TFR 0x0074
#define B_AX_TFR_SH 0
#define B_AX_TFR_MSK 0xff

#define R_AX_UART_RFW 0x0078
#define B_AX_RFFE BIT(9)
#define B_AX_RFPE BIT(8)
#define B_AX_RFWD_SH 0
#define B_AX_RFWD_MSK 0xff

#define R_AX_UART_USR 0x007C

#define R_AX_UART_TFL 0x0080
#define B_AX_TFL_SH 0
#define B_AX_TFL_MSK 0xffffffffL

#define R_AX_UART_RFL 0x0084
#define B_AX_RFL_SH 0
#define B_AX_RFL_MSK 0xffffffffL

#define R_AX_UART_SRR 0x0088
#define B_AX_XFR BIT(2)
#define B_AX_RFR BIT(1)
#define B_AX_UR BIT(0)

#define R_AX_UART_HTX 0x00A4
#define B_AX_HTX BIT(0)

#define R_AX_UART_DMASA 0x00A8
#define B_AX_DMASA BIT(0)

#define R_AX_UART_CPR 0x00F4
#define B_AX_FIFO_MODE_SH 16
#define B_AX_FIFO_MODE_MSK 0xff
#define B_AX_DMA_EXTRA BIT(13)
#define B_AX_UART_ADD_ENCODED_PARAMS BIT(12)
#define B_AX_SHADOW BIT(11)
#define B_AX_FIFO_STAT BIT(10)
#define B_AX_FIFO_ACCESS BIT(9)
#define B_AX_ADDITIONAL_FEAT BIT(8)
#define B_AX_SIR_LP_MODE BIT(7)
#define B_AX_SIR_MODE BIT(6)
#define B_AX_THRE_MODE BIT(5)
#define B_AX_AFCE_MODE BIT(4)
#define B_AX_APB_DATA_WIDTH_SH 0
#define B_AX_APB_DATA_WIDTH_MSK 0x3

#define R_AX_UART_UCV 0x00F8
#define B_AX_UCV_SH 0
#define B_AX_UCV_MSK 0xffffffffL

#define R_AX_UART_CTR 0x00FC
#define B_AX_PID_SH 0
#define B_AX_PID_MSK 0xffffffffL

//
// WL_AX_Reg_UART.xls
//

//
// UART
//

//
// WL_AX_Reg_UART.xls
//

//
// UART
//

//
// WL_AX_Reg_UART.xls
//

//
// UART
//

//
// WL_AX_Reg_WLCPU_Local.xls
//

//
// WLCPU_Local_Reg
//

#define R_AX_MAILBOX_WIFI2BT_DATA_L 0x0000
#define B_AX_MBOX_WIFI2BT_DATA_L_SH 0
#define B_AX_MBOX_WIFI2BT_DATA_L_MSK 0xffffffffL

#define R_AX_MAILBOX_WIFI2BT_DATA_H 0x0004
#define B_AX_MBOX_WIFI2BT_DATA_H_SH 0
#define B_AX_MBOX_WIFI2BT_DATA_H_MSK 0xffffffffL

#define R_AX_MAILBOX_WIFI2BT_READY 0x0008
#define B_AX_MBOX_OUT_ABORT BIT(7)
#define B_AX_MBOX_ACK_WIFI2BT BIT(0)

#define R_AX_MAILBOX_BT2WIFI_DATA_L 0x0010
#define B_AX_MBOX_BT2WIFI_DATA_L_SH 0
#define B_AX_MBOX_BT2WIFI_DATA_L_MSK 0xffffffffL

#define R_AX_MAILBOX_BT2WIFI_DATA_H 0x0014
#define B_AX_MBOX_BT2WIFI_DATA_H_SH 0
#define B_AX_MBOX_BT2WIFI_DATA_H_MSK 0xffffffffL

#define R_AX_MAILBOX_CTRL 0x0018
#define B_AX_MBOX_ACK_BT2WIFI BIT(0)

#define R_AX_EXC_JUMP_ADDR 0x0020
#define B_AX_WLCPU_EXC_JUMP_ADDR_SH 0
#define B_AX_WLCPU_EXC_JUMP_ADDR_MSK 0xffffffffL

#define R_AX_CPU_BOOT_ADDR 0x0024
#define B_AX_WLCPU_BOOT_ADDR_SH 0
#define B_AX_WLCPU_BOOT_ADDR_MSK 0xffffffffL

#define R_AX_CPU_IDMEM_TO_CNT 0x0030
#define B_AX_CPU_DMEM_TO_CNT_TH_SH 16
#define B_AX_CPU_DMEM_TO_CNT_TH_MSK 0xffff
#define B_AX_CPU_IMEM_TO_CNT_TH_SH 0
#define B_AX_CPU_IMEM_TO_CNT_TH_MSK 0xffff

#define R_AX_IO_HANG_ADDR  0x003C
#define B_AX_IO_HANG_ADDR_SH 0
#define B_AX_IO_HANG_ADDR_MSK 0xffffffffL

#define R_AX_WDT_CTRL 0x0040
#define B_AX_WDT_EN BIT(31)
#define B_AX_WDT_OPT_RESET_PLATFORM_EN BIT(29)
#define B_AX_IO_HANG_IMR BIT(27)
#define B_AX_IO_HANG_CMAC_RDATA_EN BIT(26)
#define B_AX_IO_HANG_DMAC_EN BIT(25)
#define B_AX_WDT_CLR BIT(16)
#define B_AX_WDT_COUNT_SH 0
#define B_AX_WDT_COUNT_MSK 0xffff

#define R_AX_WDT_STATUS 0x0044
#define B_AX_FS_WDT_INT BIT(8)
#define B_AX_FS_WDT_INT_MSK BIT(0)

#define R_AX_WDT_CDC 0x0048
#define B_AX_WDT_CDC_SH 0
#define B_AX_WDT_CDC_MSK 0xffff

#define R_AX_INT1_CTRL_IND 0x0050
#define B_AX_FWC_INT_IND_SH 0
#define B_AX_FWC_INT_IND_MSK 0xffffffffL

#define R_AX_INT2_CTRL_IND 0x0054
#define B_AX_FWD_INT_IND_SH 0
#define B_AX_FWD_INT_IND_MSK 0x7

#define R_AX_INT3_CTRL_IND 0x0058
#define B_AX_FWS_INT_IND BIT(0)

#define R_AX_INT4_CTRL_IND 0x005C
#define B_AX_FWDA_INT_IND_SH 0
#define B_AX_FWDA_INT_IND_MSK 0x7

#define R_AX_INT5_CTRL_IND 0x0060
#define B_AX_SUB_SYS_ERR_IND_SH 29
#define B_AX_SUB_SYS_ERR_IND_MSK 0x7
#define B_AX_BACKDOOR_IND BIT(28)
#define B_AX_FWP_INT_IND_SH 0
#define B_AX_FWP_INT_IND_MSK 0x7

#define R_AX_USB_CTRL 0x0080
#define B_AX_USB2_SUSB_STS BIT(7)
#define B_AX_USB3_SUSB_STS BIT(6)
#define B_AX_ALLOW_WAKE_HOST BIT(5)
#define B_AX_WLCPU_WAKE_USB BIT(4)

//
// WL_AX_Reg_WLCPU_Local.xls
//

//
// WLCPU_Local_Reg
//

//
// WL_AX_Reg_WLCPU_Local.xls
//

//
// WLCPU_Local_Reg
//

#define R_AX_TR9_MSMMUPFN 0x0028
#define B_AX_TR9_MSMMUPFN_SH 0
#define B_AX_TR9_MSMMUPFN_MSK 0xffffffffL

#define R_AX_TR9_TIMER_BASE 0x002C
#define B_AX_TR9_TIMER_BASE_SH 0
#define B_AX_TR9_TIMER_BASE_MSK 0xffffffffL

#define R_AX_TR9_TIMER_CLK 0x0038
#define B_AX_TR9_TIMER_CLK_EN BIT(31)

#define R_AX_APB_HANG_ADDR 0x003C
#define B_AX_APB_HANG_ADDR_SH 0
#define B_AX_APB_HANG_ADDR_MSK 0xffffffffL

#define R_AX_INT0_CTRL_IND 0x004C
#define B_AX_FWD0_INT_IND_SH 0
#define B_AX_FWD0_INT_IND_MSK 0x7
#define B_AX_FWS_INT_IND_V1_SH 0
#define B_AX_FWS_INT_IND_V1_MSK 0x3
#define B_AX_APB_HANG_IND BIT(28)
#define B_AX_SUB_BB_ERR_IND_HIGH0 BIT(27)
#define B_AX_SUB_BB_ERR_IND_LOW0 BIT(26)
#define B_AX_SUB_BB_ERR_IND_HIGH1 BIT(25)
#define B_AX_SUB_BB_ERR_IND_LOW1 BIT(24)
#define B_AX_AHB_HANG_IND BIT(23)
#define B_AX_HCI_ILLEGAL_CMD_IND BIT(22)

#define R_AX_INT6_CTRL_IND 0x0064
#define B_AX_RXI300_INT_IND BIT(0)

#define R_AX_INT7_CTRL_IND 0x0068
#define B_AX_PAXIDMA_INT_IND BIT(0)

#define R_AX_INT8_CTRL_IND 0x006C
#define B_AX_FWP_INT_IND_V1_SH 0
#define B_AX_FWP_INT_IND_V1_MSK 0x3

#define R_AX_SUB_BB_ERR_IMR 0x0070
#define B_AX_SUB_BB_ERR_IMR_HIGH0 BIT(27)
#define B_AX_SUB_BB_ERR_IMR_LOW0 BIT(26)
#define B_AX_SUB_BB_ERR_IMR_HIGH1 BIT(25)
#define B_AX_SUB_BB_ERR_IMR_LOW1 BIT(24)

#define R_AX_SW_ISR_CTRL 0x0074
#define B_AX_SW_ISR_EN BIT(31)
#define B_AX_SW_ISR_CLR BIT(16)
#define B_AX_SW_ISR_COUNT_SH 0
#define B_AX_SW_ISR_COUNT_MSK 0xffff

#define R_AX_SW_ISR_STATUS 0x0078
#define B_AX_FS_SW_ISR_INT BIT(8)
#define B_AX_FS_SW_ISR_MSK BIT(0)

#define R_AX_SW_ISR_CDC 0x007C
#define B_AX_SW_ISR_CDC_SH 0
#define B_AX_SW_ISR_CDC_MSK 0xffff

#define R_AX_APB_AHB 0x0080
#define B_AX_AHB_FIXHANG_IMR BIT(29)
#define B_AX_APB_FIXHANG_IMR BIT(28)
#define B_AX_HCI_ILLEGAL_CMD_IMR BIT(27)
#define B_AX_APB_SLAVE_EN_SH 0
#define B_AX_APB_SLAVE_EN_MSK 0x3ff

#define R_AX_AHB_HANG_ADDR 0x008C
#define B_AX_AHB_HANG_ADDR_SH 0
#define B_AX_AHB_HANG_ADDR_MSK 0xffffffffL

#define R_AX_PHYREG_SET_V1 0x009C
#define B_AX_PHYREG_SET_F_SH 9
#define B_AX_PHYREG_SET_F_MSK 0x3
#define B_AX_PHYREG_VALUE_X_SH 6
#define B_AX_PHYREG_VALUE_X_MSK 0x7
#define B_AX_PHYREG_VALUE_N_SH 3
#define B_AX_PHYREG_VALUE_N_MSK 0x7
#define B_AX_PHYREG_VALUE_Y_SH 0
#define B_AX_PHYREG_VALUE_Y_MSK 0x7

#define R_AX_BIST_MCU_CTRL1 0x0100
#define B_AX_BIST_TMCK_W BIT(15)
#define B_AX_BIST_DYN_READ_EN BIT(14)
#define B_AX_BIST_LOOP_MODE BIT(13)
#define B_AX_BIST_LVDRF_CLKDIS BIT(12)
#define B_AX_BIST_ROM_MISR_SEL_SH 8
#define B_AX_BIST_ROM_MISR_SEL_MSK 0xf
#define B_AX_BIST_DRF_RESUME BIT(3)
#define B_AX_BIST_DRF_MODE BIT(2)
#define B_AX_BIST_MODE BIT(1)
#define B_AX_BIST_RESET_ALL BIT(0)

#define R_AX_BIST_MCU_CTRL2 0x0104
#define B_AX_WLMCU_MEM_RMV_FABDBG_SH 30
#define B_AX_WLMCU_MEM_RMV_FABDBG_MSK 0x3
#define B_AX_WLMCU_RMV_SIGN BIT(29)
#define B_AX_WLMCU_RMV_2PRF BIT(27)
#define B_AX_WLMCU_RMV_1PRF BIT(26)
#define B_AX_WLMCU_RMV_1PSR BIT(25)
#define B_AX_WLMCU_RMV_ROM BIT(24)
#define B_AX_WLMCU_READ_MARGIN_EN_SH 4
#define B_AX_WLMCU_READ_MARGIN_EN_MSK 0xf

#define R_AX_BIST_MCU_RESET 0x0108
#define B_AX_WLMCU_MBIST_RESET_SH 0
#define B_AX_WLMCU_MBIST_RESET_MSK 0x7ffffff

#define R_AX_BIST_MCU_DONE 0x010C
#define B_AX_WLMCU_MBIST_DONE_SH 0
#define B_AX_WLMCU_MBIST_DONE_MSK 0x7ffffff

#define R_AX_BIST_MCU_FAIL 0x0110
#define B_AX_WLMCU_MBIST_FAIL_SH 0
#define B_AX_WLMCU_MBIST_FAIL_MSK 0x7ffffff

#define R_AX_BIST_MCU_DRF_PAUSE 0x0114
#define B_AX_WLMCU_MBIST_DRF_PAUSE_SH 0
#define B_AX_WLMCU_MBIST_DRF_PAUSE_MSK 0x7ffffff

#define R_AX_BIST_MCU_ROM_MISR_OUT 0x0118
#define B_AX_WLMCU_MBIST_ROM_MISR_OUT_SH 0
#define B_AX_WLMCU_MBIST_ROM_MISR_OUT_MSK 0xffffffffL

//
// WL_AX_Reg_WLCPU_Local.xls
//

//
// WLCPU_Local_Reg
//

#endif
