#ifndef __HCI_REG_BE_H__
#define __HCI_REG_BE_H__

//
// WL_BE_Reg_GMAC.xls
//

//
// GMAC
//

#define R_BE_GMAC_IDR0 0x4800
#define B_BE_GMAC_IDR0_SH 24
#define B_BE_GMAC_IDR0_MSK 0xff
#define B_BE_GMAC_IDR1_SH 16
#define B_BE_GMAC_IDR1_MSK 0xff
#define B_BE_GMAC_IDR2_SH 8
#define B_BE_GMAC_IDR2_MSK 0xff
#define B_BE_GMAC_IDR3_SH 0
#define B_BE_GMAC_IDR3_MSK 0xff

#define R_BE_GMAC_IDR1 0x4804
#define B_BE_GMAC_IDR4_SH 24
#define B_BE_GMAC_IDR4_MSK 0xff
#define B_BE_GMAC_IDR5_SH 16
#define B_BE_GMAC_IDR5_MSK 0xff

#define R_BE_GMAC_MAR0 0x4808
#define B_BE_GMAC_MAR0_SH 24
#define B_BE_GMAC_MAR0_MSK 0xff
#define B_BE_GMAC_MAR1_SH 16
#define B_BE_GMAC_MAR1_MSK 0xff
#define B_BE_GMAC_MAR2_SH 8
#define B_BE_GMAC_MAR2_MSK 0xff
#define B_BE_GMAC_MAR3_SH 0
#define B_BE_GMAC_MAR3_MSK 0xff

#define R_BE_GMAC_MAR1 0x480C
#define B_BE_GMAC_MAR4_SH 24
#define B_BE_GMAC_MAR4_MSK 0xff
#define B_BE_GMAC_MAR5_SH 16
#define B_BE_GMAC_MAR5_MSK 0xff
#define B_BE_GMAC_MAR6_SH 8
#define B_BE_GMAC_MAR6_MSK 0xff
#define B_BE_GMAC_MAR7_SH 0
#define B_BE_GMAC_MAR7_MSK 0xff

#define R_BE_GMAC_TXOKCNT 0x4810
#define B_BE_GMAC_TXOK_SH 16
#define B_BE_GMAC_TXOK_MSK 0xffff
#define B_BE_GMAC_RXOK_SH 0
#define B_BE_GMAC_RXOK_MSK 0xffff

#define R_BE_GMAC_TXERRCNT 0x4814
#define B_BE_GMAC_TXERR_SH 16
#define B_BE_GMAC_TXERR_MSK 0xffff
#define B_BE_GMAC_RXERR_SH 0
#define B_BE_GMAC_RXERR_MSK 0xffff

#define R_BE_GMAC_MISSPKTCNT 0x4818
#define B_BE_GMAC_MISSPKT_SH 16
#define B_BE_GMAC_MISSPKT_MSK 0xffff
#define B_BE_GMAC_FAE_SH 0
#define B_BE_GMAC_FAE_MSK 0xffff

#define R_BE_GMAC_TX1COLCNT 0x481C
#define B_BE_GMAC_TX1COL_SH 16
#define B_BE_GMAC_TX1COL_MSK 0xffff
#define B_BE_GMAC_TXMCOL_SH 0
#define B_BE_GMAC_TXMCOL_MSK 0xffff

#define R_BE_GMAC_RXOKCNT 0x4820
#define B_BE_GMAC_RXOKPHY_SH 16
#define B_BE_GMAC_RXOKPHY_MSK 0xffff
#define B_BE_GMAC_RXOKBRD_SH 0
#define B_BE_GMAC_RXOKBRD_MSK 0xffff

#define R_BE_GMAC_RXOKMULCNT 0x4824
#define B_BE_GMAC_RXOKMUL_SH 16
#define B_BE_GMAC_RXOKMUL_MSK 0xffff
#define B_BE_GMAC_RXOKABT_SH 0
#define B_BE_GMAC_RXOKABT_MSK 0xffff

#define R_BE_GMAC_TXUNDERCNT 0x4828
#define B_BE_GMAC_TXUNDERC_SH 16
#define B_BE_GMAC_TXUNDERC_MSK 0xffff
#define B_BE_GMAC_RDU_MISSPKTC_SH 0
#define B_BE_GMAC_RDU_MISSPKTC_MSK 0xffff

#define R_BE_GMAC_TRXR 0x4834
#define B_BE_GMAC_TXUNDER BIT(2)

#define R_BE_GMAC_COM 0x4838
#define B_BE_GMAC_COUNTER_RST BIT(6)
#define B_BE_GMAC_R_TDSC_DEBUG BIT(5)
#define B_BE_GMAC_R_DISABLE_LSO_ERR BIT(4)
#define B_BE_GMAC_RXJUMBO BIT(3)
#define B_BE_GMAC_RXVLAN BIT(2)
#define B_BE_GMAC_RXCHKSUM BIT(1)
#define B_BE_GMAC_RST BIT(0)

#define R_BE_GMAC_IMSR 0x483C
#define B_BE_GMAC_RDU6_EN BIT(31)
#define B_BE_GMAC_RDU5_EN BIT(30)
#define B_BE_GMAC_RDU4_EN BIT(29)
#define B_BE_GMAC_RDU3_EN BIT(28)
#define B_BE_GMAC_RDU2_EN BIT(27)
#define B_BE_GMAC_SWINT_EN BIT(26)
#define B_BE_GMAC_TDU_EN BIT(25)
#define B_BE_GMAC_LINKCHG_EN BIT(24)
#define B_BE_GMAC_TER_EN BIT(23)
#define B_BE_GMAC_TOK_TI_EN BIT(22)
#define B_BE_GMAC_RDU_EN BIT(21)
#define B_BE_GMAC_PER_OVF_EN BIT(20)
#define B_BE_GMAC_HW_TXU1_ERR_EN BIT(19)
#define B_BE_GMAC_PER_RUNT_EN BIT(18)
#define B_BE_GMAC_CNT_WRAP_EN BIT(17)
#define B_BE_GMAC_ROK_EN BIT(16)
#define B_BE_GMAC_RDU6 BIT(15)
#define B_BE_GMAC_RDU5 BIT(14)
#define B_BE_GMAC_RDU4 BIT(13)
#define B_BE_GMAC_RDU3 BIT(12)
#define B_BE_GMAC_RDU2 BIT(11)
#define B_BE_GMAC_SWINT BIT(10)
#define B_BE_GMAC_TDU BIT(9)
#define B_BE_GMAC_LINKCHG BIT(8)
#define B_BE_GMAC_TER BIT(7)
#define B_BE_GMAC_TOK_TI BIT(6)
#define B_BE_GMAC_RDU BIT(5)
#define B_BE_GMAC_PER_OVF BIT(4)
#define B_BE_GMAC_HW_TXU1_ERR BIT(3)
#define B_BE_GMAC_PER_RUNT BIT(2)
#define B_BE_GMAC_CNT_WRAP BIT(1)
#define B_BE_GMAC_ROK BIT(0)

#define R_BE_GMAC_TCR 0x4840
#define B_BE_GMAC_PREAMBLE_SEL_SH 16
#define B_BE_GMAC_PREAMBLE_SEL_MSK 0xf
#define B_BE_GMAC_R_TX_JUMBO BIT(15)
#define B_BE_GMAC_R_TXCS_IPLEN BIT(14)
#define B_BE_GMAC_IFG_SEL_SH 10
#define B_BE_GMAC_IFG_SEL_MSK 0x7
#define B_BE_GMAC_LBK_SH 8
#define B_BE_GMAC_LBK_MSK 0x3
#define B_BE_GMAC_R_TX_MULTIPKT_CNT_PAUSE BIT(1)
#define B_BE_GMAC_R_TX_NOPADDING BIT(0)

#define R_BE_GMAC_RCR 0x4844
#define B_BE_GMAC_FRAG_TIMEOUT_SH 11
#define B_BE_GMAC_FRAG_TIMEOUT_MSK 0xf
#define B_BE_GMAC_ACCEPT_TCPCSERR BIT(10)
#define B_BE_GMAC_ACCEPT_UDPCSERR BIT(9)
#define B_BE_GMAC_ACCEPT_IPCSERR BIT(8)
#define B_BE_GMAC_HOMEPNA BIT(7)
#define B_BE_GMAC_AFLOW BIT(6)
#define B_BE_GMAC_ACCEPT_CERERR BIT(5)
#define B_BE_GMAC_ACCEPT_RUNT BIT(4)
#define B_BE_GMAC_ACCEPT_BROADCAST BIT(3)
#define B_BE_GMAC_ACCEPT_MULTICAST BIT(2)
#define B_BE_GMAC_APM BIT(1)
#define B_BE_GMAC_AAP BIT(0)

#define R_BE_GMAC_CPUTAG0 0x4848
#define B_BE_GMAC_CTEN_RX BIT(31)
#define B_BE_GMAC_CT_TSIZE_SH 27
#define B_BE_GMAC_CT_TSIZE_MSK 0xf
#define B_BE_GMAC_CT_RSIZE_H_SH 25
#define B_BE_GMAC_CT_RSIZE_H_MSK 0x3
#define B_BE_GMAC_CT_DSLRN BIT(24)
#define B_BE_GMAC_CT_NORMK BIT(23)
#define B_BE_GMAC_CT_ASPRI BIT(22)
#define B_BE_GMAC_CT_SWITCH_SH 18
#define B_BE_GMAC_CT_SWITCH_MSK 0xf
#define B_BE_GMAC_CT_RSIZE_L_SH 16
#define B_BE_GMAC_CT_RSIZE_L_MSK 0x3
#define B_BE_GMAC_CTPM_SH 8
#define B_BE_GMAC_CTPM_MSK 0xff
#define B_BE_GMAC_CTPV_SH 0
#define B_BE_GMAC_CTPV_MSK 0xff

#define R_BE_GMAC_CONFIG 0x484C
#define B_BE_GMAC_R_LXM64 BIT(31)
#define B_BE_GMAC_RFF_SIZE_SEL_SH 28
#define B_BE_GMAC_RFF_SIZE_SEL_MSK 0x3
#define B_BE_GMAC_TSO_ID_SEL BIT(27)
#define B_BE_GMAC_EN_INT_ROUTE BIT(25)
#define B_BE_GMAC_EN_INT_SPLIT BIT(24)
#define B_BE_GMAC_R_EN_RFF_AFULL BIT(23)
#define B_BE_GMAC_R_RXDV_EXTRA BIT(22)
#define B_BE_GMAC_R_HW_FLOWCTRL BIT(21)
#define B_BE_GMAC_R_EN_TX_EXTRA BIT(16)

#define R_BE_GMAC_CPUTAG1 0x4850
#define B_BE_GMAC_R_REASON_FB_SH 16
#define B_BE_GMAC_R_REASON_FB_MSK 0xff
#define B_BE_GMAC_R_STREAMID_SH 8
#define B_BE_GMAC_R_STREAMID_MSK 0x7f

#define R_BE_GMAC_MICR 0x4854
#define B_BE_GMAC_DIS_DLY_MODE BIT(6)
#define B_BE_GMAC_SET_D_TXC BIT(5)
#define B_BE_GMAC_RXC_DLY_SEL_SH 0
#define B_BE_GMAC_RXC_DLY_SEL_MSK 0x1f

#define R_BE_GMAC_MSR 0x4858
#define B_BE_GMAC_FORCE_TRXFCE BIT(31)
#define B_BE_GMAC_RXFCE BIT(30)
#define B_BE_GMAC_TXFCE BIT(29)
#define B_BE_GMAC_SPEED_1000 BIT(28)
#define B_BE_GMAC_SPEED_10 BIT(27)
#define B_BE_GMAC_LINKB BIT(26)
#define B_BE_GMAC_TXPF BIT(25)
#define B_BE_GMAC_RXPF BIT(24)
#define B_BE_GMAC_SEL_RGMII BIT(23)
#define B_BE_GMAC_FULLDUPREG BIT(22)
#define B_BE_GMAC_NWCOMPLETE BIT(21)
#define B_BE_GMAC_SEL_MII BIT(20)
#define B_BE_GMAC_FORCEDFULLDUP BIT(19)
#define B_BE_GMAC_FORCELINK BIT(18)
#define B_BE_GMAC_FORCE_SPD_SH 16
#define B_BE_GMAC_FORCE_SPD_MSK 0x3
#define B_BE_GMAC_GMAC_SEL_PHYIF_0 BIT(15)
#define B_BE_GMAC_GMAC_PHY_MODE BIT(13)
#define B_BE_GMAC_RGMII_RX_DECODE_STS BIT(12)
#define B_BE_GMAC_RGMII_TX_ENCODE_STS BIT(11)
#define B_BE_GMAC_FORCE_SPD_MODE BIT(10)
#define B_BE_GMAC_EEE_ABY_SH 8
#define B_BE_GMAC_EEE_ABY_MSK 0x3

#define R_BE_GMAC_MIIAR 0x485C
#define B_BE_GMAC_FLAG BIT(31)
#define B_BE_GMAC_PHYADDRESS_SH 26
#define B_BE_GMAC_PHYADDRESS_MSK 0x1f
#define B_BE_GMAC_EN_EEEP_AUTO_WRITE BIT(23)
#define B_BE_GMAC_DISABLE_AUTO_POLLING BIT(22)
#define B_BE_GMAC_POLLING_EEE_REG BIT(21)
#define B_BE_GMAC_REGADDR_SH 16
#define B_BE_GMAC_REGADDR_MSK 0x1f
#define B_BE_GMAC_DATA_SH 0
#define B_BE_GMAC_DATA_MSK 0xffff

#define R_BE_GMAC_SWINT 0x4860
#define B_BE_GMAC_SWINT_TRIGGER BIT(24)

#define R_BE_GMAC_VLAN_REG 0x4864
#define B_BE_GMAC_STAG_PID_SH 16
#define B_BE_GMAC_STAG_PID_MSK 0xffff
#define B_BE_GMAC_R_EN_RSTAG BIT(15)
#define B_BE_GMAC_R_EN_TSTAG BIT(14)

#define R_BE_GMAC_VLAN_REG1 0x4868
#define B_BE_GMAC_R_EN_RSTAG1 BIT(15)
#define B_BE_GMAC_R_EN_TSTAG1 BIT(14)

#define R_BE_GMAC_LED_CTRL 0x4870
#define B_BE_GMAC_EEE_EN_LED BIT(19)
#define B_BE_GMAC_CUSTOM_LED BIT(18)
#define B_BE_GMAC_LEDSEL_SH 16
#define B_BE_GMAC_LEDSEL_MSK 0x3
#define B_BE_GMAC_LEDSE3_SH 12
#define B_BE_GMAC_LEDSE3_MSK 0xf
#define B_BE_GMAC_LEDSE2_SH 8
#define B_BE_GMAC_LEDSE2_MSK 0xf
#define B_BE_GMAC_LEDSE1_SH 4
#define B_BE_GMAC_LEDSE1_MSK 0xf
#define B_BE_GMAC_LEDSE0_SH 0
#define B_BE_GMAC_LEDSE0_MSK 0xf

#define R_BE_GMAC_ETHP_CTRL 0x4874
#define B_BE_GMAC_TX_EN BIT(31)
#define B_BE_GMAC_RX_EN BIT(30)
#define B_BE_GMAC_TX_IDLE BIT(29)
#define B_BE_GMAC_RX_IDLE BIT(28)
#define B_BE_GMAC_ETHP1_EN BIT(7)
#define B_BE_GMAC_ETHP1_PROTO_EN BIT(6)
#define B_BE_GMAC_ETHP1_DESC_EN BIT(5)
#define B_BE_GMAC_ETHP0_EN BIT(3)
#define B_BE_GMAC_ETHP0_PROTO_EN BIT(2)
#define B_BE_GMAC_ETHP0_DESC_EN BIT(1)

#define R_BE_GMAC_IO_CTRL 0x4878
#define B_BE_GMAC_HOST_MRU_SH 16
#define B_BE_GMAC_HOST_MRU_MSK 0x7fff
#define B_BE_GMAC_INTERRUPT_MODE BIT(9)
#define B_BE_GMAC_FRAG_EN BIT(5)
#define B_BE_GMAC_RXFTH_SH 2
#define B_BE_GMAC_RXFTH_MSK 0x3
#define B_BE_GMAC_TXFTH_SH 0
#define B_BE_GMAC_TXFTH_MSK 0x3

#define R_BE_GMAC_MEM_BIST 0x4880
#define B_BE_GMAC_DRF_BIST_DONE BIT(31)
#define B_BE_GMAC_BIST_DONE BIT(30)
#define B_BE_GMAC_DRF_RFF_FAIL BIT(29)
#define B_BE_GMAC_DRF_TFF_FAIL BIT(28)
#define B_BE_GMAC_RFF_FAIL BIT(27)
#define B_BE_GMAC_TFF_FAIL BIT(26)
#define B_BE_GMAC_CSR_RFF_DVSE BIT(11)
#define B_BE_GMAC_CSR_RFF_DVS_SH 8
#define B_BE_GMAC_CSR_RFF_DVS_MSK 0x7
#define B_BE_GMAC_CSR_TFF_DVSE BIT(3)
#define B_BE_GMAC_CSR_TFF_DVS_SH 0
#define B_BE_GMAC_CSR_TFF_DVS_MSK 0x7

#define R_BE_GMAC_PKTGEN 0x4884
#define B_BE_GMAC_EN_PGLBK BIT(15)
#define B_BE_GMAC_PGLBK_DATA_PAT_SEL BIT(14)
#define B_BE_GMAC_PGLBK_DONE BIT(13)
#define B_BE_GMAC_PGLBK_FAIL BIT(12)
#define B_BE_GMAC_PBLBK_PKT_LENGTH_SEL BIT(11)
#define B_BE_GMAC_PGLBK_PKT_NUM_SEL_SH 9
#define B_BE_GMAC_PGLBK_PKT_NUM_SEL_MSK 0x3
#define B_BE_GMAC_R_DISABLE_TXCRC BIT(8)
#define B_BE_GMAC_PGLBK_DATA_PAT_SH 0
#define B_BE_GMAC_PGLBK_DATA_PAT_MSK 0xff

#define R_BE_GMAC_EEE_CR1 0x4888
#define B_BE_GMAC_EN_FRC_EEE BIT(31)
#define B_BE_GMAC_FRC_EEE_GIGA BIT(30)
#define B_BE_GMAC_FRC_EEE_100M BIT(29)
#define B_BE_GMAC_EN_EEE_10M BIT(28)
#define B_BE_GMAC_EN_EEE_TX BIT(27)
#define B_BE_GMAC_EN_EEE_RX BIT(26)
#define B_BE_GMAC_EEE_OUTQ_LOWQ_OVER BIT(23)
#define B_BE_GMAC_EEE_STS BIT(19)
#define B_BE_GMAC_EEE_TX_STS BIT(18)
#define B_BE_GMAC_EEE_RX_STS BIT(17)
#define B_BE_GMAC_EEE_PAUSEFLAG BIT(16)
#define B_BE_GMAC_EEE_WAKE_SET1 BIT(14)
#define B_BE_GMAC_EEE_WAKE_SET0 BIT(13)
#define B_BE_GMAC_EEE_REQ_SET2 BIT(12)
#define B_BE_GMAC_EEE_REQ_SET1 BIT(11)
#define B_BE_GMAC_EEE_REQ_SET0 BIT(10)
#define B_BE_GMAC_EEE_RXTIMER_EN BIT(9)
#define B_BE_GMAC_EEE_TXTIMER_EN BIT(8)
#define B_BE_GMAC_EEE_TIMER_UNIT_GIGA_1_SH 6
#define B_BE_GMAC_EEE_TIMER_UNIT_GIGA_1_MSK 0x3
#define B_BE_GMAC_EEE_TIMER_UNIT_GIGA_2_SH 4
#define B_BE_GMAC_EEE_TIMER_UNIT_GIGA_2_MSK 0x3
#define B_BE_GMAC_EEE_TIMER_UNIT_100_1_SH 2
#define B_BE_GMAC_EEE_TIMER_UNIT_100_1_MSK 0x3
#define B_BE_GMAC_EEE_TIMER_UNIT_100_2_SH 0
#define B_BE_GMAC_EEE_TIMER_UNIT_100_2_MSK 0x3

#define R_BE_GMAC_EEE_CR2 0x488C
#define B_BE_GMAC_EEE_TIMER_TW_GIGA_SH 24
#define B_BE_GMAC_EEE_TIMER_TW_GIGA_MSK 0xff
#define B_BE_GMAC_EEE_TIMER_TR_GIGA_SH 16
#define B_BE_GMAC_EEE_TIMER_TR_GIGA_MSK 0xff
#define B_BE_GMAC_EEE_TIMER_TD_GIGA_SH 8
#define B_BE_GMAC_EEE_TIMER_TD_GIGA_MSK 0xff
#define B_BE_GMAC_EEE_TIMER_TP_GIGA_SH 0
#define B_BE_GMAC_EEE_TIMER_TP_GIGA_MSK 0xff

#define R_BE_GMAC_EEE_CR3 0x4890
#define B_BE_GMAC_EEE_TIMER_TW_100_SH 24
#define B_BE_GMAC_EEE_TIMER_TW_100_MSK 0xff
#define B_BE_GMAC_EEE_TIMER_TR_100_SH 16
#define B_BE_GMAC_EEE_TIMER_TR_100_MSK 0xff
#define B_BE_GMAC_EEE_TIMER_TD_100_SH 8
#define B_BE_GMAC_EEE_TIMER_TD_100_MSK 0xff
#define B_BE_GMAC_EEE_TIMER_TP_100_SH 0
#define B_BE_GMAC_EEE_TIMER_TP_100_MSK 0xff

#define R_BE_GMAC_EEE_CR4 0x4894
#define B_BE_GMAC_EEE_TX_THR_GIGA_SH 16
#define B_BE_GMAC_EEE_TX_THR_GIGA_MSK 0xffff
#define B_BE_GMAC_EEE_TX_THR_100_SH 0
#define B_BE_GMAC_EEE_TX_THR_100_MSK 0xffff

#define R_BE_GMAC_EEE_LPI_TM0 0x4898
#define B_BE_GMAC_EEE_RXLPI_TIME_SH 0
#define B_BE_GMAC_EEE_RXLPI_TIME_MSK 0x3fffff

#define R_BE_GMAC_EEE_LPI_TM1 0x489C
#define B_BE_GMAC_EEE_STOP_TXC BIT(23)
#define B_BE_GMAC_EEE_TRXCTL_LEVEL BIT(22)
#define B_BE_GMAC_EEE_TXLPI_TIME_SH 0
#define B_BE_GMAC_EEE_TXLPI_TIME_MSK 0x3fffff

#define R_BE_GMAC_IMR0 0x48D0
#define B_BE_GMAC_IMR0_TDU5 BIT(28)
#define B_BE_GMAC_IMR0_TDU4 BIT(27)
#define B_BE_GMAC_IMR0_TDU3 BIT(26)
#define B_BE_GMAC_IMR0_TDU2 BIT(25)
#define B_BE_GMAC_IMR0_TDU1 BIT(24)
#define B_BE_GMAC_IMR0_TOK5 BIT(20)
#define B_BE_GMAC_IMR0_TOK4 BIT(19)
#define B_BE_GMAC_IMR0_TOK3 BIT(18)
#define B_BE_GMAC_IMR0_TOK2 BIT(17)
#define B_BE_GMAC_IMR0_TOK1 BIT(16)
#define B_BE_GMAC_IMR0_ROK6 BIT(5)
#define B_BE_GMAC_IMR0_ROK5 BIT(4)
#define B_BE_GMAC_IMR0_ROK4 BIT(3)
#define B_BE_GMAC_IMR0_ROK3 BIT(2)
#define B_BE_GMAC_IMR0_ROK2 BIT(1)
#define B_BE_GMAC_IMR0_ROK1 BIT(0)

#define R_BE_GMAC_IMR1 0x48D4
#define B_BE_GMAC_IMR1_TDU5 BIT(28)
#define B_BE_GMAC_IMR1_TDU4 BIT(27)
#define B_BE_GMAC_IMR1_TDU3 BIT(26)
#define B_BE_GMAC_IMR1_TDU2 BIT(25)
#define B_BE_GMAC_IMR1_TDU1 BIT(24)
#define B_BE_GMAC_IMR1_TOK5 BIT(20)
#define B_BE_GMAC_IMR1_TOK4 BIT(19)
#define B_BE_GMAC_IMR1_TOK3 BIT(18)
#define B_BE_GMAC_IMR1_TOK2 BIT(17)
#define B_BE_GMAC_IMR1_TOK1 BIT(16)
#define B_BE_GMAC_IMR1_RDU6 BIT(13)
#define B_BE_GMAC_IMR1_RDU5 BIT(12)
#define B_BE_GMAC_IMR1_RDU4 BIT(11)
#define B_BE_GMAC_IMR1_RDU3 BIT(10)
#define B_BE_GMAC_IMR1_RDU2 BIT(9)
#define B_BE_GMAC_IMR1_RDU1 BIT(8)
#define B_BE_GMAC_IMR1_ROK6 BIT(5)
#define B_BE_GMAC_IMR1_ROK5 BIT(4)
#define B_BE_GMAC_IMR1_ROK4 BIT(3)
#define B_BE_GMAC_IMR1_ROK3 BIT(2)
#define B_BE_GMAC_IMR1_ROK2 BIT(1)
#define B_BE_GMAC_IMR1_ROK1 BIT(0)

#define R_BE_GMAC_ISR1 0x48D8
#define B_BE_GMAC_ISR_TDU5 BIT(28)
#define B_BE_GMAC_ISR_TDU4 BIT(27)
#define B_BE_GMAC_ISR_TDU3 BIT(26)
#define B_BE_GMAC_ISR_TDU2 BIT(25)
#define B_BE_GMAC_ISR_TDU1 BIT(24)
#define B_BE_GMAC_ISR_TOK5 BIT(20)
#define B_BE_GMAC_ISR_TOK4 BIT(19)
#define B_BE_GMAC_ISR_TOK3 BIT(18)
#define B_BE_GMAC_ISR_TOK2 BIT(17)
#define B_BE_GMAC_ISR_TOK1 BIT(16)
#define B_BE_GMAC_ISR_ROK6 BIT(5)
#define B_BE_GMAC_ISR_ROK5 BIT(4)
#define B_BE_GMAC_ISR_ROK4 BIT(3)
#define B_BE_GMAC_ISR_ROK3 BIT(2)
#define B_BE_GMAC_ISR_ROK2 BIT(1)
#define B_BE_GMAC_ISR_ROK1 BIT(0)

#define R_BE_GMAC_INTR 0x48DC
#define B_BE_GMAC_TR5_INT_ROUTING BIT(24)
#define B_BE_GMAC_TR4_INT_ROUTING BIT(22)
#define B_BE_GMAC_TR3_INT_ROUTING BIT(20)
#define B_BE_GMAC_TR2_INT_ROUTING BIT(18)
#define B_BE_GMAC_TR1_INT_ROUTING BIT(16)
#define B_BE_GMAC_RR6_INT_ROUTING BIT(10)
#define B_BE_GMAC_RR5_INT_ROUTING BIT(8)
#define B_BE_GMAC_RR4_INT_ROUTING BIT(6)
#define B_BE_GMAC_RR3_INT_ROUTING BIT(4)
#define B_BE_GMAC_RR2_INT_ROUTING BIT(2)
#define B_BE_GMAC_RR1_INT_ROUTING BIT(0)

#define R_BE_GMAC_INTAGDROPPKT 0x48E8
#define B_BE_GMAC_INTAGDROPPKT_SH 0
#define B_BE_GMAC_INTAGDROPPKT_MSK 0xffffffffL

#define R_BE_GMAC_INRUNTDROPPKT 0x48EC
#define B_BE_GMAC_INRUNTDROPPKT_SH 0
#define B_BE_GMAC_INRUNTDROPPKT_MSK 0xffffffffL

#define R_BE_GMAC_INCRCERRPKT 0x48F0
#define B_BE_GMAC_INCRCERRPKT_SH 0
#define B_BE_GMAC_INCRCERRPKT_MSK 0xffffffffL

#define R_BE_GMAC_INIPCSERRPKT 0x48F4
#define B_BE_GMAC_INIPCSERRPKT_SH 0
#define B_BE_GMAC_INIPCSERRPKT_MSK 0xffffffffL

#define R_BE_GMAC_INUDPCSERRPKT 0x48F8
#define B_BE_GMAC_INUDPCSERRPKT_SH 0
#define B_BE_GMAC_INUDPCSERRPKT_MSK 0xffffffffL

#define R_BE_GMAC_INTCPCSERRPKT 0x48FC
#define B_BE_GMAC_INTCPCSERRPKT_SH 0
#define B_BE_GMAC_INTCPCSERRPKT_MSK 0xffffffffL

#define R_BE_GMAC_RXERRCNT 0x4900
#define B_BE_GMAC_RXERRCNT_SH 0
#define B_BE_GMAC_RXERRCNT_MSK 0xffffffffL

#define R_BE_GMAC_INETHPDROPPKT 0x4904
#define B_BE_GMAC_INETHPDROPPKT_SH 0
#define B_BE_GMAC_INETHPDROPPKT_MSK 0xffffffffL

#define R_BE_GMAC_IFINOCTETS_H 0x4908
#define B_BE_GMAC_IFINOCTETS_H_SH 0
#define B_BE_GMAC_IFINOCTETS_H_MSK 0xffffffffL

#define R_BE_GMAC_IFINOCTETS_L 0x490C
#define B_BE_GMAC_IFINOCTETS_L_SH 0
#define B_BE_GMAC_IFINOCTETS_L_MSK 0xffffffffL

#define R_BE_GMAC_IFINUCPKT_H 0x4910
#define B_BE_GMAC_IFINUCPKT_H_SH 0
#define B_BE_GMAC_IFINUCPKT_H_MSK 0xffffffffL

#define R_BE_GMAC_IFINUCPKT_L 0x4914
#define B_BE_GMAC_IFINUCPKT_L_SH 0
#define B_BE_GMAC_IFINUCPKT_L_MSK 0xffffffffL

#define R_BE_GMAC_IFINMCPKT_H 0x4918
#define B_BE_GMAC_IFINMCPKT_H_SH 0
#define B_BE_GMAC_IFINMCPKT_H_MSK 0xffffffffL

#define R_BE_GMAC_IFINMCPKT_L 0x491C
#define B_BE_GMAC_IFINMCPKT_L_SH 0
#define B_BE_GMAC_IFINMCPKT_L_MSK 0xffffffffL

#define R_BE_GMAC_IFINBCPKT_H 0x4920
#define B_BE_GMAC_IFINBCPKT_H_SH 0
#define B_BE_GMAC_IFINBCPKT_H_MSK 0xffffffffL

#define R_BE_GMAC_IFINBCPKT_L 0x4924
#define B_BE_GMAC_IFINBCPKT_L_SH 0
#define B_BE_GMAC_IFINBCPKT_L_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTOCTETS_H 0x4928
#define B_BE_GMAC_IFOUTOCTETS_H_SH 0
#define B_BE_GMAC_IFOUTOCTETS_H_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTOCTETS_L 0x492C
#define B_BE_GMAC_IFOUTOCTETS_L_SH 0
#define B_BE_GMAC_IFOUTOCTETS_L_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTUCPKT_H 0x4930
#define B_BE_GMAC_IFOUTUCPKT_H_SH 0
#define B_BE_GMAC_IFOUTUCPKT_H_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTUCPKT_L 0x4934
#define B_BE_GMAC_IFOUTUCPKT_L_SH 0
#define B_BE_GMAC_IFOUTUCPKT_L_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTMCPKT_H 0x4938
#define B_BE_GMAC_IFOUTMCPKT_H_SH 0
#define B_BE_GMAC_IFOUTMCPKT_H_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTMCPKT_L 0x493C
#define B_BE_GMAC_IFOUTMCPKT_L_SH 0
#define B_BE_GMAC_IFOUTMCPKT_L_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTBCPKT_H 0x4940
#define B_BE_GMAC_IFOUTBCPKT_H_SH 0
#define B_BE_GMAC_IFOUTBCPKT_H_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTBCPKT_L 0x4944
#define B_BE_GMAC_IFOUTBCPKT_L_SH 0
#define B_BE_GMAC_IFOUTBCPKT_L_MSK 0xffffffffL

#define R_BE_GMAC_IFOUTDISCARDS 0x4948
#define B_BE_GMAC_IFOUTDISCARDS_SH 0
#define B_BE_GMAC_IFOUTDISCARDS_MSK 0xffffffffL

#define R_BE_GMAC_INDECAPPKTS 0x494C
#define B_BE_GMAC_INDECAPPKTS_SH 0
#define B_BE_GMAC_INDECAPPKTS_MSK 0xffffffffL

#define R_BE_GMAC_OUTENCAPPKTS 0x4950
#define B_BE_GMAC_OUTENCAPPKTS_SH 0
#define B_BE_GMAC_OUTENCAPPKTS_MSK 0xffffffffL

#define R_BE_GMAC_INFRAGERRPKT 0x4954
#define B_BE_GMAC_INFRAGERRPKT_SH 0
#define B_BE_GMAC_INFRAGERRPKT_MSK 0xffffffffL

#define R_BE_GMAC_INTXBDABORTCNT 0x4958
#define B_BE_GMAC_INTXBDABORTCNT_SH 0
#define B_BE_GMAC_INTXBDABORTCNT_MSK 0xffffffffL

#define R_BE_GMAC_SDS_CFG1 0x4964
#define B_BE_GMAC_LOAD_SYS_PAR BIT(31)
#define B_BE_GMAC_SDS_REG_RDY BIT(30)
#define B_BE_GMAC_SDS_CD_OUT BIT(19)
#define B_BE_GMAC_SDS_CMD BIT(18)
#define B_BE_GMAC_SDS_CEN_IN BIT(17)
#define B_BE_GMAC_SDS_WE_IN BIT(16)

#define R_BE_GMAC_SDS_CFG2 0x4968
#define B_BE_GMAC_SDS_A_IN_SH 16
#define B_BE_GMAC_SDS_A_IN_MSK 0xffff
#define B_BE_GMAC_SDS_DIO_SH 0
#define B_BE_GMAC_SDS_DIO_MSK 0xffff

#define R_BE_GMAC_ETHP0_0 0x4970
#define B_BE_GMAC_ETHP0_DA5_SH 24
#define B_BE_GMAC_ETHP0_DA5_MSK 0xff
#define B_BE_GMAC_ETHP0_DA4_SH 16
#define B_BE_GMAC_ETHP0_DA4_MSK 0xff
#define B_BE_GMAC_ETHP0_DA3_SH 8
#define B_BE_GMAC_ETHP0_DA3_MSK 0xff
#define B_BE_GMAC_ETHP0_DA2_SH 0
#define B_BE_GMAC_ETHP0_DA2_MSK 0xff

#define R_BE_GMAC_ETHP0_1 0x4974
#define B_BE_GMAC_ETHP0_DA1_SH 24
#define B_BE_GMAC_ETHP0_DA1_MSK 0xff
#define B_BE_GMAC_ETHP0_DA0_SH 16
#define B_BE_GMAC_ETHP0_DA0_MSK 0xff
#define B_BE_GMAC_ETHP0_SA5_SH 8
#define B_BE_GMAC_ETHP0_SA5_MSK 0xff
#define B_BE_GMAC_ETHP0_SA4_SH 0
#define B_BE_GMAC_ETHP0_SA4_MSK 0xff

#define R_BE_GMAC_ETHP0_2 0x4978
#define B_BE_GMAC_ETHP0_SA3_SH 24
#define B_BE_GMAC_ETHP0_SA3_MSK 0xff
#define B_BE_GMAC_ETHP0_SA2_SH 16
#define B_BE_GMAC_ETHP0_SA2_MSK 0xff
#define B_BE_GMAC_ETHP0_SA1_SH 8
#define B_BE_GMAC_ETHP0_SA1_MSK 0xff
#define B_BE_GMAC_ETHP0_SA0_SH 0
#define B_BE_GMAC_ETHP0_SA0_MSK 0xff

#define R_BE_GMAC_ETHP0_3 0x497C
#define B_BE_GMAC_ETHP0_TYPE1_SH 24
#define B_BE_GMAC_ETHP0_TYPE1_MSK 0xff
#define B_BE_GMAC_ETHP0_TYPE0_SH 16
#define B_BE_GMAC_ETHP0_TYPE0_MSK 0xff
#define B_BE_GMAC_ETHP0_PROTO_SH 8
#define B_BE_GMAC_ETHP0_PROTO_MSK 0xff
#define B_BE_GMAC_ETHP0_LS BIT(7)
#define B_BE_GMAC_ETHP0_INT BIT(5)
#define B_BE_GMAC_ETHP0_FRAGID_SH 0
#define B_BE_GMAC_ETHP0_FRAGID_MSK 0xf

#define R_BE_GMAC_ETHP0_M0 0x4980
#define B_BE_GMAC_ETHP_DA_MASK2_SH 16
#define B_BE_GMAC_ETHP_DA_MASK2_MSK 0xffff
#define B_BE_GMAC_ETHP_DA_MASK1_SH 0
#define B_BE_GMAC_ETHP_DA_MASK1_MSK 0xffff

#define R_BE_GMAC_ETHP0_M1 0x4984
#define B_BE_GMAC_ETHP_DA_MASK0_SH 16
#define B_BE_GMAC_ETHP_DA_MASK0_MSK 0xffff
#define B_BE_GMAC_ETHP_SA_MASK2_SH 0
#define B_BE_GMAC_ETHP_SA_MASK2_MSK 0xffff

#define R_BE_GMAC_ETHP0_M2 0x4988
#define B_BE_GMAC_ETHP_SA_MASK1_SH 16
#define B_BE_GMAC_ETHP_SA_MASK1_MSK 0xffff
#define B_BE_GMAC_ETHP_SA_MASK0_SH 0
#define B_BE_GMAC_ETHP_SA_MASK0_MSK 0xffff

#define R_BE_GMAC_ETHP0_M3 0x498C
#define B_BE_GMAC_ETHP_TYPE_MASK_SH 16
#define B_BE_GMAC_ETHP_TYPE_MASK_MSK 0xffff
#define B_BE_GMAC_ETHP_PROTO_MASK_SH 8
#define B_BE_GMAC_ETHP_PROTO_MASK_MSK 0xff
#define B_BE_GMAC_ETHP_DESC_MASK_SH 0
#define B_BE_GMAC_ETHP_DESC_MASK_MSK 0xff

#define R_BE_GMAC_ETHP1_0 0x4990
#define B_BE_GMAC_ETHP1_DA5_SH 24
#define B_BE_GMAC_ETHP1_DA5_MSK 0xff
#define B_BE_GMAC_ETHP1_DA4_SH 16
#define B_BE_GMAC_ETHP1_DA4_MSK 0xff
#define B_BE_GMAC_ETHP1_DA3_SH 8
#define B_BE_GMAC_ETHP1_DA3_MSK 0xff
#define B_BE_GMAC_ETHP1_DA2_SH 0
#define B_BE_GMAC_ETHP1_DA2_MSK 0xff

#define R_BE_GMAC_ETHP1_1 0x4994
#define B_BE_GMAC_ETHP1_DA1_SH 24
#define B_BE_GMAC_ETHP1_DA1_MSK 0xff
#define B_BE_GMAC_ETHP1_DA0_SH 16
#define B_BE_GMAC_ETHP1_DA0_MSK 0xff
#define B_BE_GMAC_ETHP1_SA5_SH 8
#define B_BE_GMAC_ETHP1_SA5_MSK 0xff
#define B_BE_GMAC_ETHP1_SA4_SH 0
#define B_BE_GMAC_ETHP1_SA4_MSK 0xff

#define R_BE_GMAC_ETHP1_2 0x4998
#define B_BE_GMAC_ETHP1_SA3_SH 24
#define B_BE_GMAC_ETHP1_SA3_MSK 0xff
#define B_BE_GMAC_ETHP1_SA2_SH 16
#define B_BE_GMAC_ETHP1_SA2_MSK 0xff
#define B_BE_GMAC_ETHP1_SA1_SH 8
#define B_BE_GMAC_ETHP1_SA1_MSK 0xff
#define B_BE_GMAC_ETHP1_SA0_SH 0
#define B_BE_GMAC_ETHP1_SA0_MSK 0xff

#define R_BE_GMAC_ETHP1_3 0x499C
#define B_BE_GMAC_ETHP1_TYPE1_SH 24
#define B_BE_GMAC_ETHP1_TYPE1_MSK 0xff
#define B_BE_GMAC_ETHP1_TYPE0_SH 16
#define B_BE_GMAC_ETHP1_TYPE0_MSK 0xff
#define B_BE_GMAC_ETHP1_PROTO_SH 8
#define B_BE_GMAC_ETHP1_PROTO_MSK 0xff
#define B_BE_GMAC_ETHP1_LS BIT(7)
#define B_BE_GMAC_ETHP1_INT BIT(5)
#define B_BE_GMAC_ETHP1_FRAGID_SH 0
#define B_BE_GMAC_ETHP1_FRAGID_MSK 0xf

#define R_BE_GMAC_ETHP1_M0 0x49A0

#define R_BE_GMAC_ETHP1_M1 0x49A4

#define R_BE_GMAC_ETHP1_M2 0x49A8

#define R_BE_GMAC_ETHP1_M3 0x49AC

#define R_BE_GMAC_TXBD_LAT 0x49B0
#define B_BE_GMAC_BULK_END BIT(31)
#define B_BE_GMAC_LS BIT(30)
#define B_BE_GMAC_ABORT BIT(29)
#define B_BE_GMAC_QSEL_SH 25
#define B_BE_GMAC_QSEL_MSK 0xf
#define B_BE_GMAC_MEMORY_ADDRESS_SH 10
#define B_BE_GMAC_MEMORY_ADDRESS_MSK 0x1fff
#define B_BE_GMAC_LENGTH_SH 0
#define B_BE_GMAC_LENGTH_MSK 0x3ff

#define R_BE_GMAC_PFC_MAP0 0x49B4
#define B_BE_GMAC_CHANNEL7_SH 28
#define B_BE_GMAC_CHANNEL7_MSK 0x7
#define B_BE_GMAC_CHANNEL6_SH 24
#define B_BE_GMAC_CHANNEL6_MSK 0x7
#define B_BE_GMAC_CHANNEL5_SH 20
#define B_BE_GMAC_CHANNEL5_MSK 0x7
#define B_BE_GMAC_CHANNEL4_SH 16
#define B_BE_GMAC_CHANNEL4_MSK 0x7
#define B_BE_GMAC_CHANNEL3_SH 12
#define B_BE_GMAC_CHANNEL3_MSK 0x7
#define B_BE_GMAC_CHANNEL2_SH 8
#define B_BE_GMAC_CHANNEL2_MSK 0x7
#define B_BE_GMAC_CHANNEL1_SH 4
#define B_BE_GMAC_CHANNEL1_MSK 0x7
#define B_BE_GMAC_CHANNEL0_SH 0
#define B_BE_GMAC_CHANNEL0_MSK 0x7

#define R_BE_GMAC_PFC_MAP1 0x49B8
#define B_BE_GMAC_CHANNEL13_SH 20
#define B_BE_GMAC_CHANNEL13_MSK 0x7
#define B_BE_GMAC_CHANNEL12_SH 16
#define B_BE_GMAC_CHANNEL12_MSK 0x7
#define B_BE_GMAC_CHANNEL11_SH 12
#define B_BE_GMAC_CHANNEL11_MSK 0x7
#define B_BE_GMAC_CHANNEL10_SH 8
#define B_BE_GMAC_CHANNEL10_MSK 0x7
#define B_BE_GMAC_CHANNEL9_SH 4
#define B_BE_GMAC_CHANNEL9_MSK 0x7
#define B_BE_GMAC_CHANNEL8_SH 0
#define B_BE_GMAC_CHANNEL8_MSK 0x7

//
// WL_BE_Reg_PCIE.xls
//

//
// PCIE
//

#define R_BE_PCIE_TOG_RST 0x3000
#define B_BE_PCIE_INTX_EN BIT(29)
#define B_BE_PCIE_TOG_ELBI_RST BIT(13)
#define B_BE_PCIE_TOG_WLAN_FLR_RST BIT(12)
#define B_BE_PCIE_TOG_REG_FLR_RST BIT(11)
#define B_BE_PCIE_TOG_REG_RST BIT(10)
#define B_BE_PCIE_TOG_ANA_RST BIT(9)
#define B_BE_PCIE_TOG_WLAN_RST BIT(8)
#define B_BE_PCIE_TOG_FLR_RST BIT(7)
#define B_BE_PCIE_TOG_RET_NON_STKY_RST BIT(6)
#define B_BE_PCIE_TOG_RET_STKY_RST BIT(5)
#define B_BE_PCIE_TOG_NON_STKY_RST BIT(4)
#define B_BE_PCIE_TOG_STKY_RST BIT(3)
#define B_BE_PCIE_TOG_RET_CORE_RST BIT(2)
#define B_BE_PCIE_TOG_PWR_RST BIT(1)
#define B_BE_PCIE_TOG_PERST_RST BIT(0)

#define R_BE_PCIE_FRZ_CLK 0x3004
#define B_BE_PCIE_FRZ_ELBI_RST BIT(29)
#define B_BE_PCIE_FRZ_WLAN_FLR_RST BIT(28)
#define B_BE_PCIE_FRZ_REG_FLR_RST BIT(27)
#define B_BE_PCIE_FRZ_REG_RST BIT(26)
#define B_BE_PCIE_FRZ_ANA_RST BIT(25)
#define B_BE_PCIE_FRZ_WLAN_RST BIT(24)
#define B_BE_PCIE_FRZ_FLR_RST BIT(23)
#define B_BE_PCIE_FRZ_RET_NON_STKY_RST BIT(22)
#define B_BE_PCIE_FRZ_RET_STKY_RST BIT(21)
#define B_BE_PCIE_FRZ_NON_STKY_RST BIT(20)
#define B_BE_PCIE_FRZ_STKY_RST BIT(19)
#define B_BE_PCIE_FRZ_RET_CORE_RST BIT(18)
#define B_BE_PCIE_FRZ_PWR_RST BIT(17)
#define B_BE_PCIE_FRZ_PERST_RST BIT(16)
#define B_BE_PCIE_DBG_CLK BIT(4)
#define B_BE_PCIE_EN_CLK BIT(3)
#define B_BE_PCIE_DBI_ACLK_ACT BIT(2)
#define B_BE_PCIE_S1_ACLK_ACT BIT(1)
#define B_BE_PCIE_EN_AUX_CLK BIT(0)

#define R_BE_PCIE_PS_CTRL_V1 0x3008
#define B_BE_RSM_FROM_L0S_CNT_SH 24
#define B_BE_RSM_FROM_L0S_CNT_MSK 0xff
#define B_BE_RSM_L0S_EN BIT(8)
#define B_BE_CMAC_EXIT_L1_EN BIT(7)
#define B_BE_DMAC0_EXIT_L1_EN BIT(6)
#define B_BE_L1OFF_PWR_OFF_EN BIT(5)
#define B_BE_SEL_XFER_PENDING BIT(3)
#define B_BE_SEL_REQ_ENTR_L1 BIT(2)
#define B_BE_PCIE_EN_SWENT_L23 BIT(1)
#define B_BE_SEL_REQ_EXIT_L1 BIT(0)

#define R_BE_PCIE_MIX_CFG_V1 0x300C
#define B_BE_ASPM_CTRL_SH 16
#define B_BE_ASPM_CTRL_MSK 0x3
#define B_BE_HPS_CLKR_PCIE_SH 12
#define B_BE_HPS_CLKR_PCIE_MSK 0x3
#define B_BE_XFER_PENDING_FW BIT(11)
#define B_BE_XFER_PENDING BIT(10)
#define B_BE_REQ_EXIT_L1 BIT(9)
#define B_BE_REQ_ENTR_L1 BIT(8)
#define B_BE_MSI_TIMEOUT_ID_V1_SH 5
#define B_BE_MSI_TIMEOUT_ID_V1_MSK 0x7
#define B_BE_L1SUB_DISABLE BIT(0)

#define R_BE_L1_CLK_CTRL 0x3010
#define B_BE_RAS_SD_HOLD_LTSSM BIT(12)
#define B_BE_RAS_TBA_CTRL_SH 8
#define B_BE_RAS_TBA_CTRL_MSK 0x3
#define B_BE_CLK_REQ_N BIT(1)
#define B_BE_CLK_PM_EN BIT(0)

#define R_BE_PCIE_MAILBOX 0x3014
#define B_BE_PCIE_MAILBOX_SH 0
#define B_BE_PCIE_MAILBOX_MSK 0xffffffffL

#define R_BE_AWMISC_INFO 0x3020
#define B_BE_INFO_SILENT_DROP BIT(25)
#define B_BE_INFO_EP BIT(24)
#define B_BE_AWMISC_INFO_SH 0
#define B_BE_AWMISC_INFO_MSK 0x3fffff

#define R_BE_AWMISC_INFO_L 0x3024
#define B_BE_AWMISIC_INFO_L_SH 0
#define B_BE_AWMISIC_INFO_L_MSK 0xffffffffL

#define R_BE_AWMISC_INFO_H 0x3028
#define B_BE_AWMISC_INFO_H_SH 0
#define B_BE_AWMISC_INFO_H_MSK 0xffffffffL

#define R_BE_AWMISC_INFO_TAG 0x302C
#define B_BE_AWMISC_INFO_TAG_SH 0
#define B_BE_AWMISC_INFO_TAG_MSK 0xff

#define R_BE_ARMISC_INFO 0x3030
#define B_BE_ARMISC_INFO_SH 0
#define B_BE_ARMISC_INFO_MSK 0x3fffff

#define R_BE_PCIE_BG_CLR 0x303C
#define B_BE_BG_CLR_APB_S0 BIT(15)
#define B_BE_BG_CLR_ASYNC_APB_S0 BIT(14)
#define B_BE_BG_CLR_APB_REG BIT(13)
#define B_BE_BG_CLR_ASYNC_APB_REG BIT(12)
#define B_BE_BG_CLR_M0 BIT(11)
#define B_BE_BG_CLR_ASYNC_M0 BIT(10)
#define B_BE_BG_CLR_M1 BIT(9)
#define B_BE_BG_CLR_ASYNC_M1 BIT(8)
#define B_BE_BG_CLR_M2 BIT(7)
#define B_BE_BG_CLR_ASYNC_M2 BIT(6)
#define B_BE_BG_CLR_M3 BIT(5)
#define B_BE_BG_CLR_ASYNC_M3 BIT(4)
#define B_BE_IO8_BG_CLR BIT(3)
#define B_BE_IO8_BG_CLR_ASYNC BIT(2)

#define R_BE_DBI_ADDR_SEL 0x3040
#define B_BE_DBI_ADDR_SEL_SH 12
#define B_BE_DBI_ADDR_SEL_MSK 0xfffff

#define R_BE_PCIE_LAT_CTRL 0x3044
#define B_BE_SYS_SUS_L12_EN BIT(17)
#define B_BE_MDIO_S_EN BIT(16)
#define B_BE_LDO_T3_LAT_SH 12
#define B_BE_LDO_T3_LAT_MSK 0x7
#define B_BE_VMAIN_LAT_SH 8
#define B_BE_VMAIN_LAT_MSK 0x7
#define B_BE_CLK_REQ_LAT_SH 4
#define B_BE_CLK_REQ_LAT_MSK 0xf
#define B_BE_CLK_REQ_SEL BIT(0)

#define R_BE_PCIE_HIMR00_V1 0x30B0
#define B_BE_HCI_AXIDMA_INT_EN BIT(29)
#define B_BE_HC00ISR_IND_INT_EN_V1 BIT(28)
#define B_BE_HD1ISR_IND_INT_EN_V1 BIT(27)
#define B_BE_HD0ISR_IND_INT_EN_V1 BIT(26)
#define B_BE_HS1ISR_IND_INT_EN BIT(25)
#define B_BE_HS0ISR_IND_INT_EN BIT(24)
#define B_BE_PCIE_HOTRST_INT_EN BIT(16)
#define B_BE_PCIE_FLR_INT_EN BIT(15)
#define B_BE_PCIE_PERST_INT_EN BIT(14)
#define B_BE_PCIE_DBG_STE_INT_EN BIT(13)

#define R_BE_PCIE_HISR00_V1 0x30B4
#define B_BE_HCI_AXIDMA_INT BIT(29)
#define B_BE_HC00ISR_IND_INT_V1 BIT(28)
#define B_BE_HD1ISR_IND_INT_V1 BIT(27)
#define B_BE_HD0ISR_IND_INT_V1 BIT(26)
#define B_BE_HS1ISR_IND_INT BIT(25)
#define B_BE_HS0ISR_IND_INT BIT(24)
#define B_BE_PCIE_HOTRST_INT BIT(16)
#define B_BE_PCIE_FLR_INT BIT(15)
#define B_BE_PCIE_PERST_INT BIT(14)
#define B_BE_PCIE_DBG_STE_INT BIT(13)

#define R_BE_PCIE_HRPWM_V1 0x30C0
#define B_BE_PCIE_HRPWM_SH 0
#define B_BE_PCIE_HRPWM_MSK 0xffff

#define R_BE_PCIE_CRPWM 0x30C4
#define B_BE_PCIE_CRPWM_SH 0
#define B_BE_PCIE_CRPWM_MSK 0xffff

#define R_BE_LBC_WATCHDOG_V1 0x30D8
#define B_BE_LBC_ADDR_V1_SH 10
#define B_BE_LBC_ADDR_V1_MSK 0x3ffff
#define B_BE_LBC_TIMER_V1_SH 4
#define B_BE_LBC_TIMER_V1_MSK 0xf
#define B_BE_LBC_FLAG_V1 BIT(1)
#define B_BE_LBC_EN_V1 BIT(0)

#define R_BE_PCIE_HIMR10_V1 0x30E0
#define B_BE_HC10ISR_IND_INT_EN_V1 BIT(28)

#define R_BE_PCIE_HISR10_V1 0x30E4
#define B_BE_HC10ISR_IND_INT_V1 BIT(28)

#define R_BE_PCIE_EXP_CTRL_V1 0x30F0
#define B_BE_PCIE_ACTIVE_FORCE_V1 BIT(1)
#define B_BE_PCIE_BIAS_FORCE_V1 BIT(0)

#define R_BE_TSFTIMER_HCI_V1 0x30FC
#define B_BE_TSFT2_HCI_SH 16
#define B_BE_TSFT2_HCI_MSK 0xffff
#define B_BE_TSFT1_HCI_SH 0
#define B_BE_TSFT1_HCI_MSK 0xffff

#define R_BE_PCIE_IO_RCY_M1 0x3100
#define B_BE_PCIE_IO_RCY_P_M1 BIT(5)
#define B_BE_PCIE_IO_RCY_WDT_P_M1 BIT(4)
#define B_BE_PCIE_IO_RCY_WDT_MODE_M1 BIT(3)
#define B_BE_PCIE_IO_RCY_TRIG_M1 BIT(0)

#define R_BE_PCIE_WDT_TIMER_M1 0x3104
#define B_BE_PCIE_WDT_TIMER_M1_SH 0
#define B_BE_PCIE_WDT_TIMER_M1_MSK 0xffffffffL

#define R_BE_PCIE_PADDR_M1 0x3108
#define B_BE_PCIE_PADDR_M1_SH 0
#define B_BE_PCIE_PADDR_M1_MSK 0xffffffffL

#define R_BE_PCIE_IO_RCY_M2 0x310C
#define B_BE_PCIE_IO_RCY_P_M2 BIT(5)
#define B_BE_PCIE_IO_RCY_WDT_P_M2 BIT(4)
#define B_BE_PCIE_IO_RCY_WDT_MODE_M2 BIT(3)
#define B_BE_PCIE_IO_RCY_TRIG_M2 BIT(0)

#define R_BE_PCIE_WDT_TIMER_M2 0x3110
#define B_BE_PCIE_WDT_TIMER_M2_SH 0
#define B_BE_PCIE_WDT_TIMER_M2_MSK 0xffffffffL

#define R_BE_PCIE_PADDR_M2 0x3114
#define B_BE_PCIE_PADDR_M2_SH 0
#define B_BE_PCIE_PADDR_M2_MSK 0xffffffffL

#define R_BE_PCIE_IO_RCY_E0 0x3118
#define B_BE_PCIE_IO_RCY_P_E0 BIT(5)
#define B_BE_PCIE_IO_RCY_WDT_P_E0 BIT(4)
#define B_BE_PCIE_IO_RCY_WDT_MODE_E0 BIT(3)
#define B_BE_PCIE_IO_RCY_TRIG_E0 BIT(0)

#define R_BE_PCIE_WDT_TIMER_E0 0x311C
#define B_BE_PCIE_WDT_TIMER_E0_SH 0
#define B_BE_PCIE_WDT_TIMER_E0_MSK 0xffffffffL

#define R_BE_PCIE_PADDR_E0 0x3120
#define B_BE_PCIE_PADDR_E0_SH 0
#define B_BE_PCIE_PADDR_E0_MSK 0xffffffffL

#define R_BE_PCIE_IO_RCY_S1 0x3124
#define B_BE_PCIE_IO_RCY_RP_S1 BIT(7)
#define B_BE_PCIE_IO_RCY_WP_S1 BIT(6)
#define B_BE_PCIE_IO_RCY_WDT_RP_S1 BIT(5)
#define B_BE_PCIE_IO_RCY_WDT_WP_S1 BIT(4)
#define B_BE_PCIE_IO_RCY_WDT_MODE_S1 BIT(3)
#define B_BE_PCIE_IO_RCY_RTRIG_S1 BIT(1)
#define B_BE_PCIE_IO_RCY_WTRIG_S1 BIT(0)

#define R_BE_PCIE_WDT_TIMER_S1 0x3128
#define B_BE_PCIE_WDT_TIMER_S1_SH 0
#define B_BE_PCIE_WDT_TIMER_S1_MSK 0xffffffffL

#define R_BE_PCIE_PADDR_W_S1 0x312C
#define B_BE_PCIE_PADDR_W_S1_SH 0
#define B_BE_PCIE_PADDR_W_S1_MSK 0xffffffffL

#define R_BE_PCIE_PADDR_R_S1 0x3130
#define B_BE_PCIE_PADDR_R_S1_SH 0
#define B_BE_PCIE_PADDR_R_S1_MSK 0xffffffffL

#define R_BE_PCIE_DBG_MODE 0x31C0
#define B_BE_PCIE_DBG_MODE_SH 16
#define B_BE_PCIE_DBG_MODE_MSK 0x3f

#define R_BE_PCIE_DBG_GPO 0x31C4
#define B_BE_PCIE_DBG_GPO_SH 0
#define B_BE_PCIE_DBG_GPO_MSK 0xffffffffL

#define R_BE_PCIE_DBG_INFO 0x31C8
#define B_BE_PCIE_DBG_INFO_SH 0
#define B_BE_PCIE_DBG_INFO_MSK 0xffffffffL

#define R_BE_PCIE_DBG_STATE 0x31D0
#define B_BE_PCIE_DBG_STATE_MODE_SH 8
#define B_BE_PCIE_DBG_STATE_MODE_MSK 0x7
#define B_BE_PCIE_DBG_STATE_GRP_SH 4
#define B_BE_PCIE_DBG_STATE_GRP_MSK 0x7
#define B_BE_PCIE_DBG_STATE_MSK BIT(2)
#define B_BE_PCIE_DBG_STATE_CLR BIT(1)
#define B_BE_PCIE_DBG_STATE_SET BIT(0)

#define R_BE_PCIE_DBG_STATE_D 0x31D4
#define B_BE_PCIE_DBG_STATE_D3_SH 16
#define B_BE_PCIE_DBG_STATE_D3_MSK 0x7f
#define B_BE_PCIE_DBG_STATE_D2_SH 8
#define B_BE_PCIE_DBG_STATE_D2_MSK 0x7f
#define B_BE_PCIE_DBG_STATE_D1_SH 0
#define B_BE_PCIE_DBG_STATE_D1_MSK 0x7f

#define R_BE_PCIE_DBG_INFO_D 0x31D8
#define B_BE_PCIE_DBG_INFO_D3_SH 16
#define B_BE_PCIE_DBG_INFO_D3_MSK 0x3f
#define B_BE_PCIE_DBG_INFO_D2_SH 8
#define B_BE_PCIE_DBG_INFO_D2_MSK 0x3f
#define B_BE_PCIE_DBG_INFO_D1_SH 0
#define B_BE_PCIE_DBG_INFO_D1_MSK 0x3f

#define R_BE_PCIE_MIT_TMR 0x3330
#define B_BE_PCIE_MIT_RX_TMR_SH 4
#define B_BE_PCIE_MIT_RX_TMR_MSK 0x3
#define B_BE_PCIE_MIT_TX_TMR_SH 0
#define B_BE_PCIE_MIT_TX_TMR_MSK 0x3

#define R_BE_PCIE_MIT_CNT 0x3334
#define B_BE_PCIE_RX_MIT_CNT_SH 24
#define B_BE_PCIE_RX_MIT_CNT_MSK 0xff
#define B_BE_PCIE_TX_MIT_CNT_SH 16
#define B_BE_PCIE_TX_MIT_CNT_MSK 0xff
#define B_BE_PCIE_RX_MIT_TMR_CNT_SH 8
#define B_BE_PCIE_RX_MIT_TMR_CNT_MSK 0xff
#define B_BE_PCIE_TX_MIT_TMR_CNT_SH 0
#define B_BE_PCIE_TX_MIT_TMR_CNT_MSK 0xff

#define R_BE_PCIE_MIT_CH_EN 0x3338
#define B_BE_PCIE_MIT_RXP2_EN BIT(17)
#define B_BE_PCIE_MIT_RXP1_EN BIT(16)
#define B_BE_PCIE_MIT_TXCH12_EN BIT(12)
#define B_BE_PCIE_MIT_TXCH11_EN BIT(11)
#define B_BE_PCIE_MIT_TXCH10_EN BIT(10)
#define B_BE_PCIE_MIT_TXCH9_EN BIT(9)
#define B_BE_PCIE_MIT_TXCH8_EN BIT(8)
#define B_BE_PCIE_MIT_TXCH7_EN BIT(7)
#define B_BE_PCIE_MIT_TXCH6_EN BIT(6)
#define B_BE_PCIE_MIT_TXCH5_EN BIT(5)
#define B_BE_PCIE_MIT_TXCH4_EN BIT(4)
#define B_BE_PCIE_MIT_TXCH3_EN BIT(3)
#define B_BE_PCIE_MIT_TXCH2_EN BIT(2)
#define B_BE_PCIE_MIT_TXCH1_EN BIT(1)
#define B_BE_PCIE_MIT_TXCH0_EN BIT(0)

#define R_BE_PCIE_MIT_TX_ISR 0x3340
#define B_BE_PCIE_TX_CH12_ISR BIT(12)
#define B_BE_PCIE_TX_CH11_ISR BIT(11)
#define B_BE_PCIE_TX_CH10_ISR BIT(10)
#define B_BE_PCIE_TX_CH9_ISR BIT(9)
#define B_BE_PCIE_TX_CH8_ISR BIT(8)
#define B_BE_PCIE_TX_CH7_ISR BIT(7)
#define B_BE_PCIE_TX_CH6_ISR BIT(6)
#define B_BE_PCIE_TX_CH5_ISR BIT(5)
#define B_BE_PCIE_TX_CH4_ISR BIT(4)
#define B_BE_PCIE_TX_CH3_ISR BIT(3)
#define B_BE_PCIE_TX_CH2_ISR BIT(2)
#define B_BE_PCIE_TX_CH1_ISR BIT(1)
#define B_BE_PCIE_TX_CH0_ISR BIT(0)

#define R_BE_PCIE_MIT_RX_ISR 0x3344
#define B_BE_PCIE_RX_RXP2_ISR BIT(1)
#define B_BE_PCIE_RX_RXP1_ISR BIT(0)

#define R_BE_PCIE_MIT_TX_IMR 0x3348
#define B_BE_PCIE_TX_CH12_IMR BIT(12)
#define B_BE_PCIE_TX_CH11_IMR BIT(11)
#define B_BE_PCIE_TX_CH10_IMR BIT(10)
#define B_BE_PCIE_TX_CH9_IMR BIT(9)
#define B_BE_PCIE_TX_CH8_IMR BIT(8)
#define B_BE_PCIE_TX_CH7_IMR BIT(7)
#define B_BE_PCIE_TX_CH6_IMR BIT(6)
#define B_BE_PCIE_TX_CH5_IMR BIT(5)
#define B_BE_PCIE_TX_CH4_IMR BIT(4)
#define B_BE_PCIE_TX_CH3_IMR BIT(3)
#define B_BE_PCIE_TX_CH2_IMR BIT(2)
#define B_BE_PCIE_TX_CH1_IMR BIT(1)
#define B_BE_PCIE_TX_CH0_IMR BIT(0)

#define R_BE_PCIE_MIT_RX_IMR 0x334C
#define B_BE_PCIE_RX_RXP2_IMR BIT(1)
#define B_BE_PCIE_RX_RXP1_IMR BIT(0)

//
// WL_BE_Reg_Page_SDIO.xls
//

//
// SDIO_Local_Reg_Spec
//

#define R_BE_SDIO_TX_CTRL 0x3000
#define B_BE_SDIO_INT_TIMEOUT_SH 16
#define B_BE_SDIO_INT_TIMEOUT_MSK 0xffff
#define B_BE_IO_ERR_STATUS BIT(15)
#define B_BE_CMD53_W_MIX BIT(14)
#define B_BE_CMD53_TX_FORMAT BIT(13)
#define B_BE_CMD53_R_TIMEOUT_MASK BIT(12)
#define B_BE_CMD53_R_TIMEOUT_UNIT_SH 10
#define B_BE_CMD53_R_TIMEOUT_UNIT_MSK 0x3
#define B_BE_REPLY_ERRCRC_IN_DATA BIT(9)
#define B_BE_EN_CMD53_OVERLAP BIT(8)
#define B_BE_REPLY_ERR_IN_R5 BIT(7)
#define B_BE_R18A_EN BIT(6)
#define B_BE_SDIO_CMD_FORCE_VLD BIT(5)
#define B_BE_INIT_CMD_EN BIT(4)
#define B_BE_RXINT_READ_MASK_DIS BIT(3)
#define B_BE_EN_RXDMA_MASK_INT BIT(2)
#define B_BE_EN_MASK_TIMER BIT(1)
#define B_BE_CMD_ERR_STOP_INT_EN BIT(0)

#define R_BE_SDIO_CTRL 0x3004
#define B_BE_SDIO_DRV_TYPE_D_SH 28
#define B_BE_SDIO_DRV_TYPE_D_MSK 0xf
#define B_BE_SDIO_DRV_TYPE_C_SH 24
#define B_BE_SDIO_DRV_TYPE_C_MSK 0xf
#define B_BE_SDIO_DRV_TYPE_B_SH 20
#define B_BE_SDIO_DRV_TYPE_B_MSK 0xf
#define B_BE_SDIO_DRV_TYPE_A_SH 16
#define B_BE_SDIO_DRV_TYPE_A_MSK 0xf
#define B_BE_SIG_OUT_PH BIT(8)
#define B_BE_CMD11_SEQ_END_DELAY_SH 4
#define B_BE_CMD11_SEQ_END_DELAY_MSK 0xf
#define B_BE_CMD11_SEQ_SAMPLE_INTERVAL_SH 1
#define B_BE_CMD11_SEQ_SAMPLE_INTERVAL_MSK 0x7
#define B_BE_CMD11_SEQ_EN BIT(0)

#define R_BE_SDIO_MONITOR 0x3008
#define B_BE_TSF_FREERUN_CNT_REG_SH 0
#define B_BE_TSF_FREERUN_CNT_REG_MSK 0xffffff

#define R_BE_SDIO_MONITOR_2 0x300C
#define B_BE_CMD53_WT_EN BIT(23)
#define B_BE_SDIO_CLK_MONITOR_SH 21
#define B_BE_SDIO_CLK_MONITOR_MSK 0x3
#define B_BE_SDIO_CLK_CNT_SH 0
#define B_BE_SDIO_CLK_CNT_MSK 0x1fffff

#define R_BE_SDIO_CTRL_2 0x3010
#define B_BE_SDIO_CLK_SMT BIT(1)
#define B_BE_SDIO_DATA_SMT BIT(0)

#define R_BE_SDIO_MONITOR_3 0x3014
#define B_BE_MAC_THR_SH 0
#define B_BE_MAC_THR_MSK 0xffffffffL

#define R_BE_SDIO_LOCAL_REG 0x3018
#define B_BE_IOREG2APB_TIMEOUT_TH_SH 14
#define B_BE_IOREG2APB_TIMEOUT_TH_MSK 0xff
#define B_BE__TUNIT_SEL_SH 12
#define B_BE__TUNIT_SEL_MSK 0x3
#define B_BE_FEN_TUNIT BIT(11)
#define B_BE_IOREG2APB_CLR_MODE_SH 9
#define B_BE_IOREG2APB_CLR_MODE_MSK 0x3
#define B_BE_CMD_IOREG_HW_CLR_EN BIT(8)
#define B_BE_RX_LEN_UP_MODE_SH 6
#define B_BE_RX_LEN_UP_MODE_MSK 0x3
#define B_BE__MAC_IS_ACTIVE BIT(4)
#define B_BE_SDIO_IOREG_RST BIT(3)
#define B_BE_DISABLE_0X800 BIT(2)
#define B_BE_EN_CMD53_RX_MIX_MODE BIT(1)
#define B_BE_EN_RX_LEN_CMD_OK BIT(0)
#define B_BE_CMD11_TIMEOUT_THRESHOLD_SH 0
#define B_BE_CMD11_TIMEOUT_THRESHOLD_MSK 0xffff

#define R_BE_SDIO_HTSFR_INFO_V1 0x3030
#define B_BE_HTSFT2_SH 16
#define B_BE_HTSFT2_MSK 0xffff
#define B_BE_HTSFT1_SH 0
#define B_BE_HTSFT1_MSK 0xffff

#define R_BE_SDIO_TX_IOREG_INFO 0x3034
#define B_BE_IOREG_W_BUSY_EN BIT(2)
#define B_BE_TX_TRIGGER_DELAY BIT(1)
#define B_BE_HCPWM2_SDIO_SYNC_SH 0
#define B_BE_HCPWM2_SDIO_SYNC_MSK 0xffff

#define R_BE_SDIO_INDIRECT_ADDR_V1 0x3040
#define B_BE_INDIRECT_RDY BIT(31)
#define B_BE_INDIRECT_ADDR_SH 0
#define B_BE_INDIRECT_ADDR_MSK 0x7fffffffL

#define R_BE_SDIO_INDIRECT_DATA 0x3044
#define B_BE_INDIRECT_DATA_SH 0
#define B_BE_INDIRECT_DATA_MSK 0xffffffffL

#define R_BE_SDIO_INDIRECT_CTRL 0x3048
#define B_BE_INDIRECT_REG_R BIT(3)
#define B_BE_INDIRECT_REG_W BIT(2)
#define B_BE_INDIRECT_REG_SIZE_SH 0
#define B_BE_INDIRECT_REG_SIZE_MSK 0x3

#define R_BE_SDIO_TRX_STAT 0x3070
#define B_BE_R_TXDMA_CS_SH 12
#define B_BE_R_TXDMA_CS_MSK 0x7
#define B_BE_R_TXDATA_CS_SH 8
#define B_BE_R_TXDATA_CS_MSK 0xf
#define B_BE_R_RXDMA_CS_SH 4
#define B_BE_R_RXDMA_CS_MSK 0xf
#define B_BE_R_RXDATA_CS_SH 0
#define B_BE_R_RXDATA_CS_MSK 0xf

#define R_BE_SDIO_HRPWM1_V1 0x3080
#define B_BE_HRPWM_SH 16
#define B_BE_HRPWM_MSK 0xffff

#define R_BE_SDIO_BUS_CTRL 0x3084
#define B_BE_R_CCCR_EHS BIT(22)
#define B_BE_EE_SPI_CLK_OPTION BIT(21)
#define B_BE_INTR_CTRL BIT(20)
#define B_BE_SDIO_VOLTAGE BIT(19)
#define B_BE_BYPASS_INIT BIT(18)
#define B_BE_HCI_RESUME_RDY BIT(17)
#define B_BE_HCI_SUS_REQ BIT(16)
#define B_BE_FN1_CRC16_SYNC_EN BIT(15)
#define B_BE_CMD53_RDATA_EARLY BIT(14)
#define B_BE_HISR_W_CLR_EN BIT(13)
#define B_BE_INT_MASK_DIS BIT(12)
#define B_BE_PAD_CLK_XHGE_EN BIT(11)
#define B_BE_INTER_CLK_EN BIT(10)
#define B_BE_EN_RPT_TXCRC BIT(9)
#define B_BE_DIS_RXDMA_STS BIT(8)
#define B_BE_HPS_CLKR_SH 0
#define B_BE_HPS_CLKR_MSK 0xff

#define R_BE_SDIO_RESPONSE_TIMER 0x3088
#define B_BE_SDIO_CMD_CRC_SH 16
#define B_BE_SDIO_CMD_CRC_MSK 0xff
#define B_BE_CMDIN_2RESP_TIMER_SH 0
#define B_BE_CMDIN_2RESP_TIMER_MSK 0xffff

#define R_BE_SDIO_HSISR 0x3090
#define B_BE_SDIO_RESP_FLAG_EN_SH 24
#define B_BE_SDIO_RESP_FLAG_EN_MSK 0xff
#define B_BE_SDIO_RESP_FLAG_SH 16
#define B_BE_SDIO_RESP_FLAG_MSK 0xff
#define B_BE_HISR_MASK BIT(8)
#define B_BE_DRV_WLAN_INT_CLR BIT(1)
#define B_BE_DRV_WLAN_INT BIT(0)

#define R_BE_SDIO_EXTEND_RBLOK_GAP_V1 0x3094
#define B_BE_EXTEND_RBLOCK_GAP_SH 0
#define B_BE_EXTEND_RBLOCK_GAP_MSK 0x3f

#define R_BE_SDIO_DIOERR_RPT_V1 0x30C0
#define B_BE_DATA_CRC_ERR_CNT_SH 24
#define B_BE_DATA_CRC_ERR_CNT_MSK 0xff
#define B_BE_CMD_CRC_ERR_CNT_SH 16
#define B_BE_CMD_CRC_ERR_CNT_MSK 0xff

#define R_BE_SDIO_CMD_ERR_CONTENT_L_V1 0x30C4
#define B_BE_SDIO_CMD_ERR_CONTENT_L_SH 0
#define B_BE_SDIO_CMD_ERR_CONTENT_L_MSK 0xffffffffL

#define R_BE_SDIO_CMD_ERR_CONTENT 0x30C8
#define B_BE_SDIO_DATA_CRC_SH 16
#define B_BE_SDIO_DATA_CRC_MSK 0xffff
#define B_BE_FN1_WDATA_TO_FLG BIT(15)
#define B_BE_FN1_WDATA_LEN_SHORT_FLG BIT(14)
#define B_BE_D3_CRC_ERR BIT(12)
#define B_BE_D2_CRC_ERR BIT(11)
#define B_BE_D1_CRC_ERR BIT(10)
#define B_BE_D0_CRC_ERR BIT(9)
#define B_BE_CMD_CRC_ERR BIT(8)
#define B_BE_SDIO_CMD_ERR_CONTENT_H_SH 0
#define B_BE_SDIO_CMD_ERR_CONTENT_H_MSK 0xff

#define R_BE_SDIO_TRANS_FIFO_STATUS 0x30CC
#define B_BE_SD_DBG_SEL_SH 8
#define B_BE_SD_DBG_SEL_MSK 0xff
#define B_BE_RXDMA_READ_PTR_CLR BIT(7)
#define B_BE_RXDMA_WRITE_PTR_CLR BIT(6)
#define B_BE_TXDMA_READ_PTR_CLR BIT(5)
#define B_BE_TXDMA_WRITE_PTR_CLR BIT(4)
#define B_BE__RXDMA_FIFO_UNDERFLOW BIT(3)
#define B_BE_RXDMA_FIFO_OVERFLOW BIT(2)
#define B_BE_TXDMA_FIFO_UNDERFLOW BIT(1)
#define B_BE_TXDMA_FIFO_OVERFLOW BIT(0)

#define R_BE_SDIO_HIMR 0x3100
#define B_BE_RXDMA_FIFO_UNDERFLOW_EN BIT(29)
#define B_BE_TXDMA_FIFO_OVERFLOW_EN BIT(28)
#define B_BE_BT_INT_EN BIT(24)
#define B_BE_HS0ISR_IND_EN BIT(16)
#define B_BE_HC10ISR_IND_EN BIT(9)
#define B_BE_HC00ISR_IND_EN BIT(8)
#define B_BE_HD1ISR_IND_EN BIT(3)
#define B_BE_HD0ISR_IND_EN BIT(2)
#define B_BE_SDIO_AVAL_INT_EN BIT(1)
#define B_BE_RX_REQUEST_INT_EN BIT(0)

#define R_BE_SDIO_HISR 0x3104
#define B_BE_RXDMA_FIFO_UNDERFLOW_INT BIT(29)
#define B_BE_TXDMA_FIFO_OVERFLOW_INT BIT(28)
#define B_BE_BT_INT BIT(24)
#define B_BE_HS0ISR_IND BIT(16)
#define B_BE_HC10ISR_IND BIT(9)
#define B_BE_HC00ISR_IND BIT(8)
#define B_BE_HD1ISR_IND BIT(3)
#define B_BE_HD0ISR_IND BIT(2)
#define B_BE_SDIO_AVAL_INT BIT(1)
#define B_BE_RX_REQUEST_INT BIT(0)

#define R_BE_SDIO_RX_REQ_LEN 0x3108
#define B_BE_RX_REQ_LEN_SH 0
#define B_BE_RX_REQ_LEN_MSK 0x3ffff

#define R_BE_SDIO_AVAL_INTRPT_STAT 0x310C
#define B_BE_SDIO_ACH11_INTRPT_STAT BIT(11)
#define B_BE_SDIO_ACH10_INTRPT_STAT BIT(10)
#define B_BE_SDIO_ACH9_INTRPT_STAT BIT(9)
#define B_BE_SDIO_ACH8_INTRPT_STAT BIT(8)
#define B_BE_SDIO_ACH7_INTRPT_STAT BIT(7)
#define B_BE_SDIO_ACH6_INTRPT_STAT BIT(6)
#define B_BE_SDIO_ACH5_INTRPT_STAT BIT(5)
#define B_BE_SDIO_ACH4_INTRPT_STAT BIT(4)
#define B_BE_SDIO_ACH3_INTRPT_STAT BIT(3)
#define B_BE_SDIO_ACH2_INTRPT_STAT BIT(2)
#define B_BE_SDIO_ACH1_INTRPT_STAT BIT(1)
#define B_BE_SDIO_ACH0_INTRPT_STAT BIT(0)

#define R_BE_SDIO_TXPG_WP 0x3110
#define B_BE_SDIO_ACH12_AVAL_PG_SH 16
#define B_BE_SDIO_ACH12_AVAL_PG_MSK 0x1fff
#define B_BE_SDIO_WP_AVAL_PG_SH 0
#define B_BE_SDIO_WP_AVAL_PG_MSK 0x1fff

#define R_BE_SDIO_TXPG_0 0x3114
#define B_BE_SDIO_ACH1_USE_PG_SH 16
#define B_BE_SDIO_ACH1_USE_PG_MSK 0x1fff
#define B_BE_SDIO_ACH0_USE_PG_SH 0
#define B_BE_SDIO_ACH0_USE_PG_MSK 0x1fff

#define R_BE_SDIO_TXPG_1 0x3118
#define B_BE_SDIO_ACH3_USE_PG_SH 16
#define B_BE_SDIO_ACH3_USE_PG_MSK 0x1fff
#define B_BE_SDIO_ACH2_USE_PG_SH 0
#define B_BE_SDIO_ACH2_USE_PG_MSK 0x1fff

#define R_BE_SDIO_TXPG_2 0x311C
#define B_BE_SDIO_ACH5_USE_PG_SH 16
#define B_BE_SDIO_ACH5_USE_PG_MSK 0x1fff
#define B_BE_SDIO_ACH4_USE_PG_SH 0
#define B_BE_SDIO_ACH4_USE_PG_MSK 0x1fff

#define R_BE_SDIO_TXPG_3_V1 0x3120
#define B_BE_SDIO_ACH7_USE_PG_SH 16
#define B_BE_SDIO_ACH7_USE_PG_MSK 0x1fff
#define B_BE_SDIO_ACH6_USE_PG_SH 0
#define B_BE_SDIO_ACH6_USE_PG_MSK 0x1fff

#define R_BE_SDIO_TXPG_4 0x3124
#define B_BE_SDIO_ACH9_USE_PG_SH 16
#define B_BE_SDIO_ACH9_USE_PG_MSK 0x1fff
#define B_BE_SDIO_ACH8_USE_PG_SH 0
#define B_BE_SDIO_ACH8_USE_PG_MSK 0x1fff

#define R_BE_SDIO_TXPG_5 0x3128
#define B_BE_SDIO_ACH11_USE_PG_SH 16
#define B_BE_SDIO_ACH11_USE_PG_MSK 0x1fff
#define B_BE_SDIO_ACH10_USE_PG_SH 0
#define B_BE_SDIO_ACH10_USE_PG_MSK 0x1fff

#define R_BE_BT_IINT 0x3210
#define B_BE_BT_INTRD_AND_ENINTRD BIT(24)

#define R_BE_BT_ENINTRD 0x3214
#define B_BE_BT_ENINTRD BIT(0)

#define R_BE_BTSTATE_DBG_BT2SDIO 0x3230
#define B_BE_BTSTATE_DBG_BT2SDIO_SH 0
#define B_BE_BTSTATE_DBG_BT2SDIO_MSK 0xffffffffL

#define R_BE_BT_SRAM 0x3240
#define B_BE_RXPKT_REMAIN_CNT_SH 16
#define B_BE_RXPKT_REMAIN_CNT_MSK 0xffff
#define B_BE_SRAM_R_UNDERFLOW BIT(13)
#define B_BE_SRAM_W_OVERERFLOW BIT(12)
#define B_BE_RXFIFO_READY_SH 10
#define B_BE_RXFIFO_READY_MSK 0x3
#define B_BE_TXFIFO_EMPTY_SH 8
#define B_BE_TXFIFO_EMPTY_MSK 0x3
#define B_BE_BT_WAKEUP BIT(0)

#define R_BE_BT_SDIO_HEADER 0x3244
#define B_BE_SDIO_HEADER_SH 0
#define B_BE_SDIO_HEADER_MSK 0xffffffffL

#define R_BE_BT_ENINT_TXDROP 0x3248
#define B_BE_BT_ENINT_TXDROP BIT(25)
#define B_BE_BT_ENINT_TXDROP_LEISO BIT(24)
#define B_BE_SDIO_FN2_SB_INT_POL BIT(16)
#define B_BE_TXPKT_REMAIN_CNT_SH 0
#define B_BE_TXPKT_REMAIN_CNT_MSK 0xffff

#define R_BE_BT_EMIT_TXDROP 0x324C
#define B_BE_SDIO_FN2_LEISO_EN BIT(8)
#define B_BE_BT_ENINTANDINT_TXDROP BIT(1)
#define B_BE_BT_ENINTANDINT_TXDROP_LEISO BIT(0)

#define R_BE_BT_SDIO_FN2_CLK 0x3270
#define B_BE_FN2_RXCRC_BAD_EVT_DIS BIT(16)
#define B_BE_FN2_TXCRC_ERR_NO_DELAY BIT(10)
#define B_BE_FN2_TXCRC_BAD_EVT_DIS BIT(9)
#define B_BE_FN2_TXCRC_EN BIT(8)
#define B_BE_NOT_FN2_GCLK_EN BIT(1)
#define B_BE_SDIO_FN2_GCLK_EN BIT(0)

#define R_BE_FN2_CRC_ERR 0x3274
#define B_BE_FN2_LAT_CMD_REG_15_0_SH 16
#define B_BE_FN2_LAT_CMD_REG_15_0_MSK 0xffff
#define B_BE_FN2_DAT_CRC_ERR_CNT_SH 8
#define B_BE_FN2_DAT_CRC_ERR_CNT_MSK 0xf
#define B_BE_FN2_CMD_CRC_ERR_CNT_SH 0
#define B_BE_FN2_CMD_CRC_ERR_CNT_MSK 0xf

#define R_BE_FN2_LAT_CMD 0x3278
#define B_BE_FN2_LESS_WDATA_FLG BIT(30)
#define B_BE_FN2_WDATA_TO_FLG BIT(29)
#define B_BE_FN2_LAT_CRC_ERROR_SH 24
#define B_BE_FN2_LAT_CRC_ERROR_MSK 0x1f
#define B_BE_FN2_LAT_CMD_REG_39_16_SH 0
#define B_BE_FN2_LAT_CMD_REG_39_16_MSK 0xffffff

#define R_BE_FN2_LAT_DATA_CRC 0x327C
#define B_BE_FN2_LAT_DATA_CRC_SH 0
#define B_BE_FN2_LAT_DATA_CRC_MSK 0xffff

#define R_BE_SDIO_CCCR_000 0x3300
#define B_BE_R_CCCR_IOR2 BIT(26)
#define B_BE_R_CCCR_IOR1 BIT(25)
#define B_BE_CCCR_IOE2 BIT(18)
#define B_BE_CCCR_IOE1 BIT(17)
#define B_BE_EE_SD_REV_SH 8
#define B_BE_EE_SD_REV_MSK 0xf
#define B_BE_EE_SDIO_REV_SH 4
#define B_BE_EE_SDIO_REV_MSK 0xf
#define B_BE_EE_CCCR_REV_SH 0
#define B_BE_EE_CCCR_REV_MSK 0xf

#define R_BE_SDIO_CCCR_004 0x3304
#define B_BE_CCCR_CD_DIS BIT(31)
#define B_BE_EE_CCCR_SCSI BIT(30)
#define B_BE_CCCR_ECSI BIT(29)
#define B_BE_CCCR_BUS_WIDTH_SH 24
#define B_BE_CCCR_BUS_WIDTH_MSK 0x3
#define B_BE_CCCR_RES BIT(19)
#define B_BE_CCCR_AS_SH 16
#define B_BE_CCCR_AS_MSK 0x7
#define B_BE_R_CCCR_INT2 BIT(10)
#define B_BE_R_CCCR_INT1 BIT(9)
#define B_BE_CCCR_IEN2 BIT(2)
#define B_BE_CCCR_IEN1 BIT(1)
#define B_BE_CCCR_IENM BIT(0)

#define R_BE_SDIO_CCCR_008 0x3308
#define B_BE_FN0_CIS_PTR_RO_SH 8
#define B_BE_FN0_CIS_PTR_RO_MSK 0xffffff
#define B_BE_CCCR_E4MI BIT(5)
#define B_BE_CCCR_S4MI BIT(4)
#define B_BE_CCCR_SBS BIT(3)
#define B_BE_CCCR_SRW BIT(2)
#define B_BE_CCCR_SMB BIT(1)
#define B_BE_CCCR_SDC BIT(0)

#define R_BE_SDIO_CCCR_00C 0x330C

#define R_BE_SDIO_CCCR_010 0x3310
#define B_BE_CCCR_BSS_SH 25
#define B_BE_CCCR_BSS_MSK 0x7
#define B_BE_CCCR_EMPC BIT(17)
#define B_BE_EE_CCCR_SMPC BIT(16)
#define B_BE_CCCR_FN0_BLK_SIZE_SH 0
#define B_BE_CCCR_FN0_BLK_SIZE_MSK 0xffff

#define R_BE_SDIO_CCCR_014 0x3314
#define B_BE_CCCR_EAI BIT(17)
#define B_BE_EE_SAI BIT(16)
#define B_BE_CCCR_DTS_SH 12
#define B_BE_CCCR_DTS_MSK 0x3
#define B_BE_EE_CCCR_SDTD BIT(10)
#define B_BE_EE_CCCR_SDTC BIT(9)
#define B_BE_EE_CCCR_SDTA BIT(8)
#define B_BE_EE_SDDR50 BIT(2)
#define B_BE_EE_SSDR104 BIT(1)
#define B_BE_EE_SSDR50 BIT(0)

#define R_BE_SDIO_FBR1_100 0x3400
#define B_BE_EE_FN1_PS3_SH 20
#define B_BE_EE_FN1_PS3_MSK 0xf
#define B_BE_FN1_EPS BIT(17)
#define B_BE_EE_FN1_SPS BIT(16)
#define B_BE_SDIO_WIFI_RO_SH 0
#define B_BE_SDIO_WIFI_RO_MSK 0xff

#define R_BE_SDIO_FBR1_104 0x3404

#define R_BE_SDIO_FBR1_108 0x3408
#define B_BE_FN1_CIS_PTR_RO_SH 8
#define B_BE_FN1_CIS_PTR_RO_MSK 0xffffff

#define R_BE_SDIO_FBR1_110 0x3410
#define B_BE_CCCR_FN1_BLK_SIZE_SH 0
#define B_BE_CCCR_FN1_BLK_SIZE_MSK 0xffff

#define R_BE_SDIO_FBR2_200 0x3500
#define B_BE_EE_FN1_PS3_BT_SH 12
#define B_BE_EE_FN1_PS3_BT_MSK 0xf
#define B_BE_SDIO_BT_RO_SH 0
#define B_BE_SDIO_BT_RO_MSK 0xff

#define R_BE_SDIO_FBR1_204 0x3504

#define R_BE_SDIO_FBR1_208 0x3508
#define B_BE_FN2_CIS_PTR_RO_SH 8
#define B_BE_FN2_CIS_PTR_RO_MSK 0xffffff

#define R_BE_SDIO_FBR1_210 0x3510
#define B_BE_CCCR_FN2_BLK_SIZE_SH 0
#define B_BE_CCCR_FN2_BLK_SIZE_MSK 0xffff

#define R_BE_SDIO_FN0_CIS_000 0x3600
#define B_BE_FN0_CIS_3_SH 24
#define B_BE_FN0_CIS_3_MSK 0xff
#define B_BE_FN0_CIS_2_SH 16
#define B_BE_FN0_CIS_2_MSK 0xff
#define B_BE_FN0_CIS_1_SH 8
#define B_BE_FN0_CIS_1_MSK 0xff
#define B_BE_FN0_CIS_0_SH 0
#define B_BE_FN0_CIS_0_MSK 0xff

#define R_BE_SDIO_FN0_CIS_004 0x3604
#define B_BE_FN0_CIS_7_SH 24
#define B_BE_FN0_CIS_7_MSK 0xff
#define B_BE_FN0_CIS_6_SH 16
#define B_BE_FN0_CIS_6_MSK 0xff
#define B_BE_FN0_CIS_5_SH 8
#define B_BE_FN0_CIS_5_MSK 0xff
#define B_BE_FN0_CIS_4_SH 0
#define B_BE_FN0_CIS_4_MSK 0xff

#define R_BE_SDIO_FN0_CIS_008 0x3608
#define B_BE_FN0_CIS_11_SH 24
#define B_BE_FN0_CIS_11_MSK 0xff
#define B_BE_FN0_CIS_10_SH 16
#define B_BE_FN0_CIS_10_MSK 0xff
#define B_BE_FN0_CIS_9_SH 8
#define B_BE_FN0_CIS_9_MSK 0xff
#define B_BE_FN0_CIS_8_SH 0
#define B_BE_FN0_CIS_8_MSK 0xff

#define R_BE_SDIO_FN0_CIS_00C 0x360C
#define B_BE_FN0_CIS_15_SH 24
#define B_BE_FN0_CIS_15_MSK 0xff
#define B_BE_FN0_CIS_14_SH 16
#define B_BE_FN0_CIS_14_MSK 0xff
#define B_BE_FN0_CIS_13_SH 8
#define B_BE_FN0_CIS_13_MSK 0xff
#define B_BE_FN0_CIS_12_SH 0
#define B_BE_FN0_CIS_12_MSK 0xff

#define R_BE_SDIO_FN0_CIS_010 0x3610
#define B_BE_FN0_CIS_END_FLAG_SH 0
#define B_BE_FN0_CIS_END_FLAG_MSK 0xff

#define R_BE_SDIO_FN1_CIS_100 0x3700
#define B_BE_FN1_CIS_3_SH 24
#define B_BE_FN1_CIS_3_MSK 0xff
#define B_BE_FN1_CIS_2_SH 16
#define B_BE_FN1_CIS_2_MSK 0xff
#define B_BE_FN1_CIS_1_SH 8
#define B_BE_FN1_CIS_1_MSK 0xff
#define B_BE_FN1_CIS_0_SH 0
#define B_BE_FN1_CIS_0_MSK 0xff

#define R_BE_SDIO_FN1_CIS_104 0x3704
#define B_BE_FN1_CIS_7_SH 24
#define B_BE_FN1_CIS_7_MSK 0xff
#define B_BE_FN1_CIS_6_SH 16
#define B_BE_FN1_CIS_6_MSK 0xff
#define B_BE_FN1_CIS_5_SH 8
#define B_BE_FN1_CIS_5_MSK 0xff
#define B_BE_FN1_CIS_4_SH 0
#define B_BE_FN1_CIS_4_MSK 0xff

#define R_BE_SDIO_FN1_CIS_108 0x3708
#define B_BE_FN1_CIS_11_SH 24
#define B_BE_FN1_CIS_11_MSK 0xff
#define B_BE_FN1_CIS_10_SH 16
#define B_BE_FN1_CIS_10_MSK 0xff
#define B_BE_FN1_CIS_9_SH 8
#define B_BE_FN1_CIS_9_MSK 0xff
#define B_BE_FN1_CIS_8_SH 0
#define B_BE_FN1_CIS_8_MSK 0xff

#define R_BE_SDIO_FN1_CIS_10C 0x370C
#define B_BE_FN1_CIS_15_SH 24
#define B_BE_FN1_CIS_15_MSK 0xff
#define B_BE_FN1_CIS_14_SH 16
#define B_BE_FN1_CIS_14_MSK 0xff
#define B_BE_FN1_CIS_13_SH 8
#define B_BE_FN1_CIS_13_MSK 0xff
#define B_BE_FN1_CIS_12_SH 0
#define B_BE_FN1_CIS_12_MSK 0xff

#define R_BE_SDIO_FN1_CIS_110 0x3710
#define B_BE_FN1_CIS_19_SH 24
#define B_BE_FN1_CIS_19_MSK 0xff
#define B_BE_FN1_CIS_18_SH 16
#define B_BE_FN1_CIS_18_MSK 0xff
#define B_BE_FN1_CIS_17_SH 8
#define B_BE_FN1_CIS_17_MSK 0xff
#define B_BE_FN1_CIS_16_SH 0
#define B_BE_FN1_CIS_16_MSK 0xff

#define R_BE_SDIO_FN1_CIS_114 0x3714
#define B_BE_FN1_CIS_23_SH 24
#define B_BE_FN1_CIS_23_MSK 0xff
#define B_BE_FN1_CIS_22_SH 16
#define B_BE_FN1_CIS_22_MSK 0xff
#define B_BE_FN1_CIS_21_SH 8
#define B_BE_FN1_CIS_21_MSK 0xff
#define B_BE_FN1_CIS_20_SH 0
#define B_BE_FN1_CIS_20_MSK 0xff

#define R_BE_SDIO_FN1_CIS_118 0x3718
#define B_BE_FN1_CIS_27_SH 24
#define B_BE_FN1_CIS_27_MSK 0xff
#define B_BE_FN1_CIS_26_SH 16
#define B_BE_FN1_CIS_26_MSK 0xff
#define B_BE_FN1_CIS_25_SH 8
#define B_BE_FN1_CIS_25_MSK 0xff
#define B_BE_FN1_CIS_24_SH 0
#define B_BE_FN1_CIS_24_MSK 0xff

#define R_BE_SDIO_FN1_CIS_11C 0x371C
#define B_BE_FN1_CIS_31_SH 24
#define B_BE_FN1_CIS_31_MSK 0xff
#define B_BE_FN1_CIS_30_SH 16
#define B_BE_FN1_CIS_30_MSK 0xff
#define B_BE_FN1_CIS_29_SH 8
#define B_BE_FN1_CIS_29_MSK 0xff
#define B_BE_FN1_CIS_28_SH 0
#define B_BE_FN1_CIS_28_MSK 0xff

#define R_BE_SDIO_FN1_CIS_120 0x3720
#define B_BE_FN1_CIS_35_SH 24
#define B_BE_FN1_CIS_35_MSK 0xff
#define B_BE_FN1_CIS_34_SH 16
#define B_BE_FN1_CIS_34_MSK 0xff
#define B_BE_FN1_CIS_33_SH 8
#define B_BE_FN1_CIS_33_MSK 0xff
#define B_BE_FN1_CIS_32_SH 0
#define B_BE_FN1_CIS_32_MSK 0xff

#define R_BE_SDIO_FN1_CIS_124 0x3724
#define B_BE_FN1_CIS_39_SH 24
#define B_BE_FN1_CIS_39_MSK 0xff
#define B_BE_FN1_CIS_38_SH 16
#define B_BE_FN1_CIS_38_MSK 0xff
#define B_BE_FN1_CIS_37_SH 8
#define B_BE_FN1_CIS_37_MSK 0xff
#define B_BE_FN1_CIS_36_SH 0
#define B_BE_FN1_CIS_36_MSK 0xff

#define R_BE_SDIO_FN1_CIS_128 0x3728
#define B_BE_FN1_CIS_43_SH 24
#define B_BE_FN1_CIS_43_MSK 0xff
#define B_BE_FN1_CIS_42_SH 16
#define B_BE_FN1_CIS_42_MSK 0xff
#define B_BE_FN1_CIS_41_SH 8
#define B_BE_FN1_CIS_41_MSK 0xff
#define B_BE_FN1_CIS_40_SH 0
#define B_BE_FN1_CIS_40_MSK 0xff

#define R_BE_SDIO_FN1_CIS_12C 0x372C
#define B_BE_FN1_CIS_47_SH 24
#define B_BE_FN1_CIS_47_MSK 0xff
#define B_BE_FN1_CIS_46_SH 16
#define B_BE_FN1_CIS_46_MSK 0xff
#define B_BE_FN1_CIS_45_SH 8
#define B_BE_FN1_CIS_45_MSK 0xff
#define B_BE_FN1_CIS_44_SH 0
#define B_BE_FN1_CIS_44_MSK 0xff

#define R_BE_SDIO_FN1_CIS_130 0x3730
#define B_BE_FN1_CIS_END_FLAG_SH 0
#define B_BE_FN1_CIS_END_FLAG_MSK 0xff

#define R_BE_SDIO_FN2_CIS_200 0x3800
#define B_BE_FN2_CIS_3_SH 24
#define B_BE_FN2_CIS_3_MSK 0xff
#define B_BE_FN2_CIS_2_SH 16
#define B_BE_FN2_CIS_2_MSK 0xff
#define B_BE_FN2_CIS_1_SH 8
#define B_BE_FN2_CIS_1_MSK 0xff
#define B_BE_FN2_CIS_0_SH 0
#define B_BE_FN2_CIS_0_MSK 0xff

#define R_BE_SDIO_FN2_CIS_204 0x3804
#define B_BE_FN2_CIS_7_SH 24
#define B_BE_FN2_CIS_7_MSK 0xff
#define B_BE_FN2_CIS_6_SH 16
#define B_BE_FN2_CIS_6_MSK 0xff
#define B_BE_FN2_CIS_5_SH 8
#define B_BE_FN2_CIS_5_MSK 0xff
#define B_BE_FN2_CIS_4_SH 0
#define B_BE_FN2_CIS_4_MSK 0xff

#define R_BE_SDIO_FN2_CIS_208 0x3808
#define B_BE_FN2_CIS_11_SH 24
#define B_BE_FN2_CIS_11_MSK 0xff
#define B_BE_FN2_CIS_10_SH 16
#define B_BE_FN2_CIS_10_MSK 0xff
#define B_BE_FN2_CIS_9_SH 8
#define B_BE_FN2_CIS_9_MSK 0xff
#define B_BE_FN2_CIS_8_SH 0
#define B_BE_FN2_CIS_8_MSK 0xff

#define R_BE_SDIO_FN2_CIS_20C 0x380C
#define B_BE_FN2_CIS_15_SH 24
#define B_BE_FN2_CIS_15_MSK 0xff
#define B_BE_FN2_CIS_14_SH 16
#define B_BE_FN2_CIS_14_MSK 0xff
#define B_BE_FN2_CIS_13_SH 8
#define B_BE_FN2_CIS_13_MSK 0xff
#define B_BE_FN2_CIS_12_SH 0
#define B_BE_FN2_CIS_12_MSK 0xff

#define R_BE_SDIO_FN2_CIS_210 0x3810
#define B_BE_FN2_CIS_19_SH 24
#define B_BE_FN2_CIS_19_MSK 0xff
#define B_BE_FN2_CIS_18_SH 16
#define B_BE_FN2_CIS_18_MSK 0xff
#define B_BE_FN2_CIS_17_SH 8
#define B_BE_FN2_CIS_17_MSK 0xff
#define B_BE_FN2_CIS_16_SH 0
#define B_BE_FN2_CIS_16_MSK 0xff

#define R_BE_SDIO_FN2_CIS_214 0x3814
#define B_BE_FN2_CIS_23_SH 24
#define B_BE_FN2_CIS_23_MSK 0xff
#define B_BE_FN2_CIS_22_SH 16
#define B_BE_FN2_CIS_22_MSK 0xff
#define B_BE_FN2_CIS_21_SH 8
#define B_BE_FN2_CIS_21_MSK 0xff
#define B_BE_FN2_CIS_20_SH 0
#define B_BE_FN2_CIS_20_MSK 0xff

#define R_BE_SDIO_FN2_CIS_218 0x3818
#define B_BE_FN2_CIS_27_SH 24
#define B_BE_FN2_CIS_27_MSK 0xff
#define B_BE_FN2_CIS_26_SH 16
#define B_BE_FN2_CIS_26_MSK 0xff
#define B_BE_FN2_CIS_25_SH 8
#define B_BE_FN2_CIS_25_MSK 0xff
#define B_BE_FN2_CIS_24_SH 0
#define B_BE_FN2_CIS_24_MSK 0xff

#define R_BE_SDIO_FN2_CIS_21C 0x381C
#define B_BE_FN2_CIS_31_SH 24
#define B_BE_FN2_CIS_31_MSK 0xff
#define B_BE_FN2_CIS_30_SH 16
#define B_BE_FN2_CIS_30_MSK 0xff
#define B_BE_FN2_CIS_29_SH 8
#define B_BE_FN2_CIS_29_MSK 0xff
#define B_BE_FN2_CIS_28_SH 0
#define B_BE_FN2_CIS_28_MSK 0xff

#define R_BE_SDIO_FN2_CIS_220 0x3820
#define B_BE_FN2_CIS_35_SH 24
#define B_BE_FN2_CIS_35_MSK 0xff
#define B_BE_FN2_CIS_34_SH 16
#define B_BE_FN2_CIS_34_MSK 0xff
#define B_BE_FN2_CIS_33_SH 8
#define B_BE_FN2_CIS_33_MSK 0xff
#define B_BE_FN2_CIS_32_SH 0
#define B_BE_FN2_CIS_32_MSK 0xff

#define R_BE_SDIO_FN2_CIS_224 0x3824
#define B_BE_FN2_CIS_39_SH 24
#define B_BE_FN2_CIS_39_MSK 0xff
#define B_BE_FN2_CIS_38_SH 16
#define B_BE_FN2_CIS_38_MSK 0xff
#define B_BE_FN2_CIS_37_SH 8
#define B_BE_FN2_CIS_37_MSK 0xff
#define B_BE_FN2_CIS_36_SH 0
#define B_BE_FN2_CIS_36_MSK 0xff

#define R_BE_SDIO_FN2_CIS_228 0x3828
#define B_BE_FN2_CIS_43_SH 24
#define B_BE_FN2_CIS_43_MSK 0xff
#define B_BE_FN2_CIS_42_SH 16
#define B_BE_FN2_CIS_42_MSK 0xff
#define B_BE_FN2_CIS_41_SH 8
#define B_BE_FN2_CIS_41_MSK 0xff
#define B_BE_FN2_CIS_40_SH 0
#define B_BE_FN2_CIS_40_MSK 0xff

#define R_BE_SDIO_FN2_CIS_22C 0x382C
#define B_BE_FN2_CIS_47_SH 24
#define B_BE_FN2_CIS_47_MSK 0xff
#define B_BE_FN2_CIS_46_SH 16
#define B_BE_FN2_CIS_46_MSK 0xff
#define B_BE_FN2_CIS_45_SH 8
#define B_BE_FN2_CIS_45_MSK 0xff
#define B_BE_FN2_CIS_44_SH 0
#define B_BE_FN2_CIS_44_MSK 0xff

#define R_BE_SDIO_FN2_CIS_230 0x3830
#define B_BE_FN2_CIS_END_FLAG_SH 0
#define B_BE_FN2_CIS_END_FLAG_MSK 0xff

//
// WL_BE_Reg_USB.xls
//

//
// USB_REG
//

#define R_BE_USB2_MAC_0_V1 0x0000
#define B_BE_TOUT_DELAY_FS_V1_SH 24
#define B_BE_TOUT_DELAY_FS_V1_MSK 0xff
#define B_BE_TOUT_DELAY_HS_V1_SH 16
#define B_BE_TOUT_DELAY_HS_V1_MSK 0xff
#define B_BE_TOUT_DIS_V1 BIT(15)
#define B_BE_CRC_CHK_OPT_V1 BIT(14)
#define B_BE_FORCE_PCERST_V1 BIT(13)
#define B_BE_FORCE_TOGL_V1 BIT(12)
#define B_BE_FORCE_TOGLSEL_V1 BIT(11)
#define B_BE_FORCE_PIDSW_V1 BIT(10)
#define B_BE_FORCE_PCE_IN_V1 BIT(9)
#define B_BE_FORCE_PCE_OUT_V1 BIT(8)
#define B_BE_PID_FORCE_V1_SH 0
#define B_BE_PID_FORCE_V1_MSK 0xff

#define R_BE_USB2_MAC_1_V1 0x0004
#define B_BE_FORCE_PCE_CMD_V1 BIT(31)

#define R_BE_USB2_LINK_PORT_V1 0x0008
#define B_BE_R_HOST_PWR_CTRL_V1 BIT(23)
#define B_BE_R_USB2_CLR_TXVLD_V1 BIT(22)
#define B_BE_R_USB2_SE0_V1 BIT(21)
#define B_BE_HOST_RESUME_EDGE_EN_V1 BIT(20)
#define B_BE_RESUME_SEL_V1_SH 16
#define B_BE_RESUME_SEL_V1_MSK 0xf
#define B_BE_DELAY_CHIRP_K_V1_SH 14
#define B_BE_DELAY_CHIRP_K_V1_MSK 0x3
#define B_BE_FORCE_TXVLD1_V1 BIT(13)
#define B_BE_FORCE_TXVLD0_V1 BIT(12)
#define B_BE_DORCE_DAT1_V1 BIT(11)
#define B_BE_FORCE_DAT0_V1 BIT(10)
#define B_BE_LS_TEST_V1 BIT(9)
#define B_BE_LS_CHANGE_V1 BIT(8)
#define B_BE_FORCE_HS_SW_V1 BIT(7)
#define B_BE_FORCE_FS_SW_V1 BIT(6)
#define B_BE_FORCE_HSXCVR_V1 BIT(5)
#define B_BE_FORCE_FSXCVR_V1 BIT(4)
#define B_BE_FORCE_HSTERM_V1 BIT(3)
#define B_BE_FORCE_FSTERM_V1 BIT(2)
#define B_BE_FORCE_NORM_SW_V1 BIT(1)
#define B_BE_FORCE_DBSN_V1 BIT(0)

#define R_BE_USB2_LPM_0_V1 0x0010
#define B_BE_USBPHY_PLL_ALIVE_V1 BIT(17)
#define B_BE_USB_LPM_MAX_EN_V1 BIT(16)
#define B_BE_USB_LPM_MIN_EN_V1 BIT(15)
#define B_BE_BESL_EN_V1 BIT(14)
#define B_BE_USB_LPM_NYET_EN_V1 BIT(13)
#define B_BE_USB_LPM_MAX_ACK_V1 BIT(12)
#define B_BE_USB_LPM_EN_V1 BIT(11)
#define B_BE_USB2_SUSB_V1 BIT(10)
#define B_BE_LPM_PLL_ALIVE_V1 BIT(9)
#define B_BE_USB_LPS_OUT_V1 BIT(8)
#define B_BE_USB_LPM_WAKEUP_EN_V1 BIT(6)
#define B_BE_NEVER_SUSPEND_V1 BIT(5)
#define B_BE_SUSPND_EN_V1 BIT(4)
#define B_BE_WAKEUP_EN_V1 BIT(3)
#define B_BE_USB_SUS_WAKEUP_EN_V1 BIT(2)
#define B_BE_RESUME_SND_V1 BIT(1)
#define B_BE_CONNECT_EN_V1 BIT(0)

#define R_BE_USB2_LPM_1_V1 0x0014
#define B_BE_USB_LPM_MAX_V1_SH 20
#define B_BE_USB_LPM_MAX_V1_MSK 0xf
#define B_BE_USB_LPM_MIN_V1_SH 16
#define B_BE_USB_LPM_MIN_V1_MSK 0xf
#define B_BE_R_WAKE_HOST_WT_H_V1_SH 8
#define B_BE_R_WAKE_HOST_WT_H_V1_MSK 0xff
#define B_BE_R_WAKE_HOST_WT_L_V1_SH 0
#define B_BE_R_WAKE_HOST_WT_L_V1_MSK 0xff

#define R_BE_USB2_MACRO_TEST_MODE_V1 0x0018
#define B_BE_TXRDY_SLB_SEL_V1 BIT(14)
#define B_BE_SLB_EN_V1 BIT(13)
#define B_BE_SLB_RST_V1 BIT(12)
#define B_BE_SLB_FAIL_V1 BIT(11)
#define B_BE_SLB_DONE_V1 BIT(10)
#define B_BE_SLB_PS1_SW_V1_SH 8
#define B_BE_SLB_PS1_SW_V1_MSK 0x3
#define B_BE_PHY_LOOP_TEST_V1 BIT(3)
#define B_BE_USBTMOD_V1_SH 0
#define B_BE_USBTMOD_V1_MSK 0x7

#define R_BE_USB2_PHY_REG_0_V1 0x0020
#define B_BE_USB2PHY_REG_EN_V1 BIT(17)
#define B_BE_VLPADM_V1 BIT(16)
#define B_BE_VSTATUS_IN_V1_SH 8
#define B_BE_VSTATUS_IN_V1_MSK 0xff
#define B_BE_VCONTROL_V1_SH 0
#define B_BE_VCONTROL_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_1_V1 0x0024
#define B_BE_USB2PHY_DELAY_V1_SH 8
#define B_BE_USB2PHY_DELAY_V1_MSK 0xff
#define B_BE_VSTATUS_OUT_V1_SH 0
#define B_BE_VSTATUS_OUT_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_2_V1 0x0028
#define B_BE_USB2_PHY_P0_E3_V1_SH 24
#define B_BE_USB2_PHY_P0_E3_V1_MSK 0xff
#define B_BE_USB2_PHY_P0_E2_V1_SH 16
#define B_BE_USB2_PHY_P0_E2_V1_MSK 0xff
#define B_BE_USB2_PHY_P0_E1_V1_SH 8
#define B_BE_USB2_PHY_P0_E1_V1_MSK 0xff
#define B_BE_USB2_PHY_P0_E0_V1_SH 0
#define B_BE_USB2_PHY_P0_E0_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_3_V1 0x002C
#define B_BE_USB2_PHY_P0_E7_V1_SH 24
#define B_BE_USB2_PHY_P0_E7_V1_MSK 0xff
#define B_BE_USB2_PHY_P0_E6_V1_SH 16
#define B_BE_USB2_PHY_P0_E6_V1_MSK 0xff
#define B_BE_USB2_PHY_P0_E5_V1_SH 8
#define B_BE_USB2_PHY_P0_E5_V1_MSK 0xff
#define B_BE_USB2_PHY_P0_E4_V1_SH 0
#define B_BE_USB2_PHY_P0_E4_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_4_V1 0x0030
#define B_BE_USB2_PHY_P1_E3_V1_SH 24
#define B_BE_USB2_PHY_P1_E3_V1_MSK 0xff
#define B_BE_USB2_PHY_P1_E2_V1_SH 16
#define B_BE_USB2_PHY_P1_E2_V1_MSK 0xff
#define B_BE_USB2_PHY_P1_E1_V1_SH 8
#define B_BE_USB2_PHY_P1_E1_V1_MSK 0xff
#define B_BE_USB2_PHY_P1_E0_V1_SH 0
#define B_BE_USB2_PHY_P1_E0_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_5_V1 0x0034
#define B_BE_USB2_PHY_P1_E7_V1_SH 24
#define B_BE_USB2_PHY_P1_E7_V1_MSK 0xff
#define B_BE_USB2_PHY_P1_E6_V1_SH 16
#define B_BE_USB2_PHY_P1_E6_V1_MSK 0xff
#define B_BE_USB2_PHY_P1_E5_V1_SH 8
#define B_BE_USB2_PHY_P1_E5_V1_MSK 0xff
#define B_BE_USB2_PHY_P1_E4_V1_SH 0
#define B_BE_USB2_PHY_P1_E4_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_6_V1 0x0038
#define B_BE_USB2_PHY_F3_V1_SH 24
#define B_BE_USB2_PHY_F3_V1_MSK 0xff
#define B_BE_USB2_PHY_F2_V1_SH 16
#define B_BE_USB2_PHY_F2_V1_MSK 0xff
#define B_BE_USB2_PHY_F1_V1_SH 8
#define B_BE_USB2_PHY_F1_V1_MSK 0xff
#define B_BE_USB2_PHY_F0_V1_SH 0
#define B_BE_USB2_PHY_F0_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_7_V1 0x003C
#define B_BE_USB2_PHY_F7_V1_SH 24
#define B_BE_USB2_PHY_F7_V1_MSK 0xff
#define B_BE_USB2_PHY_F6_V1_SH 16
#define B_BE_USB2_PHY_F6_V1_MSK 0xff
#define B_BE_USB2_PHY_F5_V1_SH 8
#define B_BE_USB2_PHY_F5_V1_MSK 0xff
#define B_BE_USB2_PHY_F4_V1_SH 0
#define B_BE_USB2_PHY_F4_V1_MSK 0xff

#define R_BE_USB2_PHY_REG_8_V1 0x0040
#define B_BE_USB2PHY_UPDATE_2_V1_SH 16
#define B_BE_USB2PHY_UPDATE_2_V1_MSK 0xff
#define B_BE_USB2PHY_UPDATE_1_V1_SH 8
#define B_BE_USB2PHY_UPDATE_1_V1_MSK 0xff
#define B_BE_USB2PHY_UPDATE_0_V1_SH 0
#define B_BE_USB2PHY_UPDATE_0_V1_MSK 0xff
#define B_BE_VENDOR_IDX_UPPER_BOND_SH 0
#define B_BE_VENDOR_IDX_UPPER_BOND_MSK 0xff

#define R_BE_USB_ENDPOINT_0_V1 0x0060
#define B_BE_EP_MAXPKT_V1_SH 16
#define B_BE_EP_MAXPKT_V1_MSK 0x3ff
#define B_BE_EP_EN_V1 BIT(15)
#define B_BE_EP_TYPE_V1_SH 13
#define B_BE_EP_TYPE_V1_MSK 0x3
#define B_BE_EP_ISTALL_V1 BIT(12)
#define B_BE_EP_OSTALL_V1 BIT(11)
#define B_BE_EP_STREAMEN_V1 BIT(10)
#define B_BE_EP_OUT_V1 BIT(9)
#define B_BE_EP_IN_V1 BIT(8)
#define B_BE_BT_INTR_SEL_V1 BIT(5)
#define B_BE_R_SIE_INIT_DONE_V1 BIT(4)
#define B_BE_EP_IDX_V1_SH 0
#define B_BE_EP_IDX_V1_MSK 0xf

#define R_BE_USB_ENDPOINT_1_V1 0x0064
#define B_BE_EP_MAX_STREAM_V1_SH 16
#define B_BE_EP_MAX_STREAM_V1_MSK 0xff
#define B_BE_EP_MAX_BURST_V1_SH 8
#define B_BE_EP_MAX_BURST_V1_MSK 0xff
#define B_BE_EP_INT_INTERVAL_V1_SH 0
#define B_BE_EP_INT_INTERVAL_V1_MSK 0xff

#define R_BE_USB_ENDPOINT_2_V1 0x0068
#define B_BE_EP_BPI_V1_SH 16
#define B_BE_EP_BPI_V1_MSK 0xffff
#define B_BE_USB3_EP_IN_ST_V1_SH 8
#define B_BE_USB3_EP_IN_ST_V1_MSK 0xff
#define B_BE_USB3_EP_OUT_ST_V1_SH 0
#define B_BE_USB3_EP_OUT_ST_V1_MSK 0xff

#define R_BE_USB_ENDPOINT_3_V1 0x006C
#define B_BE_EP12_PAUSE_STATE_V1 BIT(31)
#define B_BE_EP11_PAUSE_STATE_V1 BIT(30)
#define B_BE_EP10_PAUSE_STATE_V1 BIT(29)
#define B_BE_EP9_PAUSE_STATE_V1 BIT(28)
#define B_BE_EP8_PAUSE_STATE_V1 BIT(27)
#define B_BE_EP7_PAUSE_STATE_V1 BIT(26)
#define B_BE_EP6_PAUSE_STATE_V1 BIT(25)
#define B_BE_EP5_PAUSE_STATE_V1 BIT(24)
#define B_BE_EP4_PAUSE_STATE_V1 BIT(23)
#define B_BE_EP12_TX_PAUSE_V1 BIT(22)
#define B_BE_EP11_TX_PAUSE_V1 BIT(21)
#define B_BE_EP10_TX_PAUSE_V1 BIT(20)
#define B_BE_EP9_TX_PAUSE_V1 BIT(19)
#define B_BE_EP8_RX_PAUSE_V1 BIT(18)
#define B_BE_EP7_TX_PAUSE_V1 BIT(17)
#define B_BE_EP6_TX_PAUSE_V1 BIT(16)
#define B_BE_EP5_TX_PAUSE_V1 BIT(15)
#define B_BE_EP4_RX_PAUSE_V1 BIT(14)
#define B_BE_INTERRUPT_BULK_IN_V1 BIT(12)
#define B_BE_AC_BULKOUT_V1_SH 10
#define B_BE_AC_BULKOUT_V1_MSK 0x3
#define B_BE_BULKOUT1_V1 BIT(9)
#define B_BE_BULKOUT0_V1 BIT(8)
#define B_BE_INTERRUPT_INTERVAL_V1_SH 0
#define B_BE_INTERRUPT_INTERVAL_V1_MSK 0xf

#define R_BE_USB_HOST_REQUEST_0_V1 0x0070
#define B_BE_ERR_STR2_LEN_V1_SH 24
#define B_BE_ERR_STR2_LEN_V1_MSK 0xff
#define B_BE_ERR_STR1_LEN_V1_SH 8
#define B_BE_ERR_STR1_LEN_V1_MSK 0xffff
#define B_BE_DEVADDR_V1_SH 0
#define B_BE_DEVADDR_V1_MSK 0x7f

#define R_BE_USB_HOST_REQUEST_1_V1 0x0074
#define B_BE_USB_PID_V1_SH 16
#define B_BE_USB_PID_V1_MSK 0xffff
#define B_BE_USB_VID_V1_SH 0
#define B_BE_USB_VID_V1_MSK 0xffff

#define R_BE_USB_HOST_REQUEST_2_V1 0x0078
#define B_BE_MAC_ADDR_1_V1_SH 24
#define B_BE_MAC_ADDR_1_V1_MSK 0xff
#define B_BE_MAC_ADDR_0_V1_SH 16
#define B_BE_MAC_ADDR_0_V1_MSK 0xff
#define B_BE_FORCE_LPM_BCD201_V1 BIT(15)
#define B_BE_SELF_POWER_EN_V1 BIT(14)
#define B_BE_R_FORCE_U3MAC_HS_MODE_V1 BIT(13)
#define B_BE_LOAD_LTM_CAP_V1 BIT(12)
#define B_BE_USB3_DEV_CAP_DESC_EN_V1 BIT(11)
#define B_BE_AUTOLOAD_STRING_EN_V1 BIT(10)
#define B_BE_REMOTE_WAKEUP_V1 BIT(9)
#define B_BE_SQNUM_ROM_V1 BIT(8)
#define B_BE_ERR_STR2_LEN_FLAG_V1 BIT(7)
#define B_BE_ERR_STR1_LEN_FLAG_V1 BIT(6)
#define B_BE_ERR_STR0_LEN_FLAG_V1 BIT(5)
#define B_BE_R_USBIO_MODE_V1 BIT(4)
#define B_BE_EXREG_TO_EN_V1 BIT(3)
#define B_BE_EXREG_TO_SEL_V1_SH 0
#define B_BE_EXREG_TO_SEL_V1_MSK 0x7

#define R_BE_USB_HOST_REQUEST_3_V1 0x007C
#define B_BE_MAC_ADDR_5_V1_SH 24
#define B_BE_MAC_ADDR_5_V1_MSK 0xff
#define B_BE_MAC_ADDR_4_V1_SH 16
#define B_BE_MAC_ADDR_4_V1_MSK 0xff
#define B_BE_MAC_ADDR_3_V1_SH 8
#define B_BE_MAC_ADDR_3_V1_MSK 0xff
#define B_BE_MAC_ADDR_2_V1_SH 0
#define B_BE_MAC_ADDR_2_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_4_V1 0x0080
#define B_BE__MANUFACTURE_STRING_3_V1_SH 24
#define B_BE__MANUFACTURE_STRING_3_V1_MSK 0xff
#define B_BE__MANUFACTURE_STRING_2_V1_SH 16
#define B_BE__MANUFACTURE_STRING_2_V1_MSK 0xff
#define B_BE__MANUFACTURE_STRING_1_V1_SH 8
#define B_BE__MANUFACTURE_STRING_1_V1_MSK 0xff
#define B_BE__MANUFACTURE_STRING_0_V1_SH 0
#define B_BE__MANUFACTURE_STRING_0_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_5_V1 0x0084
#define B_BE_MANUFACTURE_STRING_7_V1_SH 24
#define B_BE_MANUFACTURE_STRING_7_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_6_V1_SH 16
#define B_BE_MANUFACTURE_STRING_6_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_5_V1_SH 8
#define B_BE_MANUFACTURE_STRING_5_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_4_V1_SH 0
#define B_BE_MANUFACTURE_STRING_4_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_6_V1 0x0088
#define B_BE_MANUFACTURE_STRING_B_V1_SH 24
#define B_BE_MANUFACTURE_STRING_B_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_A_V1_SH 16
#define B_BE_MANUFACTURE_STRING_A_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_9_V1_SH 8
#define B_BE_MANUFACTURE_STRING_9_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_8_V1_SH 0
#define B_BE_MANUFACTURE_STRING_8_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_7_V1 0x008C
#define B_BE_MANUFACTURE_STRING_F_V1_SH 24
#define B_BE_MANUFACTURE_STRING_F_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_E_V1_SH 16
#define B_BE_MANUFACTURE_STRING_E_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_D_V1_SH 8
#define B_BE_MANUFACTURE_STRING_D_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_C_V1_SH 0
#define B_BE_MANUFACTURE_STRING_C_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_8_V1 0x0090
#define B_BE_MANUFACTURE_STRING_13_V1_SH 24
#define B_BE_MANUFACTURE_STRING_13_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_12_V1_SH 16
#define B_BE_MANUFACTURE_STRING_12_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_11_V1_SH 8
#define B_BE_MANUFACTURE_STRING_11_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_10_V1_SH 0
#define B_BE_MANUFACTURE_STRING_10_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_9_V1 0x0094
#define B_BE_MANUFACTURE_STRING_17_V1_SH 24
#define B_BE_MANUFACTURE_STRING_17_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_16_V1_SH 16
#define B_BE_MANUFACTURE_STRING_16_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_15_V1_SH 8
#define B_BE_MANUFACTURE_STRING_15_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_14_V1_SH 0
#define B_BE_MANUFACTURE_STRING_14_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_A_V1 0x0098
#define B_BE_MANUFACTURE_STRING_1B_V1_SH 24
#define B_BE_MANUFACTURE_STRING_1B_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_1A_V1_SH 16
#define B_BE_MANUFACTURE_STRING_1A_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_19_V1_SH 8
#define B_BE_MANUFACTURE_STRING_19_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_18_V1_SH 0
#define B_BE_MANUFACTURE_STRING_18_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_B_V1 0x009C
#define B_BE_MANUFACTURE_STRING_1F_V1_SH 24
#define B_BE_MANUFACTURE_STRING_1F_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_1E_V1_SH 16
#define B_BE_MANUFACTURE_STRING_1E_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_1D_V1_SH 8
#define B_BE_MANUFACTURE_STRING_1D_V1_MSK 0xff
#define B_BE_MANUFACTURE_STRING_1C_V1_SH 0
#define B_BE_MANUFACTURE_STRING_1C_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_C_V1 0x00A0
#define B_BE_PRODUCT_STRING_3_V1_SH 24
#define B_BE_PRODUCT_STRING_3_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_2_V1_SH 16
#define B_BE_PRODUCT_STRING_2_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_1_V1_SH 8
#define B_BE_PRODUCT_STRING_1_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_0_V1_SH 0
#define B_BE_PRODUCT_STRING_0_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_D_V1 0x00A4
#define B_BE_PRODUCT_STRING_7_V1_SH 24
#define B_BE_PRODUCT_STRING_7_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_6_V1_SH 16
#define B_BE_PRODUCT_STRING_6_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_5_V1_SH 8
#define B_BE_PRODUCT_STRING_5_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_4_V1_SH 0
#define B_BE_PRODUCT_STRING_4_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_E_V1 0x00A8
#define B_BE_PRODUCT_STRING_B_V1_SH 24
#define B_BE_PRODUCT_STRING_B_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_A_V1_SH 16
#define B_BE_PRODUCT_STRING_A_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_9_V1_SH 8
#define B_BE_PRODUCT_STRING_9_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_8_V1_SH 0
#define B_BE_PRODUCT_STRING_8_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_F_V1 0x00AC
#define B_BE_PRODUCT_STRING_F_V1_SH 24
#define B_BE_PRODUCT_STRING_F_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_E_V1_SH 16
#define B_BE_PRODUCT_STRING_E_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_D_V1_SH 8
#define B_BE_PRODUCT_STRING_D_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_C_V1_SH 0
#define B_BE_PRODUCT_STRING_C_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_10_V1 0x00B0
#define B_BE_PRODUCT_STRING_13_V1_SH 24
#define B_BE_PRODUCT_STRING_13_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_12_V1_SH 16
#define B_BE_PRODUCT_STRING_12_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_11_V1_SH 8
#define B_BE_PRODUCT_STRING_11_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_10_V1_SH 0
#define B_BE_PRODUCT_STRING_10_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_11_V1 0x00B4
#define B_BE_PRODUCT_STRING_17_V1_SH 24
#define B_BE_PRODUCT_STRING_17_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_16_V1_SH 16
#define B_BE_PRODUCT_STRING_16_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_15_V1_SH 8
#define B_BE_PRODUCT_STRING_15_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_14_V1_SH 0
#define B_BE_PRODUCT_STRING_14_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_12_V1 0x00B8
#define B_BE_PRODUCT_STRING_1B_V1_SH 24
#define B_BE_PRODUCT_STRING_1B_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_1A_V1_SH 16
#define B_BE_PRODUCT_STRING_1A_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_19_V1_SH 8
#define B_BE_PRODUCT_STRING_19_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_18_V1_SH 0
#define B_BE_PRODUCT_STRING_18_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_13_V1 0x00BC
#define B_BE_PRODUCT_STRING_1F_V1_SH 24
#define B_BE_PRODUCT_STRING_1F_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_1E_V1_SH 16
#define B_BE_PRODUCT_STRING_1E_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_1D_V1_SH 8
#define B_BE_PRODUCT_STRING_1D_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_1C_V1_SH 0
#define B_BE_PRODUCT_STRING_1C_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_14_V1 0x00C0
#define B_BE_PRODUCT_STRING_23_V1_SH 24
#define B_BE_PRODUCT_STRING_23_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_22_V1_SH 16
#define B_BE_PRODUCT_STRING_22_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_21_V1_SH 8
#define B_BE_PRODUCT_STRING_21_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_20_V1_SH 0
#define B_BE_PRODUCT_STRING_20_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_15_V1 0x00C4
#define B_BE_PRODUCT_STRING_27_V1_SH 24
#define B_BE_PRODUCT_STRING_27_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_26_V1_SH 16
#define B_BE_PRODUCT_STRING_26_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_25_V1_SH 8
#define B_BE_PRODUCT_STRING_25_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_24_V1_SH 0
#define B_BE_PRODUCT_STRING_24_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_16_V1 0x00C8
#define B_BE_PRODUCT_STRING_2B_V1_SH 24
#define B_BE_PRODUCT_STRING_2B_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_2A_V1_SH 16
#define B_BE_PRODUCT_STRING_2A_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_29_V1_SH 8
#define B_BE_PRODUCT_STRING_29_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_28_V1_SH 0
#define B_BE_PRODUCT_STRING_28_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_17_V1 0x00CC
#define B_BE_PRODUCT_STRING_2F_V1_SH 24
#define B_BE_PRODUCT_STRING_2F_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_2E_V1_SH 16
#define B_BE_PRODUCT_STRING_2E_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_2D_V1_SH 8
#define B_BE_PRODUCT_STRING_2D_V1_MSK 0xff
#define B_BE_PRODUCT_STRING_2C_V1_SH 0
#define B_BE_PRODUCT_STRING_2C_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_18_V1 0x00D0
#define B_BE_SERIAL_NUMBER_STRING_3_V1_SH 24
#define B_BE_SERIAL_NUMBER_STRING_3_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_2_V1_SH 16
#define B_BE_SERIAL_NUMBER_STRING_2_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_1_V1_SH 8
#define B_BE_SERIAL_NUMBER_STRING_1_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_0_V1_SH 0
#define B_BE_SERIAL_NUMBER_STRING_0_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_19_V1 0x00D4
#define B_BE_SERIAL_NUMBER_STRING_7_V1_SH 24
#define B_BE_SERIAL_NUMBER_STRING_7_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_6_V1_SH 16
#define B_BE_SERIAL_NUMBER_STRING_6_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_5_V1_SH 8
#define B_BE_SERIAL_NUMBER_STRING_5_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_4_V1_SH 0
#define B_BE_SERIAL_NUMBER_STRING_4_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_1A_V1 0x00D8
#define B_BE_SERIAL_NUMBER_STRING_B_V1_SH 24
#define B_BE_SERIAL_NUMBER_STRING_B_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_A_V1_SH 16
#define B_BE_SERIAL_NUMBER_STRING_A_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_9_V1_SH 8
#define B_BE_SERIAL_NUMBER_STRING_9_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_8_V1_SH 0
#define B_BE_SERIAL_NUMBER_STRING_8_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_1B_V1 0x00DC
#define B_BE_SERIAL_NUMBER_STRING_F_V1_SH 24
#define B_BE_SERIAL_NUMBER_STRING_F_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_E_V1_SH 16
#define B_BE_SERIAL_NUMBER_STRING_E_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_D_V1_SH 8
#define B_BE_SERIAL_NUMBER_STRING_D_V1_MSK 0xff
#define B_BE_SERIAL_NUMBER_STRING_C_V1_SH 0
#define B_BE_SERIAL_NUMBER_STRING_C_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_1C_V1 0x00E0
#define B_BE_USB3_U2SEL_V1_SH 16
#define B_BE_USB3_U2SEL_V1_MSK 0xffff
#define B_BE_USB3_U1PEL_V1_SH 0
#define B_BE_USB3_U1PEL_V1_MSK 0xffff

#define R_BE_USB_HOST_REQUEST_1D_V1 0x00E4
#define B_BE_HW_VENDOR_INDEX_V1_SH 16
#define B_BE_HW_VENDOR_INDEX_V1_MSK 0xff

#define R_BE_USB_HOST_REQUEST_1E_V1 0x00E8
#define B_BE_DIS_STALL_FUNC_WAKE_V1 BIT(24)
#define B_BE_USB3_U2_DEV_EXIT_LAT_V1_SH 8
#define B_BE_USB3_U2_DEV_EXIT_LAT_V1_MSK 0xffff
#define B_BE_USB3_U1_DEV_EXIT_LAT_V1_SH 0
#define B_BE_USB3_U1_DEV_EXIT_LAT_V1_MSK 0xff

#define R_BE_USB3_MAC_LINK_0_V1 0x0100
#define B_BE_INTS_USB3_HRESET_EN_V1 BIT(31)
#define B_BE_INTS_USB3_RECOV_EN_V1 BIT(30)
#define B_BE_INTS_USB3_LPBK_EN_V1 BIT(29)
#define B_BE_INTS_USB3_RXDET_EN_V1 BIT(28)
#define B_BE_INTS_USB3_POLL_EN_V1 BIT(27)
#define B_BE_INTS_USB3_U3_EN_V1 BIT(26)
#define B_BE_INTS_USB3_U1U2_EN_V1 BIT(25)
#define B_BE_INTS_USB3_U0_EN_V1 BIT(24)
#define B_BE_INTS_USB3_RECOV2U0_EN_V1 BIT(23)
#define B_BE_INTS_USB3_SSINACT_EN_V1 BIT(22)
#define B_BE_INTS_USB3_SSDIS_EN_V1 BIT(21)
#define B_BE_INTS_USB3_CMPLY_EN_V1 BIT(20)
#define B_BE_INTS_USB3_RECOV2U0_V1 BIT(19)
#define B_BE_INTS_USB3_SSINACT_V1 BIT(18)
#define B_BE_INTS_USB3_SSDIS_V1 BIT(17)
#define B_BE_INTS_USB3_CMPLY_V1 BIT(16)
#define B_BE_INTS_USB3_HRESET_V1 BIT(15)
#define B_BE_INTS_USB3_RECOV_V1 BIT(14)
#define B_BE_INTS_USB3_LPBK_V1 BIT(13)
#define B_BE_INTS_USB3_RXDET_V1 BIT(12)
#define B_BE_INTS_USB3_POLL_V1 BIT(11)
#define B_BE_INTS_USB3_U3_V1 BIT(10)
#define B_BE_INTS_USB3_U1U2_V1 BIT(9)
#define B_BE_INTS_USB3_U0_V1 BIT(8)
#define B_BE_EN_ROVIDLE_TIMEOUT_V1 BIT(6)
#define B_BE_EN_UNFIN_RTY_V1 BIT(5)
#define B_BE_SSPHY_U1_QUICK_LFPS_V1 BIT(4)
#define B_BE_USB3_DIS_ISOC_TIME_GT_V1 BIT(3)
#define B_BE_R_DIS_USB3_U2_EN_V1 BIT(2)
#define B_BE_R_DIS_USB3_U1_EN_V1 BIT(1)
#define B_BE_LINK_ST_DETECT_TERM_V1 BIT(0)

#define R_BE_USB3_MAC_LINK_1_V1 0x0104
#define B_BE_WARM_RESET_TIME_V1_SH 0
#define B_BE_WARM_RESET_TIME_V1_MSK 0x3

#define R_BE_USB3_MAC_PIU_V1 0x0108
#define B_BE_SSPHY_CLR_TERM_V1 BIT(1)
#define B_BE_SSPHY_SET_TERM_V1 BIT(0)

#define R_BE_USB3_MAC_PTL_V1 0x010C
#define B_BE_BCDVALUE_V1_SH 2
#define B_BE_BCDVALUE_V1_MSK 0x3
#define B_BE_WLAN0_BUF_NUMP_EN_V1 BIT(1)
#define B_BE_IGNORE_RETRY_BIT_V1 BIT(0)

#define R_BE_USB3_MAC_PRTSM_V1 0x0110
#define B_BE_EN_IMMED_POP_CREDIT_V1 BIT(0)

#define R_BE_USB3_MAC_NPI_CONFIG_INTF_0_V1 0x0114
#define B_BE_SSPHY_LFPS_FILTER_V1 BIT(31)
#define B_BE_SSPHY_TX_SWING_V1 BIT(30)
#define B_BE_SSPHY_TXMARGIN_V1_SH 27
#define B_BE_SSPHY_TXMARGIN_V1_MSK 0x7
#define B_BE_SSPHY_TXDEEMPHASIS_V1_SH 25
#define B_BE_SSPHY_TXDEEMPHASIS_V1_MSK 0x3
#define B_BE_SSPHY_ELASTIC_BUF_V1 BIT(24)
#define B_BE_HIRD_THR_V1_SH 19
#define B_BE_HIRD_THR_V1_MSK 0x1f
#define B_BE_DEV_SPEED_V1_SH 16
#define B_BE_DEV_SPEED_V1_MSK 0x7
#define B_BE_U1_ACTIVE_TIMEOUT_V1_SH 8
#define B_BE_U1_ACTIVE_TIMEOUT_V1_MSK 0xff
#define B_BE_USB3_TARGET_LINK_STATE_V1_SH 4
#define B_BE_USB3_TARGET_LINK_STATE_V1_MSK 0xf
#define B_BE_APPL1RSP_V1 BIT(3)
#define B_BE_LPM_CAPABLE_V1 BIT(2)
#define B_BE_USB3_EOF_V1_SH 0
#define B_BE_USB3_EOF_V1_MSK 0x3

#define R_BE_USB3_MAC_NPI_CONFIG_INTF_1_V1 0x0118
#define B_BE_NPI_SCALEDOWN_MODE_V1_SH 24
#define B_BE_NPI_SCALEDOWN_MODE_V1_MSK 0x3
#define B_BE_SSPHY_POWERDOWN_SCALE_V1_SH 8
#define B_BE_SSPHY_POWERDOWN_SCALE_V1_MSK 0x1fff
#define B_BE_SSPHY_U1_FAST_OUT_V1 BIT(7)
#define B_BE_SSPHY_P3_FOR_P2_V1 BIT(6)
#define B_BE_SSPHY_U1_RXVALID_V1 BIT(5)
#define B_BE_SSPHY_DIS_SCAMBLE_V1 BIT(4)
#define B_BE_SSPHY_SKIP_RXDETECT_V1 BIT(3)
#define B_BE_SSPHY_LFPS_P0_ALIGN_V1 BIT(2)
#define B_BE_SSPHY_P3P2_TRANS_V1 BIT(1)
#define B_BE_SSPHY_P3_EXITIN_P2_V1 BIT(0)

#define R_BE_USB3_MAC_NPI_CONFIG_INTF_2_V1 0x011C
#define B_BE_SSPHY_U2EXIT_LPFS_V1 BIT(18)
#define B_BE_SSPHY_PHYSOFTRST_V1 BIT(17)
#define B_BE_SSPHY_HSTPRTCMPL_V1 BIT(16)
#define B_BE_SSPHY_U2SSINACTP3OK_V1 BIT(15)
#define B_BE_SSPHY_DISRXDETP3_V1 BIT(14)
#define B_BE_SSPHY_UX_EXIT_IN_PX_V1 BIT(13)
#define B_BE_SSPHY_PING_ENH_EN_V1 BIT(12)
#define B_BE_SSPHY_U1U2EXITFAIL_TO_RECOV_V1 BIT(11)
#define B_BE_SSPHY_ALWAYS_REQ_V1 BIT(10)
#define B_BE_SSPHY_START_RX_DET_V1 BIT(9)
#define B_BE_SSPHY_DIS_RX_DET_V1 BIT(8)
#define B_BE_SSPHY_DELAY_P1P2P3_V1_SH 5
#define B_BE_SSPHY_DELAY_P1P2P3_V1_MSK 0x7
#define B_BE_SSPHY_SUSPEND_EN_V1 BIT(4)
#define B_BE_SSPHY_DATWIDTH_V1_SH 2
#define B_BE_SSPHY_DATWIDTH_V1_MSK 0x3
#define B_BE_SSPHY_ABORTRXDETLNU2_V1 BIT(1)
#define B_BE_SSPHY_RX_DETECT_LPFS_V1 BIT(0)

#define R_BE_USB3_MAC_NPI_POWER_0_V1 0x0120
#define B_BE_U3_LTM_EN_V1 BIT(28)
#define B_BE_LINK_STATE_REQ_V1_SH 24
#define B_BE_LINK_STATE_REQ_V1_MSK 0xf
#define B_BE_SUSCLK_RATIO_V1_SH 8
#define B_BE_SUSCLK_RATIO_V1_MSK 0x1fff
#define B_BE_TEST_CTRL_V1_SH 4
#define B_BE_TEST_CTRL_V1_MSK 0xf
#define B_BE_UFRAME_SCALE_V1_SH 2
#define B_BE_UFRAME_SCALE_V1_MSK 0x3
#define B_BE_LOCAL_LBK_V1 BIT(1)
#define B_BE_EN_SLEEP_USB_V1 BIT(0)

#define R_BE_USB3_MAC_NPI_POWER_1_V1 0x0124
#define B_BE_WAKE_WAIT_XTAL_V1 BIT(27)
#define B_BE_WAKE_WAIT_CURRENT_V1 BIT(26)
#define B_BE_WAKEUP_NEG_SEL_V1 BIT(25)
#define B_BE_SSPHY_USB3_ATTEMPT_V1 BIT(24)
#define B_BE_WAIT_IDLE_TIME_V1_SH 20
#define B_BE_WAIT_IDLE_TIME_V1_MSK 0xf
#define B_BE_U2_EN_MAC_IDLE_V1 BIT(18)
#define B_BE_U1_EN_MAC_IDLE_V1 BIT(17)
#define B_BE_SWITCH_CLK_EN_V1 BIT(16)
#define B_BE_USB3_SAMPLE_RXELECIDLE_V1_SH 8
#define B_BE_USB3_SAMPLE_RXELECIDLE_V1_MSK 0xff
#define B_BE_U3_INIT_U2_V1 BIT(7)
#define B_BE_U3_INIT_U1_V1 BIT(6)
#define B_BE_SET_U3_WAKE_V1 BIT(5)
#define B_BE_U3_U2_EN_V1 BIT(4)
#define B_BE_U3_U1_EN_V1 BIT(3)
#define B_BE_U3_INIT_U2_EN_V1 BIT(2)
#define B_BE_U3_INIT_U1_EN_V1 BIT(1)
#define B_BE_USB3_RUN_V1 BIT(0)

#define R_BE_USB3_MAC_NPI_POWER_2_V1 0x0128
#define B_BE_NPI_LINK_STATE_LATCH_V1_SH 16
#define B_BE_NPI_LINK_STATE_LATCH_V1_MSK 0xff
#define B_BE_NPI_HOST_RESUME_DETECTED_V1 BIT(15)
#define B_BE_NPI_DEV_CONNECT_SPEED_V1_SH 12
#define B_BE_NPI_DEV_CONNECT_SPEED_V1_MSK 0x7
#define B_BE_NPI_LINK_STATE_V1_SH 8
#define B_BE_NPI_LINK_STATE_V1_MSK 0xf
#define B_BE_POLL_EN_V1 BIT(7)
#define B_BE_POLL_SAMPLE_ON_V1 BIT(6)
#define B_BE_POLL_ACT_V1_SH 4
#define B_BE_POLL_ACT_V1_MSK 0x3
#define B_BE_POLL_NOACT_V1_SH 0
#define B_BE_POLL_NOACT_V1_MSK 0xf

#define R_BE_USB3_MAC_NPI_POWER_3_V1 0x012C
#define B_BE_R_CNT_SWITCH_USB32_PARA_V1_SH 0
#define B_BE_R_CNT_SWITCH_USB32_PARA_V1_MSK 0xffff

#define R_BE_USB3_MAC_NPI_STATUS_V1 0x0130
#define B_BE_NPI_DEV_CONNECTED_V1 BIT(0)

#define R_BE_USB3_MAC_NPI_DEVICE_NOTIFICATION_V1 0x0134
#define B_BE_DEVNOTE_BIA_V1_SH 16
#define B_BE_DEVNOTE_BIA_V1_MSK 0xffff
#define B_BE_DEVNOTE_BELT_V1_SH 0
#define B_BE_DEVNOTE_BELT_V1_MSK 0xfff

#define R_BE_USB3_MAC_NPI_TRANSMIT_V1 0x0138
#define B_BE_NPI_TX_ACK_TP_DATA_WAIT_V1_SH 0
#define B_BE_NPI_TX_ACK_TP_DATA_WAIT_V1_MSK 0xf

#define R_BE_USB3_MAC_NPI_OTHERS_V1 0x013C
#define B_BE_EN_FIX_RX_ABORT_V1 BIT(8)
#define B_BE_FLADJ_30MHZ_REG_V1_SH 0
#define B_BE_FLADJ_30MHZ_REG_V1_MSK 0x3f

#define R_BE_USB3_WRAP_0_V1 0x0140
#define B_BE_U1TOU2_TIMER_V1_SH 24
#define B_BE_U1TOU2_TIMER_V1_MSK 0xff
#define B_BE_WAKE_ST_DBG_V1_SH 20
#define B_BE_WAKE_ST_DBG_V1_MSK 0xf
#define B_BE_ARB_ST_DBG_V1_SH 18
#define B_BE_ARB_ST_DBG_V1_MSK 0x3
#define B_BE_BIA_REQ_V1 BIT(17)
#define B_BE_BELT_REQ_V1 BIT(16)
#define B_BE_USB3_VENDOR_LEN_TH_V1_SH 0
#define B_BE_USB3_VENDOR_LEN_TH_V1_MSK 0xffff

#define R_BE_USB3_WRAP_1_V1 0x0144
#define B_BE_DIS_PKT_FUNC_WAKE_V1 BIT(0)

#define R_BE_USB3_PHY_V1 0x0148
#define B_BE_USB3_PHY_RWDATA_V1_SH 16
#define B_BE_USB3_PHY_RWDATA_V1_MSK 0xffff
#define B_BE_USB3_PHY_ADR_V1_SH 8
#define B_BE_USB3_PHY_ADR_V1_MSK 0x1f
#define B_BE_USB3_PHY_REG_WRFLAG_V1 BIT(7)
#define B_BE_USB3_PHY_REG_RDFLAG_V1 BIT(6)
#define B_BE_USB3_PHY_REG_ADR_V1_SH 0
#define B_BE_USB3_PHY_REG_ADR_V1_MSK 0x1f

#define R_BE_USB3_OTHERS_V1 0x0150
#define B_BE_R_REATTACH_TIMER_V1_SH 28
#define B_BE_R_REATTACH_TIMER_V1_MSK 0xf
#define B_BE_R_CNT_MS_SEL_V1_SH 24
#define B_BE_R_CNT_MS_SEL_V1_MSK 0x7
#define B_BE_VENDOR_LPM_TEST_V1_SH 16
#define B_BE_VENDOR_LPM_TEST_V1_MSK 0xff
#define B_BE_ISOC_DELAY_VALUE_V1_SH 0
#define B_BE_ISOC_DELAY_VALUE_V1_MSK 0xffff

#define R_BE_USB_APPLICATION_BT_0_V1 0x0160
#define B_BE_BTRX0_BUFFER_WADDR_V1_SH 24
#define B_BE_BTRX0_BUFFER_WADDR_V1_MSK 0xff
#define B_BE_USB_INTOKEN_TIMEOUT_V1_SH 20
#define B_BE_USB_INTOKEN_TIMEOUT_V1_MSK 0x7
#define B_BE_BRX_BUF_CHK_V1_SH 16
#define B_BE_BRX_BUF_CHK_V1_MSK 0x7
#define B_BE_BTRX0_RPKT_SIZE_V1_SH 0
#define B_BE_BTRX0_RPKT_SIZE_V1_MSK 0xffff

#define R_BE_USB_APPLICATION_BT_1_V1 0x0164
#define B_BE_USB2BT_PWR_INFO_REG_MASK_V1_SH 20
#define B_BE_USB2BT_PWR_INFO_REG_MASK_V1_MSK 0xf
#define B_BE_FUNCTION_SUSB_EN_BT_V1 BIT(19)
#define B_BE_LOWPOWER_BT_V1 BIT(18)
#define B_BE_FUNCTION_WAKE_EN_BT_V1 BIT(17)
#define B_BE_FUNCTION_WAKE_CAPABLE_BT_V1 BIT(16)
#define B_BE_BT_ISO_ZERO_EN_V1 BIT(14)
#define B_BE_R_RXDMA_MODE_V1_SH 12
#define B_BE_R_RXDMA_MODE_V1_MSK 0x3
#define B_BE_GPS_USB_ACTIVE_V1 BIT(11)
#define B_BE_BT_TXQ_STOP_V1_SH 8
#define B_BE_BT_TXQ_STOP_V1_MSK 0x7

#define R_BE_USB_APPLICATION_BT_2_V1 0x0168
#define B_BE_BT_TX_V1 BIT(17)
#define B_BE_BT_RX_V1 BIT(16)
#define B_BE_BTTX_FIFO_OVER_EP3_V1 BIT(13)
#define B_BE_BTTX_FIFO_OVER_EP2_V1 BIT(12)
#define B_BE_BTTX_FIFO_OVER_EP0_V1 BIT(11)
#define B_BE_BTRX_FIFO_OVER_EP3_V1 BIT(10)
#define B_BE_BTRX_FIFO_OVER_EP2_V1 BIT(9)
#define B_BE_BTRX_FIFO_OVER_EP1_V1 BIT(8)
#define B_BE_BTTX_FIFO_UNDR_EP3_V1 BIT(5)
#define B_BE_BTTX_FIFO_UNDR_EP2_V1 BIT(4)
#define B_BE_BTTX_FIFO_UNDR_EP0_V1 BIT(3)
#define B_BE_BTRX_FIFO_UNDR_EP3_V1 BIT(2)
#define B_BE_BTRX_FIFO_UNDR_EP2_V1 BIT(1)
#define B_BE_BTRX_FIFO_UNDR_EP1_V1 BIT(0)

#define R_BE_USB_APPLICATION_BT_3_V1 0x016C
#define B_BE_DBG_BTRX_WADDR_V1_SH 16
#define B_BE_DBG_BTRX_WADDR_V1_MSK 0xfff
#define B_BE_DBG_BTRX_RPKT_V1_SH 0
#define B_BE_DBG_BTRX_RPKT_V1_MSK 0xffff

#define R_BE_USB_WLAN0_0_V1 0x0170
#define B_BE_WLAN_INT_LEN_V1_SH 16
#define B_BE_WLAN_INT_LEN_V1_MSK 0xffff
#define B_BE_WLAN0_TXQ_STALL_DIS_V1 BIT(4)
#define B_BE_FUNCTION_SUSB_EN_WLAN0_V1 BIT(3)
#define B_BE_LOWPOWER_WLAN0_V1 BIT(2)
#define B_BE_FUNCTION_WAKE_EN_WLAN0_V1 BIT(1)
#define B_BE_FUNCTION_WAKE_CAPABLE_WLAN0_V1 BIT(0)

#define R_BE_USB_WLAN0_1_V1 0x0174
#define B_BE_USBRX_RST_V1 BIT(9)
#define B_BE_USBTX_RST_V1 BIT(8)
#define B_BE_R_USBRX_SRAM_LS_V1 BIT(7)
#define B_BE_R_USBRX_SRAM_DS_V1 BIT(6)
#define B_BE_R_USBTX_SRAM_LS_V1 BIT(5)
#define B_BE_R_USBTX_SRAM_DS_V1 BIT(4)
#define B_BE_WLRX_FIFO_OVER_V1_SH 2
#define B_BE_WLRX_FIFO_OVER_V1_MSK 0x3
#define B_BE_WLRX_FIFO_UNDR_V1_SH 0
#define B_BE_WLRX_FIFO_UNDR_V1_MSK 0x3

#define R_BE_USB_AUTO_INSTALL_0_V1 0x0180
#define B_BE_AINST_POLL_1_V1 BIT(28)
#define B_BE_AINST_POLL_0_V1 BIT(27)
#define B_BE_AINST_TX1_CLR_BUF_V1 BIT(26)
#define B_BE_AINST_TX0_CLR_BUF_V1 BIT(25)
#define B_BE_WLAN_FW_RDY_V1 BIT(24)
#define B_BE_RECONF_USBEP_V1 BIT(23)
#define B_BE_RECONF_USBEP_EN_V1 BIT(22)
#define B_BE_BULK_ONLY_MASS_STORAGE_RESET_V1 BIT(21)
#define B_BE_BULK_ONLY_MASS_STORAGE_RESET_EN_V1 BIT(20)
#define B_BE_AINST_RXLEN_V1_SH 8
#define B_BE_AINST_RXLEN_V1_MSK 0xfff
#define B_BE_AINST_RX1_INTR_V1 BIT(7)
#define B_BE_AINST_RX0_INTR_V1 BIT(6)
#define B_BE_AINXT_TX1_INTR_V1 BIT(5)
#define B_BE_AINST_TX0_INTR_V1 BIT(4)
#define B_BE_AUTO_INST_TXQ_STALL_DIS_V1 BIT(3)
#define B_BE_LOWPOWER_AINST_V1 BIT(2)
#define B_BE_FUNCTION_WANE_EN_AINST_V1 BIT(1)

#define R_BE_USB_AUTO_INSTALL_1_V1 0x0184
#define B_BE_AINST_TX1LEN_V1_SH 16
#define B_BE_AINST_TX1LEN_V1_MSK 0xfff
#define B_BE_AINST_TX0LEN_V1_SH 0
#define B_BE_AINST_TX0LEN_V1_MSK 0xfff

#define R_BE_USB_AUTO_INSTALL_2_V1 0x0188
#define B_BE_AINST_PID_V1_SH 16
#define B_BE_AINST_PID_V1_MSK 0xffff
#define B_BE_AINST_VID_V1_SH 0
#define B_BE_AINST_VID_V1_MSK 0xffff

#define R_BE_USB_AUTO_INSTALL_3_V1 0x018C
#define B_BE_AINST_TXSTATUS_V1_SH 8
#define B_BE_AINST_TXSTATUS_V1_MSK 0xff
#define B_BE_AINST_RXSTATUS_V1_SH 0
#define B_BE_AINST_RXSTATUS_V1_MSK 0xff

#define R_BE_USB_BRIDGE_UART_0_V1 0x0190
#define B_BE_BRIDGE_XFACTOR_ADJ_USB2_V1_SH 20
#define B_BE_BRIDGE_XFACTOR_ADJ_USB2_V1_MSK 0xfff
#define B_BE_BRIDGE_XFACTOR_V1_SH 16
#define B_BE_BRIDGE_XFACTOR_V1_MSK 0xf
#define B_BE_BRIDGE_BAUD_USB2_V1_SH 0
#define B_BE_BRIDGE_BAUD_USB2_V1_MSK 0xfff

#define R_BE_USB_BRIDGE_UART_1_V1 0x0194
#define B_BE_BRIDGE_WAKEUP_EN_V1_SH 30
#define B_BE_BRIDGE_WAKEUP_EN_V1_MSK 0x3
#define B_BE_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_V1_SH 16
#define B_BE_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_V1_MSK 0xfff
#define B_BE_BRIDGE_LE_CON_HAN_VLD_V1 BIT(9)
#define B_BE_BRIDGE_LE_ON_V1 BIT(8)
#define B_BE_BRIDGE_DEBUG_PKTCNT_EN_V1 BIT(6)
#define B_BE_BRIDGE_RESET_RCV_SEL_V1 BIT(5)
#define B_BE_BRIDGE_WLS0_V1 BIT(4)
#define B_BE_BRIDGE_STB_V1 BIT(3)
#define B_BE_BRIDGE_PEN_V1 BIT(2)
#define B_BE_BRIDGE_EPS_V1 BIT(1)
#define B_BE_BRIDGE_STKP_V1 BIT(0)

#define R_BE_USB_BRIDGE_UART_2_V1 0x0198
#define B_BE_BRIDGE_DEBUG_SEL_V1_SH 24
#define B_BE_BRIDGE_DEBUG_SEL_V1_MSK 0xff
#define B_BE_R_BRIDGE_UARTEN_V1 BIT(23)
#define B_BE_BRIDGE_LPM_EN_V1 BIT(22)
#define B_BE_BRIDGE_TXSCO_TIME_INTERVAL_EN_V1 BIT(21)
#define B_BE_BRIDGE_TXSCO_PKT_LEN_MAT_EN_V1 BIT(20)
#define B_BE_BRIDGE_TXSCO_CON_HAN_MAT_EN_V1 BIT(19)
#define B_BE_BRIDGE_USB_TX_HCICMDLEN_SEL_V1 BIT(18)
#define B_BE_R_BRIDGE_JCIRXEN_V1 BIT(17)
#define B_BE_R_BRIDGE_HCITXEN_V1 BIT(16)
#define B_BE_BRIDGE_RXSCOBUF_FLOW_SEL_V1_SH 12
#define B_BE_BRIDGE_RXSCOBUF_FLOW_SEL_V1_MSK 0xf
#define B_BE_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_V1_SH 0
#define B_BE_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_V1_MSK 0xfff

#define R_BE_USB_BRIDGE_UART_3_V1 0x019C
#define B_BE_BRIDGE_URT_RXINDIC_ERR_V1 BIT(31)
#define B_BE_BRIDGE_LE_SHORTPKTERR_CNT_V1_SH 24
#define B_BE_BRIDGE_LE_SHORTPKTERR_CNT_V1_MSK 0x7f
#define B_BE_BRIDGE_ACL_SHORTPKTERR_CNT_V1_SH 16
#define B_BE_BRIDGE_ACL_SHORTPKTERR_CNT_V1_MSK 0xff
#define B_BE_BRIDGE_LE_LONGPKTERR_CNT_V1_SH 8
#define B_BE_BRIDGE_LE_LONGPKTERR_CNT_V1_MSK 0xff
#define B_BE_BRIDGE_ACL_LONGPKTERR_CNT_V1_SH 0
#define B_BE_BRIDGE_ACL_LONGPKTERR_CNT_V1_MSK 0xff

#define R_BE_USB_BRIDGE_UART_4_V1 0x01A0
#define B_BE_BRIDGE_XFACTOR_ADJ_USB3_V1_SH 20
#define B_BE_BRIDGE_XFACTOR_ADJ_USB3_V1_MSK 0xfff
#define B_BE_BRIDGE_XFACTOR_USB3_V1_SH 16
#define B_BE_BRIDGE_XFACTOR_USB3_V1_MSK 0xf
#define B_BE_BRIDGE_BAUD_USB3_V1_SH 0
#define B_BE_BRIDGE_BAUD_USB3_V1_MSK 0xfff

#define R_BE_USB_BT_BRIDGE_V1 0x01A8
#define B_BE_R_DIS_BTBRI_SS_SYSON_V1 BIT(2)
#define B_BE_R_DIS_BTBRI_SS_STS_V1 BIT(1)
#define B_BE_R_DIS_BTBRI_L1U2_STS_V1 BIT(0)

#define R_BE_USB_DMA_WRAPPER_V1 0x01B0
#define B_BE_PKT_BASE_EN_V1 BIT(11)
#define B_BE_FUNCTION_SUSB_OPT_V1 BIT(8)
#define B_BE_TX7LEN_MISMATCH_V1 BIT(7)
#define B_BE_TX6LEN_MISMATCH_V1 BIT(6)
#define B_BE_TX5LEN_MISMATCH_V1 BIT(5)
#define B_BE_TX4LEN_MISMATCH_V1 BIT(4)
#define B_BE_TX3LEN_MISMATCH_V1 BIT(3)
#define B_BE_TX2LEN_MISMATCH_V1 BIT(2)
#define B_BE_TX1LEN_MISMATCH_V1 BIT(1)
#define B_BE_TX0LEN_MISMATCH_V1 BIT(0)

#define R_BE_USB_WLAN1_V1 0x01B8
#define B_BE_WLAN_TX_V1 BIT(12)
#define B_BE_WLAN_RX_V1 BIT(11)
#define B_BE_WLAN1_TXQ_STALL_DIS_V1 BIT(10)
#define B_BE_WLAN1_RXQ_STOP_V1_SH 8
#define B_BE_WLAN1_RXQ_STOP_V1_MSK 0x3
#define B_BE_WLAN1_TXQ_STOP_V1_SH 4
#define B_BE_WLAN1_TXQ_STOP_V1_MSK 0xf
#define B_BE_FUNCTION_SUSB_EN_WLAN1_V1 BIT(3)
#define B_BE_LOWPOWER_WLAN1_V1 BIT(2)
#define B_BE_FUNCTION_WAKE_EN_WLAN1_V1 BIT(1)
#define B_BE_FUNCTION_WAKE_CAPABLE_WLAN1_V1 BIT(0)

#define R_BE_USB_GPS_V1 0x01C0
#define B_BE_FUNCTION_SUSB_EN_GPS_V1 BIT(3)
#define B_BE_LOWPOWER_GPS_V1 BIT(2)
#define B_BE_FUNCTION_WAKE_EN_GPS_V1 BIT(1)
#define B_BE_FUNCTION_WAKE_CAPABLE_GPS_V1 BIT(0)

#define R_BE_USB_DEBUG_0_V1 0x01D0
#define B_BE_SLEEP_GNT_BT_V1 BIT(17)
#define B_BE_SLEEP_REQ_BT_V1 BIT(16)
#define B_BE_DEBUG_SIGNAL_001_V1_SH 8
#define B_BE_DEBUG_SIGNAL_001_V1_MSK 0xff
#define B_BE_USB_DBGO_SEL_V1_SH 0
#define B_BE_USB_DBGO_SEL_V1_MSK 0xff

#define R_BE_USB_DEBUG_1_V1 0x01D4
#define B_BE_EP7_COUNTER_V1_SH 28
#define B_BE_EP7_COUNTER_V1_MSK 0xf
#define B_BE_EP6_COUNTER_V1_SH 24
#define B_BE_EP6_COUNTER_V1_MSK 0xf
#define B_BE_EP5_COUNTER_V1_SH 20
#define B_BE_EP5_COUNTER_V1_MSK 0xf
#define B_BE_EP4_COUNTER_V1_SH 16
#define B_BE_EP4_COUNTER_V1_MSK 0xf
#define B_BE_EP3_COUNTER_V1_SH 12
#define B_BE_EP3_COUNTER_V1_MSK 0xf
#define B_BE_EP2_COUNTER_V1_SH 8
#define B_BE_EP2_COUNTER_V1_MSK 0xf
#define B_BE_EP1_COUNTER_V1_SH 4
#define B_BE_EP1_COUNTER_V1_MSK 0xf
#define B_BE_EP0_COUNTER_V1_SH 0
#define B_BE_EP0_COUNTER_V1_MSK 0xf

#define R_BE_USB_DEBUG_2_V1 0x01D8
#define B_BE_EP15_COUNTER_V1_SH 28
#define B_BE_EP15_COUNTER_V1_MSK 0xf
#define B_BE_EP14_COUNTER_V1_SH 24
#define B_BE_EP14_COUNTER_V1_MSK 0xf
#define B_BE_EP13_COUNTER_V1_SH 20
#define B_BE_EP13_COUNTER_V1_MSK 0xf
#define B_BE_EP12_COUNTER_V1_SH 16
#define B_BE_EP12_COUNTER_V1_MSK 0xf
#define B_BE_EP11_COUNTER_V1_SH 12
#define B_BE_EP11_COUNTER_V1_MSK 0xf
#define B_BE_EP10_COUNTER_V1_SH 8
#define B_BE_EP10_COUNTER_V1_MSK 0xf
#define B_BE_EP9_COUNTER_V1_SH 4
#define B_BE_EP9_COUNTER_V1_MSK 0xf
#define B_BE_EP8_COUNTER_V1_SH 0
#define B_BE_EP8_COUNTER_V1_MSK 0xf

#define R_BE_USB_DEBUG_3_V1 0x01DC
#define B_BE_RX_STATE_MACHINE_V1_SH 24
#define B_BE_RX_STATE_MACHINE_V1_MSK 0xff
#define B_BE_TX_STATE_MACHINE_V1_SH 16
#define B_BE_TX_STATE_MACHINE_V1_MSK 0xff
#define B_BE_IO_STATE_MACHINE_V1_SH 8
#define B_BE_IO_STATE_MACHINE_V1_MSK 0xff
#define B_BE_REG_WRITE_COUNTER_V1_SH 4
#define B_BE_REG_WRITE_COUNTER_V1_MSK 0xf
#define B_BE_REG_READ_COUNTER_V1_SH 0
#define B_BE_REG_READ_COUNTER_V1_MSK 0xf

#define R_BE_USB_DEBUG_4_V1 0x01E0
#define B_BE_EP15_CNT_DIRECT_V1 BIT(31)
#define B_BE_EP14_CNT_DIRECT_V1 BIT(30)
#define B_BE_EP13_CNT_DIRECT_V1 BIT(29)
#define B_BE_EP12_CNT_DIRECT_V1 BIT(28)
#define B_BE_EP11_CNT_DIRECT_V1 BIT(27)
#define B_BE_EP10_CNT_DIRECT_V1 BIT(26)
#define B_BE_EP9_CNT_DIRECT_V1 BIT(25)
#define B_BE_EP8_CNT_DIRECT_V1 BIT(24)
#define B_BE_EP7_CNT_DIRECT_V1 BIT(23)
#define B_BE_EP6_CNT_DIRECT_V1 BIT(22)
#define B_BE_EP5_CNT_DIRECT_V1 BIT(21)
#define B_BE_EP4_CNT_DIRECT_V1 BIT(20)
#define B_BE_EP3_CNT_DIRECT_V1 BIT(19)
#define B_BE_EP2_CNT_DIRECT_V1 BIT(18)
#define B_BE_EP1_CNT_DIRECT_V1 BIT(17)
#define B_BE_EP0_CNT_DIRECT_V1 BIT(16)
#define B_BE_HW_TXVLD_TOGGLE_EN_V1 BIT(15)
#define B_BE_HW_FORCE_TXRDY_EN_V1 BIT(14)
#define B_BE_TXVLD_TOGGLE_VAL_V1_SH 8
#define B_BE_TXVLD_TOGGLE_VAL_V1_MSK 0xf
#define B_BE_TXVLD_TOUT_VAL_V1_SH 0
#define B_BE_TXVLD_TOUT_VAL_V1_MSK 0xff

#define R_BE_USB_IO_ONREG_WDT_V1 0x01E4
#define B_BE_ON_IOH_ADDR_V1_SH 8
#define B_BE_ON_IOH_ADDR_V1_MSK 0xffffff
#define B_BE_ON_IOH_TIMER_V1_SH 4
#define B_BE_ON_IOH_TIMER_V1_MSK 0xf
#define B_BE_ON_IOH_HW_AUTO_RST_V1 BIT(3)
#define B_BE_ON_IOH_EMPTY_V1 BIT(2)
#define B_BE_ON_IOH_RST_STS_V1 BIT(0)

#define R_BE_USB_IO_OFFREG_WDT_V1 0x01E8
#define B_BE_OFF_IOH_ADDR_V1_SH 8
#define B_BE_OFF_IOH_ADDR_V1_MSK 0xffffff
#define B_BE_OFF_IOH_TIMER_V1_SH 4
#define B_BE_OFF_IOH_TIMER_V1_MSK 0xf
#define B_BE_OFF_IOH_HW_AUTO_RST_V1 BIT(3)
#define B_BE_ON_IOH_SW_RST_V1 BIT(2)
#define B_BE_OFF_IOH_RST_STS_V1 BIT(0)

#define R_BE_USB_CPU_IO_RST_V1 0x01EC
#define B_BE_CPU_IOH_ADDR_V1_SH 16
#define B_BE_CPU_IOH_ADDR_V1_MSK 0xffff
#define B_BE_CPU_IOH_TIMEOUT_TH_V1_SH 8
#define B_BE_CPU_IOH_TIMEOUT_TH_V1_MSK 0x1f
#define B_BE_CPU_IOH_DSC_SW_RST_V1 BIT(1)
#define B_BE_CPU_IOH_SRC_SW_RST_V1 BIT(0)

#define R_BE_USB_STATUS_V1 0x01F0
#define B_BE_USB3_DIS_USB2PHY BIT(30)
#define B_BE_USB2_DIS_USB3 BIT(29)
#define B_BE_USB11_DIS_USB3 BIT(28)
#define B_BE_DIS_CTRL BIT(27)
#define B_BE_USB_EP_NUM_V1_SH 4
#define B_BE_USB_EP_NUM_V1_MSK 0xf
#define B_BE_R_SSIC_EN_V1 BIT(2)
#define B_BE_R_USB2_SEL_V1 BIT(1)
#define B_BE_MODE_HS_V1 BIT(0)

#define R_BE_USB_D2F_F2D_INFO_V1 0x0200
#define B_BE_HRPWM_V1_SH 16
#define B_BE_HRPWM_V1_MSK 0xffff
#define B_BE_CPWM_V1_SH 0
#define B_BE_CPWM_V1_MSK 0xffff

#define R_BE_USB3_V1 0x0220
#define B_BE_U3_STATE_V1_SH 12
#define B_BE_U3_STATE_V1_MSK 0xf
#define B_BE_U3_SUB_STATE_V1_SH 8
#define B_BE_U3_SUB_STATE_V1_MSK 0xf
#define B_BE_HPS_CLKR_USB_V1_SH 0
#define B_BE_HPS_CLKR_USB_V1_MSK 0xff

#define R_BE_USB_OTHERS_0_V1 0x0230
#define B_BE_USBTX_EP3IF_OK_CNT_V1_SH 24
#define B_BE_USBTX_EP3IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP2IF_OK_CNT_V1_SH 16
#define B_BE_USBTX_EP2IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP1IF_OK_CNT_V1_SH 8
#define B_BE_USBTX_EP1IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP0IF_OK_CNT_V1_SH 0
#define B_BE_USBTX_EP0IF_OK_CNT_V1_MSK 0xff

#define R_BE_USB_OTHERS_1_V1 0x0234
#define B_BE_USBTX_EP7IF_OK_CNT_V1_SH 24
#define B_BE_USBTX_EP7IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP6IF_OK_CNT_V1_SH 16
#define B_BE_USBTX_EP6IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP5IF_OK_CNT_V1_SH 8
#define B_BE_USBTX_EP5IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP4IF_OK_CNT_V1_SH 0
#define B_BE_USBTX_EP4IF_OK_CNT_V1_MSK 0xff

#define R_BE_USB_OTHERS_2_V1 0x0238
#define B_BE_USBRX_DMAIF_OK_CNT_V1_SH 24
#define B_BE_USBRX_DMAIF_OK_CNT_V1_MSK 0xff
#define B_BE_USBRX_EPIF_OK_CNT_V1_SH 16
#define B_BE_USBRX_EPIF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP9IF_OK_CNT_V1_SH 8
#define B_BE_USBTX_EP9IF_OK_CNT_V1_MSK 0xff
#define B_BE_USBTX_EP8IF_OK_CNT_V1_SH 0
#define B_BE_USBTX_EP8IF_OK_CNT_V1_MSK 0xff

#define R_BE_USB_OTHERS_3_V1 0x023C
#define B_BE_VENDOR_LMP_LATCH_DATA_L_V1_SH 0
#define B_BE_VENDOR_LMP_LATCH_DATA_L_V1_MSK 0xffffffffL

#define R_BE_USB_OTHERS_4_V1 0x0240
#define B_BE_VENDOR_LMP_LATCH_DATA_H_V1_SH 0
#define B_BE_VENDOR_LMP_LATCH_DATA_H_V1_MSK 0xffffffffL

#define R_BE_USB_OTHERS_5_V1 0x0244
#define B_BE_APPEND_ZERO_PKT_V1_SH 24
#define B_BE_APPEND_ZERO_PKT_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_EXTE_7_V1_SH 21
#define B_BE_USB_AUTO_LOAD_EXTE_7_V1_MSK 0x3
#define B_BE_USB_AUTO_LOAD_EXTE_0_V1_SH 16
#define B_BE_USB_AUTO_LOAD_EXTE_0_V1_MSK 0x1f
#define B_BE_USB_AUTO_LOAD_EXTE_2_V1_SH 8
#define B_BE_USB_AUTO_LOAD_EXTE_2_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_EXTE_1_V1_SH 0
#define B_BE_USB_AUTO_LOAD_EXTE_1_V1_MSK 0xff

#define R_BE_USB_OTHERS_6_V1 0x0248
#define B_BE_USB_AUTO_LOAD_STRING_3_V1_SH 24
#define B_BE_USB_AUTO_LOAD_STRING_3_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_STRING_2_V1_SH 16
#define B_BE_USB_AUTO_LOAD_STRING_2_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_STRING_1_V1_SH 8
#define B_BE_USB_AUTO_LOAD_STRING_1_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_STRING_0_V1_SH 0
#define B_BE_USB_AUTO_LOAD_STRING_0_V1_MSK 0xff

#define R_BE_USB_OTHERS_7_V1 0x024C
#define B_BE_USB_AUTO_LOAD_BRIDGE_FLAG_V1_SH 22
#define B_BE_USB_AUTO_LOAD_BRIDGE_FLAG_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_EXTE_FLAG_V1_SH 14
#define B_BE_USB_AUTO_LOAD_EXTE_FLAG_V1_MSK 0xff
#define B_BE_USB_AUTO_LOAD_STRING_FLAG_V1 BIT(13)
#define B_BE_USB_AUTO_LOAD_INIT2_FLAG_V1_SH 7
#define B_BE_USB_AUTO_LOAD_INIT2_FLAG_V1_MSK 0x3f
#define B_BE_USB_AUTO_LOAD_INIT1_FLAG_V1_SH 0
#define B_BE_USB_AUTO_LOAD_INIT1_FLAG_V1_MSK 0x7f

#define R_BE_USB_FW_ISR_V1 0x0254
#define B_BE_IO_OFFREG_TIMEOUT_INT_V1 BIT(8)
#define B_BE_IO_ONREG_TIMEOUT_INT_V1 BIT(0)

#define R_BE_USB_FW_IMR_V1 0x0258
#define B_BE_IO_OFFREG_TIMEOUT_INT_EN_V1 BIT(8)
#define B_BE_IO_ONREG_TIMEOUT_INT_EN_V1 BIT(0)

#define R_BE_HUSBIMR_V1 0x0270
#define B_BE_USB_CPUIO_TIMEOUT_INT_EN_V1 BIT(29)
#define B_BE_USB_HC1ISR_IDCT_INT_EN_V1 BIT(28)
#define B_BE_USB_HC0ISR_IDCT_INT_EN_V1 BIT(27)
#define B_BE_USB_HD1ISR_IDCT_INT_EN_V1 BIT(26)
#define B_BE_USB_HD0ISR_IDCT_INT_EN_V1 BIT(25)
#define B_BE_USB_HS1ISR_IDCT_INT_EN_V1 BIT(24)
#define B_BE_USB_HS0ISR_IDCT_INT_EN_V1 BIT(23)
#define B_BE_USB_TX_CH12_INT_EN_V1 BIT(7)
#define B_BE_USB_TX_CH10_INT_EN_V1 BIT(6)
#define B_BE_USB_TX_CH8_INT_EN_V1 BIT(5)
#define B_BE_USB_TX_CH6_INT_EN_V1 BIT(4)
#define B_BE_USB_TX_CH4_INT_EN_V1 BIT(3)
#define B_BE_USB_TX_CH2_INT_EN_V1 BIT(2)
#define B_BE_USB_TX_CH0_INT_EN_V1 BIT(1)
#define B_BE_USB_RX_INT_EN_V1 BIT(0)

#define R_BE_HUSBISR_V1 0x0274
#define B_BE_USB_CPUIO_TIMEOUT_INT_V1 BIT(29)
#define B_BE_USB_HC1ISR_IDCT_INT_V1 BIT(28)
#define B_BE_USB_HC0ISR_IDCT_INT_V1 BIT(27)
#define B_BE_USB_HD1ISR_IDCT_INT_V1 BIT(26)
#define B_BE_USB_HD0ISR_IDCT_INT_V1 BIT(25)
#define B_BE_USB_HS1ISR_IDCT_INT_V1 BIT(24)
#define B_BE_USB_HS0ISR_IDCT_INT_V1 BIT(23)
#define B_BE_USB_TX_CH12_INT_V1 BIT(7)
#define B_BE_USB_TX_CH10_INT_V1 BIT(6)
#define B_BE_USB_TX_CH8_INT_V1 BIT(5)
#define B_BE_USB_TX_CH6_INT_V1 BIT(4)
#define B_BE_USB_TX_CH4_INT_V1 BIT(3)
#define B_BE_USB_TX_CH2_INT_V1 BIT(2)
#define B_BE_USB_TX_CH0_INT_V1 BIT(1)
#define B_BE_USB_RX_INT_V1 BIT(0)

#endif
